/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.curricula.CurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.DefaultCurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.ParallelInitialization;
import org.unitime.timetable.solver.curricula.ProjectedStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculaCourseDemands
implements StudentCourseDemands {
    private static Log sLog = LogFactory.getLog(CurriculaCourseDemands.class);
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();
    private Hashtable<Long, Hashtable<Long, Double>> iEnrollmentPriorities = new Hashtable();
    private IdGenerator lastStudentId = new IdGenerator();
    protected ProjectedStudentCourseDemands iFallback;
    private Hashtable<Long, Hashtable<String, Set<String>>> iLoadedCurricula = new Hashtable();
    private HashSet<Long> iCheckedCourses = new HashSet();
    private boolean iIncludeOtherStudents = true;
    private boolean iSetStudentCourseLimits = false;
    private CurriculumEnrollmentPriorityProvider iEnrollmentPriorityProvider = null;
    private DataProperties iProperties = null;

    public CurriculaCourseDemands(DataProperties properties) {
        this.iProperties = properties;
        if (properties != null) {
            this.iFallback = new ProjectedStudentCourseDemands(properties);
        }
        this.iIncludeOtherStudents = properties.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherStudents);
        this.iSetStudentCourseLimits = properties.getPropertyBoolean("CurriculaCourseDemands.SetStudentCourseLimits", this.iSetStudentCourseLimits);
        this.iEnrollmentPriorityProvider = new DefaultCurriculumEnrollmentPriorityProvider(properties);
        if (properties.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider") != null) {
            try {
                this.iEnrollmentPriorityProvider = (CurriculumEnrollmentPriorityProvider)Class.forName(properties.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to use custom enrollment priority provider: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public CurriculaCourseDemands() {
        this(null);
    }

    @Override
    public boolean isMakingUpStudents() {
        return true;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iFallback.init(hibSession, progress, session, offerings);
        ArrayList curricula = null;
        if (offerings != null && offerings.size() <= 1000) {
            String courses = "";
            int nrCourses = 0;
            for (InstructionalOffering offering : offerings) {
                for (CourseOffering course : offering.getCourseOfferings()) {
                    if (!courses.isEmpty()) {
                        courses = courses + ",";
                    }
                    courses = courses + course.getUniqueId();
                    ++nrCourses;
                }
            }
            if (nrCourses > 0 && nrCourses <= 1000) {
                HashSet curriculaSet = new HashSet(hibSession.createQuery("select distinct c from CurriculumCourse cc inner join cc.classification.curriculum c where c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + courses + ")").setLong("sessionId", session.getUniqueId().longValue()).list());
                curriculaSet.addAll(hibSession.createQuery("select distinct d from CurriculumCourse cc inner join cc.classification.curriculum c, Curriculum d where c.academicArea = d.academicArea and d.multipleMajors = true and size(c.majors) <= 1 and size(c.majors) < size(d.majors) and (select count(m) from Curriculum x inner join x.majors m where x.uniqueId = c.uniqueId and m not in elements(d.majors)) = 0 and c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + courses + ")").setLong("sessionId", session.getUniqueId().longValue()).list());
                curriculaSet.addAll(hibSession.createQuery("select distinct d from CurriculumCourse cc inner join cc.classification.curriculum c, Curriculum d where c.multipleMajors = true and size(c.majors) >= 1 and size(c.majors) > size(d.majors) and c.academicArea = d.academicArea and (select count(m) from Curriculum x inner join x.majors m where x.uniqueId = d.uniqueId and m not in elements(c.majors)) = 0 and c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + courses + ")").setLong("sessionId", session.getUniqueId().longValue()).list());
                curricula = new ArrayList(curriculaSet);
            }
        }
        if (curricula == null) {
            curricula = hibSession.createQuery("select c from Curriculum c where c.academicArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list();
        }
        ArrayList<Initialization> inits = new ArrayList<Initialization>();
        for (Curriculum curriculum : curricula) {
            for (CurriculumClassification clasf : curriculum.getClassifications()) {
                if (clasf.getNrStudents() <= 0) continue;
                ArrayList<CurriculumClassification> templates = new ArrayList<CurriculumClassification>();
                if (curriculum.isMultipleMajors().booleanValue()) {
                    for (Curriculum parent : curricula) {
                        if (!parent.isTemplateFor(curriculum)) continue;
                        for (CurriculumClassification parentClasf : parent.getClassifications()) {
                            if (!parentClasf.getAcademicClassification().equals(clasf.getAcademicClassification())) continue;
                            templates.add(parentClasf);
                        }
                    }
                }
                inits.add(new Initialization(clasf, templates));
            }
        }
        new ParallelInitialization("Loading curricula", this.iProperties.getPropertyInt("CurriculaCourseDemands.NrThreads", 1), inits).execute(hibSession, progress);
        if (this.iDemands.isEmpty()) {
            progress.warn("There are no curricula, using projected course demands instead.");
        }
    }

    protected String getCacheName() {
        return "curriculum-demands";
    }

    protected void computeTargetShare(int nrStudents, Collection<CurriculumCourse> courses, CurriculumCourseGroupsProvider course2groups, CurModel model) {
        for (CurriculumCourse c1 : courses) {
            float x1 = c1.getPercShare().floatValue() * (float)nrStudents;
            HashSet[] group = new HashSet[]{new HashSet(), new HashSet()};
            LinkedList<CurriculumCourse> queue = new LinkedList<CurriculumCourse>();
            queue.add(c1);
            HashSet<CurriculumCourseGroup> done = new HashSet<CurriculumCourseGroup>();
            while (!queue.isEmpty()) {
                CurriculumCourse c = (CurriculumCourse)queue.poll();
                for (CurriculumCourseGroup g : course2groups.getGroups(c)) {
                    if (!done.add(g)) continue;
                    for (CurriculumCourse x : courses) {
                        if (x.equals(c) || x.equals(c1) || !course2groups.getGroups(x).contains(g) || !group[group[0].contains(c) ? 0 : g.getType()].add(x)) continue;
                        queue.add(x);
                    }
                }
            }
            for (CurriculumCourse c2 : courses) {
                float x2 = c2.getPercShare().floatValue() * (float)nrStudents;
                if (c1.getUniqueId() >= c2.getUniqueId()) continue;
                float share = c1.getPercShare().floatValue() * c2.getPercShare().floatValue() * (float)nrStudents;
                boolean opt = group[0].contains(c2);
                boolean req = !opt && group[1].contains(c2);
                model.setTargetShare(c1.getUniqueId(), c2.getUniqueId(), opt ? 0.0 : (req ? (double)Math.min(x1, x2) : (double)share), true);
            }
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        if (this.iDemands.isEmpty()) {
            return this.iFallback.getDemands(course);
        }
        Set<StudentCourseDemands.WeightedStudentId> demands = this.iDemands.get(course.getUniqueId());
        if (!this.iIncludeOtherStudents) {
            return demands;
        }
        if (demands == null) {
            demands = new HashSet<StudentCourseDemands.WeightedStudentId>();
            this.iDemands.put(course.getUniqueId(), demands);
        }
        if (this.iCheckedCourses.add(course.getUniqueId())) {
            int was = demands.size();
            Hashtable<String, Set<String>> curricula = this.iLoadedCurricula.get(course.getUniqueId());
            Set<StudentCourseDemands.WeightedStudentId> other = this.iFallback.getDemands(course);
            if (curricula == null || curricula.isEmpty()) {
                demands.addAll(other);
            } else {
                block0: for (StudentCourseDemands.WeightedStudentId student : other) {
                    for (StudentCourseDemands.AreaCode area : student.getAreas()) {
                        Set<String> majors = curricula.get(area.getArea());
                        if (majors == null || !majors.contains("") && !student.match(area.getArea(), majors)) continue;
                        continue block0;
                    }
                    demands.add(student);
                }
            }
            if (demands.size() > was) {
                sLog.info((Object)(course.getCourseName() + " has " + (demands.size() - was) + " other students (besides of the " + was + " curriculum students)."));
            }
        }
        return demands;
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        if (this.iIncludeOtherStudents && studentId >= 0L) {
            return this.iFallback.getCourses(studentId);
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        Hashtable<Long, Double> priorities = this.iEnrollmentPriorities.get(studentId);
        return priorities == null ? null : priorities.get(courseId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCurriculumCourseGroupsProvider
    implements CurriculumCourseGroupsProvider {
        private Map<Long, Set<CurriculumCourseGroup>> iTable = new HashMap<Long, Set<CurriculumCourseGroup>>();

        public void add(CurriculumCourse course) {
            Set<CurriculumCourseGroup> groups = this.iTable.get(course.getCourse().getUniqueId());
            if (groups == null) {
                groups = new HashSet<CurriculumCourseGroup>();
                this.iTable.put(course.getCourse().getUniqueId(), groups);
            }
            groups.addAll(course.getGroups());
        }

        @Override
        public Set<CurriculumCourseGroup> getGroups(CurriculumCourse course) {
            Set<CurriculumCourseGroup> groups = this.iTable.get(course.getCourse().getUniqueId());
            return groups == null ? course.getGroups() : groups;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultCurriculumCourseGroupsProvider
    implements CurriculumCourseGroupsProvider {
        @Override
        public Set<CurriculumCourseGroup> getGroups(CurriculumCourse course) {
            return course.getGroups();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CurriculumCourseGroupsProvider {
        public Set<CurriculumCourseGroup> getGroups(CurriculumCourse var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Initialization
    implements ParallelInitialization.Task {
        private CurriculumClassification iClassification;
        private List<CurriculumClassification> iTemplates;
        private boolean iUpdateClassification = false;
        private CurModel iModel;
        private Hashtable<Long, CourseOffering> iCourses;
        private Assignment<CurVariable, CurValue> iAssignment;

        public Initialization(CurriculumClassification classification, List<CurriculumClassification> templates) {
            this.iClassification = classification;
            this.iTemplates = templates;
        }

        @Override
        public void setup(org.hibernate.Session hibSession) {
            Element cache;
            sLog.debug((Object)("Processing " + this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getName() + " ... (" + this.iClassification.getNrStudents() + " students, " + this.iClassification.getCourses().size() + " courses)"));
            ArrayList<CurStudent> students = new ArrayList<CurStudent>();
            for (long i = 0L; i < (long)this.iClassification.getNrStudents().intValue(); ++i) {
                students.add(new CurStudent(-(1L + i), 1.0));
            }
            this.iModel = new CurModel(students);
            this.iCourses = new Hashtable();
            Collection<CurriculumCourse> courses = null;
            CurriculumCourseGroupsProvider course2groups = null;
            if (this.iTemplates == null || this.iTemplates.isEmpty()) {
                courses = this.iClassification.getCourses();
                course2groups = new DefaultCurriculumCourseGroupsProvider();
            } else {
                HashMap curriculumCourses = new HashMap();
                course2groups = new TableCurriculumCourseGroupsProvider();
                for (CurriculumClassification template : this.iTemplates) {
                    for (CurriculumCourse course : template.getCourses()) {
                        CurriculumCourse prev = (CurriculumCourse)curriculumCourses.get(course.getCourse().getUniqueId());
                        if (prev == null || prev.getPercShare().floatValue() < course.getPercShare().floatValue()) {
                            curriculumCourses.put(course.getCourse().getUniqueId(), course);
                        }
                        ((TableCurriculumCourseGroupsProvider)course2groups).add(course);
                    }
                }
                for (CurriculumCourse course : this.iClassification.getCourses()) {
                    curriculumCourses.put(course.getCourse().getUniqueId(), course);
                    ((TableCurriculumCourseGroupsProvider)course2groups).add(course);
                }
                courses = curriculumCourses.values();
            }
            for (CurriculumCourse course : courses) {
                HashSet<String> majors;
                this.iModel.addCourse(course.getUniqueId(), course.getCourse().getCourseName(), course.getPercShare().floatValue() * (float)this.iClassification.getNrStudents().intValue(), CurriculaCourseDemands.this.iEnrollmentPriorityProvider.getEnrollmentPriority(course, course2groups));
                this.iCourses.put(course.getUniqueId(), course.getCourse());
                Hashtable curricula = (Hashtable)CurriculaCourseDemands.this.iLoadedCurricula.get(course.getCourse().getUniqueId());
                if (curricula == null) {
                    curricula = new Hashtable();
                    CurriculaCourseDemands.this.iLoadedCurricula.put(course.getCourse().getUniqueId(), curricula);
                }
                if ((majors = (HashSet<String>)curricula.get(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation())) == null) {
                    majors = new HashSet<String>();
                    curricula.put(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation(), majors);
                }
                if (this.iClassification.getCurriculum().getMajors().isEmpty()) {
                    majors.add("");
                    continue;
                }
                for (PosMajor mj : this.iClassification.getCurriculum().getMajors()) {
                    majors.add(mj.getCode());
                }
            }
            CurriculaCourseDemands.this.computeTargetShare(this.iClassification.getNrStudents(), courses, course2groups, this.iModel);
            if (CurriculaCourseDemands.this.iSetStudentCourseLimits) {
                this.iModel.setStudentLimits();
            }
            Solution<CurVariable, CurValue> cachedSolution = null;
            this.iAssignment = new DefaultSingleAssignment();
            Document cachedXml = this.iClassification.getStudentsDocument();
            Element element = cache = cachedXml == null ? null : cachedXml.getRootElement();
            if (cache != null && cache.getName().equals(CurriculaCourseDemands.this.getCacheName())) {
                cachedSolution = CurModel.loadFromXml(cache);
                if (CurriculaCourseDemands.this.iSetStudentCourseLimits) {
                    ((CurModel)cachedSolution.getModel()).setStudentLimits();
                }
            }
            if (cachedSolution != null && ((CurModel)cachedSolution.getModel()).isSameModel((Object)this.iModel)) {
                sLog.debug((Object)"  using cached model...");
                this.iModel = (CurModel)cachedSolution.getModel();
                this.iAssignment = cachedSolution.getAssignment();
            } else {
                this.iUpdateClassification = true;
            }
        }

        @Override
        public void execute() {
            if (this.iUpdateClassification) {
                this.iModel.solve(CurriculaCourseDemands.this.iProperties, this.iAssignment);
            }
        }

        @Override
        public void teardown(org.hibernate.Session hibSession) {
            if (this.iUpdateClassification) {
                Document doc = DocumentHelper.createDocument();
                this.iModel.saveAsXml(doc.addElement(CurriculaCourseDemands.this.getCacheName()), this.iAssignment);
                this.iClassification.setStudentsDocument(doc);
                hibSession.update((Object)this.iClassification);
            }
            String majors = "";
            for (PosMajor major : this.iClassification.getCurriculum().getMajors()) {
                if (!majors.isEmpty()) {
                    majors = majors + ",";
                }
                majors = majors + major.getCode();
            }
            for (CurStudent s : this.iModel.getStudents()) {
                StudentCourseDemands.WeightedStudentId student = new StudentCourseDemands.WeightedStudentId(-CurriculaCourseDemands.this.lastStudentId.newId(), this.iClassification);
                HashSet<StudentCourseDemands.WeightedCourseOffering> studentCourses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                CurriculaCourseDemands.this.iStudentRequests.put(student.getStudentId(), studentCourses);
                Hashtable<Long, Double> priorities = new Hashtable<Long, Double>();
                CurriculaCourseDemands.this.iEnrollmentPriorities.put(student.getStudentId(), priorities);
                for (CurCourse course : s.getCourses(this.iAssignment)) {
                    HashSet<StudentCourseDemands.WeightedStudentId> courseStudents;
                    CourseOffering co = this.iCourses.get(course.getCourseId());
                    if (course.getPriority() != null) {
                        priorities.put(co.getUniqueId(), course.getPriority());
                    }
                    if ((courseStudents = (HashSet<StudentCourseDemands.WeightedStudentId>)CurriculaCourseDemands.this.iDemands.get(co.getUniqueId())) == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
            }
        }
    }
}

