/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.TimetableXMLSaver;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.ParallelSolver;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.solver.TimetableDatabaseSaver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.interactive.Suggestions;
import org.unitime.timetable.solver.interactive.SuggestionsModel;
import org.unitime.timetable.solver.remote.BackupFileFilter;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.ConflictStatisticsInfo;
import org.unitime.timetable.solver.ui.DeptBalancingReport;
import org.unitime.timetable.solver.ui.DiscouragedInstructorBtbReport;
import org.unitime.timetable.solver.ui.PerturbationReport;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.solver.ui.RoomReport;
import org.unitime.timetable.solver.ui.SameSubpartBalancingReport;
import org.unitime.timetable.solver.ui.SolverUnassignedClassesModel;
import org.unitime.timetable.solver.ui.StudentConflictsReport;
import org.unitime.timetable.solver.ui.ViolatedDistrPreferencesReport;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.timegrid.SolverGridModel;
import org.unitime.timetable.webutil.timegrid.TimetableGridContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableSolver
extends ParallelSolver<Lecture, Placement>
implements SolverProxy {
    private static Log sLog = LogFactory.getLog(TimetableSolver.class);
    private boolean iWorking = false;
    private Date iLoadedDate = null;
    private int iDebugLevel = 3;
    private Vector iAssignmentRecords = new Vector();
    private Vector iBestAssignmentRecords = new Vector();
    private ConflictStatisticsInfo iCbsInfo = null;
    private CommitedClassAssignmentProxy iCommitedClassAssignmentProxy = null;
    private long iLastTimeStamp = System.currentTimeMillis();
    private boolean iIsPassivated = false;
    private Map iProgressBeforePassivation = null;
    private PropertiesInfo iGlobalInfoBeforePassivation = null;
    private Map<String, String> iCurrentSolutionInfoBeforePassivation = null;
    private Map<String, String> iBestSolutionInfoBeforePassivation = null;
    private File iPassivationFolder = null;
    private String iPassivationPuid = null;
    private Thread iWorkThread = null;
    private SolverDisposeListener iSolverDisposeListener;
    private HashSet iDepartmentIds = null;

    public TimetableSolver(DataProperties properties, SolverDisposeListener solverDisposeListener) {
        super(properties);
        this.iCommitedClassAssignmentProxy = new CommitedClassAssignmentProxy();
        this.iSolverDisposeListener = solverDisposeListener;
    }

    @Override
    public Date getLoadedDate() {
        List log;
        if (this.iLoadedDate == null && !this.isPassivated() && (log = Progress.getInstance((Object)this.currentSolution().getModel()).getLog()) != null && !log.isEmpty()) {
            this.iLoadedDate = ((Progress.Message)log.get(0)).getDate();
        }
        return this.iLoadedDate;
    }

    public Solution<Lecture, Placement> currentSolution() {
        this.activateIfNeeded();
        return super.currentSolution();
    }

    @Override
    public void start() {
        this.activateIfNeeded();
        this.iCbsInfo = null;
        super.start();
    }

    @Override
    public String getLog() {
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(this.iDebugLevel, true);
    }

    @Override
    public String getLog(int level, boolean includeDate) {
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(level, includeDate);
    }

    @Override
    public String getLog(int level, boolean includeDate, String fromStage) {
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(level, includeDate, fromStage);
    }

    @Override
    public String getNote() {
        return this.getProperties().getProperty("General.Note");
    }

    @Override
    public void setNote(String note) {
        this.getProperties().setProperty("General.Note", note);
    }

    @Override
    public void setDebugLevel(int level) {
        this.iDebugLevel = level;
    }

    @Override
    public int getDebugLevel() {
        return this.iDebugLevel;
    }

    @Override
    public boolean isWorking() {
        if (this.isRunning()) {
            return true;
        }
        return this.iWorking;
    }

    @Override
    public void restoreBest() {
        this.iAssignmentRecords = new Vector(this.iBestAssignmentRecords);
        this.currentSolution().restoreBest();
    }

    @Override
    public void saveBest() {
        this.iBestAssignmentRecords = new Vector(this.iAssignmentRecords);
        this.currentSolution().saveBest();
    }

    @Override
    public Map getProgress() {
        if (this.isPassivated()) {
            return this.iProgressBeforePassivation;
        }
        try {
            Hashtable<String, Object> ret = new Hashtable<String, Object>();
            Progress p = Progress.getInstance((Object)super.currentSolution().getModel());
            ret.put("STATUS", p.getStatus());
            ret.put("PHASE", p.getPhase());
            ret.put("PROGRESS", new Long(p.getProgress()));
            ret.put("MAX_PROGRESS", new Long(p.getProgressMax()));
            ret.put("VERSION", Constants.getVersion());
            return ret;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void finalSectioning() {
        this.iWorkThread = new FinalSectioning();
        this.iWorkThread.start();
    }

    @Override
    public void dispose() {
        this.disposeNoInherit(true);
    }

    private void disposeNoInherit(boolean unregister) {
        super.dispose();
        this.iAssignmentRecords.clear();
        this.iBestAssignmentRecords.clear();
        this.iCbsInfo = null;
        if (this.currentSolution() != null && this.currentSolution().getModel() != null) {
            Progress.removeInstance((Object)this.currentSolution().getModel());
        }
        this.setInitalSolution(null);
        if (unregister && this.iSolverDisposeListener != null) {
            this.iSolverDisposeListener.onDispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        super.onFinish();
        try {
            int repeat;
            this.iWorking = true;
            if (this.currentSolution().getBestInfo() != null) {
                this.currentSolution().restoreBest();
            }
            if (this.getProperties().getPropertyBoolean("General.SwitchStudents", true)) {
                ((TimetableModel)this.currentSolution().getModel()).switchStudents(this.currentSolution().getAssignment());
                this.currentSolution().saveBest();
            }
            if (this.currentSolution().getBestInfo() != null && this.getProperties().getPropertyBoolean("General.Save", false)) {
                TimetableDatabaseSaver saver = new TimetableDatabaseSaver((Solver)this);
                Lock lock = this.currentSolution().getLock().readLock();
                lock.lock();
                try {
                    saver.save();
                    Object var4_4 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            if ((repeat = this.getProperties().getPropertyInt("Test.Repeat", 0)) > 0) {
                this.getProperties().setProperty("Test.Repeat", String.valueOf(repeat - 1));
                this.getProperties().remove((Object)"General.SolutionId");
                this.load(this.getProperties());
                Object var6_7 = null;
                this.iWorking = false;
                return;
            }
            if (this.getProperties().getPropertyBoolean("General.Unload", false)) {
                this.dispose();
            } else {
                Progress.getInstance((Object)this.currentSolution().getModel()).setStatus("Awaiting commands ...");
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.iWorking = false;
            throw throwable;
        }
        Object var6_8 = null;
        this.iWorking = false;
    }

    protected void onStop() {
        super.onStop();
        if (this.currentSolution().getBestInfo() != null) {
            this.currentSolution().restoreBest();
        }
    }

    @Override
    public void save(boolean createNewSolution, boolean commitSolution) {
        this.iWorking = true;
        this.getProperties().setProperty("General.CreateNewSolution", createNewSolution ? "true" : "false");
        if (createNewSolution) {
            this.getProperties().remove((Object)"General.SolutionId");
        }
        this.getProperties().setProperty("General.CommitSolution", commitSolution ? "true" : "false");
        TimetableDatabaseSaver saver = new TimetableDatabaseSaver((Solver)this);
        saver.setCallback(this.getSavingDoneCallback());
        this.iWorkThread = new Thread((Runnable)((Object)saver));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    @Override
    public void load(DataProperties properties) {
        this.iAssignmentRecords.clear();
        this.iBestAssignmentRecords.clear();
        this.iCbsInfo = null;
        sLog.debug((Object)"History cleared");
        this.setProperties(properties);
        TimetableModel model = new TimetableModel(this.getProperties());
        Progress.getInstance((Object)model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
        this.iWorking = true;
        this.setInitalSolution((Model)model);
        this.initSolver();
        TimetableDatabaseLoader loader = new TimetableDatabaseLoader(model, (Assignment<Lecture, Placement>)this.currentSolution().getAssignment());
        loader.setCallback(this.getLoadingDoneCallback());
        this.iWorkThread = new Thread((Runnable)((Object)loader));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    @Override
    public void reload(DataProperties properties) {
        if (this.currentSolution() == null || this.currentSolution().getModel() == null) {
            this.load(properties);
            return;
        }
        Callback callBack = this.getReloadingDoneCallback();
        this.setProperties(properties);
        TimetableModel model = new TimetableModel(this.getProperties());
        this.iWorking = true;
        Progress.changeInstance((Object)this.currentSolution().getModel(), (Object)model);
        this.setInitalSolution((Model)model);
        this.initSolver();
        TimetableDatabaseLoader loader = new TimetableDatabaseLoader(model, (Assignment<Lecture, Placement>)this.currentSolution().getAssignment());
        loader.setCallback(callBack);
        this.iWorkThread = new Thread((Runnable)((Object)loader));
        this.iWorkThread.start();
    }

    public Callback getLoadingDoneCallback() {
        return new LoadingDoneCallback();
    }

    public Callback getReloadingDoneCallback() {
        return new ReloadingDoneCallback();
    }

    public Callback getSavingDoneCallback() {
        return new SavingDoneCallback();
    }

    protected void afterSave() {
    }

    protected void afterLoad() {
    }

    protected void afterFinalSectioning() {
    }

    protected boolean useAmPm() {
        return this.getProperties().getPropertyBoolean("General.UseAmPm", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertiesInfo getGlobalInfo() {
        if (this.isPassivated()) {
            return this.iGlobalInfoBeforePassivation;
        }
        Map info = null;
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info = super.currentSolution().getBestInfo();
            if (info == null) {
                info = super.currentSolution().getInfo();
            }
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
        PropertiesInfo globalInfo = new PropertiesInfo();
        for (Map.Entry entry : info.entrySet()) {
            String key = (String)entry.getKey();
            String value = entry.getValue().toString();
            globalInfo.setProperty(key, value);
        }
        return globalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConflictStatisticsInfo getCbsInfo() {
        ConflictStatistics cbs = null;
        for (Extension ext : this.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs == null || cbs.getNoGoods().isEmpty()) {
            if (this.iCbsInfo != null) {
                return this.iCbsInfo;
            }
            return null;
        }
        ConflictStatisticsInfo info = new ConflictStatisticsInfo();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info.load((Solver<Lecture, Placement>)this, cbs);
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConflictStatisticsInfo getCbsInfo(Long classId) {
        ConflictStatistics cbs = null;
        for (Extension ext : this.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs == null || cbs.getNoGoods().isEmpty()) {
            if (this.iCbsInfo != null) {
                return this.iCbsInfo;
            }
            return null;
        }
        ConflictStatisticsInfo info = new ConflictStatisticsInfo();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info.load((Solver<Lecture, Placement>)this, cbs, classId);
            Object var6_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SolverUnassignedClassesModel getUnassignedClassesModel(String prefix) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            SolverUnassignedClassesModel solverUnassignedClassesModel = new SolverUnassignedClassesModel(this, prefix);
            Object var5_4 = null;
            lock.unlock();
            return solverUnassignedClassesModel;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private boolean match(Query q, final String name) {
        return q == null || q.match(new Query.TermMatcher(){

            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(term, " ,");
                    block0: while (s.hasMoreTokens()) {
                        String termToken = s.nextToken();
                        StringTokenizer t = new StringTokenizer(name, " ,");
                        while (t.hasMoreTokens()) {
                            String token = t.nextToken();
                            if (!token.toLowerCase().startsWith(termToken.toLowerCase())) continue;
                            continue block0;
                        }
                        return false;
                    }
                    return true;
                }
                if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                    return name.matches(term);
                }
                if ("find".equals(attr)) {
                    return name.toLowerCase().indexOf(term.toLowerCase()) >= 0;
                }
                return false;
            }
        });
    }

    private boolean match(Query q, final RoomConstraint rc) {
        return q == null || q.match(new Query.TermMatcher(){

            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(rc.getName(), " ,");
                    while (s.hasMoreTokens()) {
                        String token = s.nextToken();
                        if (!term.equalsIgnoreCase(token)) continue;
                        return true;
                    }
                } else {
                    if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                        return rc.getName().matches(term);
                    }
                    if ("find".equals(attr)) {
                        return rc.getName().toLowerCase().indexOf(term.toLowerCase()) >= 0;
                    }
                    if ("type".equals(attr) && rc.getType() != null) {
                        RoomType type = (RoomType)RoomTypeDAO.getInstance().get(rc.getType());
                        return type != null && (term.equalsIgnoreCase(type.getReference()) || term.equalsIgnoreCase(type.getLabel()));
                    }
                    if ("size".equals(attr)) {
                        int min = 0;
                        int max = Integer.MAX_VALUE;
                        Size prefix = Size.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = Size.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = Size.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = Size.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = Size.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = Size.eq;
                            number = number.substring(1);
                        }
                        try {
                            int a = Integer.parseInt(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1;
                                    break;
                                }
                                case gt: {
                                    min = a + 1;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Integer.parseInt(a);
                                max = Integer.parseInt(b);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        return min <= rc.getCapacity() && rc.getCapacity() <= max;
                    }
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getTimetableGridTables(TimetableGridContext context) {
        Vector<SolverGridModel> models = new Vector<SolverGridModel>();
        Query q = context.getFilter() == null ? null : new Query(context.getFilter());
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            TimetableModel model = (TimetableModel)this.currentSolution().getModel();
            switch (context.getResourceType()) {
                case 0: {
                    for (RoomConstraint rc : model.getRoomConstraints()) {
                        if (!this.match(q, rc)) continue;
                        models.add(new SolverGridModel((Solver)this, rc, context));
                    }
                    break;
                }
                case 1: {
                    for (InstructorConstraint ic : model.getInstructorConstraints()) {
                        if (!this.match(q, ic.getName())) continue;
                        models.add(new SolverGridModel((Solver)this, ic, context));
                    }
                    break;
                }
                case 2: {
                    for (DepartmentSpreadConstraint dc : model.getDepartmentSpreadConstraints()) {
                        if (!this.match(q, dc.getName())) continue;
                        models.add(new SolverGridModel((Solver)this, dc, context));
                    }
                    if (!model.getDepartmentSpreadConstraints().isEmpty()) break;
                    Assignment assignment = this.currentSolution().getAssignment();
                    HashMap<Department, HashSet<Long>> dept2class = new HashMap<Department, HashSet<Long>>();
                    for (Object[] pair : DepartmentDAO.getInstance().getSession().createQuery("select c.controllingDept, c.uniqueId from Class_ c where c.managingDept.solverGroup.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", (Object[])this.getOwnerId(), (Type)new LongType()).list()) {
                        Department dept = (Department)pair[0];
                        Long l = (Long)pair[1];
                        HashSet<Long> classIds = (HashSet<Long>)dept2class.get(dept);
                        if (classIds == null) {
                            classIds = new HashSet<Long>();
                            dept2class.put(dept, classIds);
                        }
                        classIds.add(l);
                    }
                    for (Department d : new TreeSet(dept2class.keySet())) {
                        if (!this.match(q, d.getShortLabel())) continue;
                        Set classIds = (Set)dept2class.get(d);
                        int n = 0;
                        ArrayList<Placement> placements = new ArrayList<Placement>();
                        for (Lecture lecture : this.currentSolution().getModel().variables()) {
                            if (!classIds.contains(lecture.getClassId())) continue;
                            ++n;
                            Placement placement = (Placement)assignment.getValue((Variable)lecture);
                            if (placement == null) continue;
                            placements.add(placement);
                        }
                        if (n <= 0) continue;
                        models.add(new SolverGridModel((Solver)this, 2, d.getUniqueId(), d.getShortLabel(), n, placements, context));
                    }
                    break;
                }
                case 3: {
                    Hashtable curricula = new Hashtable();
                    boolean hasCurricula = false;
                    HashSet<String> ignore = new HashSet<String>();
                    HashSet<String> tested = new HashSet<String>();
                    for (Student student : model.getAllStudents()) {
                        List<Student> students;
                        String c;
                        if (student.getCurriculum() != null && student.getAcademicClassification() != null) {
                            if (!hasCurricula) {
                                curricula.clear();
                                hasCurricula = true;
                            }
                            if (tested.add(c = student.getCurriculum() + " " + student.getAcademicClassification()) && !this.match(q, c)) {
                                ignore.add(c);
                            }
                            if (ignore.contains(c)) continue;
                            students = (ArrayList<Student>)curricula.get(c);
                            if (students == null) {
                                students = new ArrayList<Student>();
                                curricula.put(c, students);
                            }
                            students.add(student);
                            continue;
                        }
                        if (hasCurricula || student.getAcademicArea() == null || student.getAcademicClassification() == null) continue;
                        c = student.getAcademicArea() + (student.getMajor() == null ? "" : " " + student.getMajor()) + " " + student.getAcademicClassification();
                        if (tested.add(c) && !this.match(q, c)) {
                            ignore.add(c);
                        }
                        if (ignore.contains(c)) continue;
                        students = (List)curricula.get(c);
                        if (students == null) {
                            students = new ArrayList();
                            curricula.put(c, students);
                        }
                        students.add(student);
                    }
                    for (Map.Entry entry : curricula.entrySet()) {
                        models.add(new SolverGridModel((Solver)this, (String)entry.getKey(), (List)entry.getValue(), context));
                    }
                    break;
                }
                case 4: {
                    Assignment assignment = this.currentSolution().getAssignment();
                    HashMap<SubjectArea, HashSet<Long>> hashMap = new HashMap<SubjectArea, HashSet<Long>>();
                    for (Object[] pair : DepartmentDAO.getInstance().getSession().createQuery("select co.subjectArea, c.uniqueId from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = true and c.managingDept.solverGroup.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", (Object[])this.getOwnerId(), (Type)new LongType()).list()) {
                        SubjectArea sa = (SubjectArea)pair[0];
                        Long classId = (Long)pair[1];
                        HashSet<Long> classIds = (HashSet<Long>)hashMap.get(sa);
                        if (classIds == null) {
                            classIds = new HashSet<Long>();
                            hashMap.put(sa, classIds);
                        }
                        classIds.add(classId);
                    }
                    for (SubjectArea sa : new TreeSet(hashMap.keySet())) {
                        if (!this.match(q, sa.getSubjectAreaAbbreviation())) continue;
                        Set classIds = (Set)hashMap.get(sa);
                        int size = 0;
                        ArrayList<Placement> placements = new ArrayList<Placement>();
                        for (Lecture lecture : this.currentSolution().getModel().variables()) {
                            if (!classIds.contains(lecture.getClassId())) continue;
                            ++size;
                            Placement placement = (Placement)assignment.getValue((Variable)lecture);
                            if (placement == null) continue;
                            placements.add(placement);
                        }
                        if (size <= 0) continue;
                        models.add(new SolverGridModel((Solver)this, 4, sa.getUniqueId(), sa.getSubjectAreaAbbreviation(), size, placements, context));
                    }
                    break;
                }
            }
            Object var21_42 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var21_43 = null;
            lock.unlock();
            throw throwable;
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassAssignmentDetails getClassAssignmentDetails(Long classId, boolean includeConstraints) {
        Iterator iterator;
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            TimetableModel model = (TimetableModel)this.currentSolution().getModel();
            for (Lecture lecture : model.variables()) {
                if (!lecture.getClassId().equals(classId)) continue;
                ClassAssignmentDetails classAssignmentDetails = new ClassAssignmentDetails((Solver)this, lecture, includeConstraints);
                Object var9_8 = null;
                lock.unlock();
                return classAssignmentDetails;
            }
            iterator = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            lock.unlock();
            throw throwable;
        }
        Object var9_9 = null;
        lock.unlock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Suggestions getSuggestions(SuggestionsModel model) {
        if (this.iWorking) {
            return null;
        }
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Suggestions suggestions = new Suggestions((Solver)this, model);
            Object var5_4 = null;
            lock.unlock();
            return suggestions;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignmentPreferenceInfo getInfo(Hint hint) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            AssignmentPreferenceInfo assignmentPreferenceInfo = hint.getInfo((Solver)this);
            Object var5_4 = null;
            lock.unlock();
            return assignmentPreferenceInfo;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNotValidReason(Hint hint) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            String string = hint.getNotValidReason((Solver)this);
            Object var5_4 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Collection hints) {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Placement p;
            Hashtable<Variable, Placement> initialAssignments = new Hashtable<Variable, Placement>();
            for (Placement placement : this.currentSolution().getAssignment().assignedValues()) {
                initialAssignments.put(placement.variable(), placement);
            }
            AssignmentRecord record = new AssignmentRecord((Solver)this);
            for (Hint hint : hints) {
                p = hint.getPlacement((TimetableModel)this.currentSolution().getModel());
                if (p != null) {
                    Placement ini = (Placement)initialAssignments.get(p.variable());
                    record.add(ini, p);
                    Progress.getInstance((Object)this.currentSolution().getModel()).info(((Lecture)p.variable()).getName() + ": " + (ini == null ? "not assigned" : ini.getLongName(this.useAmPm())) + " &rarr; " + p.getLongName(this.useAmPm()));
                    if (ini == null) continue;
                    this.currentSolution().getAssignment().unassign(0L, p.variable());
                    continue;
                }
                if (hint.getDays() != 0) continue;
                Lecture lecture = null;
                for (Lecture l : this.currentSolution().getModel().variables()) {
                    if (!l.getClassId().equals(hint.getClassId())) continue;
                    lecture = l;
                }
                if (lecture == null || lecture.isCommitted()) continue;
                this.currentSolution().getAssignment().unassign(0L, lecture);
            }
            for (Hint hint : hints) {
                p = hint.getPlacement((TimetableModel)this.currentSolution().getModel());
                if (p == null) continue;
                this.currentSolution().getAssignment().assign(0L, (Value)p);
            }
            for (Lecture lec : this.currentSolution().getModel().unassignedVariables(this.currentSolution().getAssignment())) {
                p = (Placement)initialAssignments.get(lec);
                if (p == null) continue;
                record.add(p, null);
                Progress.getInstance((Object)this.currentSolution().getModel()).info(((Lecture)p.variable()).getName() + ": " + p.getLongName(this.useAmPm()) + " &rarr; not assigned");
            }
            record.done();
            this.iAssignmentRecords.addElement(record);
            Object var12_11 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable conflictInfo(Collection hints) {
        Hashtable<Hint, String> conflictTable = new Hashtable<Hint, String>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            HashSet<Hint> done = new HashSet<Hint>();
            for (Hint hint : hints) {
                Placement p = hint.getPlacement((TimetableModel)this.currentSolution().getModel());
                if (p == null) continue;
                for (Constraint constraint : ((Lecture)p.variable()).hardConstraints()) {
                    HashSet conflicts = new HashSet();
                    constraint.computeConflicts(this.currentSolution().getAssignment(), (Value)p, conflicts);
                    if (conflicts == null || conflicts.isEmpty()) continue;
                    for (Placement conflict : conflicts) {
                        Hint confHint = new Hint((Solver)this, conflict);
                        if (done.contains(confHint) || conflictTable.containsKey(confHint)) continue;
                        String name = constraint.getName();
                        if (constraint instanceof RoomConstraint) {
                            name = "Room " + constraint.getName();
                        } else if (constraint instanceof InstructorConstraint) {
                            name = "Instructor " + constraint.getName();
                        } else if (constraint instanceof GroupConstraint) {
                            name = "Distribution " + constraint.getName();
                        } else if (constraint instanceof DepartmentSpreadConstraint) {
                            name = "Balancing of department " + constraint.getName();
                        } else if (constraint instanceof SpreadConstraint) {
                            name = "Same subpart spread " + constraint.getName();
                        } else if (constraint instanceof ClassLimitConstraint) {
                            name = "Class limit " + constraint.getName();
                        }
                        conflictTable.put(confHint, name);
                    }
                }
                done.add(hint);
            }
            Object var16_15 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            lock.unlock();
            throw throwable;
        }
        return conflictTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> currentSolutionInfo() {
        if (this.isPassivated()) {
            return this.iCurrentSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map map = super.currentSolution().getExtendedInfo();
            Object var4_3 = null;
            lock.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> bestSolutionInfo() {
        if (this.isPassivated()) {
            return this.iBestSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map map = super.currentSolution().getBestInfo();
            Object var4_3 = null;
            lock.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void setProperties(DataProperties properties) {
        this.activateIfNeeded();
        this.getProperties().putAll((Map)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean backup(File folder, String puid) {
        boolean bl;
        folder.mkdirs();
        if (this.currentSolution() == null) {
            return false;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        TimetableXMLSaver saver = new TimetableXMLSaver((Solver)this);
        File outXmlFile = new File(folder, puid + BackupFileFilter.sXmlExtension);
        File outPropertiesFile = new File(folder, puid + BackupFileFilter.sPropertiesExtension);
        try {
            saver.save(outXmlFile);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outPropertiesFile);
                this.getProperties().store((OutputStream)fos, "Backup file");
                fos.flush();
                fos.close();
                fos = null;
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
            bl = true;
        }
        catch (Exception e) {
            try {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                if (outXmlFile.exists()) {
                    outXmlFile.delete();
                }
                if (outPropertiesFile.exists()) {
                    outPropertiesFile.delete();
                }
                Object var12_16 = null;
                lock.unlock();
                return false;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                lock.unlock();
                throw throwable;
            }
        }
        Object var12_15 = null;
        lock.unlock();
        return bl;
    }

    @Override
    public boolean restore(File folder, String puid) {
        return this.restore(folder, puid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean restore(File folder, String puid, boolean removeFiles) {
        this.iAssignmentRecords.clear();
        this.iBestAssignmentRecords.clear();
        this.iCbsInfo = null;
        sLog.debug((Object)("restore(folder=" + folder + ",puid=" + puid + ")"));
        File inXmlFile = new File(folder, puid + BackupFileFilter.sXmlExtension);
        File inPropertiesFile = new File(folder, puid + BackupFileFilter.sPropertiesExtension);
        TimetableModel model = null;
        try {
            block8: {
                if (this.isRunning()) {
                    this.stopSolver();
                }
                this.disposeNoInherit(false);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(inPropertiesFile);
                    this.getProperties().load((InputStream)fis);
                    Object var9_9 = null;
                    if (fis == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                fis.close();
            }
            model = new TimetableModel(this.getProperties());
            Progress.getInstance((Object)model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            this.setInitalSolution((Model)model);
            this.initSolver();
            TimetableXMLLoader loader = new TimetableXMLLoader(model, this.currentSolution().getAssignment());
            loader.setSolver((Solver)this);
            loader.setInputFile(inXmlFile);
            loader.load(this.currentSolution());
            loader.setSolver(null);
            Progress.getInstance((Object)model).setStatus("Awaiting commands ...");
            if (removeFiles) {
                inXmlFile.delete();
                inPropertiesFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            if (model != null) {
                Progress.removeInstance(model);
            }
            return false;
        }
    }

    public Long[] getOwnerId() {
        return this.getProperties().getPropertyLongArry("General.SolverGroupId", null);
    }

    @Override
    public Set getDepartmentIds() {
        if (this.iDepartmentIds != null) {
            return this.iDepartmentIds;
        }
        this.iDepartmentIds = new HashSet();
        Long[] ownerId = this.getOwnerId();
        for (int i = 0; i < ownerId.length; ++i) {
            SolverGroup sg = (SolverGroup)new SolverGroupDAO().get(ownerId[i]);
            Iterator<Department> j = sg.getDepartments().iterator();
            while (j.hasNext()) {
                this.iDepartmentIds.add(j.next().getUniqueId());
            }
        }
        return this.iDepartmentIds;
    }

    @Override
    public org.unitime.timetable.model.Assignment getAssignment(Class_ clazz) throws Exception {
        Department dept = clazz.getManagingDept();
        if (dept != null && this.getDepartmentIds().contains(dept.getUniqueId())) {
            return this.getAssignment(clazz.getUniqueId());
        }
        return this.iCommitedClassAssignmentProxy.getAssignment(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.unitime.timetable.model.Assignment getAssignment(Long classId) {
        Placement placement;
        Lecture lecture;
        Lock lock;
        block13: {
            Lecture l2;
            block12: {
                lock = this.currentSolution().getLock().readLock();
                lock.lock();
                lecture = null;
                for (Lecture l2 : this.currentSolution().getModel().variables()) {
                    if (!l2.getClassId().equals(classId)) continue;
                    lecture = l2;
                    break;
                }
                if (lecture != null) break block12;
                Iterator iterator = null;
                Object var13_6 = null;
                lock.unlock();
                return iterator;
            }
            placement = (Placement)this.currentSolution().getAssignment().getValue(lecture);
            if (placement != null) break block13;
            l2 = null;
            Object var13_7 = null;
            lock.unlock();
            return l2;
        }
        try {
            org.unitime.timetable.model.Assignment assignment = new org.unitime.timetable.model.Assignment();
            assignment.setClassName(lecture.getName());
            assignment.setDays(new Integer(placement.getTimeLocation().getDayCode()));
            assignment.setStartSlot(new Integer(placement.getTimeLocation().getStartSlot()));
            if (placement.getTimeLocation().getDatePatternId() != null) {
                assignment.setDatePattern((DatePattern)DatePatternDAO.getInstance().get(placement.getTimeLocation().getDatePatternId()));
            }
            assignment.setSlotsPerMtg(placement.getTimeLocation().getLength());
            assignment.setBreakTime(placement.getTimeLocation().getBreakTime());
            HashSet<Location> rooms = new HashSet<Location>();
            if (placement.isMultiRoom()) {
                for (RoomLocation r : placement.getRoomLocations()) {
                    Location room = (Location)new LocationDAO().get(r.getId());
                    if (room == null) continue;
                    rooms.add(room);
                }
            } else {
                Location room = (Location)new LocationDAO().get(placement.getRoomLocation().getId());
                if (room != null) {
                    rooms.add(room);
                }
            }
            assignment.setRooms(rooms);
            TimePattern pattern = (TimePattern)new TimePatternDAO().get(placement.getTimeLocation().getTimePatternId());
            assignment.setTimePattern(pattern);
            HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                DepartmentalInstructor instructor = null;
                if (ic.getResourceId() != null) {
                    instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(ic.getResourceId());
                }
                if (instructor == null) continue;
                instructors.add(instructor);
            }
            assignment.setInstructors(instructors);
            org.unitime.timetable.model.Assignment assignment2 = assignment;
            Object var13_8 = null;
            lock.unlock();
            return assignment2;
        }
        catch (Throwable throwable) {
            Object var13_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) throws Exception {
        Department dept = clazz.getManagingDept();
        if (dept != null && this.getDepartmentIds().contains(dept.getUniqueId())) {
            return this.getAssignmentInfo(clazz.getUniqueId());
        }
        return this.iCommitedClassAssignmentProxy.getAssignmentInfo(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) {
        AssignmentPreferenceInfo assignmentPreferenceInfo;
        Placement placement;
        Lock lock;
        block6: {
            Lecture lecture;
            block5: {
                lock = this.currentSolution().getLock().readLock();
                lock.lock();
                try {
                    lecture = null;
                    for (Lecture l : this.currentSolution().getModel().variables()) {
                        if (!l.getClassId().equals(classId)) continue;
                        lecture = l;
                        break;
                    }
                    if (lecture != null) break block5;
                    Iterator iterator = null;
                    Object var7_6 = null;
                    lock.unlock();
                    return iterator;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            placement = (Placement)this.currentSolution().getAssignment().getValue(lecture);
            if (placement != null) break block6;
            assignmentPreferenceInfo = null;
            Object var7_7 = null;
            lock.unlock();
            return assignmentPreferenceInfo;
        }
        assignmentPreferenceInfo = new AssignmentPreferenceInfo((Solver)this, placement);
        Object var7_8 = null;
        lock.unlock();
        return assignmentPreferenceInfo;
    }

    @Override
    public Hashtable getAssignmentTable(Collection classesOrClassIds) throws Exception {
        Hashtable<Long, org.unitime.timetable.model.Assignment> assignments = new Hashtable<Long, org.unitime.timetable.model.Assignment>();
        for (Object classOrClassId : classesOrClassIds) {
            org.unitime.timetable.model.Assignment assignment;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((assignment = classOrClassId instanceof Class_ ? this.getAssignment((Class_)classOrClassId) : this.getAssignment((Long)classOrClassId)) == null) continue;
            assignments.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, assignment);
        }
        return assignments;
    }

    @Override
    public Hashtable getAssignmentTable2(Collection classesOrClassIds) throws Exception {
        return this.getAssignmentTable(classesOrClassIds);
    }

    @Override
    public Hashtable getAssignmentInfoTable(Collection classesOrClassIds) throws Exception {
        Hashtable<Long, AssignmentPreferenceInfo> infos = new Hashtable<Long, AssignmentPreferenceInfo>();
        for (Object classOrClassId : classesOrClassIds) {
            AssignmentPreferenceInfo info;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((info = classOrClassId instanceof Class_ ? this.getAssignmentInfo((Class_)classOrClassId) : this.getAssignmentInfo((Long)classOrClassId)) == null) continue;
            infos.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, info);
        }
        return infos;
    }

    @Override
    public Hashtable getAssignmentInfoTable2(Collection classesOrClassIds) throws Exception {
        return this.getAssignmentInfoTable(classesOrClassIds);
    }

    @Override
    public Vector getAssignmentRecords() {
        return this.iAssignmentRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getChangesToInitial() {
        Vector<RecordedAssignment> ret = new Vector<RecordedAssignment>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getModel().variables()) {
                if (ToolBox.equals((Object)lecture.getInitialAssignment(), (Object)this.currentSolution().getAssignment().getValue((Variable)lecture))) continue;
                RecordedAssignment a = new RecordedAssignment((Solver)this, (Placement)lecture.getInitialAssignment(), (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture));
                if (lecture.getInitialAssignment() != null) {
                    a.getBefore().setDetails(new ClassAssignmentDetails((Solver)this, lecture, (Placement)lecture.getInitialAssignment(), false));
                }
                if (this.currentSolution().getAssignment().getValue((Variable)lecture) != null) {
                    a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                }
                ret.addElement(a);
            }
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAssignedClasses() {
        Vector<ClassAssignmentDetails> ret = new Vector<ClassAssignmentDetails>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getAssignment().assignedVariables()) {
                ret.addElement(new ClassAssignmentDetails((Solver)this, lecture, false));
            }
            Object var6_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAssignedClasses(String prefix) {
        Vector<ClassAssignmentDetails> ret = new Vector<ClassAssignmentDetails>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getAssignment().assignedVariables()) {
                if (prefix != null && !lecture.getName().startsWith(prefix)) continue;
                ret.addElement(new ClassAssignmentDetails((Solver)this, lecture, false));
            }
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getChangesToBest() {
        Vector<RecordedAssignment> ret = new Vector<RecordedAssignment>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getModel().variables()) {
                Placement placement = (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                if (ToolBox.equals((Object)lecture.getBestAssignment(), (Object)placement)) continue;
                RecordedAssignment a = new RecordedAssignment((Solver)this, (Placement)lecture.getBestAssignment(), placement);
                if (lecture.getBestAssignment() != null) {
                    a.getBefore().setDetails(new ClassAssignmentDetails((Solver)this, lecture, (Placement)lecture.getBestAssignment(), false));
                }
                if (placement != null) {
                    a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                }
                ret.addElement(a);
            }
            Object var8_7 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
        return ret;
    }

    @Override
    public Vector getChangesToSolution(Long solutionId) throws Exception {
        return this.getChangesToSolution(solutionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getChangesToSolution(Long solutionId, boolean closeSession) throws Exception {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Long ownerId;
            org.unitime.timetable.model.Solution solution;
            Vector<RecordedAssignment> ret;
            Transaction tx;
            Session hibSession;
            block17: {
                block16: {
                    hibSession = new SolutionDAO().getSession();
                    tx = null;
                    ret = new Vector<RecordedAssignment>();
                    tx = hibSession.beginTransaction();
                    solution = (org.unitime.timetable.model.Solution)new SolutionDAO().get(solutionId, hibSession);
                    if (solution != null) break block16;
                    Vector vector = null;
                    Object var18_11 = null;
                    if (closeSession && hibSession != null && hibSession.isOpen()) {
                        hibSession.close();
                    }
                    Object var20_15 = null;
                    lock.unlock();
                    return vector;
                }
                ownerId = solution.getOwner().getUniqueId();
                Long[] ownerIds = this.getOwnerId();
                boolean sameOwner = false;
                for (int i = 0; i < ownerIds.length; ++i) {
                    if (!ownerId.equals(ownerIds[i])) continue;
                    sameOwner = true;
                    break;
                }
                if (sameOwner) break block17;
                Vector i = null;
                Object var18_12 = null;
                if (closeSession && hibSession != null && hibSession.isOpen()) {
                    hibSession.close();
                }
                Object var20_16 = null;
                lock.unlock();
                return i;
            }
            try {
                block18: {
                    try {
                        HashSet<Long> ids = new HashSet<Long>();
                        for (org.unitime.timetable.model.Assignment assignment : solution.getAssignments()) {
                            RecordedAssignment a;
                            Placement placement;
                            Lecture lecture = null;
                            for (Lecture l : this.currentSolution().getModel().variables()) {
                                if (!l.getClassId().equals(assignment.getClassId())) continue;
                                lecture = l;
                                break;
                            }
                            ids.add(assignment.getClassId());
                            Placement placement2 = placement = lecture == null ? null : (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                            if (lecture == null || placement == null) {
                                a = new RecordedAssignment((Solver)this, assignment.getPlacement(), null);
                                a.getBefore().setDetails(new ClassAssignmentDetails(solution, assignment, false, hibSession, null));
                                ret.addElement(a);
                                continue;
                            }
                            if (placement.equals((Object)assignment.getPlacement())) continue;
                            a = new RecordedAssignment((Solver)this, assignment.getPlacement(), placement);
                            a.getBefore().setDetails(new ClassAssignmentDetails(solution, assignment, false, hibSession, null));
                            a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                            ret.addElement(a);
                        }
                        for (Lecture lecture : this.currentSolution().getModel().variables()) {
                            Placement placement = (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                            if (ids.contains(lecture.getClassId()) || placement == null || !ownerId.equals(lecture.getSolverGroupId())) continue;
                            RecordedAssignment a = new RecordedAssignment((Solver)this, null, placement);
                            a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                            ret.addElement(a);
                        }
                        if (tx == null) break block18;
                        tx.commit();
                    }
                    catch (Exception e) {
                        if (tx == null) throw e;
                        tx.rollback();
                        throw e;
                    }
                }
                Object var18_13 = null;
                if (closeSession && hibSession != null && hibSession.isOpen()) {
                    hibSession.close();
                }
            }
            catch (Throwable throwable) {
                Object var18_14 = null;
                if (!closeSession) throw throwable;
                if (hibSession == null) throw throwable;
                if (!hibSession.isOpen()) throw throwable;
                hibSession.close();
                throw throwable;
            }
            Vector<RecordedAssignment> vector = ret;
            Object var20_17 = null;
            lock.unlock();
            return vector;
        }
        catch (Throwable throwable) {
            Object var20_18 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoomReport getRoomReport(BitSet sessionDays, int startDayDayOfWeek, Long roomType, Float nrWeeks) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            RoomReport roomReport = new RoomReport((Solver<Lecture, Placement>)this, sessionDays, startDayDayOfWeek, roomType, nrWeeks);
            Object var8_7 = null;
            lock.unlock();
            return roomReport;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeptBalancingReport getDeptBalancingReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            DeptBalancingReport deptBalancingReport = new DeptBalancingReport((Solver)this);
            Object var4_3 = null;
            lock.unlock();
            return deptBalancingReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViolatedDistrPreferencesReport getViolatedDistrPreferencesReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            ViolatedDistrPreferencesReport violatedDistrPreferencesReport = new ViolatedDistrPreferencesReport((Solver)this);
            Object var4_3 = null;
            lock.unlock();
            return violatedDistrPreferencesReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscouragedInstructorBtbReport getDiscouragedInstructorBtbReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            DiscouragedInstructorBtbReport discouragedInstructorBtbReport = new DiscouragedInstructorBtbReport((Solver)this);
            Object var4_3 = null;
            lock.unlock();
            return discouragedInstructorBtbReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StudentConflictsReport getStudentConflictsReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            StudentConflictsReport studentConflictsReport = new StudentConflictsReport((Solver)this);
            Object var4_3 = null;
            lock.unlock();
            return studentConflictsReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SameSubpartBalancingReport getSameSubpartBalancingReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            SameSubpartBalancingReport sameSubpartBalancingReport = new SameSubpartBalancingReport((Solver)this);
            Object var4_3 = null;
            lock.unlock();
            return sameSubpartBalancingReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PerturbationReport getPerturbationReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            PerturbationReport perturbationReport = new PerturbationReport((Solver)this);
            Object var4_3 = null;
            lock.unlock();
            return perturbationReport;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void load(Element element) {
        try {
            Element bestAssignmentRecords;
            this.iAssignmentRecords.clear();
            this.iBestAssignmentRecords.clear();
            Element assignmentRecords = element.element("assignmentRecords");
            if (assignmentRecords != null) {
                Iterator i = assignmentRecords.elementIterator("record");
                while (i.hasNext()) {
                    this.iAssignmentRecords.add(AssignmentRecord.fromXml((Element)i.next()));
                }
            }
            if ((bestAssignmentRecords = element.element("bestAssignmentRecords")) != null) {
                Iterator i = bestAssignmentRecords.elementIterator("record");
                while (i.hasNext()) {
                    this.iBestAssignmentRecords.add(AssignmentRecord.fromXml((Element)i.next()));
                }
            }
            if (element.element("cbsInfo") != null) {
                this.iCbsInfo = new ConflictStatisticsInfo();
                this.iCbsInfo.load(element.element("cbsInfo"));
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to load solver-related data, reson:" + e.getMessage()), (Throwable)e);
        }
    }

    public void save(Element element) {
        try {
            ConflictStatisticsInfo cbsInfo;
            AssignmentRecord r;
            Enumeration e;
            if (!this.iAssignmentRecords.isEmpty()) {
                Element assignmentRecords = element.addElement("assignmentRecords");
                e = this.iAssignmentRecords.elements();
                while (e.hasMoreElements()) {
                    r = (AssignmentRecord)e.nextElement();
                    r.toXml(assignmentRecords.addElement("record"));
                }
            }
            if (!this.iBestAssignmentRecords.isEmpty()) {
                Element bestAssignmentRecords = element.addElement("bestAssignmentRecords");
                e = this.iBestAssignmentRecords.elements();
                while (e.hasMoreElements()) {
                    r = (AssignmentRecord)e.nextElement();
                    r.toXml(bestAssignmentRecords.addElement("record"));
                }
            }
            if ((cbsInfo = this.getCbsInfo()) != null) {
                cbsInfo.save(element.addElement("cbsInfo"));
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save solver-related data, reson:" + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSVFile export(boolean useAmPm) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            CSVFile file = new CSVFile();
            file.setSeparator(",");
            file.setQuotationMark("\"");
            file.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"COURSE"), new CSVFile.CSVField((Object)"ITYPE"), new CSVFile.CSVField((Object)"SECTION"), new CSVFile.CSVField((Object)"SUFFIX"), new CSVFile.CSVField((Object)"DATE_PATTERN"), new CSVFile.CSVField((Object)"DAY"), new CSVFile.CSVField((Object)"START_TIME"), new CSVFile.CSVField((Object)"END_TIME"), new CSVFile.CSVField((Object)"ROOM"), new CSVFile.CSVField((Object)"INSTRUCTOR")});
            Vector lectures = new Vector(this.currentSolution().getModel().variables());
            Collections.sort(lectures);
            for (Lecture lecture : lectures) {
                Placement placement = (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                String name = lecture.getName();
                String itype = "";
                String section = "";
                if (name.indexOf(32) >= 0) {
                    section = name.substring(name.lastIndexOf(32) + 1);
                    name = name.substring(0, name.lastIndexOf(32)).trim();
                }
                String suffix = "";
                while (section.charAt(section.length() - 1) >= 'a' && section.charAt(section.length() - 1) <= 'z') {
                    suffix = section.charAt(section.length() - 1) + suffix;
                    section = section.substring(0, section.length() - 1);
                }
                if (name.indexOf(32) >= 0) {
                    itype = name.substring(name.lastIndexOf(32) + 1);
                    name = name.substring(0, name.lastIndexOf(32)).trim();
                }
                try {
                    Integer.parseInt(itype);
                    itype = name.substring(name.lastIndexOf(32) + 1) + " " + itype;
                    name = name.substring(0, name.lastIndexOf(32)).trim();
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)name), new CSVFile.CSVField((Object)itype), new CSVFile.CSVField((Object)section), new CSVFile.CSVField((Object)suffix), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getDatePatternName())), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getDayHeader())), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getStartTimeHeader(useAmPm))), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getEndTimeHeader(useAmPm))), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getRoomName(","))), new CSVFile.CSVField((Object)(lecture.getInstructorName() == null ? "" : lecture.getInstructorName()))});
            }
            CSVFile cSVFile = file;
            Object var14_13 = null;
            lock.unlock();
            return cSVFile;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public synchronized boolean isPassivated() {
        return this.iIsPassivated;
    }

    @Override
    public synchronized long timeFromLastUsed() {
        return System.currentTimeMillis() - this.iLastTimeStamp;
    }

    @Override
    public synchronized boolean activateIfNeeded() {
        this.iLastTimeStamp = System.currentTimeMillis();
        if (!this.isPassivated()) {
            return false;
        }
        sLog.debug((Object)("<activate " + this.iPassivationPuid + ">"));
        this.iIsPassivated = false;
        System.gc();
        sLog.debug((Object)(" -- memory usage before activation:" + Debug.getMem()));
        this.restore(this.iPassivationFolder, this.iPassivationPuid, true);
        System.gc();
        sLog.debug((Object)(" -- memory usage after activation:" + Debug.getMem()));
        return true;
    }

    @Override
    public synchronized boolean passivate(File folder, String puid) {
        if (this.isPassivated() || super.currentSolution() == null || super.currentSolution().getModel() == null) {
            return false;
        }
        sLog.debug((Object)("<passivate " + puid + ">"));
        System.gc();
        sLog.debug((Object)(" -- memory usage before passivation:" + Debug.getMem()));
        this.iProgressBeforePassivation = this.getProgress();
        if (this.iProgressBeforePassivation != null) {
            this.iProgressBeforePassivation.put("STATUS", "Pasivated");
        }
        this.iGlobalInfoBeforePassivation = this.getGlobalInfo();
        this.iCurrentSolutionInfoBeforePassivation = this.currentSolutionInfo();
        this.iBestSolutionInfoBeforePassivation = this.bestSolutionInfo();
        this.iPassivationFolder = folder;
        this.iPassivationPuid = puid;
        this.backup(this.iPassivationFolder, this.iPassivationPuid);
        this.disposeNoInherit(false);
        System.gc();
        sLog.debug((Object)(" -- memory usage after passivation:" + Debug.getMem()));
        this.iIsPassivated = true;
        return true;
    }

    @Override
    public synchronized boolean passivateIfNeeded(File folder, String puid) {
        long inactiveTimeToPassivate = 60000L * (long)ApplicationProperty.SolverPasivationTime.intValue().intValue();
        if (this.isPassivated() || inactiveTimeToPassivate <= 0L || this.timeFromLastUsed() < inactiveTimeToPassivate || this.isWorking()) {
            return false;
        }
        return this.passivate(folder, puid);
    }

    @Override
    public Date getLastUsed() {
        return new Date(this.iLastTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exportXml() throws Exception {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            File temp = File.createTempFile("course-" + this.getProperties().getProperty("General.SolverGroupId", "").replace(',', '-'), ".xml");
            File conv = null;
            boolean anonymize = ApplicationProperty.SolverXMLExportNames.isFalse();
            boolean idconv = ApplicationProperty.SolverXMLExportConvertIds.isTrue();
            if (anonymize) {
                this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
                this.getProperties().setProperty("Xml.ShowNames", "false");
                if (idconv) {
                    conv = File.createTempFile("idconv-" + this.getProperties().getProperty("General.SolverGroupId", "").replace(',', '-'), ".xml");
                    this.getProperties().setProperty("Xml.IdConv", conv.getPath());
                    Document document = DocumentHelper.createDocument();
                    document.addElement("id-convertor");
                    FileOutputStream cos = new FileOutputStream(conv);
                    new XMLWriter((OutputStream)cos, OutputFormat.createPrettyPrint()).write(document);
                    cos.flush();
                    cos.close();
                }
            }
            TimetableXMLSaver saver = new TimetableXMLSaver((Solver)this);
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            try {
                saver.save(temp);
                FileInputStream fis = new FileInputStream(temp);
                byte[] buf = new byte[16384];
                int read = 0;
                while ((read = fis.read(buf, 0, buf.length)) > 0) {
                    ret.write(buf, 0, read);
                }
                ret.flush();
                ret.close();
                fis.close();
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
            }
            temp.delete();
            if (conv != null) {
                conv.delete();
            }
            if (anonymize) {
                this.getProperties().setProperty("Xml.ConvertIds", "false");
                this.getProperties().setProperty("Xml.ShowNames", "true");
                this.getProperties().remove((Object)"Xml.IdConv");
            }
            byte[] byArray = ret.toByteArray();
            Object var12_12 = null;
            lock.unlock();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void interrupt() {
        try {
            if (this.iSolverThread != null) {
                this.iStop = true;
                if (this.iSolverThread.isAlive() && !this.iSolverThread.isInterrupted()) {
                    this.iSolverThread.interrupt();
                }
            }
            if (this.iWorkThread != null && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted()) {
                this.iWorkThread.interrupt();
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to interrupt the solver, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> statusSolutionInfo() {
        if (this.isPassivated()) {
            return this.iBestSolutionInfoBeforePassivation == null ? this.iCurrentSolutionInfoBeforePassivation : this.iBestSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map info = super.currentSolution().getBestInfo();
            try {
                Solution solution = this.getWorkingSolution();
                if (info == null || this.getSolutionComparator().isBetterThanBestSolution(solution)) {
                    info = solution.getModel().getInfo(solution.getAssignment());
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            Map map = info;
            Object var5_5 = null;
            lock.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object exec(Object[] cmd) throws Exception {
        Class[] types = new Class[(cmd.length - 2) / 2];
        Object[] args = new Object[(cmd.length - 2) / 2];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (Class)cmd[2 * i + 2];
            args[i] = cmd[2 * i + 3];
        }
        return this.getClass().getMethod((String)cmd[0], types).invoke((Object)this, args);
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public String getUser() {
        return this.getProperties().getProperty("General.OwnerPuid");
    }

    @Override
    public boolean hasFinalSectioning() {
        return ((TimetableModel)this.currentSolution().getModel()).getStudentSectioning().hasFinalSectioning();
    }

    @Override
    public boolean hasConflicts(Long offeringId) throws Exception {
        return false;
    }

    @Override
    public Set<org.unitime.timetable.model.Assignment> getConflicts(Long classId) throws Exception {
        return null;
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) throws Exception {
        return null;
    }

    public static interface SolverDisposeListener {
        public void onDispose();
    }

    public static class RecordedAssignment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Hint iBefore = null;
        private Hint iAfter = null;

        public RecordedAssignment(Solver solver, Placement before, Placement after) {
            if (before != null) {
                this.iBefore = new Hint(solver, before, false);
            }
            if (after != null) {
                this.iAfter = new Hint(solver, after, false);
            }
        }

        public RecordedAssignment(Hint before, Hint after) {
            this.iBefore = before;
            this.iAfter = after;
        }

        public Hint getBefore() {
            return this.iBefore;
        }

        public Hint getAfter() {
            return this.iAfter;
        }

        public void toXml(Element element) {
            if (this.iBefore != null) {
                this.iBefore.toXml(element.addElement("before"));
            }
            if (this.iAfter != null) {
                this.iAfter.toXml(element.addElement("after"));
            }
        }

        public static RecordedAssignment fromXml(Element element) {
            Hint before = null;
            Hint after = null;
            if (element.element("before") != null) {
                before = Hint.fromXml(element.element("before"));
            }
            if (element.element("after") != null) {
                after = Hint.fromXml(element.element("after"));
            }
            return new RecordedAssignment(before, after);
        }
    }

    public static class AssignmentRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Solver iSolver;
        private Date iTimeStamp = new Date();
        private Suggestion iBefore = null;
        private Suggestion iAfter = null;
        private Vector iAssignments = new Vector();

        public AssignmentRecord() {
        }

        public AssignmentRecord(Solver solver) {
            this.iSolver = solver;
            this.iBefore = new Suggestion(this.iSolver);
        }

        public void done() {
            this.iAfter = new Suggestion(this.iSolver);
        }

        public void add(Placement before, Placement after) {
            this.iAssignments.add(new RecordedAssignment(this.iSolver, before, after));
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public Suggestion getBefore() {
            return this.iBefore;
        }

        public Suggestion getAfter() {
            return this.iAfter;
        }

        public Vector getAssignments() {
            return this.iAssignments;
        }

        public String toString() {
            return "Record{TS=" + this.iTimeStamp + ", before=" + this.iBefore + ", after=" + this.iAfter + ", assignments=" + this.iAssignments.size() + "}";
        }

        public void toXml(Element element) throws Exception {
            if (this.iTimeStamp != null) {
                element.addAttribute("timeStamp", String.valueOf(this.iTimeStamp.getTime()));
            }
            if (this.iBefore != null) {
                this.iBefore.toXml(element.addElement("before"));
            }
            if (this.iAfter != null) {
                this.iAfter.toXml(element.addElement("after"));
            }
            if (this.iAssignments != null) {
                Enumeration e = this.iAssignments.elements();
                while (e.hasMoreElements()) {
                    RecordedAssignment ra = (RecordedAssignment)e.nextElement();
                    ra.toXml(element.addElement("assignment"));
                }
            }
        }

        public static AssignmentRecord fromXml(Element element) throws Exception {
            AssignmentRecord r = new AssignmentRecord();
            if (element.attributeValue("timeStamp") != null) {
                r.iTimeStamp = new Date(Long.parseLong(element.attributeValue("timeStamp")));
            }
            if (element.element("before") != null) {
                r.iBefore = Suggestion.fromXml(element.element("before"));
            }
            if (element.element("after") != null) {
                r.iAfter = Suggestion.fromXml(element.element("after"));
            }
            Iterator i = element.elementIterator("assignment");
            while (i.hasNext()) {
                r.iAssignments.add(RecordedAssignment.fromXml((Element)i.next()));
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }

    public class SavingDoneCallback
    implements Callback {
        public void execute() {
            TimetableSolver.this.iWorking = false;
            TimetableSolver.this.afterSave();
            Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }

    public class LoadingDoneCallback
    implements Callback {
        public void execute() {
            TimetableSolver.this.iLoadedDate = new Date();
            TimetableSolver.this.iWorking = false;
            TimetableSolver.this.afterLoad();
            Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
            if (TimetableSolver.this.getProperties().getPropertyBoolean("General.StartSolver", false)) {
                TimetableSolver.this.start();
            }
        }
    }

    public class ReloadingDoneCallback
    implements Callback {
        Hashtable iCurrentAssignmentTable = new Hashtable();
        Hashtable iBestAssignmentTable = new Hashtable();
        Hashtable iInitialAssignmentTable = new Hashtable();
        String iSolutionId = null;
        Progress iProgress = null;

        public ReloadingDoneCallback() {
            this.iSolutionId = TimetableSolver.this.getProperties().getProperty("General.SolutionId");
            for (Lecture lecture : TimetableSolver.this.currentSolution().getModel().variables()) {
                Placement current = (Placement)TimetableSolver.this.currentSolution().getAssignment().getValue((Variable)lecture);
                if (current != null) {
                    this.iCurrentAssignmentTable.put(lecture.getClassId(), current);
                }
                if (lecture.getBestAssignment() != null) {
                    this.iBestAssignmentTable.put(lecture.getClassId(), lecture.getBestAssignment());
                }
                if (lecture.getInitialAssignment() == null) continue;
                this.iInitialAssignmentTable.put(lecture.getClassId(), lecture.getInitialAssignment());
            }
        }

        private Lecture getLecture(Long classId) {
            for (Lecture lecture : TimetableSolver.this.currentSolution().getModel().variables()) {
                if (!lecture.getClassId().equals(classId)) continue;
                return lecture;
            }
            return null;
        }

        private Placement getPlacement(Lecture lecture, Placement placement) {
            TimeLocation time = null;
            for (TimeLocation t : lecture.timeLocations()) {
                if (!placement.getTimeLocation().equals((Object)t)) continue;
                time = t;
                break;
            }
            if (time == null) {
                this.iProgress.warn("WARNING: Time " + placement.getTimeLocation().getLongName(TimetableSolver.this.useAmPm()) + " is no longer valid for class " + lecture.getName());
                return null;
            }
            Vector<RoomLocation> rooms = new Vector<RoomLocation>();
            for (RoomLocation r : lecture.roomLocations()) {
                if (placement.isMultiRoom() && placement.getRoomLocations().contains(r)) {
                    rooms.add(r);
                }
                if (placement.isMultiRoom() || !placement.getRoomLocation().equals((Object)r)) continue;
                rooms.add(r);
                break;
            }
            if (rooms.size() != lecture.getNrRooms()) {
                this.iProgress.warn("WARNING: Room(s) " + (placement.isMultiRoom() ? placement.getRoomLocations().toString() : placement.getRoomLocation().getName()) + " are no longer valid for class " + lecture.getName());
                return null;
            }
            return new Placement(lecture, time, rooms);
        }

        private void assign(Placement placement) {
            ((TimetableModel)TimetableSolver.this.currentSolution().getModel()).weaken(TimetableSolver.this.currentSolution().getAssignment(), (Value)placement);
            if (placement.isValid()) {
                Map conflictConstraints = TimetableSolver.this.currentSolution().getModel().conflictConstraints(TimetableSolver.this.currentSolution().getAssignment(), (Value)placement);
                if (conflictConstraints.isEmpty()) {
                    TimetableSolver.this.currentSolution().getAssignment().assign(0L, (Value)placement);
                } else {
                    this.iProgress.warn("Unable to assign " + ((Lecture)placement.variable()).getName() + " &larr; " + placement.getLongName(TimetableSolver.this.useAmPm()));
                    this.iProgress.warn("&nbsp;&nbsp;Reason:");
                    for (Constraint c : conflictConstraints.keySet()) {
                        Collection vals = (Collection)conflictConstraints.get(c);
                        for (Placement v : vals) {
                            this.iProgress.warn("&nbsp;&nbsp;&nbsp;&nbsp;" + ((Lecture)v.variable()).getName() + " = " + v.getLongName(TimetableSolver.this.useAmPm()));
                        }
                        this.iProgress.debug("&nbsp;&nbsp;&nbsp;&nbsp;in constraint " + c);
                    }
                }
            } else {
                Map conflictConstraints;
                Lecture lecture = (Lecture)placement.variable();
                String reason = "";
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    if (ic.isAvailable(lecture, placement)) continue;
                    reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;instructor " + ic.getName() + " not available";
                }
                if (lecture.getNrRooms() > 0) {
                    if (placement.isMultiRoom()) {
                        for (RoomLocation roomLocation : placement.getRoomLocations()) {
                            if (roomLocation.getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) continue;
                            reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;room " + roomLocation.getName() + " not available";
                        }
                    } else if (!placement.getRoomLocation().getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) {
                        reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;room " + placement.getRoomLocation().getName() + " not available";
                    }
                }
                if (!(conflictConstraints = TimetableSolver.this.currentSolution().getModel().conflictConstraints(TimetableSolver.this.currentSolution().getAssignment(), (Value)placement)).isEmpty()) {
                    for (Constraint c : conflictConstraints.keySet()) {
                        Set vals = (Set)conflictConstraints.get(c);
                        for (Placement p : vals) {
                            Lecture l = (Lecture)p.variable();
                            if (l.isCommitted()) {
                                reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;conflict with committed assignment " + l.getName() + " = " + p.getLongName(TimetableSolver.this.useAmPm()) + " (in constraint " + c + ")";
                            }
                            if (!p.equals((Object)placement)) continue;
                            reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;constraint " + c;
                        }
                    }
                }
                this.iProgress.warn("Unable to assign " + lecture.getName() + " &larr; " + placement.getLongName(TimetableSolver.this.useAmPm()) + (reason.length() == 0 ? "." : ":" + reason));
            }
        }

        private void unassignAll() {
            for (Lecture lecture : TimetableSolver.this.currentSolution().getModel().variables()) {
                TimetableSolver.this.currentSolution().getAssignment().unassign(0L, (Variable)lecture);
            }
        }

        public void execute() {
            Placement placement;
            Lecture lecture;
            this.iProgress = Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel());
            if (!this.iBestAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating best assignment ...", (long)this.iBestAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iBestAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    lecture = this.getLecture((Long)entry.getKey());
                    if (lecture == null || (placement = this.getPlacement(lecture, (Placement)entry.getValue())) == null) continue;
                    this.assign(placement);
                }
                TimetableSolver.this.currentSolution().saveBest();
            }
            if (!this.iInitialAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating initial assignment ...", (long)this.iInitialAssignmentTable.size());
                for (Map.Entry entry : this.iInitialAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    lecture = this.getLecture((Long)entry.getKey());
                    if (lecture == null || (placement = this.getPlacement(lecture, (Placement)entry.getValue())) == null) continue;
                    lecture.setInitialAssignment((Value)placement);
                }
            }
            if (!this.iCurrentAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating current assignment ...", (long)this.iCurrentAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iCurrentAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    lecture = this.getLecture((Long)entry.getKey());
                    if (lecture == null || (placement = this.getPlacement(lecture, (Placement)entry.getValue())) == null) continue;
                    this.assign(placement);
                }
            }
            this.iCurrentAssignmentTable.clear();
            TimetableSolver.this.iBestAssignmentRecords.clear();
            this.iInitialAssignmentTable.clear();
            this.iProgress = null;
            if (this.iSolutionId != null) {
                TimetableSolver.this.getProperties().setProperty("General.SolutionId", this.iSolutionId);
            }
            TimetableSolver.this.iLoadedDate = new Date();
            TimetableSolver.this.iWorking = false;
            TimetableSolver.this.afterLoad();
            Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }

    public class FinalSectioning
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("FinalSectioning");
            TimetableSolver.this.iWorking = true;
            try {
                ((TimetableModel)TimetableSolver.this.currentSolution().getModel()).switchStudents(TimetableSolver.this.currentSolution().getAssignment());
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                TimetableSolver.this.iWorking = false;
                Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
                throw throwable;
            }
            TimetableSolver.this.iWorking = false;
            Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
            TimetableSolver.this.afterFinalSectioning();
        }
    }
}

