/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.Iterator;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.UpdateRoomDepartmentsRequest.class)
public class UpdateRoomDepartmentsBackend
implements GwtRpcImplementation<RoomInterface.UpdateRoomDepartmentsRequest, GwtRpcResponseNull> {
    @Override
    public GwtRpcResponseNull execute(RoomInterface.UpdateRoomDepartmentsRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        Transaction tx = null;
        try {
            Session hibSession = new RoomDeptDAO().getSession();
            tx = hibSession.beginTransaction();
            if (request.hasDepartment()) {
                RoomDept x;
                Iterator<RoomDept> j;
                RoomDept rd;
                Department department = (Department)DepartmentDAO.getInstance().get(request.getDepartment().getId(), hibSession);
                context.checkPermission(department, Right.EditRoomDepartments);
                if (request.hasAddLocations()) {
                    for (Location location : hibSession.createQuery("from Location where uniqueId in :ids").setParameterList("ids", request.getAddLocations()).list()) {
                        rd = null;
                        j = location.getRoomDepts().iterator();
                        while (rd == null && j.hasNext()) {
                            x = j.next();
                            if (!x.getDepartment().equals(department)) continue;
                            rd = x;
                        }
                        if (rd != null) continue;
                        rd = new RoomDept();
                        rd.setDepartment(department);
                        rd.setRoom(location);
                        rd.setControl(Boolean.FALSE);
                        department.getRoomDepts().add(rd);
                        location.getRoomDepts().add(rd);
                        hibSession.saveOrUpdate((Object)location);
                        hibSession.saveOrUpdate((Object)rd);
                        hibSession.saveOrUpdate((Object)location);
                        ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.CREATE, null, department);
                    }
                }
                if (request.hasDropLocations()) {
                    for (Location location : hibSession.createQuery("from Location where uniqueId in :ids").setParameterList("ids", request.getDropLocations()).list()) {
                        rd = null;
                        j = location.getRoomDepts().iterator();
                        while (rd == null && j.hasNext()) {
                            x = j.next();
                            if (!x.getDepartment().equals(department)) continue;
                            rd = x;
                        }
                        ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.DELETE, null, department);
                        department.getRoomDepts().remove(rd);
                        location.getRoomDepts().remove(rd);
                        hibSession.saveOrUpdate((Object)location);
                        hibSession.delete((Object)rd);
                        location.removedFromDepartment(department, hibSession);
                    }
                }
                hibSession.saveOrUpdate((Object)department);
            } else if (request.hasExamType()) {
                context.checkPermission(Right.EditRoomDepartmentsExams);
                ExamType type = (ExamType)ExamTypeDAO.getInstance().get(request.getExamType().getId(), hibSession);
                if (request.hasAddLocations()) {
                    for (Location location : hibSession.createQuery("from Location where uniqueId in :ids").setParameterList("ids", request.getAddLocations()).list()) {
                        location.setExamEnabled(type, true);
                        hibSession.saveOrUpdate((Object)location);
                        ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.UPDATE, null, null);
                    }
                }
                if (request.hasDropLocations()) {
                    for (Location location : hibSession.createQuery("from Location where uniqueId in :ids").setParameterList("ids", request.getDropLocations()).list()) {
                        location.setExamEnabled(type, false);
                        hibSession.saveOrUpdate((Object)location);
                        ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.UPDATE, null, null);
                    }
                }
            }
            tx.commit();
            return new GwtRpcResponseNull();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (tx != null) {
                tx.rollback();
            }
            if (e instanceof GwtRpcException) {
                throw (GwtRpcException)e;
            }
            throw new GwtRpcException(e.getMessage());
        }
    }
}

