/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:hql.xml")
public class HQLExportXML
implements Exporter {
    public String reference() {
        return "report.xml";
    }

    public void export(ExportHelper helper) throws IOException {
        String s = helper.getParameter("id");
        if (s == null) {
            throw new IllegalArgumentException("No report provided, please set the id parameter.");
        }
        SavedHQL report = (SavedHQL)SavedHQLDAO.getInstance().get(Long.valueOf(s));
        if (report == null) {
            throw new IllegalArgumentException("Report " + s + " does not exist.");
        }
        helper.getSessionContext().checkPermission(report, Right.HQLReportEdit);
        helper.setup("text/xml", report.getName().replace('/', '-').replace('\\', '-').replace(':', '-') + ".xml", false);
        Document document = DocumentHelper.createDocument();
        document.addDocType("report", "-//UniTime//UniTime HQL Reports DTD/EN", "http://www.unitime.org/interface/Reports.dtd");
        Element reportEl = document.addElement("report");
        reportEl.addAttribute("name", report.getName());
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (!report.isSet(flag)) continue;
            reportEl.addElement("flag").setText(flag.name());
        }
        if (report.getDescription() != null) {
            reportEl.addElement("description").add((CDATA)new DOMCDATA(report.getDescription()));
        }
        if (report.getQuery() != null) {
            reportEl.addElement("query").add((CDATA)new DOMCDATA(report.getQuery()));
        }
        reportEl.addAttribute("created", new Date().toString());
        OutputStream out = helper.getOutputStream();
        new XMLWriter(out, OutputFormat.createPrettyPrint()).write(document);
    }
}

