/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.permissions.SimpleSessionPermission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;

public class StudentSchedulingPermissions {

    @PermissionForRight(value=Right.StudentSchedulingRequestStudentUpdate)
    public static class StudentSchedulingRequestStudentUpdate
    extends SimpleSessionPermission {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) && ApplicationProperty.CustomizationStudentEnrollments.value() != null;
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingChangeStudentStatus)
    public static class StudentSchedulingChangeStudentStatus
    extends SimpleSessionPermission {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && (source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) || source.getStatusType().can(DepartmentStatusType.Status.StudentsAssistant) || source.getStatusType().can(DepartmentStatusType.Status.StudentsPreRegister));
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingEmailStudent)
    public static class StudentSchedulingEmailStudent
    extends SimpleSessionPermission {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) && ApplicationProperty.OnlineSchedulingEmailConfirmation.isTrue();
        }
    }

    @PermissionForRight(value=Right.StudentSchedulingMassCancel)
    public static class StudentSchedulingMassCancel
    extends SimpleSessionPermission {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) && source.getStatusType().can(DepartmentStatusType.Status.StudentsOnline) && CustomStudentEnrollmentHolder.isAllowWaitListing();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.StudentEnrollments)
    public static class StudentEnrollments
    implements Permission<Student> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Student source) {
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                return source.getExternalUniqueId().equals(user.getExternalUserId());
            }
            return true;
        }

        @Override
        public Class<Student> type() {
            return Student.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.OfferingEnrollments)
    public static class OfferingEnrollments
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (DepartmentalInstructor instructor : source.getCoordinators()) {
                    if (!user.getExternalUserId().equals(instructor.getExternalUniqueId())) continue;
                    return true;
                }
                return false;
            }
            return this.permissionDepartment.check(user, source.getControllingCourseOffering().getSubjectArea().getDepartment());
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ConsentApproval)
    public static class ConsentApproval
    implements Permission<CourseOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, CourseOffering source) {
            if (source.getConsentType() == null) {
                return false;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                if (!"IN".equals(source.getConsentType().getReference())) {
                    return false;
                }
                for (DepartmentalInstructor instructor : source.getInstructionalOffering().getCoordinators()) {
                    if (!user.getExternalUserId().equals(instructor.getExternalUniqueId())) continue;
                    return true;
                }
                return false;
            }
            return this.permissionDepartment.check(user, source.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment());
        }

        @Override
        public Class<CourseOffering> type() {
            return CourseOffering.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.CourseRequests)
    public static class CourseRequests
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            DepartmentStatusType status = source.getStatusType();
            return status != null && status.can(DepartmentStatusType.Status.StudentsPreRegister) && !status.can(DepartmentStatusType.Status.StudentsAssistant) && !status.can(DepartmentStatusType.Status.StudentsOnline);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.SchedulingReports)
    public static class SchedulingReports
    extends SchedulingAssistant {
    }

    @PermissionForRight(value=Right.SchedulingDashboard)
    public static class SchedulingDashboard
    extends SchedulingAssistant {
        public boolean check(UserContext user, Session source) {
            return super.check(user, source) || this.permissionSession.check(user, source, DepartmentStatusType.Status.StudentsPreRegister);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.SchedulingAssistant)
    public static class SchedulingAssistant
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        SolverServerService solverServerService;

        protected boolean hasInstance(Long sessionId) {
            if (sessionId == null) {
                return false;
            }
            return this.solverServerService.getOnlineStudentSchedulingContainer().hasSolver(sessionId.toString());
        }

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source, DepartmentStatusType.Status.StudentsAssistant, DepartmentStatusType.Status.StudentsOnline)) {
                return false;
            }
            return this.hasInstance(user.getCurrentAcademicSessionId());
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.EnrollmentAuditPDFReports)
    public static class EnrollmentAuditPDFReports
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.StudentSectioningSolutionExportXml)
    public static class StudentSectioningSolutionExportXml
    extends StudentSectioningSolver {
    }

    @PermissionForRight(value=Right.StudentSectioningSolverDashboard)
    public static class StudentSectioningSolverDashboard
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentSectioningSolverLog)
    public static class StudentSectioningSolverLog
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentSectioningSolver)
    public static class StudentSectioningSolver
    extends StudentScheduling {
    }

    @PermissionForRight(value=Right.StudentScheduling)
    public static class StudentScheduling
    extends SimpleSessionPermission {
    }
}

