/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.stereotype.Service;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="permissionSession")
public class SimpleSessionPermission
implements Permission.PermissionSession {
    @Override
    public boolean check(UserContext user, Session session) {
        return this.check(user, session, new DepartmentStatusType.Status[0]) && this.checkStatus(session.getStatusType());
    }

    @Override
    public boolean check(UserContext user, Session session, DepartmentStatusType.Status ... status) {
        if (user == null || user.getCurrentAuthority() == null || session == null) {
            return false;
        }
        UserAuthority authority = user.getCurrentAuthority();
        if (!authority.hasRight(Right.SessionIndependent) && !authority.hasQualifier(session)) {
            return false;
        }
        if (!authority.hasRight(Right.AllowTestSessions) && (session.getStatusType() == null || session.getStatusType().isTestSession())) {
            return false;
        }
        if (status.length > 0 && !authority.hasRight(Right.StatusIndependent)) {
            DepartmentStatusType type = session.getStatusType();
            if (type == null) {
                return false;
            }
            for (DepartmentStatusType.Status s : status) {
                if (!type.can(s)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Class<Session> type() {
        return Session.class;
    }

    public boolean checkStatus(DepartmentStatusType status) {
        return true;
    }
}

