/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnasignedCourseRequests
implements StudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private StudentSectioningModel iModel = null;

    public UnasignedCourseRequests(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        return this.createTable(assignment, properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true), properties.getPropertyBoolean("useAmPm", true));
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, boolean includeLastLikeStudents, boolean includeRealStudents, boolean useAmPm) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportUnassignedCourse()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict())});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy() && !includeLastLikeStudents || !student.isDummy() && !includeRealStudents) continue;
            for (Request request : student.getRequests()) {
                Enrollment enrollment;
                if (request instanceof FreeTimeRequest || (enrollment = (Enrollment)assignment.getValue((Variable)request)) != null || !student.canAssign(assignment, request)) continue;
                CourseRequest courseRequest = (CourseRequest)request;
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(student.getId()));
                line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                line.add(new CSVFile.CSVField((Object)student.getName()));
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (dbStudent != null) {
                    line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                }
                line.add(new CSVFile.CSVField((Object)((Course)courseRequest.getCourses().get(0)).getName()));
                TreeSet<Enrollment> overlaps = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                    @Override
                    public int compare(Enrollment o1, Enrollment o2) {
                        return o1.getRequest().compareTo(o2.getRequest());
                    }
                });
                Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                List av = courseRequest.getAvaiableEnrollmentsSkipSameTime(assignment);
                if (av.isEmpty() || av.size() == 1 && ((Enrollment)av.get(0)).equals((Object)courseRequest.getInitialAssignment()) && this.getModel().inConflict(assignment, (Value)av.get(0))) {
                    if (((Course)courseRequest.getCourses().get(0)).getLimit() >= 0) {
                        line.add(new CSVFile.CSVField((Object)MSG.courseIsFull()));
                    } else {
                        line.add(new CSVFile.CSVField((Object)MSG.classNotAvailable()));
                    }
                } else {
                    for (Enrollment enrl : av) {
                        for (Request q : enrl.getStudent().getRequests()) {
                            Enrollment x;
                            if (q.equals((Object)request) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                            for (SctAssignment a : x.getAssignments()) {
                                if (!a.isOverlapping(enrl.getAssignments())) continue;
                                overlaps.add(x);
                                if (!(x.getRequest() instanceof CourseRequest)) continue;
                                CourseRequest cr = (CourseRequest)x.getRequest();
                                TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                if (ss == null) {
                                    ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                    overlapingSections.put(cr, ss);
                                }
                                ss.add((Section)a);
                            }
                        }
                    }
                    if (!overlaps.isEmpty()) {
                        String overlap = "";
                        for (Enrollment q : overlaps) {
                            if (!overlap.isEmpty()) {
                                overlap = overlap + "\n";
                            }
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                overlap = overlap + OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest());
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = ov + ",";
                                }
                            }
                            overlap = overlap + ov;
                        }
                        line.add(new CSVFile.CSVField((Object)MSG.conflictWithFirst(overlap)));
                    } else {
                        line.add(new CSVFile.CSVField((Object)MSG.courseNotAssigned()));
                    }
                }
                csv.addLine(line);
            }
        }
        return csv;
    }
}

