/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.HashMap;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ReloadAllStudents
extends ReloadAllData {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Throwable throwable2;
        Boolean bl;
        OnlineSectioningServer.Lock lock = server.lockAll();
        helper.beginTransaction();
        try {
            server.clearAllStudents();
            HashMap<Long, List<XCourseRequest>> requestMap = new HashMap<Long, List<XCourseRequest>>();
            List students = helper.getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.academicAreaClassifications as a left join fetch s.posMajors as mj left join fetch s.waitlists as w left join fetch s.groups as g where s.session.uniqueId=:sessionId").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list();
            for (Student student : students) {
                XStudent s = ReloadAllStudents.loadStudent(student, requestMap, server, helper);
                if (s == null) continue;
                server.update(s, true);
            }
            helper.commitTransaction();
            bl = true;
        }
        catch (Exception e) {
            try {
                helper.rollbackTransaction();
                if (!(e instanceof SectioningException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (SectioningException)e;
            }
            catch (Throwable throwable2) {
                Object var10_11 = null;
                lock.release();
            }
        }
        Object var10_10 = null;
        lock.release();
        return bl;
        throw throwable2;
    }

    public String name() {
        return "reload-all-students";
    }
}

