/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Collection;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ChangeStudentStatus
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iStudentIds = null;
    private String iStatus = null;

    public ChangeStudentStatus forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public ChangeStudentStatus withStatus(String status) {
        this.iStatus = status;
        return this;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public boolean hasStatus() {
        return this.iStatus != null && !this.iStatus.isEmpty();
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        StudentSectioningStatus status = this.hasStatus() ? (StudentSectioningStatus)helper.getHibSession().createQuery("from StudentSectioningStatus where reference = :ref").setString("ref", this.getStatus()).uniqueResult() : null;
        for (Long studentId : this.getStudentIds()) {
            Object var11_11;
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            try {
                XStudent student = server.getStudent(studentId);
                helper.beginTransaction();
                try {
                    Student dbStudent = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    if (student != null && dbStudent != null) {
                        OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
                        if (status != null) {
                            action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(status.getUniqueId()).setName(status.getLabel()).setExternalId(status.getReference()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
                        }
                        student.setStatus(this.getStatus());
                        dbStudent.setSectioningStatus(status);
                        helper.getHibSession().saveOrUpdate((Object)dbStudent);
                        server.update(student, false);
                    }
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
                var11_11 = null;
                lock.release();
            }
            catch (Throwable throwable) {
                var11_11 = null;
                lock.release();
                throw throwable;
            }
        }
        return true;
    }

    @Override
    public String name() {
        return "status-change";
    }
}

