/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.hibernate.Query;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectioningStatusFilterAction
implements OnlineSectioningAction<EventInterface.FilterRpcResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private EventInterface.FilterRpcRequest iRequest = null;

    public SectioningStatusFilterAction forRequest(EventInterface.FilterRpcRequest request) {
        this.iRequest = request;
        return this;
    }

    @Override
    public EventInterface.FilterRpcResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        switch (this.iRequest.getCommand()) {
            case LOAD: {
                return this.load(server, helper);
            }
            case SUGGESTIONS: {
                return this.suggestions(server, helper);
            }
            case ENUMERATE: {
                return this.enumarate(server, helper);
            }
        }
        return null;
    }

    public EventInterface.FilterRpcResponse load(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        StudentQuery query = SectioningStatusFilterAction.getQuery(this.iRequest, server);
        ArrayList<EventInterface.FilterRpcResponse.Entity> areas = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object o : query.select("aac.academicArea.uniqueId, aac.academicArea.academicAreaAbbreviation, aac.academicArea.title, count(distinct s.uniqueId)").order("aac.academicArea.academicAreaAbbreviation, aac.academicArea.title").group("aac.academicArea.uniqueId, aac.academicArea.academicAreaAbbreviation, aac.academicArea.title").exclude("area").exclude("major").exclude("course").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity a = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            a.setCount(((Number)o[3]).intValue());
            areas.add(a);
        }
        response.add("area", areas);
        if (this.iRequest.hasOption("area")) {
            ArrayList<EventInterface.FilterRpcResponse.Entity> majors = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (Object o : query.select("m.uniqueId, m.code, m.name, count(distinct s)").from("PosMajor m").where("m in elements(s.posMajors)").order("m.code, m.name").group("m.uniqueId, m.code, m.name").exclude("major").query(helper.getHibSession()).list()) {
                EventInterface.FilterRpcResponse.Entity m = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
                m.setCount(((Number)o[3]).intValue());
                majors.add(m);
            }
            response.add("major", majors);
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> classifications = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object o : query.select("aac.academicClassification.uniqueId, aac.academicClassification.code, aac.academicClassification.name, count(distinct s)").order("aac.academicClassification.code, aac.academicClassification.name").group("aac.academicClassification.uniqueId, aac.academicClassification.code, aac.academicClassification.name").exclude("classification").exclude("course").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            classifications.add(c);
        }
        response.add("classification", classifications);
        ArrayList<EventInterface.FilterRpcResponse.Entity> groups = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object o : query.select("g.uniqueId, g.groupAbbreviation, g.groupName, count(distinct s)").from("StudentGroup g").where("g in elements(s.groups)").order("g.groupAbbreviation, g.groupName").group("g.uniqueId, g.groupAbbreviation, g.groupName").exclude("group").exclude("course").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            groups.add(c);
        }
        response.add("group", groups);
        ArrayList<EventInterface.FilterRpcResponse.Entity> acc = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object[] o : query.select("a.uniqueId, a.abbreviation, a.name, count(distinct s)").from("StudentAccomodation a").where("a in elements(s.accomodations)").order("a.abbreviation, a.name").group("a.uniqueId, a.abbreviation, a.name").exclude("accommodation").exclude("course").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            acc.add(c);
        }
        response.add("accommodation", acc);
        ArrayList<EventInterface.FilterRpcResponse.Entity> states = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        int defaultStatus = ((Number)query.select("count(distinct s)").where("s.sectioningStatus is null").exclude("status").query(helper.getHibSession()).uniqueResult()).intValue();
        if (defaultStatus > 0) {
            Session session = (Session)SessionDAO.getInstance().get(server.getAcademicSession().getUniqueId(), helper.getHibSession());
            EventInterface.FilterRpcResponse.Entity s = session.getDefaultSectioningStatus() == null ? new EventInterface.FilterRpcResponse.Entity(0L, "Not Set", "No Restrictions (Default)", new String[0]) : new EventInterface.FilterRpcResponse.Entity(session.getDefaultSectioningStatus().getUniqueId(), "Not Set", session.getDefaultSectioningStatus().getReference() + " (Default)", "hint", session.getDefaultSectioningStatus().getLabel());
            s.setCount(defaultStatus);
            states.add(s);
        }
        for (Object[] o : query.select("s.sectioningStatus.uniqueId, s.sectioningStatus.reference, s.sectioningStatus.label, count(distinct s)").order("s.sectioningStatus.reference, s.sectioningStatus.label").group("s.sectioningStatus.uniqueId, s.sectioningStatus.reference, s.sectioningStatus.label").exclude("status").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity s = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[1], "hint", (String)o[2]);
            s.setCount(((Number)o[3]).intValue());
            states.add(s);
        }
        if (states.size() > 1) {
            response.add("status", states);
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> assignment = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        assignment.add(new EventInterface.FilterRpcResponse.Entity(0L, "Assigned", CONSTANTS.assignmentType()[0], "translated-value", CONSTANTS.assignmentType()[0]));
        assignment.add(new EventInterface.FilterRpcResponse.Entity(1L, "Reserved", CONSTANTS.assignmentType()[1], "translated-value", CONSTANTS.assignmentType()[1]));
        assignment.add(new EventInterface.FilterRpcResponse.Entity(2L, "Not Assigned", CONSTANTS.assignmentType()[2], "translated-value", CONSTANTS.assignmentType()[2]));
        assignment.add(new EventInterface.FilterRpcResponse.Entity(3L, "Wait-Listed", CONSTANTS.assignmentType()[3], "translated-value", CONSTANTS.assignmentType()[3]));
        response.add("assignment", assignment);
        ArrayList<EventInterface.FilterRpcResponse.Entity> consent = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        consent.add(new EventInterface.FilterRpcResponse.Entity(-1L, "Consent", CONSTANTS.consentTypeAbbv()[0], "translated-value", CONSTANTS.consentTypeAbbv()[0]));
        for (OfferingConsentType type : OfferingConsentType.getConsentTypeList()) {
            consent.add(new EventInterface.FilterRpcResponse.Entity(type.getUniqueId(), type.getAbbv(), type.getLabel(), new String[0]));
        }
        consent.add(new EventInterface.FilterRpcResponse.Entity(-2L, "No Consent", CONSTANTS.consentTypeAbbv()[1], "translated-value", CONSTANTS.consentTypeAbbv()[1]));
        consent.add(new EventInterface.FilterRpcResponse.Entity(-3L, "Waiting", CONSTANTS.consentTypeAbbv()[2], "translated-value", CONSTANTS.consentTypeAbbv()[2]));
        consent.add(new EventInterface.FilterRpcResponse.Entity(-4L, "Approved", CONSTANTS.consentTypeAbbv()[3], "translated-value", CONSTANTS.consentTypeAbbv()[3]));
        consent.add(new EventInterface.FilterRpcResponse.Entity(-5L, "To Do", CONSTANTS.consentTypeAbbv()[4], "translated-value", CONSTANTS.consentTypeAbbv()[4]));
        response.add("consent", consent);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public EventInterface.FilterRpcResponse suggestions(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Iterator instance;
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        if (!(this.iRequest.getText().isEmpty() || response.getSuggestions() != null && response.getSuggestions().size() >= 20)) {
            List subjects = helper.getHibSession().createQuery("select s from SubjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation) like :name or lower(' ' || s.title) like :title) order by s.subjectAreaAbbreviation").setString("name", this.iRequest.getText().toLowerCase() + "%").setString("title", "% " + this.iRequest.getText().toLowerCase() + "%").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setMaxResults(20).list();
            for (SubjectArea subjectArea : subjects) {
                response.addSuggestion(subjectArea.getSubjectAreaAbbreviation() + " - " + subjectArea.getTitle(), subjectArea.getSubjectAreaAbbreviation(), "Subject Area", "course");
            }
            if (subjects.size() == 1) {
                for (CourseOffering courseOffering : new TreeSet<CourseOffering>(((SubjectArea)subjects.get(0)).getCourseOfferings())) {
                    if (courseOffering.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                    response.addSuggestion(courseOffering.getCourseName() + (courseOffering.getTitle() == null ? "" : " - " + courseOffering.getTitle()), courseOffering.getCourseName(), "Course Offering", "course");
                }
            } else if (subjects.isEmpty()) {
                List courses = helper.getHibSession().createQuery("select c from CourseOffering c inner join c.subjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation || ' ' || c.courseNbr) like :name or lower(' ' || c.title) like :title) and c.instructionalOffering.notOffered = false order by s.subjectAreaAbbreviation, c.courseNbr").setString("name", this.iRequest.getText().toLowerCase() + "%").setString("title", "% " + this.iRequest.getText().toLowerCase() + "%").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setMaxResults(20).list();
                for (CourseOffering course : courses) {
                    response.addSuggestion(course.getCourseName() + (course.getTitle() == null ? "" : " - " + course.getTitle()), course.getCourseName(), "Course Offering", "course");
                }
            }
        }
        StudentQuery query = SectioningStatusFilterAction.getQuery(this.iRequest, server);
        if (!(this.iRequest.getText().isEmpty() || response.getSuggestions() != null && response.getSuggestions().size() >= 20)) {
            void var6_12;
            instance = query.select("distinct s").exclude("student").order("s.lastName, s.firstName, s.middleName");
            boolean bl = false;
            String where = "";
            StringTokenizer s = new StringTokenizer(this.iRequest.getText().trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                if (!where.isEmpty()) {
                    where = where + " and ";
                }
                where = where + "(upper(s.firstName) like :cn" + (int)var6_12 + " || '%' or upper(s.middleName) like :cn" + (int)var6_12 + " || '%' or upper(s.lastName) like :cn" + (int)var6_12 + " || '%' or upper(s.email) like :cn" + (int)var6_12 + ")";
                ((StudentQuery.QueryInstance)((Object)instance)).set("cn" + (int)var6_12, token);
                ++var6_12;
            }
            if (var6_12 > 0) {
                ((StudentQuery.QueryInstance)((Object)instance)).where("(" + where + ") or upper(trim(trailing ' ' from s.lastName || ', ' || s.firstName || ' ' || s.middleName)) = :name or s.externalUniqueId = :id");
                ((StudentQuery.QueryInstance)((Object)instance)).set("name", this.iRequest.getText().trim().toUpperCase());
                ((StudentQuery.QueryInstance)((Object)instance)).set("id", this.iRequest.getText().trim());
                for (Student student : ((StudentQuery.QueryInstance)((Object)instance)).limit(20).query(helper.getHibSession()).list()) {
                    response.addSuggestion(helper.getStudentNameFormat().format(student), student.getExternalUniqueId(), "Student", "student");
                }
            }
        }
        if (!this.iRequest.getText().isEmpty() && (response.getSuggestions() == null || response.getSuggestions().size() < 20) && "true".equals(this.iRequest.getOption("approval"))) {
            for (TimetableManager timetableManager : helper.getHibSession().createQuery("select distinct m from TimetableManager m inner join m.managerRoles r inner join m.departments d where  (lower(m.externalUniqueId) like :q || '%' or lower(m.emailAddress) like :q || '%' or lower(m.lastName) || ' ' || lower(m.firstName) like :q || '%') and 'ConsentApproval' in elements(r.role.rights) and d.session.uniqueId = :sessionId order by m.lastName, m.firstName, m.middleName").setString("q", this.iRequest.getText().toLowerCase()).setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setMaxResults(20).list()) {
                response.addSuggestion(timetableManager.getName(), timetableManager.getName(), "Approved by", "approver");
            }
            for (DepartmentalInstructor departmentalInstructor : helper.getHibSession().createQuery("select distinct i from CourseOffering c inner join c.instructionalOffering.coordinators i where c.subjectArea.session.uniqueId = :sessionId and c.consentType.reference != :reference and (lower(i.externalUniqueId) like :q || '%' or lower(i.email) like :q || '%' or lower(i.lastName) || ' ' || lower(i.firstName) like :q || '%') order by i.lastName, i.firstName, i.middleName").setString("q", this.iRequest.getText().toLowerCase()).setString("reference", "IN").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setMaxResults(20).list()) {
                response.addSuggestion(departmentalInstructor.getNameLastFirst(), departmentalInstructor.getNameLastFirst(), "Approved by", "approver");
            }
        }
        if (this.iRequest.getText().length() > 1 && (response.getSuggestions() == null || response.getSuggestions().size() < 20)) {
            instance = query.select("distinct l.operation").exclude("operation").order("l.operation").from("OnlineSectioningLog l").where("l.session.uniqueId = :sessionId").where("l.student = s.externalUniqueId");
            String string = this.iRequest.getText();
            if (!"operation".startsWith(string.toLowerCase())) {
                ((StudentQuery.QueryInstance)((Object)instance)).set("q", string);
                ((StudentQuery.QueryInstance)((Object)instance)).where("l.operation like :q || '%'");
            }
            for (String op : ((StudentQuery.QueryInstance)((Object)instance)).limit(20).query(helper.getHibSession()).list()) {
                response.addSuggestion(Constants.toInitialCase(op.replace('-', ' ')), op, "Operation", "operation");
            }
        }
        return response;
    }

    public EventInterface.FilterRpcResponse enumarate(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        return response;
    }

    @Override
    public String name() {
        return "filter-" + this.iRequest.getCommand().name().toLowerCase();
    }

    public static StudentQuery getQuery(EventInterface.FilterRpcRequest request, OnlineSectioningServer server) {
        int id;
        StudentQuery query = new StudentQuery(server.getAcademicSession().getUniqueId());
        if (request.getText() == null || !request.getText().isEmpty()) {
            // empty if block
        }
        if (request.hasOptions("area")) {
            String area = "";
            id = 0;
            for (String string : request.getOptions("area")) {
                area = area + (area.isEmpty() ? "" : ",") + ":Xar" + id;
                query.addParameter("area", "Xar" + id, string);
                ++id;
            }
            query.addWhere("area", "aac.academicArea.academicAreaAbbreviation in (" + area + ")");
        }
        if (request.hasOptions("classification")) {
            String classf = "";
            id = 0;
            for (String string : request.getOptions("classification")) {
                classf = classf + (classf.isEmpty() ? "" : ",") + ":Xcf" + id;
                query.addParameter("classification", "Xcf" + id, string);
                ++id;
            }
            query.addWhere("classification", "aac.academicClassification.code in (" + classf + ")");
        }
        if (request.hasOptions("major")) {
            query.addFrom("major", "PosMajor m");
            String major = "";
            id = 0;
            for (String string : request.getOptions("major")) {
                major = major + (major.isEmpty() ? "" : ",") + ":Xmj" + id;
                query.addParameter("major", "Xmj" + id, string);
                ++id;
            }
            query.addWhere("major", "m in elements(s.posMajors) and m.code in (" + major + ")");
        }
        if (request.hasOptions("group")) {
            query.addFrom("group", "StudentGroup g");
            String group = "";
            id = 0;
            for (String string : request.getOptions("group")) {
                group = group + (group.isEmpty() ? "" : ",") + ":Xgr" + id;
                query.addParameter("group", "Xgr" + id, string);
                ++id;
            }
            query.addWhere("group", "g in elements(s.groups) and g.groupAbbreviation in (" + group + ")");
        }
        if (request.hasOptions("accommodation")) {
            query.addFrom("accommodation", "StudentAccomodation a");
            String acc = "";
            id = 0;
            for (String string : request.getOptions("accommodation")) {
                acc = acc + (acc.isEmpty() ? "" : ",") + ":Xacc" + id;
                query.addParameter("accommodation", "Xacc" + id, string);
                ++id;
            }
            query.addWhere("accommodation", "a in elements(s.accomodations) and a.abbreviation in (" + acc + ")");
        }
        if (request.hasOptions("status")) {
            String status = "";
            id = 0;
            boolean hasDefault = false;
            for (String s : request.getOptions("status")) {
                if ("Not Set".equals(s)) {
                    hasDefault = true;
                    continue;
                }
                status = status + (status.isEmpty() ? "" : ",") + ":Xst" + id;
                query.addParameter("status", "Xst" + id, s);
                ++id;
            }
            if (id > 0) {
                if (hasDefault) {
                    query.addWhere("status", "s.sectioningStatus is null or s.sectioningStatus.reference in (" + status + ")");
                } else {
                    query.addWhere("status", "s.sectioningStatus.reference in (" + status + ")");
                }
            } else if (hasDefault) {
                query.addWhere("status", "s.sectioningStatus is null");
            }
        }
        if (request.hasOptions("student")) {
            String student = "";
            id = 0;
            StringTokenizer s = new StringTokenizer(request.getOption("student").trim(), ", ");
            while (s.hasMoreTokens()) {
                String string = s.nextToken().toUpperCase();
                student = student + (student.isEmpty() ? "" : " and ") + "(upper(s.firstName) like :Xstd" + id + " || '%' or " + "upper(s.middleName) like :Xstd" + id + " || '%' or upper(s.lastName) like :Xstd" + id + " || '%' or upper(s.email) like :Xstd" + id + " || '%')";
                query.addParameter("student", "Xstd" + id, string);
                ++id;
            }
            if (id > 0) {
                student = "(" + student + ") or (upper(trim(trailing ' ' from s.lastName || ', ' || s.firstName || ' ' || s.middleName)) = :Xstd) or (s.externalUniqueId = :Xsid)";
                query.addParameter("student", "Xstd", request.getOption("student").trim().toUpperCase());
                query.addParameter("student", "Xsid", request.getOption("student").trim());
                query.addWhere("student", student);
            }
        }
        if (request.hasOption("course")) {
            query.addParameter("course", "Xco", request.getOption("course"));
            query.addWhere("course", "co.subjectAreaAbbv = :Xco or co.subjectAreaAbbv || ' ' || co.courseNbr = :Xco");
            query.addFrom("course", "inner join s.courseDemands cd inner join cd.courseRequests cr inner join cr.courseOffering co");
        }
        return query;
    }

    public Set<Long> getStudentIds(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        return new HashSet<Long>(SectioningStatusFilterAction.getQuery(this.iRequest, server).select("distinct s.uniqueId").query(helper.getHibSession()).list());
    }

    public List<XStudent> getStudens(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<XStudent> students = new ArrayList<XStudent>();
        for (XStudent student : SectioningStatusFilterAction.getQuery(this.iRequest, server).select("distinct s").query(helper.getHibSession()).list()) {
            students.add(new XStudent(student));
        }
        return students;
    }

    public static CourseQuery getCourseQuery(EventInterface.FilterRpcRequest request, OnlineSectioningServer server) {
        CourseQuery query = new CourseQuery(SectioningStatusFilterAction.getQuery(request, server));
        if (request.hasOption("course")) {
            query.addParameter("course", "Xco", request.getOption("course"));
            query.addWhere("course", "co.subjectAreaAbbv = :Xco or co.subjectAreaAbbv || ' ' || co.courseNbr = :Xco");
            query.addFrom("course", null);
        }
        return query;
    }

    public List<XCourseId> getCourseIds(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<XCourseId> ids = new ArrayList<XCourseId>();
        for (Object[] line : SectioningStatusFilterAction.getCourseQuery(this.iRequest, server).select("distinct co.instructionalOffering.uniqueId, co.uniqueId, co.subjectAreaAbbv, co.courseNbr").query(helper.getHibSession()).list()) {
            ids.add(new XCourseId(((Number)line[0]).longValue(), ((Number)line[1]).longValue(), line[2] + " " + line[3]));
        }
        return ids;
    }

    public List<XCourse> getCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<XCourse> courses = new ArrayList<XCourse>();
        for (CourseOffering co : SectioningStatusFilterAction.getCourseQuery(this.iRequest, server).select("distinct co").query(helper.getHibSession()).list()) {
            courses.add(new XCourse(co));
        }
        return courses;
    }

    public static class CourseQuery
    extends StudentQuery {
        public CourseQuery(Long sessionId) {
            super(sessionId);
        }

        public CourseQuery(StudentQuery q) {
            super(q);
        }

        public StudentQuery.QueryInstance select(String select) {
            return new StudentQuery.QueryInstance(select){

                public String query() {
                    return "select " + (this.iSelect == null ? "distinct co" : this.iSelect) + " from CourseRequest cr inner join cr.courseOffering co inner join cr.courseDemand cd inner join cd.student s left outer join s.academicAreaClassifications aac " + (this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + CourseQuery.this.getFrom(this.iExclude) + " where s.session.uniqueId = :sessionId" + CourseQuery.this.getWhere(this.iExclude) + (this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StudentQuery {
        protected Long iSessionId;
        protected Map<String, String> iFrom = new HashMap<String, String>();
        protected Map<String, String> iWhere = new HashMap<String, String>();
        protected Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public StudentQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public StudentQuery(StudentQuery q) {
            this.iSessionId = q.iSessionId;
            this.iFrom.putAll(q.iFrom);
            this.iWhere.putAll(q.iWhere);
            this.iParams.putAll(q.iParams);
        }

        public void addFrom(String option, String from) {
            if (from == null) {
                this.iFrom.remove(option);
            } else {
                this.iFrom.put(option, from);
            }
        }

        public void addWhere(String option, String where) {
            if (where == null) {
                this.iWhere.remove(option);
            } else {
                this.iWhere.put(option, where);
            }
        }

        protected void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            if (value == null) {
                params.remove(name);
            } else {
                params.put(name, value);
            }
        }

        public String getFrom(Collection<String> excludeOption) {
            String from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = from + (entry.getValue().startsWith("inner join") ? " " : ", ") + entry.getValue();
            }
            return from;
        }

        public String getWhere(Collection<String> excludeOption) {
            String where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public Query setParams(Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
            }
            return query;
        }

        public QueryInstance select(String select) {
            return new QueryInstance(select);
        }

        public class QueryInstance {
            protected String iSelect = null;
            protected String iFrom = null;
            protected String iWhere = null;
            protected String iOrderBy = null;
            protected String iGroupBy = null;
            protected String iType = "Student";
            protected Integer iLimit = null;
            protected Set<String> iExclude = new HashSet<String>();
            protected Map<String, Object> iParams = new HashMap<String, Object>();

            private QueryInstance(String select) {
                this.iSelect = select;
            }

            public QueryInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public QueryInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public QueryInstance type(String type) {
                this.iType = type;
                return this;
            }

            public QueryInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public QueryInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public QueryInstance exclude(String excludeOption) {
                this.iExclude.add(excludeOption);
                return this;
            }

            public QueryInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public QueryInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct s" : this.iSelect) + " from " + this.iType + " s left outer join s.academicAreaClassifications aac " + (this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + StudentQuery.this.getFrom(this.iExclude) + " where s.session.uniqueId = :sessionId" + StudentQuery.this.getWhere(this.iExclude) + (this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public Query query(org.hibernate.Session hibSession) {
                Query query = StudentQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude).setLong("sessionId", StudentQuery.this.iSessionId.longValue()).setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }
}

