/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.reports.OnlineSectioningReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulinAssistantReport
implements OnlineSectioningReport.Report {
    @Override
    public String getYear() {
        return System.getProperty("year", "2012");
    }

    @Override
    public String getTerm() {
        return System.getProperty("term", "Fall");
    }

    @Override
    public String getCampus() {
        return System.getProperty("campus", "PWL");
    }

    @Override
    public File getReportFolder() {
        return new File(System.getProperty("user.home", "~"));
    }

    @Override
    public String[] getExcludeUsers() {
        return System.getProperty("exclude", "TEST").split(",");
    }

    @Override
    public String getLastTimeStamp() {
        return System.getProperty("before", null);
    }

    @Override
    public String[] getOperations() {
        return new String[]{"section", "suggestions", "reload-student"};
    }

    public double diff(OnlineSectioningLog.Enrollment e1, OnlineSectioningLog.Enrollment e2) {
        if (e1.getSectionCount() == 0) {
            return e2.getSectionCount() == 0 ? 1.0 : 0.0;
        }
        double cnt = 0.0;
        for (OnlineSectioningLog.Section s1 : e1.getSectionList()) {
            boolean match = false;
            for (OnlineSectioningLog.Section s2 : e2.getSectionList()) {
                if (!s1.getClazz().getExternalId().equals(s2.getClazz().getExternalId())) continue;
                match = true;
                break;
            }
            if (!match) continue;
            cnt += 1.0;
        }
        return cnt / (double)Math.max(e1.getSectionCount(), e2.getSectionCount());
    }

    public double diff(List<OnlineSectioningLog.Enrollment> computed, OnlineSectioningLog.Enrollment saved) {
        double diff = 0.0;
        for (OnlineSectioningLog.Enrollment e : computed) {
            diff = Math.max(diff, this.diff(e, saved));
        }
        return diff;
    }

    public double diff(OnlineSectioningLog.Enrollment e1, Set<Long> e2) {
        if (e1.getSectionCount() == 0) {
            return e2.size() == 0 ? 1.0 : 0.0;
        }
        double cnt = 0.0;
        for (OnlineSectioningLog.Section s1 : e1.getSectionList()) {
            if (!e2.contains(s1.getClazz().getUniqueId())) continue;
            cnt += 1.0;
        }
        return cnt / (double)Math.max(e1.getSectionCount(), e2.size());
    }

    public double diff(List<OnlineSectioningLog.Enrollment> computed, Set<Long> enrollment) {
        double diff = 0.0;
        for (OnlineSectioningLog.Enrollment e : computed) {
            diff = Math.max(diff, this.diff(e, enrollment));
        }
        return diff;
    }

    private double minutes(OnlineSectioningLog.Action a1, OnlineSectioningLog.Action a2) {
        return (double)Math.abs(a1.getStartTime() - a2.getStartTime()) / 60000.0;
    }

    @Override
    public void process(OnlineSectioningReport report, String student, List<OnlineSectioningLog.Action> actions) {
        boolean hasSection = false;
        for (OnlineSectioningLog.Action action : actions) {
            if (!"section".equals(action.getOperation())) continue;
            hasSection = true;
            break;
        }
        if (!hasSection) {
            return;
        }
        long done = Math.round(report.inc("Students", 1.0));
        OnlineSectioningLog.Action firstSection = null;
        OnlineSectioningLog.Action lastSectionOrSuggestion = null;
        int nrSections = 0;
        int nrSuggestions = 0;
        int nrCycles = 0;
        HashSet<Long> enrollment = new HashSet<Long>();
        for (Number classId : StudentDAO.getInstance().getSession().createQuery("select e.clazz.uniqueId from StudentClassEnrollment e where e.student.uniqueId = :studentId").setLong("studentId", actions.get(0).getStudent().getUniqueId()).list()) {
            enrollment.add(classId.longValue());
        }
        ArrayList<OnlineSectioningLog.Enrollment> last = new ArrayList<OnlineSectioningLog.Enrollment>();
        ArrayList<OnlineSectioningLog.Enrollment> all = new ArrayList<OnlineSectioningLog.Enrollment>();
        OnlineSectioningLog.Enrollment first = null;
        OnlineSectioningLog.Enrollment lastBanner = null;
        OnlineSectioningLog.Action previous = null;
        for (OnlineSectioningLog.Action action : actions) {
            double bannerDiff2;
            OnlineSectioningLog.Enrollment computed;
            if (previous != null && this.minutes(previous, action) > 120.0) {
                firstSection = null;
                lastSectionOrSuggestion = null;
                nrSections = 0;
                nrSuggestions = 0;
                first = null;
                last.clear();
            }
            previous = action;
            if ("section".equals(action.getOperation())) {
                computed = null;
                for (OnlineSectioningLog.Enrollment e : action.getEnrollmentList()) {
                    if (e.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED || e.getSectionCount() <= 0) continue;
                    computed = e;
                    break;
                }
                if (computed == null) continue;
                if (first == null) {
                    first = computed;
                }
                last.clear();
                last.add(computed);
                all.add(computed);
                ++nrSections;
                lastSectionOrSuggestion = action;
                if (firstSection == null) {
                    firstSection = action;
                }
            }
            if ("suggestions".equals(action.getOperation())) {
                computed = null;
                for (OnlineSectioningLog.Enrollment e : action.getEnrollmentList()) {
                    if (e.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED || e.getSectionCount() <= 0) continue;
                    computed = e;
                    last.add(e);
                    all.add(e);
                }
                if (computed == null) continue;
                ++nrSuggestions;
                lastSectionOrSuggestion = action;
            }
            if (!"reload-student".equals(action.getOperation()) || firstSection == null) continue;
            OnlineSectioningLog.Enrollment stored = null;
            for (OnlineSectioningLog.Enrollment e : action.getEnrollmentList()) {
                if (e.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.STORED || e.getSectionCount() <= 0) continue;
                stored = e;
                break;
            }
            if (stored == null) continue;
            lastBanner = stored;
            report.inc("Sections per cycle", nrSections);
            report.inc("Suggestions per cycle", nrSuggestions);
            double assistantTime = this.minutes(lastSectionOrSuggestion, firstSection);
            double assistantDiff = this.diff(last, first);
            if (assistantDiff > 0.0) {
                report.inc("Assistant time [min]", assistantTime);
                report.inc("Difference [first - last]", assistantDiff);
            }
            double bannerTime = this.minutes(action, lastSectionOrSuggestion);
            double bannerDiff = this.diff(last, stored);
            if (bannerDiff > 0.0) {
                report.inc("Banner time [min]", bannerTime);
                report.inc("Difference [last - Banner]", bannerDiff);
            }
            if ((bannerDiff2 = this.diff(all, stored)) > 0.0) {
                report.inc("Difference [all - Banner]", bannerDiff2);
            }
            firstSection = null;
            lastSectionOrSuggestion = null;
            first = null;
            last.clear();
            nrSections = 0;
            nrSuggestions = 0;
            ++nrCycles;
        }
        report.inc("Cycles per student", nrCycles);
        if (!all.isEmpty() && !enrollment.isEmpty()) {
            report.inc("Difference [last - enrollment]", this.diff(all, enrollment));
            if (nrCycles > 0) {
                report.inc("Difference [last - enrollment] (cycles > 0)", this.diff(all, enrollment));
            }
        }
        if (lastBanner != null && !all.isEmpty()) {
            report.inc("Difference [all - last Banner]", this.diff(all, lastBanner));
        }
        if (done % 1L == 0L) {
            OnlineSectioningReport.sLog.info((Object)("---- after " + done + " students"));
            for (String name : new TreeSet<String>(report.iCounters.keySet())) {
                OnlineSectioningReport.sLog.info((Object)(name + ": " + report.iCounters.get(name)));
            }
        }
    }

    public static void main(String[] args) {
        try {
            new OnlineSectioningReport(new SchedulinAssistantReport()).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

