/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;

@SerializeWith(value=XInstructorSerializer.class)
public class XInstructor
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalId;
    private String iName;
    private String iEmail;

    public XInstructor() {
    }

    public XInstructor(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XInstructor(DepartmentalInstructor instructor, OnlineSectioningHelper helper) {
        this.iUniqueId = instructor.getUniqueId();
        this.iExternalId = instructor.getExternalUniqueId();
        this.iName = helper.getInstructorNameFormat().format(instructor);
        this.iEmail = instructor.getEmail();
    }

    public XInstructor(Long uniqueId, String externalId, String name, String email) {
        this.iUniqueId = uniqueId;
        this.iExternalId = externalId;
        this.iName = name;
        this.iEmail = email;
    }

    public Long getIntructorId() {
        return this.iUniqueId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public String getName() {
        return this.iName;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XInstructor)) {
            return false;
        }
        return this.getIntructorId().equals(((XInstructor)o).getIntructorId());
    }

    public int hashCode() {
        return new Long(this.getIntructorId()).hashCode();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iExternalId = (String)in.readObject();
        this.iName = (String)in.readObject();
        this.iEmail = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iExternalId);
        out.writeObject(this.iName);
        out.writeObject(this.iEmail);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XInstructorSerializer
    implements Externalizer<XInstructor> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XInstructor object) throws IOException {
            object.writeExternal(output);
        }

        public XInstructor readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XInstructor(input);
        }
    }
}

