/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningTestFwk;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XAcademicAreaCode;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreeWorksPlanScraper
extends OnlineSectioningTestFwk {
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public DegreeWorksPlanScraper() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    @Override
    protected void startServer() {
        Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2015"), ApplicationProperties.getProperty("term", "Fall"));
        if (session == null) {
            sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
            System.exit(0);
        } else {
            sLog.info((Object)("Session: " + session));
        }
        this.iSessionId = session.getUniqueId();
        OnlineSectioningLogger.getInstance().setEnabled(false);
        this.iServer = new DatabaseServer(new AcademicSessionInfo(session), false);
    }

    protected String getDegreeWorksApiSite() {
        return ApplicationProperties.getProperty("banner.dgw.site");
    }

    protected String getDegreeWorksApiUser() {
        return ApplicationProperties.getProperty("banner.dgw.user");
    }

    protected String getDegreeWorksApiPassword() {
        return ApplicationProperties.getProperty("banner.dgw.password");
    }

    protected String getDegreeWorksApiEffectiveOnly() {
        return ApplicationProperties.getProperty("banner.dgw.effectiveOnly", "false");
    }

    protected String getDegreeWorksErrorPattern() {
        return ApplicationProperties.getProperty("banner.dgw.errorPattern", "<div class=\"exceptionMessage\">\n(.*)\n\n</div>");
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    public String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        }).setPrettyPrinting().create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDegreePlans(OnlineSectioningServer server, XStudent student) throws SectioningException {
        String string;
        ClientResource resource = null;
        try {
            try {
                resource = new ClientResource(this.getDegreeWorksApiSite());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("studentId", this.getBannerId(student));
                String effectiveOnly = this.getDegreeWorksApiEffectiveOnly();
                if (effectiveOnly != null) {
                    resource.addQueryParameter("effectiveOnly", effectiveOnly);
                }
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getDegreeWorksApiUser(), this.getDegreeWorksApiPassword());
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    try {
                        String response = IOUtils.toString((Reader)resource.getResponseEntity().getReader());
                        Pattern pattern = Pattern.compile(this.getDegreeWorksErrorPattern(), 11);
                        Matcher match = pattern.matcher(response);
                        if (match.find()) {
                            throw new SectioningException(match.group(1));
                        }
                    }
                    catch (SectioningException e) {
                        throw e;
                    }
                    finally {
                        throw exception;
                    }
                }
                string = IOUtils.toString((Reader)resource.getResponseEntity().getReader());
                Object var10_14 = null;
                if (resource == null) return string;
            }
            catch (SectioningException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SectioningException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return string;
    }

    @Override
    public List<OnlineSectioningTestFwk.Operation> operations() {
        org.hibernate.Session hibSession = new _RootDAO().getSession();
        ArrayList<OnlineSectioningTestFwk.Operation> operations = new ArrayList<OnlineSectioningTestFwk.Operation>();
        OnlineSectioningHelper helper = new OnlineSectioningHelper(this.user(), null);
        List students = hibSession.createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.academicAreaClassifications as a left join fetch s.posMajors as mj left join fetch s.waitlists as w left join fetch s.groups as g where s.session.uniqueId=:sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list();
        for (Student s : students) {
            final XStudent student = new XStudent(s, helper, this.getServer().getAcademicSession().getFreeTimePattern());
            if (student == null) continue;
            operations.add(new OnlineSectioningTestFwk.Operation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public double execute(OnlineSectioningServer s) {
                    try {
                        String plans;
                        block24: {
                            plans = null;
                            long t0 = System.currentTimeMillis();
                            try {
                                Object var7_5;
                                try {
                                    plans = DegreeWorksPlanScraper.this.getDegreePlans(s, student);
                                    DegreeWorksPlanScraper.this.inc("Request Succeeded [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                    if (plans == null || plans.isEmpty() || "[]".equals(plans)) {
                                        DegreeWorksPlanScraper.this.inc("Request Succeeded with no plans", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                        DegreeWorksPlanScraper.this.inc("students-noplans", student.getExternalId(), "Time [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                    } else {
                                        DegreeWorksPlanScraper.this.inc("Request Succeeded with plans", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                        DegreeWorksPlanScraper.this.inc("students-withplans", student.getExternalId(), "Time [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                    }
                                }
                                catch (Exception e) {
                                    DegreeWorksPlanScraper.this.inc("Request Failed [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                    DegreeWorksPlanScraper.this.inc("Request Failed with  " + e.getMessage() + " [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                    DegreeWorksPlanScraper.this.inc("students-failed", student.getExternalId(), e.getMessage(), 1.0);
                                    var7_5 = null;
                                    DegreeWorksPlanScraper.this.inc("Request Time [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                    break block24;
                                }
                                var7_5 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_6 = null;
                                DegreeWorksPlanScraper.this.inc("Request Time [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                                throw throwable;
                            }
                            DegreeWorksPlanScraper.this.inc("Request Time [s]", (double)(System.currentTimeMillis() - t0) / 1000.0);
                        }
                        int ret = 0;
                        if (plans != null && !plans.isEmpty() && !"[]".equals(plans)) {
                            try {
                                FileWriter out = new FileWriter(new File(new File("plans"), DegreeWorksPlanScraper.this.getBannerId(student) + ".json"));
                                out.write(plans);
                                ((Writer)out).flush();
                                ((Writer)out).close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            DegreeWorksPlanScraper.this.inc("Request Succeeded [response length in chars]", plans.length());
                            List current = (List)DegreeWorksPlanScraper.this.getGson().fromJson(plans, XEInterface.DegreePlan.TYPE_LIST);
                            int nrActive = 0;
                            int nrLocked = 0;
                            int nrMatching = 0;
                            for (XEInterface.DegreePlan p : current) {
                                if (p.isActive.value) {
                                    ++nrActive;
                                }
                                if (p.isLocked.value) {
                                    ++nrLocked;
                                }
                                DegreeWorksPlanScraper.this.inc("plans-by-degree", p.school.code, p.degree.code, 1.0);
                                DegreeWorksPlanScraper.this.inc("plans-by-stattus", p.officialTrackingStatus.code, "All", 1.0);
                                if (p.isActive.value) {
                                    DegreeWorksPlanScraper.this.inc("plans-by-stattus", p.officialTrackingStatus.code, "Active", 1.0);
                                }
                                if (p.isLocked.value) {
                                    DegreeWorksPlanScraper.this.inc("plans-by-stattus", p.officialTrackingStatus.code, "Locked", 1.0);
                                }
                                String term = DegreeWorksPlanScraper.this.getBannerTerm(s.getAcademicSession());
                                for (XEInterface.Year y : p.years) {
                                    for (XEInterface.Term t : y.terms) {
                                        if (!term.equals(t.term.code)) continue;
                                        ++nrMatching;
                                    }
                                }
                            }
                            DegreeWorksPlanScraper.this.inc("Request Succeeded [All]", current.size());
                            if (nrActive > 0) {
                                DegreeWorksPlanScraper.this.inc("Request Succeeded [Active]", nrActive);
                            }
                            if (nrLocked > 0) {
                                DegreeWorksPlanScraper.this.inc("Request Succeeded [Locked]", nrLocked);
                            }
                            if (nrMatching > 0) {
                                DegreeWorksPlanScraper.this.inc("Request Succeeded [Matching Term]", nrMatching);
                            }
                            ret = nrActive;
                            for (XAcademicAreaCode aac : student.getAcademicAreaClasiffications()) {
                                for (XAcademicAreaCode m : student.getMajors()) {
                                    if (!m.getArea().equals(aac.getArea())) continue;
                                    DegreeWorksPlanScraper.this.inc("students-curricula", aac.getArea() + "/" + m.getCode() + " " + aac.getCode(), "Students", 1.0);
                                    DegreeWorksPlanScraper.this.inc("students-curricula", aac.getArea() + "/" + m.getCode() + " " + aac.getCode(), "Plans", current.size());
                                    DegreeWorksPlanScraper.this.inc("students-curricula", aac.getArea() + "/" + m.getCode() + " " + aac.getCode(), "Active", nrActive);
                                    DegreeWorksPlanScraper.this.inc("students-curricula", aac.getArea() + "/" + m.getCode() + " " + aac.getCode(), "Locked", nrLocked);
                                    DegreeWorksPlanScraper.this.inc("students-curricula", aac.getArea() + "/" + m.getCode() + " " + aac.getCode(), "Matching", nrMatching);
                                }
                            }
                            DegreeWorksPlanScraper.this.inc("students-withplans", student.getExternalId(), "Total", current.size());
                            DegreeWorksPlanScraper.this.inc("students-withplans", student.getExternalId(), "Active", nrActive);
                            DegreeWorksPlanScraper.this.inc("students-withplans", student.getExternalId(), "Locked", nrLocked);
                            DegreeWorksPlanScraper.this.inc("students-withplans", student.getExternalId(), "Matching", nrMatching);
                        }
                        return ret;
                    }
                    catch (Throwable t) {
                        DegreeWorksPlanScraper.this.inc("Uncaught: " + t.getMessage(), 1.0);
                        return 0.0;
                    }
                }
            });
        }
        hibSession.close();
        return operations;
    }

    public static void main(String[] args) {
        new File("plans").mkdir();
        new DegreeWorksPlanScraper().test(-1, 10);
    }
}

