/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckCourses
implements OnlineSectioningAction<Collection<String>> {
    private static final long serialVersionUID = 1L;
    private CourseRequestInterface iRequest;
    private CourseMatcher iMatcher;

    public CheckCourses forRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public CheckCourses withMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    @Override
    public Collection<String> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iMatcher != null) {
            this.iMatcher.setServer(server);
        }
        ArrayList<String> notFound = new ArrayList<String>();
        XStudent student = this.iRequest.getStudentId() == null ? null : server.getStudent(this.iRequest.getStudentId());
        for (CourseRequestInterface.Request cr : this.iRequest.getCourses()) {
            if (!cr.hasRequestedFreeTime() && cr.hasRequestedCourse() && this.lookup(server, student, cr.getRequestedCourse()) == null) {
                notFound.add(cr.getRequestedCourse());
            }
            if (cr.hasFirstAlternative() && this.lookup(server, student, cr.getFirstAlternative()) == null) {
                notFound.add(cr.getFirstAlternative());
            }
            if (!cr.hasSecondAlternative() || this.lookup(server, student, cr.getSecondAlternative()) != null) continue;
            notFound.add(cr.getSecondAlternative());
        }
        for (CourseRequestInterface.Request cr : this.iRequest.getAlternatives()) {
            if (cr.hasRequestedCourse() && this.lookup(server, student, cr.getRequestedCourse()) == null) {
                notFound.add(cr.getRequestedCourse());
            }
            if (cr.hasFirstAlternative() && this.lookup(server, student, cr.getFirstAlternative()) == null) {
                notFound.add(cr.getFirstAlternative());
            }
            if (!cr.hasSecondAlternative() || this.lookup(server, student, cr.getSecondAlternative()) != null) continue;
            notFound.add(cr.getSecondAlternative());
        }
        return notFound;
    }

    public XCourseId lookup(OnlineSectioningServer server, XStudent student, String course) {
        XCourseId c = server.getCourse(course);
        if (c != null && this.iMatcher != null && !this.iMatcher.match(c)) {
            if (student != null) {
                for (XRequest r : student.getRequests()) {
                    if (!(r instanceof XCourseRequest) || !((XCourseRequest)r).hasCourse(c.getCourseId())) continue;
                    return c;
                }
            }
            return null;
        }
        return c;
    }

    @Override
    public String name() {
        return "check-courses";
    }
}

