/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExamStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Session iSession;
    private ExamType iType;
    private DepartmentStatusType iStatus;
    private Set<TimetableManager> iManagers;

    public BaseExamStatus() {
        this.initialize();
    }

    protected void initialize() {
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public ExamType getType() {
        return this.iType;
    }

    public void setType(ExamType type) {
        this.iType = type;
    }

    public DepartmentStatusType getStatus() {
        return this.iStatus;
    }

    public void setStatus(DepartmentStatusType status) {
        this.iStatus = status;
    }

    public Set<TimetableManager> getManagers() {
        return this.iManagers;
    }

    public void setManagers(Set<TimetableManager> managers) {
        this.iManagers = managers;
    }

    public void addTomanagers(TimetableManager timetableManager) {
        if (this.iManagers == null) {
            this.iManagers = new HashSet<TimetableManager>();
        }
        this.iManagers.add(timetableManager);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamStatus)) {
            return false;
        }
        ExamStatus examStatus = (ExamStatus)o;
        if (this.getSession() == null || examStatus.getSession() == null || !this.getSession().equals(examStatus.getSession())) {
            return false;
        }
        return this.getType() != null && examStatus.getType() != null && this.getType().equals(examStatus.getType());
    }

    public int hashCode() {
        if (this.getSession() == null || this.getType() == null) {
            return super.hashCode();
        }
        return this.getSession().hashCode() ^ this.getType().hashCode();
    }

    public String toString() {
        return "ExamStatus[" + this.getSession() + ", " + this.getType() + "]";
    }

    public String toDebugString() {
        return "ExamStatus[\n\tSession: " + this.getSession() + "\n\tStatus: " + this.getStatus() + "\n\tType: " + this.getType() + "]";
    }
}

