/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimetableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDepartment
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalUniqueId;
    private String iDeptCode;
    private String iAbbreviation;
    private String iName;
    private Boolean iAllowReqTime;
    private Boolean iAllowReqRoom;
    private Boolean iAllowReqDistribution;
    private Boolean iAllowEvents;
    private Boolean iAllowStudentScheduling;
    private Boolean iInheritInstructorPreferences;
    private String iRoomSharingColor;
    private Boolean iExternalManager;
    private String iExternalMgrLabel;
    private String iExternalMgrAbbv;
    private Integer iDistributionPrefPriority;
    private Session iSession;
    private DepartmentStatusType iStatusType;
    private SolverGroup iSolverGroup;
    private Set<SubjectArea> iSubjectAreas;
    private Set<RoomDept> iRoomDepts;
    private Set<DatePattern> iDatePatterns;
    private Set<TimePattern> iTimePatterns;
    private Set<TimetableManager> iTimetableManagers;
    private Set<DepartmentalInstructor> iInstructors;
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_DEPT_CODE = "deptCode";
    public static String PROP_ABBREVIATION = "abbreviation";
    public static String PROP_NAME = "name";
    public static String PROP_ALLOW_REQ_TIME = "allowReqTime";
    public static String PROP_ALLOW_REQ_ROOM = "allowReqRoom";
    public static String PROP_ALLOW_REQ_DIST = "allowReqDistribution";
    public static String PROP_ALLOW_EVENTS = "allowEvents";
    public static String PROP_ALLOW_STUDENT_SCHD = "allowStudentScheduling";
    public static String PROP_INSTRUCTOR_PREF = "inheritInstructorPreferences";
    public static String PROP_RS_COLOR = "roomSharingColor";
    public static String PROP_EXTERNAL_MANAGER = "externalManager";
    public static String PROP_EXTERNAL_MGR_LABEL = "externalMgrLabel";
    public static String PROP_EXTERNAL_MGR_ABBV = "externalMgrAbbv";
    public static String PROP_DIST_PRIORITY = "distributionPrefPriority";

    public BaseDepartment() {
        this.initialize();
    }

    public BaseDepartment(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getDeptCode() {
        return this.iDeptCode;
    }

    public void setDeptCode(String deptCode) {
        this.iDeptCode = deptCode;
    }

    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public Boolean isAllowReqTime() {
        return this.iAllowReqTime;
    }

    public Boolean getAllowReqTime() {
        return this.iAllowReqTime;
    }

    public void setAllowReqTime(Boolean allowReqTime) {
        this.iAllowReqTime = allowReqTime;
    }

    public Boolean isAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public Boolean getAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public void setAllowReqRoom(Boolean allowReqRoom) {
        this.iAllowReqRoom = allowReqRoom;
    }

    public Boolean isAllowReqDistribution() {
        return this.iAllowReqDistribution;
    }

    public Boolean getAllowReqDistribution() {
        return this.iAllowReqDistribution;
    }

    public void setAllowReqDistribution(Boolean allowReqDistribution) {
        this.iAllowReqDistribution = allowReqDistribution;
    }

    public Boolean isAllowEvents() {
        return this.iAllowEvents;
    }

    public Boolean getAllowEvents() {
        return this.iAllowEvents;
    }

    public void setAllowEvents(Boolean allowEvents) {
        this.iAllowEvents = allowEvents;
    }

    public Boolean isAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public Boolean getAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public void setAllowStudentScheduling(Boolean allowStudentScheduling) {
        this.iAllowStudentScheduling = allowStudentScheduling;
    }

    public Boolean isInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public Boolean getInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public void setInheritInstructorPreferences(Boolean inheritInstructorPreferences) {
        this.iInheritInstructorPreferences = inheritInstructorPreferences;
    }

    public String getRoomSharingColor() {
        return this.iRoomSharingColor;
    }

    public void setRoomSharingColor(String roomSharingColor) {
        this.iRoomSharingColor = roomSharingColor;
    }

    public Boolean isExternalManager() {
        return this.iExternalManager;
    }

    public Boolean getExternalManager() {
        return this.iExternalManager;
    }

    public void setExternalManager(Boolean externalManager) {
        this.iExternalManager = externalManager;
    }

    public String getExternalMgrLabel() {
        return this.iExternalMgrLabel;
    }

    public void setExternalMgrLabel(String externalMgrLabel) {
        this.iExternalMgrLabel = externalMgrLabel;
    }

    public String getExternalMgrAbbv() {
        return this.iExternalMgrAbbv;
    }

    public void setExternalMgrAbbv(String externalMgrAbbv) {
        this.iExternalMgrAbbv = externalMgrAbbv;
    }

    public Integer getDistributionPrefPriority() {
        return this.iDistributionPrefPriority;
    }

    public void setDistributionPrefPriority(Integer distributionPrefPriority) {
        this.iDistributionPrefPriority = distributionPrefPriority;
    }

    @Override
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public DepartmentStatusType getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(DepartmentStatusType statusType) {
        this.iStatusType = statusType;
    }

    public SolverGroup getSolverGroup() {
        return this.iSolverGroup;
    }

    public void setSolverGroup(SolverGroup solverGroup) {
        this.iSolverGroup = solverGroup;
    }

    public Set<SubjectArea> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Set<SubjectArea> subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public void addTosubjectAreas(SubjectArea subjectArea) {
        if (this.iSubjectAreas == null) {
            this.iSubjectAreas = new HashSet<SubjectArea>();
        }
        this.iSubjectAreas.add(subjectArea);
    }

    public Set<RoomDept> getRoomDepts() {
        return this.iRoomDepts;
    }

    public void setRoomDepts(Set<RoomDept> roomDepts) {
        this.iRoomDepts = roomDepts;
    }

    public void addToroomDepts(RoomDept roomDept) {
        if (this.iRoomDepts == null) {
            this.iRoomDepts = new HashSet<RoomDept>();
        }
        this.iRoomDepts.add(roomDept);
    }

    public Set<DatePattern> getDatePatterns() {
        return this.iDatePatterns;
    }

    public void setDatePatterns(Set<DatePattern> datePatterns) {
        this.iDatePatterns = datePatterns;
    }

    public void addTodatePatterns(DatePattern datePattern) {
        if (this.iDatePatterns == null) {
            this.iDatePatterns = new HashSet<DatePattern>();
        }
        this.iDatePatterns.add(datePattern);
    }

    @Override
    public Set<TimePattern> getTimePatterns() {
        return this.iTimePatterns;
    }

    public void setTimePatterns(Set<TimePattern> timePatterns) {
        this.iTimePatterns = timePatterns;
    }

    public void addTotimePatterns(TimePattern timePattern) {
        if (this.iTimePatterns == null) {
            this.iTimePatterns = new HashSet<TimePattern>();
        }
        this.iTimePatterns.add(timePattern);
    }

    public Set<TimetableManager> getTimetableManagers() {
        return this.iTimetableManagers;
    }

    public void setTimetableManagers(Set<TimetableManager> timetableManagers) {
        this.iTimetableManagers = timetableManagers;
    }

    public void addTotimetableManagers(TimetableManager timetableManager) {
        if (this.iTimetableManagers == null) {
            this.iTimetableManagers = new HashSet<TimetableManager>();
        }
        this.iTimetableManagers.add(timetableManager);
    }

    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Department)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Department)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Department)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Department[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    @Override
    public String toDebugString() {
        return "Department[\n\tAbbreviation: " + this.getAbbreviation() + "\n\tAllowEvents: " + this.getAllowEvents() + "\n\tAllowReqDistribution: " + this.getAllowReqDistribution() + "\n\tAllowReqRoom: " + this.getAllowReqRoom() + "\n\tAllowReqTime: " + this.getAllowReqTime() + "\n\tAllowStudentScheduling: " + this.getAllowStudentScheduling() + "\n\tDeptCode: " + this.getDeptCode() + "\n\tDistributionPrefPriority: " + this.getDistributionPrefPriority() + "\n\tExternalManager: " + this.getExternalManager() + "\n\tExternalMgrAbbv: " + this.getExternalMgrAbbv() + "\n\tExternalMgrLabel: " + this.getExternalMgrLabel() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tInheritInstructorPreferences: " + this.getInheritInstructorPreferences() + "\n\tName: " + this.getName() + "\n\tRoomSharingColor: " + this.getRoomSharingColor() + "\n\tSession: " + this.getSession() + "\n\tSolverGroup: " + this.getSolverGroup() + "\n\tStatusType: " + this.getStatusType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

