/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collections;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.base.BaseStaff;
import org.unitime.timetable.model.dao.StaffDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

public class Staff
extends BaseStaff
implements Comparable,
NameInterface {
    private static final long serialVersionUID = 1L;

    public Staff() {
    }

    public Staff(Long uniqueId) {
        super(uniqueId);
    }

    public static List getStaffByDept(String deptCode, Long acadSessionId) throws Exception {
        if (deptCode == null) {
            return null;
        }
        Query q = StaffDAO.getInstance().getSession().createQuery("select distinct s from Staff s where s.dept=:deptCode and (select di.externalUniqueId from DepartmentalInstructor di where di.department.deptCode=:deptCode and di.department.session.uniqueId=:sessionId and di.externalUniqueId = s.externalUniqueId ) is null");
        q.setString("deptCode", deptCode);
        q.setLong("sessionId", acadSessionId.longValue());
        q.setCacheable(true);
        return q.list();
    }

    public static List findMatchingName(String fname, String lname) {
        List list = null;
        if (!(fname != null && fname.trim().length() != 0 || lname != null && lname.trim().length() != 0)) {
            return list;
        }
        Conjunction and = Restrictions.conjunction();
        if (fname != null && fname.trim().length() > 0) {
            and.add(Restrictions.ilike((String)"firstName", (String)fname, (MatchMode)MatchMode.START));
        }
        if (lname != null && lname.trim().length() > 0) {
            and.add(Restrictions.ilike((String)"lastName", (String)lname, (MatchMode)MatchMode.START));
        }
        StaffDAO sdao = new StaffDAO();
        list = sdao.getSession().createCriteria(Staff.class).add((Criterion)and).list();
        Collections.sort(list);
        return list;
    }

    public int compareTo(Object o) {
        int cmp;
        if (o == null || !(o instanceof Staff)) {
            return -1;
        }
        Staff i = (Staff)o;
        if (this.getPositionType() == null) {
            if (i.getPositionType() != null) {
                return 1;
            }
        } else {
            if (i.getPositionType() == null) {
                return -1;
            }
            cmp = this.getPositionType().getSortOrder().compareTo(i.getPositionType().getSortOrder());
            if (cmp != 0) {
                return cmp;
            }
        }
        if ((cmp = this.nameLastNameFirst().compareToIgnoreCase(i.nameLastNameFirst())) != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(i.getUniqueId() == null ? -1L : i.getUniqueId());
    }

    public String nameLastNameFirst() {
        return (this.getLastName() == null ? "" : this.getLastName().trim()) + ", " + (this.getFirstName() == null ? "" : this.getFirstName().trim()) + " " + (this.getMiddleName() == null ? "" : this.getMiddleName().trim());
    }

    public String getDeptName(Long sessionId) {
        if (this.getDept() == null || this.getDept().length() == 0) {
            return "N/A";
        }
        Department d = Department.findByDeptCode(this.getDept(), sessionId);
        if (d != null) {
            return "<span title='" + d.getHtmlTitle() + "'>" + d.getShortLabel() + "</span>";
        }
        return this.getDept();
    }

    public String getName() {
        return Constants.toInitialCase((this.getLastName() == null ? "" : this.getLastName().trim()) + ", " + (this.getFirstName() == null ? "" : this.getFirstName().trim()) + (this.getMiddleName() == null ? "" : " " + this.getMiddleName().trim()));
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }
}

