/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseReservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reservation
extends BaseReservation
implements Comparable<Reservation> {
    private static final long serialVersionUID = 1L;

    public Reservation() {
    }

    public Reservation(Long uniqueId) {
        super(uniqueId);
    }

    public boolean isExpired() {
        if (this.getExpirationDate() == null) {
            return false;
        }
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return this.getExpirationDate().before(c.getTime());
    }

    public abstract boolean isApplicable(Student var1, CourseRequest var2);

    public int getReservationLimit() {
        return this.getLimit() == null ? -1 : this.getLimit();
    }

    private boolean hasClass(Class_ clazz) {
        for (Class_ other : this.getClasses()) {
            if (!clazz.equals(other) && !other.isParentOf(clazz) && !clazz.isParentOf(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching(List<StudentClassEnrollment> enrollment) {
        if (enrollment.isEmpty()) {
            return false;
        }
        if (!this.getConfigurations().isEmpty()) {
            for (StudentClassEnrollment e : enrollment) {
                if (this.getConfigurations().contains(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig())) continue;
                return false;
            }
        }
        if (!this.getClasses().isEmpty()) {
            for (StudentClassEnrollment e : enrollment) {
                if (this.hasClass(e.getClazz())) continue;
                return false;
            }
        }
        return true;
    }

    public abstract int getPriority();

    public abstract boolean isCanAssignOverLimit();

    public abstract boolean isMustBeUsed();

    public abstract boolean isAllowOverlap();

    @Override
    public int compareTo(Reservation r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        int cmp = Double.compare(this.getRestrictivity(), r.getRestrictivity());
        if (cmp != 0) {
            return cmp;
        }
        return this.getUniqueId().compareTo(r.getUniqueId());
    }

    public double getRestrictivity() {
        if (this.getConfigurations().isEmpty()) {
            return 1.0;
        }
        double restrictivity = (double)this.getConfigurations().size() / (double)this.getInstructionalOffering().getInstrOfferingConfigs().size();
        if (this.getClasses().isEmpty()) {
            return restrictivity;
        }
        HashMap<SchedulingSubpart, Integer> counts = new HashMap<SchedulingSubpart, Integer>();
        for (Class_ class_ : this.getClasses()) {
            Integer old = (Integer)counts.get(class_.getSchedulingSubpart());
            counts.put(class_.getSchedulingSubpart(), 1 + (old == null ? 0 : old));
        }
        for (Map.Entry entry : counts.entrySet()) {
            restrictivity *= (double)((Integer)entry.getValue()).intValue() / (double)((SchedulingSubpart)entry.getKey()).getClasses().size();
        }
        return restrictivity;
    }

    protected Map<Long, Set<Long>> getSections() {
        HashMap<Long, Set<Long>> ret = new HashMap<Long, Set<Long>>();
        Iterator<Class_> iterator = this.getClasses().iterator();
        while (iterator.hasNext()) {
            for (Class_ clazz = iterator.next(); clazz != null; clazz = clazz.getParentClass()) {
                HashSet<Long> sections = (HashSet<Long>)ret.get(clazz.getSchedulingSubpart().getUniqueId());
                if (sections == null) {
                    sections = new HashSet<Long>();
                    ret.put(clazz.getSchedulingSubpart().getUniqueId(), sections);
                }
                sections.add(clazz.getUniqueId());
            }
        }
        return ret;
    }

    public int getReservedAvailableSpace() {
        if (this.getReservationLimit() < 0) {
            return Integer.MAX_VALUE;
        }
        return this.getReservationLimit() - this.countEnrollmentsForReservation();
    }

    private int countEnrollmentsForReservation() {
        HashSet<Long> checked = new HashSet<Long>();
        HashSet<Long> students = new HashSet<Long>();
        for (InstrOfferingConfig config : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    for (StudentClassEnrollment e : clazz.getStudentEnrollments()) {
                        if (e.getCourseRequest() == null || !checked.add(e.getCourseRequest().getUniqueId()) || !this.isApplicable(e.getStudent(), e.getCourseRequest()) || !this.isMatching(e.getCourseRequest().getClassEnrollments())) continue;
                        students.add(e.getStudent().getUniqueId());
                    }
                }
            }
        }
        return students.size();
    }
}

