/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseCurriculumReservation;

public class CurriculumReservation
extends BaseCurriculumReservation {
    private static final long serialVersionUID = -261396109078027984L;

    public boolean isApplicable(Student student, CourseRequest request) {
        for (AcademicAreaClassification aac : student.getAcademicAreaClassifications()) {
            if (!aac.getAcademicArea().equals(this.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(aac.getAcademicClassification())) continue;
            if (this.getMajors().isEmpty()) {
                return true;
            }
            for (PosMajor major : this.getMajors()) {
                if (!student.getPosMajors().contains(major)) continue;
                return true;
            }
        }
        return false;
    }

    public int getPriority() {
        return ApplicationProperty.ReservationPriorityCurriculum.intValue();
    }

    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitCurriculum.isTrue();
    }

    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedCurriculum.isTrue();
    }

    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapCurriculum.isTrue();
    }
}

