/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import java.util.TreeSet;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.base.BaseCurriculumCourse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumCourse
extends BaseCurriculumCourse
implements Comparable<CurriculumCourse> {
    private static final long serialVersionUID = 1L;

    public CurriculumCourse() {
    }

    public CurriculumCourse(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public int compareTo(CurriculumCourse c) {
        if (this.getOrd() != null && c.getOrd() != null && !this.getOrd().equals(c.getOrd())) {
            return this.getOrd().compareTo(c.getOrd());
        }
        if (this.getCourse().equals(c.getCourse())) {
            return this.getClassification().compareTo(c.getClassification());
        }
        for (CurriculumClassification cc1 : new TreeSet<CurriculumClassification>(this.getClassification().getCurriculum().getClassifications())) {
            int cmp;
            CurriculumClassification cc2 = null;
            for (CurriculumClassification cc : c.getClassification().getCurriculum().getClassifications()) {
                if (cc1.getAcademicClassification() != null && cc1.getAcademicClassification().equals(cc.getAcademicClassification())) {
                    cc2 = cc;
                    break;
                }
                if (cc1.getAcademicClassification() != null || !cc1.getName().equals(cc.getName())) continue;
                cc2 = cc;
                break;
            }
            float s1 = 0.0f;
            float s2 = 0.0f;
            for (CurriculumCourse x : cc1.getCourses()) {
                if (!x.getCourse().equals(this.getCourse())) continue;
                s1 = x.getPercShare().floatValue();
                break;
            }
            if (cc2 != null) {
                for (CurriculumCourse x : cc2.getCourses()) {
                    if (!x.getCourse().equals(c.getCourse())) continue;
                    s2 = x.getPercShare().floatValue();
                    break;
                }
            }
            if ((cmp = -Double.compare(s1, s2)) == 0) continue;
            return cmp;
        }
        int cmp = this.getCourse().getSubjectArea().compareTo(c.getCourse().getSubjectArea());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getCourse().getCourseNbr().compareToIgnoreCase(c.getCourse().getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        return this.getCourse().getUniqueId().compareTo(c.getCourse().getUniqueId());
    }

    public CurriculumCourse clone(CourseOffering newCourse) {
        CurriculumCourse cc = new CurriculumCourse();
        cc.setPercShare(this.getPercShare());
        cc.setOrd(this.getOrd());
        cc.setClassification(this.getClassification());
        cc.setCourse(newCourse);
        cc.setGroups(new HashSet<CurriculumCourseGroup>(this.getGroups()));
        return cc;
    }
}

