/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;

public class OnlineSectioningInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;

    public static class SectioningProperties
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId = null;
        private boolean iAdmin = false;
        private boolean iAdvisor = false;
        private boolean iEmail = false;
        private boolean iMassCancel = false;
        private boolean iChangeStatus = false;
        private boolean iRequestUpdate = false;
        private boolean iChangeLog = false;

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public boolean isAdmin() {
            return this.iAdmin;
        }

        public boolean isAdvisor() {
            return this.iAdvisor;
        }

        public boolean isAdminOrAdvisor() {
            return this.iAdmin || this.iAdvisor;
        }

        public void setAdmin(boolean admin) {
            this.iAdmin = admin;
        }

        public void setAdvisor(boolean advisor) {
            this.iAdvisor = advisor;
        }

        public void setEmail(boolean email) {
            this.iEmail = email;
        }

        public boolean isEmail() {
            return this.iEmail;
        }

        public void setMassCancel(boolean massCancel) {
            this.iMassCancel = massCancel;
        }

        public boolean isMassCancel() {
            return this.iMassCancel;
        }

        public void setChangeStatus(boolean changeStatus) {
            this.iChangeStatus = changeStatus;
        }

        public boolean isChangeStatus() {
            return this.iChangeStatus;
        }

        public void setRequestUpdate(boolean requestUpdate) {
            this.iRequestUpdate = requestUpdate;
        }

        public boolean isRequestUpdate() {
            return this.iRequestUpdate;
        }

        public void setChangeLog(boolean changeLog) {
            this.iChangeLog = changeLog;
        }

        public boolean isChangeLog() {
            return this.iChangeLog;
        }

        public boolean isCanSelectStudent() {
            return this.iEmail || this.iMassCancel || this.iChangeStatus || this.iRequestUpdate;
        }
    }

    public static class EligibilityCheck
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int iFlags = 0;
        private String iMessage = null;
        private String iCheckboxMessage = null;
        private Long iSessionId = null;
        private Long iStudentId = null;

        public EligibilityCheck() {
        }

        public EligibilityCheck(String message, EligibilityFlag ... flags) {
            this.iMessage = message;
            for (EligibilityFlag flag : flags) {
                this.setFlag(flag, true);
            }
        }

        public EligibilityCheck(EligibilityFlag ... flags) {
            for (EligibilityFlag flag : flags) {
                this.setFlag(flag, true);
            }
        }

        public void setFlag(EligibilityFlag flag, boolean set) {
            if (set && !this.hasFlag(flag)) {
                this.iFlags += flag.flag();
            }
            if (!set && this.hasFlag(flag)) {
                this.iFlags -= flag.flag();
            }
        }

        public boolean hasFlag(EligibilityFlag flag) {
            return (this.iFlags & flag.flag()) != 0;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setCheckboxMessage(String message) {
            this.iCheckboxMessage = message;
        }

        public boolean hasCheckboxMessage() {
            return this.iCheckboxMessage != null && !this.iCheckboxMessage.isEmpty();
        }

        public String getCheckboxMessage() {
            return this.iCheckboxMessage;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EligibilityFlag implements IsSerializable
        {
            IS_ADMIN,
            IS_ADVISOR,
            IS_GUEST,
            CAN_USE_ASSISTANT,
            CAN_ENROLL,
            PIN_REQUIRED,
            CAN_WAITLIST,
            RECHECK_AFTER_ENROLLMENT,
            RECHECK_BEFORE_ENROLLMENT,
            CAN_RESET,
            CONFIRM_DROP,
            QUICK_ADD_DROP,
            ALTERNATIVES_DROP,
            GWT_CONFIRMATIONS,
            DEGREE_PLANS,
            CAN_REGISTER,
            NO_REQUEST_ARROWS;


            public int flag() {
                return 1 << this.ordinal();
            }
        }
    }
}

