/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaDialogBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeDialogBox
extends AriaDialogBox
implements HasOpenHandlers<UniTimeDialogBox> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private FlowPanel iContainer;
    private FlowPanel iControls;
    private Anchor iClose;
    private boolean iEscapeToHide = false;
    private Command iSubmitHandler = null;

    public UniTimeDialogBox(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.setAnimationEnabled(true);
        this.setGlassEnabled(true);
        this.iContainer = new FlowPanel();
        this.iContainer.addStyleName("dialogContainer");
        this.iClose = new Anchor();
        this.iClose.setTitle(MESSAGES.hintCloseDialog());
        this.iClose.setStyleName("close");
        this.iClose.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeDialogBox.this.onCloseClick(event);
            }
        });
        this.iClose.setVisible(autoHide);
        this.iControls = new FlowPanel();
        this.iControls.setStyleName("dialogControls");
        this.iControls.add((Widget)this.iClose);
    }

    public void center() {
        super.center();
        AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()));
    }

    public void setAutoHideEnabled(boolean autoHide) {
        super.setAutoHideEnabled(autoHide);
        this.iClose.setVisible(autoHide);
    }

    public void setEscapeToHide(boolean escapeToHide) {
        this.iEscapeToHide = escapeToHide;
    }

    public boolean isEscapeToHide() {
        return this.iEscapeToHide;
    }

    public void setEnterToSubmit(Command submitCommand) {
        this.iSubmitHandler = submitCommand;
    }

    public boolean isEnterToSubmit() {
        return this.iSubmitHandler != null;
    }

    public void setWidget(Widget widget) {
        if (this.iContainer.getWidgetCount() == 0) {
            this.iContainer.add((Widget)this.iControls);
            super.setWidget((Widget)this.iContainer);
        } else {
            while (this.iContainer.getWidgetCount() > 1) {
                this.iContainer.remove(1);
            }
        }
        this.iContainer.add(widget);
    }

    protected void onCloseClick(ClickEvent event) {
        this.hide();
    }

    public HandlerRegistration addOpenHandler(OpenHandler<UniTimeDialogBox> handler) {
        return this.addHandler((EventHandler)handler, OpenEvent.getType());
    }

    public void show() {
        boolean fireOpen = !this.isShowing();
        super.show();
        if (fireOpen) {
            OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)this));
        }
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        if (this.isEscapeToHide() && event.getNativeEvent().getKeyCode() == 27) {
            AriaStatus.getInstance().setText(ARIA.dialogClosed(this.getText()));
            this.hide();
        }
        if (this.isEnterToSubmit() && event.getNativeEvent().getKeyCode() == 13) {
            event.getNativeEvent().stopPropagation();
            event.getNativeEvent().preventDefault();
            this.iSubmitHandler.execute();
        }
    }
}

