/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseFinderCourses
extends VerticalPanel
implements CourseFinder.CourseFinderTab<Collection<ClassAssignmentInterface.CourseAssignment>> {
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> iDataProvider = null;
    private WebTable iCourses;
    private ScrollPanel iCoursesPanel;
    private Label iCoursesTip;
    private UniTimeTabPanel iCourseDetailsTabPanel;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private CourseFinder.CourseFinderCourseDetails[] iDetails = null;
    private String iLastQuery = null;
    private boolean iShowCourses = false;
    private boolean iShowDefaultSuggestions = false;

    public CourseFinderCourses() {
        this(false, false);
    }

    public CourseFinderCourses(boolean showCourses, boolean showDefaultSuggestions) {
        this.iShowCourses = showCourses;
        this.iShowDefaultSuggestions = showDefaultSuggestions;
        this.iCourses = new WebTable();
        this.iCourses.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject(), 1, "80px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "80px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "60px"), new WebTable.Cell(MESSAGES.colTitle(), 1, "300px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "60px"), new WebTable.Cell(MESSAGES.colNote(), 1, "300px")));
        this.iCourses.addRowDoubleClickHandler(new WebTable.RowDoubleClickHandler(){

            public void onRowDoubleClick(WebTable.RowDoubleClickEvent event) {
                CourseFinderCourses.this.iCourses.setSelectedRow(event.getRowIdx());
                CourseFinderCourses.this.updateCourseDetails();
                SelectionEvent.fire((HasSelectionHandlers)CourseFinderCourses.this, (Object)CourseFinderCourses.this.getValue());
            }
        });
        this.iCourses.addRowClickHandler(new WebTable.RowClickHandler(){

            public void onRowClick(WebTable.RowClickEvent event) {
                CourseFinderCourses.this.iCourses.setSelectedRow(event.getRowIdx());
                CourseFinderCourses.this.updateCourseDetails();
            }
        });
        this.iCoursesPanel = new ScrollPanel((Widget)this.iCourses);
        this.iCoursesPanel.getElement().getStyle().setWidth(780.0, Style.Unit.PX);
        this.iCoursesPanel.getElement().getStyle().setHeight(200.0, Style.Unit.PX);
        this.iCoursesPanel.setStyleName("unitime-ScrollPanel");
        this.iCoursesTip = new Label(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
        this.iCoursesTip.setStyleName("unitime-Hint");
        ToolBox.disableTextSelectInternal((Element)this.iCoursesTip.getElement());
        this.iCoursesTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseFinderCourses.this.iCoursesTip.getText();
                do {
                    CourseFinderCourses.this.iCoursesTip.setText(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
                } while (oldText.equals(CourseFinderCourses.this.iCoursesTip.getText()));
            }
        });
        this.iCourseDetailsTabPanel = new UniTimeTabPanel();
        this.iCourseDetailsTabPanel.setDeckStyleName("unitime-TabPanel");
        this.iCourseDetailsTabPanel.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Cookies.setCookie((String)"UniTime:CourseFinderCourses", (String)String.valueOf(event.getSelectedItem()));
            }
        });
        this.setSpacing(10);
        this.add((Widget)this.iCoursesPanel);
        this.add((Widget)this.iCourseDetailsTabPanel);
        this.add((Widget)this.iCoursesTip);
    }

    @Override
    public void setDataProvider(DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public String getName() {
        return MESSAGES.courseSelectionCourses();
    }

    public Widget asWidget() {
        return this;
    }

    public void setValue(String value) {
        this.setValue(value, false);
    }

    public String getValue() {
        if (this.iCourses.getSelectedRow() < 0 || this.iCourses.getRowsCount() == 0) {
            return null;
        }
        WebTable.Row row = this.iCourses.getRows()[this.iCourses.getSelectedRow()];
        String courseName = MESSAGES.courseName(row.getCell(0).getValue(), row.getCell(1).getValue());
        if ("false".equals(row.getId()) || this.iShowCourses) {
            courseName = MESSAGES.courseNameWithTitle(row.getCell(0).getValue(), row.getCell(1).getValue(), row.getCell(3).getValue());
        }
        return courseName;
    }

    public void setValue(String value, final boolean fireEvents) {
        if (value == null) {
            value = "";
        }
        if (value.isEmpty() && !this.iShowDefaultSuggestions) {
            this.iLastQuery = null;
            this.iCourses.clearData(true);
            this.iCourses.setEmptyMessage(MESSAGES.courseSelectionNoCourseFilter());
            this.updateCourseDetails();
        } else if (!value.equals(this.iLastQuery)) {
            this.iLastQuery = value;
            this.iDataProvider.getData(value, new AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                public void onFailure(Throwable caught) {
                    CourseFinderCourses.this.iCourses.clearData(true);
                    CourseFinderCourses.this.iCourses.setEmptyMessage(caught.getMessage());
                    if (CourseFinderCourses.this.isVisible()) {
                        AriaStatus.getInstance().setText(caught.getMessage());
                    }
                    CourseFinderCourses.this.updateCourseDetails();
                    CourseFinder.ResponseEvent.fire(CourseFinderCourses.this, false);
                }

                public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
                    WebTable.Row[] records = new WebTable.Row[result.size()];
                    int idx = 0;
                    int selectRow = -1;
                    for (ClassAssignmentInterface.CourseAssignment record : result) {
                        records[idx] = new WebTable.Row(record.getSubject(), record.getCourseNbr(), record.getLimit() == null || record.getLimit() == 0 || record.getEnrollment() == null ? "" : (record.getLimit() < 0 ? "&infin;" : record.getLimit() - record.getEnrollment() + " / " + record.getLimit()), record.getTitle() == null ? "" : record.getTitle(), record.hasCredit() ? record.getCreditAbbv() : "", record.getNote() == null ? "" : record.getNote());
                        if (record.hasCredit()) {
                            records[idx].getCell(4).setTitle(record.getCreditText());
                        }
                        records[idx].setId(record.hasUniqueName() ? "true" : "false");
                        if (CourseFinderCourses.this.iLastQuery.equalsIgnoreCase(MESSAGES.courseName(record.getSubject(), record.getCourseNbr())) || record.getTitle() != null && CourseFinderCourses.this.iLastQuery.equalsIgnoreCase(MESSAGES.courseNameWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle()))) {
                            selectRow = idx;
                        }
                        if (record.getTitle() == null || record.getTitle().isEmpty()) {
                            if (record.getNote() == null || record.getNote().isEmpty()) {
                                records[idx].setAriaLabel(ARIA.courseFinderCourse(record.getSubject(), record.getCourseNbr()));
                            } else {
                                records[idx].setAriaLabel(ARIA.courseFinderCourseWithNote(record.getSubject(), record.getCourseNbr(), record.getNote()));
                            }
                        } else if (record.getNote() == null || record.getNote().isEmpty()) {
                            records[idx].setAriaLabel(ARIA.courseFinderCourseWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle()));
                        } else {
                            records[idx].setAriaLabel(ARIA.courseFinderCourseWithTitleAndNote(record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote()));
                        }
                        ++idx;
                    }
                    CourseFinderCourses.this.iCourses.setData(records);
                    if (records.length == 1) {
                        selectRow = 0;
                    }
                    if (selectRow >= 0) {
                        CourseFinderCourses.this.iCourses.setSelectedRow(selectRow);
                        CourseFinderCourses.this.scrollToSelectedRow();
                        if (fireEvents) {
                            ValueChangeEvent.fire((HasValueChangeHandlers)CourseFinderCourses.this, (Object)CourseFinderCourses.this.getValue());
                        }
                    }
                    CourseFinderCourses.this.updateCourseDetails();
                    CourseFinder.ResponseEvent.fire(CourseFinderCourses.this, !result.isEmpty());
                }
            });
        }
    }

    protected void scrollToSelectedRow() {
        if (this.iCourses.getSelectedRow() < 0) {
            return;
        }
        com.google.gwt.user.client.Element scroll = this.iCoursesPanel.getElement();
        com.google.gwt.user.client.Element item = this.iCourses.getTable().getRowFormatter().getElement(this.iCourses.getSelectedRow());
        if (item == null) {
            return;
        }
        int realOffset = 0;
        while (item != null && !item.equals((Object)scroll)) {
            realOffset += item.getOffsetTop();
            item = item.getOffsetParent();
        }
        scroll.setScrollTop(realOffset - scroll.getOffsetHeight() / 2);
    }

    protected void updateCourseDetails() {
        if (this.iCourses.getSelectedRow() < 0 || this.iCourses.getRows() == null || this.iCourses.getRows().length == 0) {
            if (this.iDetails != null) {
                for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                    detail.setValue(null);
                }
            }
            AriaStatus.getInstance().setHTML(ARIA.courseFinderNoCourse());
        } else {
            WebTable.Row row = this.iCourses.getRows()[this.iCourses.getSelectedRow()];
            String courseName = MESSAGES.courseName(row.getCell(0).getValue(), row.getCell(1).getValue());
            if ("false".equals(row.getId()) || this.iShowCourses) {
                courseName = MESSAGES.courseNameWithTitle(row.getCell(0).getValue(), row.getCell(1).getValue(), row.getCell(3).getValue());
            }
            for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                detail.setValue(courseName);
            }
            String title = row.getCell(3).getValue();
            String note = row.getCell(5).getValue();
            if (title.isEmpty()) {
                if (note.isEmpty()) {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelected(1 + this.iCourses.getSelectedRow(), this.iCourses.getRowsCount(), row.getCell(0).getValue(), row.getCell(1).getValue()));
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithNote(1 + this.iCourses.getSelectedRow(), this.iCourses.getRowsCount(), row.getCell(0).getValue(), row.getCell(1).getValue(), note));
                }
            } else if (note.isEmpty()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitle(1 + this.iCourses.getSelectedRow(), this.iCourses.getRowsCount(), row.getCell(0).getValue(), row.getCell(1).getValue(), title));
            } else {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitleAndNote(1 + this.iCourses.getSelectedRow(), this.iCourses.getRowsCount(), row.getCell(0).getValue(), row.getCell(1).getValue(), title, note));
            }
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<String> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    @Override
    public boolean isCourseSelection() {
        return true;
    }

    @Override
    public void setCourseDetails(CourseFinder.CourseFinderCourseDetails ... details) {
        this.iDetails = details;
        int tabIndex = 0;
        for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
            ScrollPanel panel = new ScrollPanel(detail.asWidget());
            panel.setStyleName("unitime-ScrollPanel-inner");
            panel.getElement().getStyle().setWidth(780.0, Style.Unit.PX);
            panel.getElement().getStyle().setHeight(200.0, Style.Unit.PX);
            this.iCourseDetailsTabPanel.add((Widget)panel, detail.getName(), true);
            Character ch = UniTimeHeaderPanel.guessAccessKey(detail.getName());
            if (ch != null) {
                this.iTabAccessKeys.put(ch, tabIndex);
            }
            ++tabIndex;
        }
        this.selectLastTab();
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 40) {
            this.iCourses.setSelectedRow(this.iCourses.getSelectedRow() + 1);
            this.scrollToSelectedRow();
            this.updateCourseDetails();
        } else if (event.getNativeKeyCode() == 38) {
            this.iCourses.setSelectedRow(this.iCourses.getSelectedRow() == 0 ? this.iCourses.getRowsCount() - 1 : this.iCourses.getSelectedRow() - 1);
            this.scrollToSelectedRow();
            this.updateCourseDetails();
        } else if (event.isControlKeyDown() || event.isAltKeyDown()) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                this.iCourseDetailsTabPanel.selectTab(entry.getValue());
                event.preventDefault();
                event.stopPropagation();
            }
        }
    }

    @Override
    public HandlerRegistration addResponseHandler(CourseFinder.ResponseHandler handler) {
        return this.addHandler(handler, CourseFinder.ResponseEvent.getType());
    }

    private void selectLastTab() {
        try {
            int tab = Integer.valueOf(Cookies.getCookie((String)"UniTime:CourseFinderCourses"));
            if (tab >= 0 || tab < this.iCourseDetailsTabPanel.getTabCount() && tab != this.iCourseDetailsTabPanel.getSelectedTab()) {
                this.iCourseDetailsTabPanel.selectTab(tab);
            } else {
                this.iCourseDetailsTabPanel.selectTab(0);
            }
        }
        catch (Exception e) {
            this.iCourseDetailsTabPanel.selectTab(0);
        }
    }

    @Override
    public void changeTip() {
        this.iCoursesTip.setText(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
        this.selectLastTab();
    }
}

