/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.command.client.GwtRpcException;

public class UniTimeNotifications {
    protected static Display NOTIFICATIONS = (Display)GWT.create(Display.class);
    protected static Logger sLogger = Logger.getLogger(UniTimeNotifications.class.getName());

    public static void info(String text) {
        AriaStatus.getInstance().setText(text);
        sLogger.log(Level.FINEST, text);
        NOTIFICATIONS.addNotification(text, NotificationType.INFO);
    }

    public static void warn(String text) {
        AriaStatus.getInstance().setText(text);
        sLogger.log(Level.FINER, text);
        NOTIFICATIONS.addNotification(text, NotificationType.WARN);
    }

    public static void error(Throwable t) {
        if (t == null) {
            return;
        }
        Throwable u = ToolBox.unwrap(t);
        UniTimeNotifications.error(u.getMessage(), u);
    }

    public static void error(String text, Throwable t) {
        AriaStatus.getInstance().setText(text);
        if (t == null) {
            sLogger.log(Level.FINE, text);
        } else if ((t = ToolBox.unwrap(t)) instanceof GwtRpcException) {
            GwtRpcException e = (GwtRpcException)t;
            if (e.hasCause()) {
                sLogger.log(Level.WARNING, text, e.getCause());
            } else {
                sLogger.log(Level.INFO, text);
            }
        } else {
            sLogger.log(Level.SEVERE, text, t);
        }
        NOTIFICATIONS.addNotification(text, NotificationType.ERROR);
    }

    public static void error(String text) {
        UniTimeNotifications.error(text, null);
    }

    public static native void createTriggers();

    public static class Implementation
    implements Display {
        protected List<Notification> iNotifications = new ArrayList<Notification>();
        protected Timer iMoveTimer = null;
        protected Animation iAnimation;

        public Implementation() {
            Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    Implementation.this.delayedMove();
                }
            });
            Window.addWindowScrollHandler((Window.ScrollHandler)new Window.ScrollHandler(){

                public void onWindowScroll(Window.ScrollEvent event) {
                    Implementation.this.delayedMove();
                }
            });
            Client.addGwtPageChangedHandler(new Client.GwtPageChangedHandler(){

                public void onChange(Client.GwtPageChangeEvent event) {
                    Implementation.this.delayedMove();
                }
            });
            this.iMoveTimer = new Timer(){

                public void run() {
                    Implementation.this.move();
                }
            };
            this.iAnimation = new NotificationAnimation();
        }

        protected void addNotification(final Notification notification) {
            RootPanel.get().add((Widget)notification, Window.getScrollLeft() + Window.getClientWidth() - 445, Window.getScrollTop() + Window.getClientHeight());
            this.iAnimation.cancel();
            Iterator<Notification> i = this.iNotifications.iterator();
            while (i.hasNext()) {
                Notification n = i.next();
                if (!n.equals((Object)notification)) continue;
                n.hide();
                i.remove();
            }
            this.move();
            this.iNotifications.add(0, notification);
            this.iAnimation.run(1000);
            Timer timer = new Timer(){

                public void run() {
                    notification.hide();
                    Implementation.this.iNotifications.remove((Object)notification);
                }
            };
            notification.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    notification.hide();
                    Implementation.this.iNotifications.remove((Object)notification);
                    Implementation.this.move();
                }
            });
            timer.schedule(10000);
        }

        protected void move() {
            int height = 0;
            this.iAnimation.cancel();
            for (HTML hTML : this.iNotifications) {
                hTML.getElement().getStyle().setProperty("left", Window.getScrollLeft() + Window.getClientWidth() - 445 + "px");
                hTML.getElement().getStyle().setProperty("top", Window.getScrollTop() + Window.getClientHeight() - (height += hTML.getElement().getClientHeight() + 10) + "px");
            }
        }

        protected void delayedMove() {
            if (!this.iNotifications.isEmpty()) {
                this.iMoveTimer.schedule(100);
            }
        }

        public void addNotification(String html, NotificationType type) {
            switch (type) {
                case ERROR: {
                    this.addNotification(new Notification(html, "unitime-NotificationError"));
                    break;
                }
                case WARN: {
                    this.addNotification(new Notification(html, "unitime-NotificationWarning"));
                    break;
                }
                case INFO: {
                    this.addNotification(new Notification(html, "unitime-NotificationInfo"));
                }
            }
        }

        public static class Notification
        extends HTML {
            Notification(String text, String style) {
                super(text);
                this.setStyleName("unitime-Notification");
                this.addStyleName(style);
            }

            public String toString() {
                return this.getHTML();
            }

            public int hashCode() {
                return this.getHTML().hashCode();
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof Notification)) {
                    return false;
                }
                return ((Notification)((Object)o)).getHTML().equals(this.getHTML());
            }

            public void hide() {
                RootPanel.get().remove((Widget)this);
            }

            public void show() {
                RootPanel.get().add((Widget)this, Window.getScrollLeft() + Window.getClientWidth() - 445, Window.getScrollTop() + Window.getClientHeight());
            }
        }

        private class NotificationAnimation
        extends Animation {
            private NotificationAnimation() {
            }

            protected void onUpdate(double progress) {
                if (Implementation.this.iNotifications.isEmpty()) {
                    return;
                }
                int height = -((int)Math.round((1.0 - progress) * (double)(Implementation.this.iNotifications.get(0).getElement().getClientHeight() + 10)));
                for (Notification notification : Implementation.this.iNotifications) {
                    notification.getElement().getStyle().setProperty("left", Window.getScrollLeft() + Window.getClientWidth() - 445 + "px");
                    notification.getElement().getStyle().setProperty("top", Window.getScrollTop() + Window.getClientHeight() - (height += notification.getElement().getClientHeight() + 10) + "px");
                }
            }
        }
    }

    public static interface Display {
        public void addNotification(String var1, NotificationType var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NotificationType {
        INFO,
        WARN,
        ERROR;

    }
}

