/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.events.ApproveDialog;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.events.EventCookie;
import org.unitime.timetable.gwt.client.events.EventMeetingTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.widgets.ImageLink;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.EventInterface;

public class EventDetail
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static DateTimeFormat sTimeStampFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private static DateTimeFormat sEventDateFormat = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormat());
    private EventInterface iEvent = null;
    private SimpleForm iForm = new SimpleForm();
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeHeaderPanel iEnrollmentHeader;
    private UniTimeTable<EventInterface.ContactInterface> iContacts;
    private EventMeetingTable iMeetings;
    private UniTimeTable<EventInterface.NoteInterface> iNotes;
    private UniTimeTable<EventInterface.RelatedObjectInterface> iOwners;
    private EnrollmentTable iEnrollments;
    private ApproveDialog iApproveDialog;
    private CheckBox iShowDeleted;
    private EventAdd.EventPropertiesProvider iProperties;
    private int iLastScrollTop;
    private int iLastScrollLeft;

    public EventDetail(EventAdd.EventPropertiesProvider properties) {
        this.iProperties = properties;
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("edit", MESSAGES.buttonEditEvent(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventDetail.this.edit();
            }
        });
        this.iHeader.addButton("previous", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventInterface prev = EventDetail.this.getPrevious(EventDetail.this.getEvent().getId());
                if (prev != null) {
                    EventDetail.this.previous(prev);
                }
            }
        });
        this.iHeader.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventInterface next = EventDetail.this.getNext(EventDetail.this.getEvent().getId());
                if (next != null) {
                    EventDetail.this.next(next);
                }
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventDetail.this.hide();
            }
        });
        this.iContacts = new UniTimeTable();
        this.iContacts.setStyleName("unitime-EventContacts");
        ArrayList<UniTimeTableHeader> contactHeader = new ArrayList<UniTimeTableHeader>();
        contactHeader.add(new UniTimeTableHeader(MESSAGES.colNamePerson()));
        contactHeader.add(new UniTimeTableHeader(MESSAGES.colEmail()));
        contactHeader.add(new UniTimeTableHeader(MESSAGES.colPhone()));
        this.iContacts.addRow(null, contactHeader);
        this.iApproveDialog = new ApproveDialog(this.iProperties){

            @Override
            protected void onSubmit(final EventInterface.SaveOrApproveEventRpcRequest.Operation operation, List<EventMeetingTable.EventMeetingRow> items, String message, boolean emailConfirmation) {
                switch (operation) {
                    case APPROVE: {
                        LoadingWidget.getInstance().show(MESSAGES.waitForApproval(EventDetail.this.iEvent.getName()));
                        break;
                    }
                    case INQUIRE: {
                        LoadingWidget.getInstance().show(MESSAGES.waitForInquiry(EventDetail.this.iEvent.getName()));
                        break;
                    }
                    case REJECT: {
                        LoadingWidget.getInstance().show(MESSAGES.waitForRejection(EventDetail.this.iEvent.getName()));
                        break;
                    }
                    case CANCEL: {
                        LoadingWidget.getInstance().show(MESSAGES.waitForCancellation(EventDetail.this.iEvent.getName()));
                    }
                }
                ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                for (EventMeetingTable.EventMeetingRow item : items) {
                    meetings.add(item.getMeeting());
                }
                RPC.execute(EventInterface.ApproveEventRpcRequest.createRequest(operation, EventDetail.this.iProperties.getSessionId(), EventDetail.this.iEvent, meetings, message, emailConfirmation), new AsyncCallback<EventInterface.SaveOrApproveEventRpcResponse>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        UniTimeNotifications.error(caught.getMessage(), caught);
                    }

                    public void onSuccess(EventInterface.SaveOrApproveEventRpcResponse result) {
                        LoadingWidget.getInstance().hide();
                        if (result.hasMessages()) {
                            for (EventInterface.MessageInterface m : result.getMessages()) {
                                if (m.isError()) {
                                    UniTimeNotifications.warn(m.getMessage());
                                    continue;
                                }
                                if (m.isWarning()) {
                                    UniTimeNotifications.error(m.getMessage());
                                    continue;
                                }
                                UniTimeNotifications.info(m.getMessage());
                            }
                        }
                        switch (operation) {
                            case APPROVE: {
                                EventDetail.this.onApprovalOrReject(EventDetail.this.iEvent.getId(), result.getEvent());
                                EventDetail.this.setEvent(result.getEvent());
                                break;
                            }
                            case REJECT: 
                            case CANCEL: {
                                EventDetail.this.onApprovalOrReject(EventDetail.this.iEvent.getId(), result.getEvent());
                                if (result.hasEventWithId()) {
                                    EventDetail.this.setEvent(result.getEvent());
                                    break;
                                }
                                EventDetail.this.hide();
                                break;
                            }
                            case INQUIRE: {
                                EventDetail.this.setEvent(result.getEvent());
                            }
                        }
                    }
                });
            }
        };
        this.iMeetings = new EventMeetingTable(EventMeetingTable.Mode.MeetingsOfAnEvent, true, this.iProperties);
        this.iMeetings.setOperation(EventMeetingTable.OperationType.Approve, this.iApproveDialog);
        this.iMeetings.setOperation(EventMeetingTable.OperationType.Reject, this.iApproveDialog);
        this.iMeetings.setOperation(EventMeetingTable.OperationType.Inquire, this.iApproveDialog);
        this.iMeetings.setOperation(EventMeetingTable.OperationType.Cancel, this.iApproveDialog);
        this.iMeetings.setEditable(false);
        this.iShowDeleted = new CheckBox("<i>" + MESSAGES.showDeletedMeetings() + "</i>", true);
        this.iShowDeleted.setValue(Boolean.valueOf(EventCookie.getInstance().isShowDeletedMeetings()));
        this.iShowDeleted.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                EventDetail.this.iMeetings.setMeetings(EventDetail.this.iEvent, EventDetail.this.iMeetings.getMeetings());
                EventCookie.getInstance().setShowDeletedMeetings((Boolean)event.getValue());
                if (((Boolean)event.getValue()).booleanValue()) {
                    EventDetail.this.iMeetings.removeStyleName("unitime-EventMeetingsHideDeleted");
                } else {
                    EventDetail.this.iMeetings.addStyleName("unitime-EventMeetingsHideDeleted");
                }
            }
        });
        if (!this.iShowDeleted.getValue().booleanValue()) {
            this.iMeetings.addStyleName("unitime-EventMeetingsHideDeleted");
        }
        this.iOwners = new UniTimeTable();
        this.iOwners.setStyleName("unitime-EventOwners");
        ArrayList<UniTimeTableHeader> ownersHeader = new ArrayList<UniTimeTableHeader>();
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colType()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colTitle()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colTime()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colLocation()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colInstructor()));
        ownersHeader.add(new UniTimeTableHeader(MESSAGES.colNote()));
        this.iOwners.addRow(null, ownersHeader);
        this.iOwners.addMouseClickListener(new UniTimeTable.MouseClickListener<EventInterface.RelatedObjectInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<EventInterface.RelatedObjectInterface> event) {
                if (event.getData() != null && event.getData().hasDetailPage()) {
                    UniTimeFrameDialog.openDialog(MESSAGES.dialogDetailsOf(event.getData().getName()), event.getData().getDetailPage() + "&menu=hide");
                }
            }
        });
        this.iEnrollmentHeader = new UniTimeHeaderPanel(MESSAGES.sectEnrollments());
        this.iEnrollments = new EnrollmentTable(false, true);
        this.iEnrollments.getTable().setStyleName("unitime-Enrollments");
        this.iNotes = new UniTimeTable();
        this.iNotes.setStyleName("unitime-EventNotes");
        ArrayList<UniTimeTableHeader> notesHeader = new ArrayList<UniTimeTableHeader>();
        notesHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
        notesHeader.add(new UniTimeTableHeader(MESSAGES.colUser()));
        notesHeader.add(new UniTimeTableHeader(MESSAGES.colAction()));
        notesHeader.add(new UniTimeTableHeader(MESSAGES.colMeetings()));
        notesHeader.add(new UniTimeTableHeader(MESSAGES.colNote()));
        notesHeader.add(new UniTimeTableHeader(MESSAGES.colAttachment()));
        this.iNotes.addRow(null, notesHeader);
        this.iFooter = this.iHeader.clonePanel();
        this.initWidget((Widget)this.iForm);
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEventDetail());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
    }

    public void hide() {
        this.setVisible(false);
        this.onHide();
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    protected void onHide() {
    }

    protected void onShow() {
    }

    protected void edit() {
    }

    protected EventInterface getNext(Long eventId) {
        return null;
    }

    protected void next(EventInterface event) {
    }

    protected EventInterface getPrevious(Long eventId) {
        return null;
    }

    protected void previous(EventInterface previous) {
    }

    protected void onApprovalOrReject(Long eventId, EventInterface event) {
    }

    public void setEvent(EventInterface event) {
        int col;
        int rowNum;
        this.iEvent = event;
        this.iApproveDialog.reset(this.iProperties.getProperties());
        this.iForm.clear();
        this.iHeader.clearMessage();
        this.iHeader.setHeaderTitle(this.iEvent.getName() + " (" + this.iEvent.getType().getName(CONSTANTS) + ")");
        this.iHeader.setEnabled("edit", this.iEvent.isCanEdit());
        this.iHeader.setEnabled("previous", this.getPrevious(this.iEvent.getId()) != null);
        this.iHeader.setEnabled("next", this.getNext(this.iEvent.getId()) != null);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iForm.addRow(MESSAGES.propEventType(), (Widget)new Label(this.iEvent.getType().getName(CONSTANTS)));
        this.iContacts.clearTable(1);
        if (this.iEvent.hasContact()) {
            Iterator<EventInterface.ContactInterface> row = new ArrayList<Label>();
            row.add((EventInterface.ContactInterface)new Label(this.iEvent.getContact().getName(MESSAGES), false));
            row.add((EventInterface.ContactInterface)new Label(this.iEvent.getContact().hasEmail() ? this.iEvent.getContact().getEmail() : "", false));
            row.add((EventInterface.ContactInterface)new Label(this.iEvent.getContact().hasPhone() ? this.iEvent.getContact().getPhone() : "", false));
            int rowNum2 = this.iContacts.addRow(this.iEvent.getContact(), (List<Widget>)((Object)row));
            for (int col2 = 0; col2 < this.iContacts.getCellCount(rowNum2); ++col2) {
                this.iContacts.getCellFormatter().addStyleName(rowNum2, col2, "main-contact");
            }
        }
        if (this.iEvent.hasAdditionalContacts()) {
            for (EventInterface.ContactInterface contact : this.iEvent.getAdditionalContacts()) {
                ArrayList<Label> row = new ArrayList<Label>();
                row.add(new Label(contact.getName(MESSAGES), false));
                row.add(new Label(contact.hasEmail() ? contact.getEmail() : "", false));
                row.add(new Label(contact.hasPhone() ? contact.getPhone() : "", false));
                rowNum = this.iContacts.addRow(contact, row);
                for (col = 0; col < this.iContacts.getCellCount(rowNum); ++col) {
                    this.iContacts.getCellFormatter().addStyleName(rowNum, col, "additional-contact");
                }
            }
        }
        if (this.iEvent.hasInstructors()) {
            for (EventInterface.ContactInterface contact : this.iEvent.getInstructors()) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Label(contact.getName(MESSAGES), false));
                row.add(new Label(contact.hasEmail() ? contact.getEmail() : "", false));
                row.add(new HTML(contact.hasPhone() ? contact.getPhone() : MESSAGES.eventContactInstructorPhone(), false));
                rowNum = this.iContacts.addRow(contact, row);
                for (col = 0; col < this.iContacts.getCellCount(rowNum); ++col) {
                    this.iContacts.getCellFormatter().addStyleName(rowNum, col, "instructor-contact");
                }
            }
        }
        if (this.iEvent.hasCoordinators()) {
            for (EventInterface.ContactInterface contact : this.iEvent.getCoordinators()) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Label(contact.getName(MESSAGES), false));
                row.add(new Label(contact.hasEmail() ? contact.getEmail() : "", false));
                row.add(new HTML(contact.hasPhone() ? contact.getPhone() : MESSAGES.eventContactCoordinatorPhone(), false));
                rowNum = this.iContacts.addRow(contact, row);
                for (col = 0; col < this.iContacts.getCellCount(rowNum); ++col) {
                    this.iContacts.getCellFormatter().addStyleName(rowNum, col, "coordinator-contact");
                }
            }
        }
        if (this.iContacts.getRowCount() > 1) {
            this.iForm.addRow(MESSAGES.propContacts(), (Widget)this.iContacts);
        }
        if (this.iEvent.hasEmail()) {
            this.iForm.addRow(MESSAGES.propAdditionalEmails(), (Widget)new Label(this.iEvent.getEmail()));
        }
        if (this.iEvent.hasSponsor()) {
            this.iForm.addRow(MESSAGES.propSponsor(), (Widget)new Label(this.iEvent.getSponsor().getName()));
        }
        if (this.iEvent.hasEnrollment()) {
            this.iForm.addRow(MESSAGES.propEnrollment(), (Widget)new Label(String.valueOf(this.iEvent.getEnrollment().toString())));
            int r = this.iForm.addRow(MESSAGES.propStudentConflicts(), (Widget)new Label(""));
            this.iForm.getRowFormatter().setVisible(r, false);
        }
        if (this.iEvent.hasMaxCapacity()) {
            this.iForm.addRow(MESSAGES.propAttendance(), (Widget)new Label(this.iEvent.getMaxCapacity().toString()));
        }
        if (this.iEvent.hasExpirationDate() && this.iEvent.hasPendingMeetings()) {
            this.iForm.addRow(MESSAGES.propExpirationDate(), (Widget)new Label(sEventDateFormat.format(this.iEvent.getExpirationDate())));
        }
        if (this.iEvent.hasLastChange()) {
            this.iForm.addRow(MESSAGES.propLastChange(), (Widget)new Label(this.iEvent.getLastChange()));
        }
        this.iMeetings.clearTable(1);
        this.iMeetings.resetColumnVisibility();
        for (EventInterface.MeetingInterface meeting : this.iEvent.getMeetings()) {
            this.iMeetings.add(new EventMeetingTable.EventMeetingRow(this.iEvent, meeting));
        }
        if (this.iMeetings.getRowCount() > 1) {
            UniTimeHeaderPanel header = new UniTimeHeaderPanel(MESSAGES.sectMeetings());
            header.addButton("operations", MESSAGES.buttonMoreOperations(), 75, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    PopupPanel popup = new PopupPanel(true);
                    EventDetail.this.iMeetings.getHeader(0).setMenu(popup);
                    popup.showRelativeTo((UIObject)event.getSource());
                    ((MenuBar)popup.getWidget()).focus();
                }
            });
            this.iForm.addHeaderRow((Widget)header);
            this.iForm.addRow((Widget)this.iMeetings);
            this.iForm.addRow((Widget)this.iShowDeleted);
            this.iForm.getCellFormatter().setHorizontalAlignment(this.iForm.getRowCount() - 1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            this.iShowDeleted.setValue(Boolean.valueOf(EventCookie.getInstance().isShowDeletedMeetings()), true);
        }
        this.iNotes.clearTable(1);
        if (this.iEvent.hasNotes()) {
            for (EventInterface.NoteInterface note : this.iEvent.getNotes()) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new HTML(note.getDate() == null ? "<i>" + MESSAGES.notApplicable() + "</i>" : sTimeStampFormat.format(note.getDate()), false));
                row.add(new HTML(note.getUser() == null ? "<i>" + MESSAGES.notApplicable() + "</i>" : note.getUser(), false));
                row.add(new HTML(note.getType() == null ? "<i>" + MESSAGES.notApplicable() + "</i>" : note.getType().getName()));
                row.add(new HTML(note.getMeetings() == null ? "<i>" + MESSAGES.notApplicable() + "</i>" : note.getMeetings(), false));
                row.add(new HTML(note.getNote() == null ? "" : note.getNote().replace("\n", "<br>"), true));
                if (note.hasAttachment()) {
                    ImageLink link = new ImageLink(new Image(RESOURCES.download()), note.hasLink() ? GWT.getHostPageBaseURL() + "upload?q=" + note.getLink() : GWT.getHostPageBaseURL() + "upload?event=" + this.iEvent.getId() + (note.getId() == null ? "&name=" + note.getAttachment() : "&note=" + note.getId()));
                    link.setTitle(note.getAttachment());
                    link.setText(note.getAttachment());
                    row.add(link);
                } else {
                    row.add(new HTML(""));
                }
                int r = this.iNotes.addRow(note, row);
                if (note.getType() == null) continue;
                this.iNotes.getRowFormatter().addStyleName(r, note.getType().getName().toLowerCase());
            }
        }
        if (this.iNotes.getRowCount() > 1) {
            this.iForm.addHeaderRow(MESSAGES.sectNotes());
            this.iForm.addRow((Widget)this.iNotes);
        }
        this.iOwners.clearTable(1);
        if (this.iEvent.hasRelatedObjects()) {
            for (EventInterface.RelatedObjectInterface obj : this.iEvent.getRelatedObjects()) {
                ArrayList<Object> row = new ArrayList<Object>();
                String course = "";
                if (obj.hasCourseNames()) {
                    for (String string : obj.getCourseNames()) {
                        if (course.isEmpty()) {
                            course = course + string;
                            continue;
                        }
                        course = course + "<span class='cross-list'>" + string + "</span>";
                    }
                } else {
                    course = obj.getName();
                }
                row.add(new HTML(course, false));
                String section = "";
                if (obj.hasExternalIds()) {
                    for (String ex : obj.getExternalIds()) {
                        if (section.isEmpty()) {
                            section = section + ex;
                            continue;
                        }
                        section = section + "<span class='cross-list'>" + ex + "</span>";
                    }
                } else if (obj.hasSectionNumber()) {
                    section = obj.getSectionNumber();
                }
                row.add(new HTML(section, false));
                String string = obj.hasInstruction() ? obj.getInstruction() : obj.getType().name();
                row.add(new Label(string, false));
                String title = "";
                if (obj.hasCourseTitles()) {
                    String last = null;
                    for (String ct : obj.getCourseTitles()) {
                        if (last != null && !last.isEmpty() && last.equals(ct)) {
                            ct = "";
                        } else {
                            last = ct;
                        }
                        if (title.isEmpty()) {
                            title = title + ct;
                            continue;
                        }
                        title = title + "<span class='cross-list'>" + ct + "</span>";
                    }
                } else {
                    title = "";
                }
                row.add(new HTML(title, false));
                if (obj.hasDate()) {
                    row.add(new Label(obj.getDate(), false));
                } else {
                    row.add(new Label());
                }
                if (obj.hasTime()) {
                    row.add(new Label(obj.getTime(), false));
                } else {
                    row.add(new Label());
                }
                String location = "";
                if (obj.hasLocations()) {
                    for (EventInterface.ResourceInterface loc : obj.getLocations()) {
                        location = location + (location.isEmpty() ? "" : "<br>") + loc.getName();
                    }
                }
                row.add(new HTML(location, false));
                if (obj.hasInstructors()) {
                    row.add(new HTML(obj.getInstructorNames("<br>", MESSAGES), false));
                } else {
                    row.add(new HTML());
                }
                if (obj.hasNote()) {
                    P note = new P("note");
                    note.setHTML(obj.getNote().replace("\n", "<br>"));
                    note.setTitle(obj.getNote());
                    row.add((Object)note);
                } else {
                    row.add(new HTML());
                }
                int rowNumber = this.iOwners.addRow(obj, row);
                this.iOwners.getRowFormatter().addStyleName(rowNumber, "owner-row");
                for (int i = 0; i < this.iOwners.getCellCount(rowNumber); ++i) {
                    this.iOwners.getCellFormatter().addStyleName(rowNumber, i, "owner-cell");
                }
            }
        }
        if (this.iOwners.getRowCount() > 1) {
            this.iForm.addHeaderRow(MESSAGES.sectRelations());
            this.iForm.addRow((Widget)this.iOwners);
        }
        this.iEnrollments.clear();
        if (this.iEvent.hasEnrollment()) {
            final int enrollmentsRow = this.iForm.addHeaderRow((Widget)this.iEnrollmentHeader);
            this.iForm.addRow((Widget)this.iEnrollments.getTable());
            this.iEnrollmentHeader.showLoading();
            final Long eventId = this.iEvent.getId();
            RPC.execute(EventInterface.EventEnrollmentsRpcRequest.getEnrollmentsForEvent(eventId, this.iProperties.getSessionId()), new AsyncCallback<GwtRpcResponseList<ClassAssignmentInterface.Enrollment>>(){

                public void onFailure(Throwable caught) {
                    if (eventId.equals(EventDetail.this.iEvent.getId())) {
                        EventDetail.this.iEnrollmentHeader.clearMessage();
                        UniTimeNotifications.error(MESSAGES.failedNoEnrollments(caught.getMessage()), caught);
                        EventDetail.this.iForm.getRowFormatter().setVisible(enrollmentsRow, false);
                        EventDetail.this.iForm.getRowFormatter().setVisible(enrollmentsRow + 1, false);
                    }
                }

                public void onSuccess(GwtRpcResponseList<ClassAssignmentInterface.Enrollment> result) {
                    if (eventId.equals(EventDetail.this.iEvent.getId())) {
                        if (result == null) {
                            result = new GwtRpcResponseList();
                        }
                        EventDetail.this.iEnrollmentHeader.clearMessage();
                        EventDetail.this.iEnrollments.clear();
                        EventDetail.this.iEnrollments.populate(result, null);
                        int conf = 0;
                        for (ClassAssignmentInterface.Enrollment e : result) {
                            if (!e.hasConflict()) continue;
                            ++conf;
                        }
                        if (conf != 0) {
                            int row = EventDetail.this.iForm.getRow(MESSAGES.propStudentConflicts());
                            ((Label)EventDetail.this.iForm.getWidget(row, 1)).setText(String.valueOf(conf));
                            EventDetail.this.iForm.getRowFormatter().setVisible(row, true);
                        }
                    }
                }
            });
        }
        this.iForm.addNotPrintableBottomRow((Widget)this.iFooter);
    }

    public EventInterface getEvent() {
        return this.iEvent;
    }
}

