/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.curricula.CurriculaCourses;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassificationsEdit
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private final CurriculaServiceAsync iService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iHeaderPanel = null;
    private UniTimeTable<CurriculumInterface> iTable;
    private List<EditFinishedHandler> iEditFinishedHandlers = new ArrayList<EditFinishedHandler>();

    public ClassificationsEdit() {
        this.iPanel = new SimpleForm();
        ClickHandler save = new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoadingWidget.getInstance().show(MESSAGES.waitSavingData());
                ClassificationsEdit.this.iService.saveClassifications(ClassificationsEdit.this.iTable.getData(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        ClassificationsEdit.this.iHeaderPanel.setErrorMessage(MESSAGES.failedToSaveCurricula(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedToSaveCurricula(caught.getMessage()), caught);
                    }

                    public void onSuccess(Boolean result) {
                        LoadingWidget.getInstance().hide();
                        ClassificationsEdit.this.iHeaderPanel.clearMessage();
                        EditFinishedEvent e = new EditFinishedEvent();
                        for (EditFinishedHandler h : ClassificationsEdit.this.iEditFinishedHandlers) {
                            h.onSave(e);
                        }
                    }
                });
            }
        };
        ClickHandler back = new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditFinishedEvent e = new EditFinishedEvent();
                for (EditFinishedHandler h : ClassificationsEdit.this.iEditFinishedHandlers) {
                    h.onBack(e);
                }
            }
        };
        ClickHandler print = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.print();
            }
        };
        this.iHeaderPanel = new UniTimeHeaderPanel();
        this.iHeaderPanel.addButton("save", MESSAGES.buttonSave(), 75, save);
        this.iHeaderPanel.addButton("back", MESSAGES.buttonBack(), 75, back);
        this.iHeaderPanel.addButton("print", MESSAGES.buttonPrint(), 75, print);
        this.iPanel.addHeaderRow((Widget)this.iHeaderPanel);
        this.iTable = new UniTimeTable();
        this.iPanel.addRow((Widget)this.iTable);
        this.iPanel.addNotPrintableBottomRow((Widget)this.iHeaderPanel.clonePanel());
        this.initWidget((Widget)this.iPanel);
    }

    public void updateAll() {
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            for (int col = 1; col < this.iTable.getCellCount(row); ++col) {
                Widget w = this.iTable.getWidget(row, col);
                if (w == null) continue;
                ((Updatable)w).update();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setData(List<CurriculumInterface> curricula) {
        void var11_19;
        void var11_17;
        this.iTable.clearTable();
        final TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications = new TreeSet<CurriculumInterface.AcademicClassificationInterface>();
        for (CurriculumInterface curriculum : curricula) {
            if (!curriculum.hasClassifications()) continue;
            for (CurriculumInterface.CurriculumClassificationInterface clasf : curriculum.getClassifications()) {
                academicClassifications.add(clasf.getAcademicClassification());
            }
        }
        final ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        ArrayList<UniTimeTableHeader.Operation> operations = new ArrayList<UniTimeTableHeader.Operation>();
        for (final CurriculaCourses.Mode m : CurriculaCourses.Mode.values()) {
            operations.add(new UniTimeTableHeader.Operation(){

                public void execute() {
                    CurriculumCookie.getInstance().setCurriculaCoursesMode(m);
                    int c = 1;
                    for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
                        ((UniTimeTableHeader)header.get(c++)).setText(clasf.getCode() + (m == CurriculaCourses.Mode.NONE ? "" : " " + MESSAGES.abbvRequestedEnrollment() + " / " + m.getAbbv()));
                    }
                    ((UniTimeTableHeader)header.get(c)).setText(m == CurriculaCourses.Mode.NONE ? MESSAGES.colTotal() : MESSAGES.colTotalOf(MESSAGES.abbvRequestedEnrollment() + " / " + m.getAbbv()));
                    ClassificationsEdit.this.updateAll();
                }

                public boolean isApplicable() {
                    return CurriculumCookie.getInstance().getCurriculaCoursesMode() != m;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return m == CurriculaCourses.Mode.NONE ? MESSAGES.opHide(CurriculumCookie.getInstance().getCurriculaCoursesMode().getName()) : MESSAGES.opShow(m.getName());
                }
            });
        }
        operations.add(new UniTimeTableHeader.Operation(){

            public void execute() {
                if (ClassificationsEdit.this.hasEmptyColumns()) {
                    ClassificationsEdit.this.hideEmptyColumns();
                } else {
                    ClassificationsEdit.this.showAllColumns();
                }
            }

            public boolean isApplicable() {
                return ClassificationsEdit.this.hasEmptyColumns() || ClassificationsEdit.this.hasHiddenColumn();
            }

            public boolean hasSeparator() {
                return true;
            }

            public String getName() {
                return ClassificationsEdit.this.hasEmptyColumns() ? MESSAGES.opHideEmptyClassifications() : MESSAGES.opShowAllClassifications();
            }
        });
        final UniTimeTableHeader hCurriculum = new UniTimeTableHeader(MESSAGES.colCurriculum());
        header.add(hCurriculum);
        hCurriculum.getOperations().addAll(operations);
        hCurriculum.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                ClassificationsEdit.this.iTable.sort(hCurriculum, new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        return a.compareTo(b);
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return true;
            }

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colCurriculum());
            }
        });
        CurriculaCourses.Mode m = CurriculumCookie.getInstance().getCurriculaCoursesMode();
        for (final CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
            final UniTimeTableHeader hClasf = new UniTimeTableHeader(clasf.getCode() + (m == CurriculaCourses.Mode.NONE ? "" : " " + MESSAGES.abbvRequestedEnrollment() + " / " + m.getAbbv()), HasHorizontalAlignment.ALIGN_CENTER);
            header.add(hClasf);
            hClasf.getOperations().addAll(operations);
            hClasf.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    ClassificationsEdit.this.iTable.sort(hClasf, new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            int t2;
                            CurriculumInterface.CurriculumClassificationInterface f = null;
                            CurriculumInterface.CurriculumClassificationInterface g = null;
                            for (CurriculumInterface.CurriculumClassificationInterface c : a.getClassifications()) {
                                if (!c.getAcademicClassification().equals(clasf)) continue;
                                f = c;
                                break;
                            }
                            for (CurriculumInterface.CurriculumClassificationInterface c : b.getClassifications()) {
                                if (!c.getAcademicClassification().equals(clasf)) continue;
                                g = c;
                                break;
                            }
                            int t1 = f.getExpected() == null ? 0 : f.getExpected();
                            int n = t2 = g.getExpected() == null ? 0 : g.getExpected();
                            if (t2 > t1) {
                                return 1;
                            }
                            if (t1 > t2) {
                                return -1;
                            }
                            return a.compareTo(b);
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.opSortBy(clasf.getCode() + " " + MESSAGES.fieldRequestedEnrollment());
                }
            });
            hClasf.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    ClassificationsEdit.this.iTable.sort(hClasf, new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            CurriculumInterface.CurriculumClassificationInterface f = null;
                            CurriculumInterface.CurriculumClassificationInterface g = null;
                            for (CurriculumInterface.CurriculumClassificationInterface c : a.getClassifications()) {
                                if (!c.getAcademicClassification().equals(clasf)) continue;
                                f = c;
                                break;
                            }
                            for (CurriculumInterface.CurriculumClassificationInterface c : b.getClassifications()) {
                                if (!c.getAcademicClassification().equals(clasf)) continue;
                                g = c;
                                break;
                            }
                            int t1 = 0;
                            int t2 = 0;
                            switch (CurriculumCookie.getInstance().getCurriculaCoursesMode()) {
                                case ENRL: {
                                    t1 = f.getEnrollment() == null ? 0 : f.getEnrollment();
                                    t2 = g.getEnrollment() == null ? 0 : g.getEnrollment();
                                    break;
                                }
                                case LAST: {
                                    t1 = f.getLastLike() == null ? 0 : f.getLastLike();
                                    t2 = g.getLastLike() == null ? 0 : g.getLastLike();
                                    break;
                                }
                                case PROJ: {
                                    t1 = f.getProjection() == null ? 0 : f.getProjection();
                                    t2 = g.getProjection() == null ? 0 : g.getProjection();
                                    break;
                                }
                                case REQ: {
                                    t1 = f.getRequested() == null ? 0 : f.getRequested();
                                    int n = t2 = g.getRequested() == null ? 0 : g.getRequested();
                                }
                            }
                            if (t2 > t1) {
                                return 1;
                            }
                            if (t1 > t2) {
                                return -1;
                            }
                            return a.compareTo(b);
                        }
                    });
                }

                public boolean isApplicable() {
                    return CurriculumCookie.getInstance().getCurriculaCoursesMode() != CurriculaCourses.Mode.NONE;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opSortBy(clasf.getCode() + " " + CurriculumCookie.getInstance().getCurriculaCoursesMode().getName());
                }
            });
        }
        final UniTimeTableHeader hTotal = new UniTimeTableHeader(m == CurriculaCourses.Mode.NONE ? MESSAGES.colTotal() : MESSAGES.colTotalOf(MESSAGES.abbvRequestedEnrollment() + " / " + m.getAbbv()), HasHorizontalAlignment.ALIGN_CENTER);
        header.add(hTotal);
        hTotal.getOperations().addAll(operations);
        hTotal.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                ClassificationsEdit.this.iTable.sort(hTotal, new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        int t1 = 0;
                        int t2 = 0;
                        for (CurriculumInterface.CurriculumClassificationInterface clasf : a.getClassifications()) {
                            if (clasf.getExpected() == null) continue;
                            t1 += clasf.getExpected().intValue();
                        }
                        for (CurriculumInterface.CurriculumClassificationInterface clasf : b.getClassifications()) {
                            if (clasf.getExpected() == null) continue;
                            t2 += clasf.getExpected().intValue();
                        }
                        if (t2 > t1) {
                            return 1;
                        }
                        if (t1 > t2) {
                            return -1;
                        }
                        return a.compareTo(b);
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return true;
            }

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colTotalOf(MESSAGES.fieldRequestedEnrollment()));
            }
        });
        hTotal.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                ClassificationsEdit.this.iTable.sort(hTotal, new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        int t1 = 0;
                        int t2 = 0;
                        switch (CurriculumCookie.getInstance().getCurriculaCoursesMode()) {
                            case ENRL: {
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : a.getClassifications()) {
                                    if (clasf.getEnrollment() == null) continue;
                                    t1 += clasf.getEnrollment().intValue();
                                }
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : b.getClassifications()) {
                                    if (clasf.getEnrollment() == null) continue;
                                    t2 += clasf.getEnrollment().intValue();
                                }
                                break;
                            }
                            case LAST: {
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : a.getClassifications()) {
                                    if (clasf.getLastLike() == null) continue;
                                    t1 += clasf.getLastLike().intValue();
                                }
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : b.getClassifications()) {
                                    if (clasf.getLastLike() == null) continue;
                                    t2 += clasf.getLastLike().intValue();
                                }
                                break;
                            }
                            case PROJ: {
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : a.getClassifications()) {
                                    if (clasf.getProjection() == null) continue;
                                    t1 += clasf.getProjection().intValue();
                                }
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : b.getClassifications()) {
                                    if (clasf.getProjection() == null) continue;
                                    t2 += clasf.getProjection().intValue();
                                }
                                break;
                            }
                            case REQ: {
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : a.getClassifications()) {
                                    if (clasf.getRequested() == null) continue;
                                    t1 += clasf.getRequested().intValue();
                                }
                                for (CurriculumInterface.CurriculumClassificationInterface clasf : b.getClassifications()) {
                                    if (clasf.getRequested() == null) continue;
                                    t2 += clasf.getRequested().intValue();
                                }
                                break;
                            }
                        }
                        if (t2 > t1) {
                            return 1;
                        }
                        if (t1 > t2) {
                            return -1;
                        }
                        return a.compareTo(b);
                    }
                });
            }

            public boolean isApplicable() {
                return CurriculumCookie.getInstance().getCurriculaCoursesMode() != CurriculaCourses.Mode.NONE;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colTotalOf(CurriculumCookie.getInstance().getCurriculaCoursesMode().getName()));
            }
        });
        this.iTable.addRow(null, header);
        ArrayList<MyCell> allCells = new ArrayList<MyCell>();
        HashMap<CurriculumInterface.AcademicClassificationInterface, ArrayList<MyCell>> clasf2cells = new HashMap<CurriculumInterface.AcademicClassificationInterface, ArrayList<MyCell>>();
        for (CurriculumInterface curriculumInterface : curricula) {
            ArrayList<Object> line = new ArrayList<Object>();
            ArrayList<MyCell> cells = new ArrayList<MyCell>();
            line.add(new Label(curriculumInterface.getAbbv(), false));
            for (CurriculumInterface.AcademicClassificationInterface acadClasf : academicClassifications) {
                CurriculumInterface.CurriculumClassificationInterface clasf = null;
                if (curriculumInterface.hasClassifications()) {
                    for (CurriculumInterface.CurriculumClassificationInterface c : curriculumInterface.getClassifications()) {
                        if (!c.getAcademicClassification().equals(acadClasf)) continue;
                        clasf = c;
                        break;
                    }
                }
                if (clasf == null) {
                    clasf = new CurriculumInterface.CurriculumClassificationInterface();
                    clasf.setAcademicClassification(acadClasf);
                    curriculumInterface.addClassification(clasf);
                }
                MyCell c = new MyCell(curriculumInterface, clasf);
                cells.add(c);
                allCells.add(c);
                ArrayList<MyCell> cellsThisClasf = (ArrayList<MyCell>)clasf2cells.get(acadClasf);
                if (cellsThisClasf == null) {
                    cellsThisClasf = new ArrayList<MyCell>();
                    clasf2cells.put(acadClasf, cellsThisClasf);
                }
                cellsThisClasf.add(c);
                line.add(c);
            }
            line.add(new MySumCell(cells));
            this.iTable.addRow(curriculumInterface, line);
        }
        ArrayList<Object> totals = new ArrayList<Object>();
        totals.add(new Label("Total", false));
        for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
            totals.add(new MySumCell((List)clasf2cells.get(clasf)));
        }
        totals.add(new MySumCell(allCells));
        this.iTable.addRow(null, totals);
        boolean bl = true;
        while (var11_17 < this.iTable.getRowCount() - 1) {
            this.iTable.getCellFormatter().getElement((int)var11_17, this.iTable.getCellCount((int)var11_17) - 1).getStyle().setBackgroundColor("#EEEEEE");
            ++var11_17;
        }
        boolean bl2 = false;
        while (var11_19 < this.iTable.getCellCount(this.iTable.getRowCount() - 1)) {
            this.iTable.getCellFormatter().getElement(this.iTable.getRowCount() - 1, (int)var11_19).getStyle().setBackgroundColor("#EEEEEE");
            ++var11_19;
        }
        this.iTable.addMouseOverListener(new UniTimeTable.MouseOverListener<CurriculumInterface>(){

            @Override
            public void onMouseOver(UniTimeTable.TableEvent<CurriculumInterface> event) {
                ClassificationsEdit.this.iTable.getCellFormatter().getElement(event.getRow(), ClassificationsEdit.this.iTable.getCellCount(event.getRow()) - 1).getStyle().clearBackgroundColor();
            }
        });
        this.iTable.addMouseOutListener(new UniTimeTable.MouseOutListener<CurriculumInterface>(){

            @Override
            public void onMouseOut(UniTimeTable.TableEvent<CurriculumInterface> event) {
                ClassificationsEdit.this.iTable.getCellFormatter().getElement(event.getRow(), ClassificationsEdit.this.iTable.getCellCount(event.getRow()) - 1).getStyle().setBackgroundColor("#EEEEEE");
            }
        });
        this.iTable.addDataChangedListener(new UniTimeTable.DataChangedListener<CurriculumInterface>(){

            @Override
            public void onDataInserted(UniTimeTable.DataChangedEvent<CurriculumInterface> event) {
            }

            @Override
            public void onDataMoved(List<UniTimeTable.DataChangedEvent<CurriculumInterface>> events) {
                for (UniTimeTable.DataChangedEvent<CurriculumInterface> event : events) {
                    ClassificationsEdit.this.iTable.getCellFormatter().getElement(event.getRow(), ClassificationsEdit.this.iTable.getCellCount(event.getRow()) - 1).getStyle().setBackgroundColor("#EEEEEE");
                }
            }

            @Override
            public void onDataRemoved(UniTimeTable.DataChangedEvent<CurriculumInterface> event) {
            }

            @Override
            public void onDataSorted(List<UniTimeTable.DataChangedEvent<CurriculumInterface>> event) {
            }
        });
        this.iHeaderPanel.setVisible(true);
        this.iTable.setVisible(true);
        this.hideEmptyColumns();
    }

    public boolean hasHiddenColumn() {
        for (int c = 1; c < this.iTable.getCellCount(0) - 1; ++c) {
            if (this.iTable.isColumnVisible(c)) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnEmpty(int col) {
        for (int r = 1; r < this.iTable.getRowCount() - 1; ++r) {
            if (((MyCell)this.iTable.getWidget(r, col)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptyColumns() {
        for (int c = 1; c < this.iTable.getCellCount(0) - 1; ++c) {
            if (!this.iTable.isColumnVisible(c) || !this.isColumnEmpty(c)) continue;
            return true;
        }
        return false;
    }

    public void hideEmptyColumns() {
        for (int c = 1; c < this.iTable.getCellCount(0) - 1; ++c) {
            this.iTable.setColumnVisible(c, !this.isColumnEmpty(c));
        }
    }

    public void showAllColumns() {
        for (int c = 1; c < this.iTable.getCellCount(0) - 1; ++c) {
            this.iTable.setColumnVisible(c, true);
        }
    }

    public void addEditFinishedHandler(EditFinishedHandler h) {
        this.iEditFinishedHandlers.add(h);
    }

    public static interface EditFinishedHandler {
        public void onBack(EditFinishedEvent var1);

        public void onSave(EditFinishedEvent var1);
    }

    public static class EditFinishedEvent {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MySumCell
    extends Composite
    implements Updatable {
        private HTML iTextBox;
        private HTML iRearLabel;
        private HorizontalPanel iPanel;
        private List<MyCell> iCells = new ArrayList<MyCell>();

        public MySumCell(List<MyCell> cells) {
            this.iCells = cells;
            for (MyCell cell : this.iCells) {
                cell.iSums.add(this);
            }
            this.iPanel = new HorizontalPanel();
            this.iTextBox = new HTML("", false);
            this.iTextBox.setWidth("60px");
            this.iTextBox.setStyleName("unitime-Label");
            this.iTextBox.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iRearLabel = new HTML("", false);
            this.iRearLabel.setWidth("55px");
            this.iRearLabel.setStyleName("unitime-Label");
            this.iRearLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iPanel.add((Widget)this.iTextBox);
            this.iPanel.setCellVerticalAlignment((Widget)this.iTextBox, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iPanel.add((Widget)this.iRearLabel);
            this.iPanel.setCellVerticalAlignment((Widget)this.iRearLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.initWidget((Widget)this.iPanel);
            this.update();
        }

        public int sumExpected() {
            int ret = 0;
            for (MyCell c : this.iCells) {
                if (c.getClassification().getExpected() == null) continue;
                ret += c.getClassification().getExpected().intValue();
            }
            return ret;
        }

        public int sumEnrollment() {
            int ret = 0;
            for (MyCell c : this.iCells) {
                if (c.getClassification().getEnrollment() == null) continue;
                ret += c.getClassification().getEnrollment().intValue();
            }
            return ret;
        }

        public int sumLastLike() {
            int ret = 0;
            for (MyCell c : this.iCells) {
                if (c.getClassification().getLastLike() == null) continue;
                ret += c.getClassification().getLastLike().intValue();
            }
            return ret;
        }

        public int sumProjection() {
            int ret = 0;
            for (MyCell c : this.iCells) {
                if (c.getClassification().getProjection() == null) continue;
                ret += c.getClassification().getProjection().intValue();
            }
            return ret;
        }

        public int sumRequested() {
            int ret = 0;
            for (MyCell c : this.iCells) {
                if (c.getClassification().getRequested() == null) continue;
                ret += c.getClassification().getRequested().intValue();
            }
            return ret;
        }

        @Override
        public void update() {
            this.iTextBox.setHTML(this.sumExpected() == 0 ? "" : String.valueOf(this.sumExpected()));
            switch (CurriculumCookie.getInstance().getCurriculaCoursesMode()) {
                case NONE: {
                    this.iRearLabel.setHTML("");
                    this.iRearLabel.setVisible(false);
                    break;
                }
                case ENRL: {
                    this.iRearLabel.setHTML(this.sumEnrollment() == 0 ? "" : String.valueOf(this.sumEnrollment()));
                    this.iRearLabel.setVisible(true);
                    break;
                }
                case LAST: {
                    this.iRearLabel.setHTML(this.sumLastLike() == 0 ? "" : String.valueOf(this.sumLastLike()));
                    this.iRearLabel.setVisible(true);
                    break;
                }
                case PROJ: {
                    this.iRearLabel.setHTML(this.sumProjection() == 0 ? "" : String.valueOf(this.sumProjection()));
                    this.iRearLabel.setVisible(true);
                    break;
                }
                case REQ: {
                    this.iRearLabel.setHTML(this.sumRequested() == 0 ? "" : String.valueOf(this.sumRequested()));
                    this.iRearLabel.setVisible(true);
                }
            }
        }
    }

    private class MyCell
    extends Composite
    implements Updatable,
    UniTimeTable.HasFocus,
    UniTimeTable.HasHint {
        private CurriculumInterface iCurriculum;
        private CurriculumInterface.CurriculumClassificationInterface iClasf;
        private TextBox iTextBox;
        private HTML iRearLabel;
        private HorizontalPanel iPanel;
        private List<MySumCell> iSums = new ArrayList<MySumCell>();

        public MyCell(CurriculumInterface curriculum, CurriculumInterface.CurriculumClassificationInterface classification) {
            this.iCurriculum = curriculum;
            this.iClasf = classification;
            this.iPanel = new HorizontalPanel();
            this.iTextBox = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT);
            this.iTextBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    try {
                        if (MyCell.this.iTextBox.getText().isEmpty()) {
                            MyCell.this.iClasf.setExpected(null);
                        } else {
                            MyCell.this.iClasf.setExpected(Integer.valueOf(MyCell.this.iTextBox.getText()));
                        }
                    }
                    catch (Exception e) {
                        MyCell.this.iClasf.setExpected(null);
                    }
                    MyCell.this.update();
                    for (MySumCell sum : MyCell.this.iSums) {
                        sum.update();
                    }
                }
            });
            this.iRearLabel = new HTML("", false);
            this.iRearLabel.setWidth("50px");
            this.iRearLabel.setStyleName("unitime-Label");
            this.iRearLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iPanel.add((Widget)this.iTextBox);
            this.iPanel.setCellVerticalAlignment((Widget)this.iTextBox, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iPanel.add((Widget)this.iRearLabel);
            this.iPanel.setCellVerticalAlignment((Widget)this.iRearLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.initWidget((Widget)this.iPanel);
            this.update();
        }

        public String getHint() {
            return MESSAGES.propCurriculum() + " " + this.iCurriculum.getAbbv() + " - " + this.iCurriculum.getName() + "<br>" + MESSAGES.propAcademicArea() + " " + this.iCurriculum.getAcademicArea().getAbbv() + " - " + this.iCurriculum.getAcademicArea().getName() + "<br>" + (this.iCurriculum.hasMajors() ? MESSAGES.propMajor() + " " + this.iCurriculum.getCodeMajorNames(", ") + "<br>" : "") + MESSAGES.propAcademicClassification() + " " + (this.iClasf.getName() != null ? this.iClasf.getName() : this.iClasf.getAcademicClassification().getCode()) + " - " + this.iClasf.getAcademicClassification().getName();
        }

        public void update() {
            this.iTextBox.setText(this.iClasf.getExpected().toString());
            switch (CurriculumCookie.getInstance().getCurriculaCoursesMode()) {
                case NONE: {
                    this.iRearLabel.setHTML("");
                    this.iRearLabel.setVisible(false);
                    break;
                }
                case ENRL: {
                    if (this.iClasf.getEnrollment() == null || this.iClasf.getEnrollment() == 0) {
                        this.iRearLabel.setHTML("");
                    } else {
                        this.iRearLabel.setHTML(this.iClasf.getEnrollment().toString());
                    }
                    this.iRearLabel.setVisible(true);
                    break;
                }
                case LAST: {
                    if (this.iClasf.getLastLike() == null || this.iClasf.getLastLike() == 0) {
                        this.iRearLabel.setHTML("");
                    } else {
                        this.iRearLabel.setHTML(this.iClasf.getLastLike().toString());
                    }
                    this.iRearLabel.setVisible(true);
                    break;
                }
                case PROJ: {
                    if (this.iClasf.getProjection() == null || this.iClasf.getProjection() == 0) {
                        this.iRearLabel.setHTML("");
                    } else {
                        this.iRearLabel.setHTML(this.iClasf.getProjection().toString());
                    }
                    this.iRearLabel.setVisible(true);
                    break;
                }
                case REQ: {
                    if (this.iClasf.getRequested() == null || this.iClasf.getRequested() == 0) {
                        this.iRearLabel.setHTML("");
                    } else {
                        this.iRearLabel.setHTML(this.iClasf.getRequested().toString());
                    }
                    this.iRearLabel.setVisible(true);
                }
            }
        }

        public CurriculumInterface.CurriculumClassificationInterface getClassification() {
            return this.iClasf;
        }

        public boolean isEmpty() {
            return this.iTextBox.getText().isEmpty() && (!this.iRearLabel.isVisible() || this.iRearLabel.getHTML().isEmpty());
        }

        public boolean focus() {
            this.iTextBox.setFocus(true);
            this.iTextBox.selectAll();
            return true;
        }
    }

    private static interface Updatable {
        public void update();
    }
}

