/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;

public class BuildingEditForm
extends ActionForm {
    private static final long serialVersionUID = -4104780400760573687L;
    private Long iUniqueId = null;
    private Long iSessionId = null;
    private String iOp = null;
    private String iExternalId = null;
    private String iName = null;
    private String iAbbreviation = null;
    private String iCoordX = null;
    private String iCoordY = null;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors;
        block12: {
            if (this.iSessionId == null || this.iSessionId <= 0L) {
                SessionContext context = HttpSessionContext.getSessionContext(request.getSession().getServletContext());
                this.iSessionId = context.isAuthenticated() ? context.getUser().getCurrentAcademicSessionId() : null;
            }
            errors = new ActionErrors();
            try {
                Building building;
                if (this.iName == null || this.iName.trim().length() == 0) {
                    errors.add("name", new ActionMessage("errors.required", (Object)""));
                } else {
                    try {
                        building = Building.findByName(this.iName, this.iSessionId);
                        if (building != null && !building.getUniqueId().equals(this.iUniqueId)) {
                            errors.add("name", new ActionMessage("errors.exists", (Object)this.iName));
                        }
                    }
                    catch (Exception e) {
                        errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
                    }
                }
                if (this.iAbbreviation == null || this.iAbbreviation.trim().length() == 0) {
                    errors.add("abbreviation", new ActionMessage("errors.required", (Object)""));
                    break block12;
                }
                try {
                    building = Building.findByBldgAbbv(this.iAbbreviation, this.iSessionId);
                    if (building != null && !building.getUniqueId().equals(this.iUniqueId)) {
                        errors.add("abbreviation", new ActionMessage("errors.exists", (Object)this.iAbbreviation));
                    }
                }
                catch (Exception e) {
                    errors.add("abbreviation", new ActionMessage("errors.generic", (Object)e.getMessage()));
                }
            }
            catch (Exception e) {
                Debug.error(e);
                errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
            }
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iUniqueId = null;
        this.iAbbreviation = null;
        this.iOp = null;
        this.iExternalId = null;
        this.iName = null;
        this.iCoordX = null;
        this.iCoordY = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    public String getCoordX() {
        return this.iCoordX;
    }

    public void setCoordX(String coordX) {
        this.iCoordX = coordX;
    }

    public String getCoordY() {
        return this.iCoordY;
    }

    public void setCoordY(String coordY) {
        this.iCoordY = coordY;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public void load(Building building) {
        this.setOp("Update");
        this.setUniqueId(building.getUniqueId());
        this.setSessionId(building.getSession().getUniqueId());
        this.setExternalId(building.getExternalUniqueId());
        this.setName(building.getName());
        this.setAbbreviation(building.getAbbreviation());
        this.setCoordX(building.getCoordinateX() == null ? null : building.getCoordinateX().toString());
        this.setCoordY(building.getCoordinateY() == null ? null : building.getCoordinateY().toString());
    }
}

