/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.dataexchange.StudentEnrollmentImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.base.BaseStudentAccomodation;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.util.Constants;

public class StudentSectioningImport
extends BaseImport {
    /*
     * Could not resolve type clashes
     */
    public void loadXml(Element rootElement) {
        try {
            Object name;
            this.beginTransaction();
            boolean trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            EnrollmentMode mode = null;
            if (rootElement.attributeValue("enrollments") != null) {
                mode = EnrollmentMode.valueOf(rootElement.attributeValue("enrollments").toUpperCase());
            } else {
                mode = EnrollmentMode.UPDATE;
                if ("true".equals(rootElement.attributeValue("keepEnrollments", "false"))) {
                    mode = EnrollmentMode.NOCHANGE;
                }
                Iterator i = rootElement.elementIterator("student");
                block2: while (i.hasNext()) {
                    Element studentElement = (Element)i.next();
                    Element reqCoursesElement = studentElement.element("updateCourseRequests");
                    if (reqCoursesElement == null || !"true".equals(reqCoursesElement.attributeValue("commit", "true"))) continue;
                    Iterator j = reqCoursesElement.elementIterator("courseOffering");
                    while (j.hasNext()) {
                        Element requestElement = (Element)j.next();
                        if (requestElement.element("class") != null) {
                            mode = EnrollmentMode.IMPORT;
                            break block2;
                        }
                        Iterator k = requestElement.elementIterator("alternative");
                        while (k.hasNext()) {
                            Element altElement = (Element)k.next();
                            if (altElement.element("class") == null) continue;
                            mode = EnrollmentMode.IMPORT;
                            break block2;
                        }
                    }
                }
            }
            this.info("Enrollment mode set to " + mode.name() + ": " + mode.toString());
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Object student : this.getHibSession().createQuery("from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId is not null").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                students.put(((BaseStudent)student).getExternalUniqueId(), (Student)student);
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (Object area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                abbv2area.put(((BaseAcademicArea)area).getAcademicAreaAbbreviation(), (AcademicArea)area);
            }
            Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
            for (Object clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2clasf.put(((BaseAcademicClassification)clasf).getCode(), (AcademicClassification)clasf);
            }
            Hashtable<String, Object> code2major = new Hashtable<String, Object>();
            for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (Object area : ((BasePosMajor)major).getAcademicAreas()) {
                    code2major.put(((BaseAcademicArea)area).getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode(), major);
                }
            }
            Hashtable<String, Object> code2minor = new Hashtable<String, Object>();
            for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                    code2minor.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode(), minor);
                }
            }
            Hashtable<String, StudentGroup> code2group = new Hashtable<String, StudentGroup>();
            for (Object group : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2group.put(((BaseStudentGroup)group).getGroupAbbreviation(), (StudentGroup)group);
            }
            Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
            for (Object accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2accomodation.put(((BaseStudentAccomodation)accomodation).getAbbreviation(), (StudentAccomodation)accomodation);
            }
            Hashtable<String, CourseOffering> name2course = new Hashtable<String, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("from CourseOffering where subjectArea.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                name2course.put(course.getCourseName(), course);
            }
            HashMap course2extId2class = new HashMap();
            HashMap course2name2class = new HashMap();
            this.info("Loading classes...");
            for (Object[] o : this.getHibSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                HashSet<Class_> sameNameClasses;
                String extId;
                HashMap<Element, HashSet<Class_>> name2class;
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                HashMap<String, HashSet<Class_>> extId2class = (HashMap<String, HashSet<Class_>>)course2extId2class.get(course.getUniqueId());
                if (extId2class == null) {
                    extId2class = new HashMap<String, HashSet<Class_>>();
                    course2extId2class.put(course.getUniqueId(), extId2class);
                }
                if ((name2class = (HashMap<Element, HashSet<Class_>>)course2name2class.get(course.getUniqueId())) == null) {
                    name2class = new HashMap<Element, HashSet<Class_>>();
                    course2name2class.put(course.getUniqueId(), name2class);
                }
                if ((extId = clazz.getExternalId(course)) != null && !extId.isEmpty()) {
                    HashSet<Class_> sameExtIdClasses = (HashSet<Class_>)extId2class.get(extId);
                    if (sameExtIdClasses == null) {
                        sameExtIdClasses = new HashSet<Class_>();
                        extId2class.put(extId, sameExtIdClasses);
                    }
                    sameExtIdClasses.add(clazz);
                }
                if ((sameNameClasses = (Set)name2class.get(name = clazz.getSchedulingSubpart().getItypeDesc().trim() + " " + clazz.getSectionNumberString())) == null) {
                    sameNameClasses = new HashSet<Class_>();
                    name2class.put((Element)name, sameNameClasses);
                }
                sameNameClasses.add(clazz);
            }
            HashSet<Long> updatedStudents = new HashSet<Long>();
            Iterator i1 = rootElement.elementIterator("student");
            while (i1.hasNext()) {
                Object email;
                Element studentElement = (Element)i1.next();
                String externalId = studentElement.attributeValue("key");
                if (externalId == null) continue;
                while (trimLeadingZerosFromExternalId && externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
                Element cancelElement = studentElement.element("cancelStudent");
                if (cancelElement != null) {
                    Student student = (Student)students.remove(externalId);
                    if (student == null) continue;
                    Iterator<Serializable> i = student.getCourseDemands().iterator();
                    while (i.hasNext()) {
                        CourseDemand cd = i.next();
                        if (cd.getFreeTime() != null) {
                            this.getHibSession().delete((Object)cd.getFreeTime());
                        }
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            this.getHibSession().delete((Object)cr);
                        }
                        i.remove();
                        this.getHibSession().delete((Object)cd);
                        updatedStudents.add(student.getUniqueId());
                    }
                    i = student.getClassEnrollments().iterator();
                    while (i.hasNext()) {
                        StudentClassEnrollment enrollment = (StudentClassEnrollment)i.next();
                        this.getHibSession().delete((Object)enrollment);
                        i.remove();
                        updatedStudents.add(student.getUniqueId());
                    }
                    boolean delete = "true".equals(cancelElement.attributeValue("delete", "false"));
                    if (delete) {
                        updatedStudents.add(student.getUniqueId());
                        this.getHibSession().delete((Object)student);
                        continue;
                    }
                }
                Element demographicsElement = studentElement.element("updateDemographics");
                Student student = (Student)students.remove(externalId);
                if (student == null) {
                    if (demographicsElement == null) {
                        this.error("Student " + externalId + " not found, but no demographics information provided.");
                        continue;
                    }
                    student = new Student();
                    student.setSession(session);
                    student.setExternalUniqueId(externalId);
                    student.setFreeTimeCategory(0);
                    student.setSchedulePreference(0);
                    student.setClassEnrollments(new HashSet<StudentClassEnrollment>());
                    student.setCourseDemands(new HashSet<CourseDemand>());
                    name = demographicsElement.element("name");
                    if (name != null) {
                        student.setFirstName(name.attributeValue("first"));
                        student.setMiddleName(name.attributeValue("middle"));
                        student.setLastName(name.attributeValue("last"));
                    } else {
                        student.setFirstName("Name");
                        student.setLastName("Unknown");
                    }
                    email = demographicsElement.element("email");
                    if (email != null) {
                        student.setEmail(email.attributeValue("value"));
                    }
                    student.setAcademicAreaClassifications(new HashSet<AcademicAreaClassification>());
                    student.setPosMajors(new HashSet<PosMajor>());
                    student.setPosMinors(new HashSet<PosMinor>());
                    student.setGroups(new HashSet<StudentGroup>());
                    student.setAccomodations(new HashSet<StudentAccomodation>());
                } else if (demographicsElement != null) {
                    name = demographicsElement.element("name");
                    if (name != null) {
                        String fName = name.attributeValue("first");
                        String mName = name.attributeValue("middle");
                        String lName = name.attributeValue("last");
                        if (!this.eq(fName, student.getFirstName())) {
                            student.setFirstName(name.attributeValue("first"));
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(mName, student.getMiddleName())) {
                            student.setMiddleName(mName);
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(lName, student.getLastName())) {
                            student.setLastName(lName);
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    if ((email = demographicsElement.element("email")) != null && !this.eq(email.attributeValue("value"), student.getEmail())) {
                        student.setEmail(email.attributeValue("value"));
                        updatedStudents.add(student.getUniqueId());
                    }
                }
                if (demographicsElement != null) {
                    Object group3;
                    String area;
                    Element f;
                    Iterator i3;
                    String code;
                    Element e;
                    Object minor4;
                    Object area22;
                    Object major2;
                    Hashtable<String, Object> sAreaClasf = new Hashtable<String, Object>();
                    email = student.getAcademicAreaClassifications().iterator();
                    while (email.hasNext()) {
                        AcademicAreaClassification aac = (AcademicAreaClassification)email.next();
                        sAreaClasf.put(aac.getAcademicArea().getAcademicAreaAbbreviation() + ":" + aac.getAcademicClassification().getCode(), aac);
                    }
                    Hashtable<String, Object> sMajors = new Hashtable<String, Object>();
                    for (Object major2 : student.getPosMajors()) {
                        for (Object area22 : ((BasePosMajor)major2).getAcademicAreas()) {
                            sMajors.put(((BaseAcademicArea)area22).getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major2).getCode(), major2);
                        }
                    }
                    Hashtable sMinors = new Hashtable();
                    major2 = student.getPosMinors().iterator();
                    while (major2.hasNext()) {
                        minor4 = (PosMinor)major2.next();
                        area22 = ((BasePosMinor)minor4).getAcademicAreas().iterator();
                        while (area22.hasNext()) {
                            AcademicArea area3 = (AcademicArea)area22.next();
                            sMinors.put(area3.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor4).getCode(), minor4);
                        }
                    }
                    Iterator i2 = demographicsElement.elementIterator("acadArea");
                    while (i2.hasNext()) {
                        String code2;
                        Element f2;
                        e = (Element)i2.next();
                        area22 = e.attributeValue("abbv");
                        String clasf = e.attributeValue("classification");
                        if (sAreaClasf.remove((String)area22 + ":" + clasf) == null) {
                            AcademicAreaClassification aac = new AcademicAreaClassification();
                            if (abbv2area.get(area22) == null) {
                                this.warn("Academic area " + (String)area22 + " not known.");
                                continue;
                            }
                            aac.setAcademicArea((AcademicArea)abbv2area.get(area22));
                            if (code2clasf.get(clasf) == null) {
                                this.warn("Academic classification " + clasf + " not known.");
                                continue;
                            }
                            aac.setAcademicClassification((AcademicClassification)code2clasf.get(clasf));
                            aac.setStudent(student);
                            student.getAcademicAreaClassifications().add(aac);
                            if (student.getUniqueId() != null) {
                                updatedStudents.add(student.getUniqueId());
                            }
                        }
                        Iterator i32 = e.elementIterator("major");
                        while (i32.hasNext()) {
                            f2 = (Element)i32.next();
                            code2 = f2.attributeValue("code");
                            if (sMajors.remove((String)area22 + ":" + code2) != null) continue;
                            PosMajor major3 = (PosMajor)code2major.get((String)area22 + ":" + code2);
                            if (major3 == null) {
                                this.warn("Major " + (String)area22 + " " + code2 + " not known.");
                                continue;
                            }
                            student.getPosMajors().add(major3);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                        i32 = e.elementIterator("minor");
                        while (i32.hasNext()) {
                            f2 = (Element)i32.next();
                            code2 = f2.attributeValue("code");
                            if (sMinors.remove((String)area22 + ":" + code2) != null) continue;
                            PosMinor minor2 = (PosMinor)code2minor.get((String)area22 + ":" + code2);
                            if (minor2 == null) {
                                this.warn("Minor " + (String)area22 + " " + code2 + " not known.");
                                continue;
                            }
                            student.getPosMinors().add(minor2);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    i2 = demographicsElement.elementIterator("major");
                    while (i2.hasNext()) {
                        e = (Element)i2.next();
                        code = e.attributeValue("code");
                        i3 = demographicsElement.elementIterator("acadArea");
                        while (i3.hasNext()) {
                            f = (Element)i3.next();
                            area = f.attributeValue("abbv");
                            PosMajor major4 = (PosMajor)code2major.get(area + ":" + code);
                            if (major4 == null || sMajors.remove(area + ":" + code) != null) continue;
                            student.getPosMajors().add(major4);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    i2 = demographicsElement.elementIterator("minor");
                    while (i2.hasNext()) {
                        e = (Element)i2.next();
                        code = e.attributeValue("code");
                        i3 = demographicsElement.elementIterator("acadArea");
                        while (i3.hasNext()) {
                            f = (Element)i3.next();
                            area = f.attributeValue("abbv");
                            PosMinor minor3 = (PosMinor)code2minor.get(area + ":" + code);
                            if (minor3 == null || sMinors.remove(area + ":" + code) != null) continue;
                            student.getPosMinors().add(minor3);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    for (AcademicAreaClassification aac : sAreaClasf.values()) {
                        student.getAcademicAreaClassifications().remove(aac);
                        this.getHibSession().delete((Object)aac);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (PosMajor major5 : sMajors.values()) {
                        student.getPosMajors().remove(major5);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (Object minor4 : sMinors.values()) {
                        student.getPosMinors().remove(minor4);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    Hashtable<String, StudentGroup> sGroups = new Hashtable<String, StudentGroup>();
                    minor4 = student.getGroups().iterator();
                    while (minor4.hasNext()) {
                        group3 = (StudentGroup)minor4.next();
                        sGroups.put(((BaseStudentGroup)group3).getGroupAbbreviation(), (StudentGroup)group3);
                    }
                    Iterator i22 = demographicsElement.elementIterator("groupAffiliation");
                    while (i22.hasNext()) {
                        Element e2 = (Element)i22.next();
                        String code3 = e2.attributeValue("code");
                        if (sGroups.remove(code3) != null) continue;
                        StudentGroup group2 = (StudentGroup)code2group.get(code3);
                        if (group2 == null) {
                            this.warn("Student group " + code3 + " not known.");
                            continue;
                        }
                        student.getGroups().add(group2);
                        group2.getStudents().add(student);
                        this.getHibSession().saveOrUpdate((Object)group2);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (Object group3 : sGroups.values()) {
                        if (((BaseStudentGroup)group3).getExternalUniqueId() == null) continue;
                        student.getGroups().remove(group3);
                        ((BaseStudentGroup)group3).getStudents().remove(student);
                        this.getHibSession().saveOrUpdate(group3);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    Hashtable<String, StudentAccomodation> sAccomodations = new Hashtable<String, StudentAccomodation>();
                    group3 = student.getAccomodations().iterator();
                    while (group3.hasNext()) {
                        StudentAccomodation accomodation = (StudentAccomodation)group3.next();
                        sAccomodations.put(accomodation.getAbbreviation(), accomodation);
                    }
                    Iterator i23 = demographicsElement.elementIterator("disability");
                    while (i23.hasNext()) {
                        Element e3 = (Element)i23.next();
                        String code4 = e3.attributeValue("code");
                        if (sAccomodations.remove(code4) != null) continue;
                        StudentAccomodation accomodation = (StudentAccomodation)code2accomodation.get(code4);
                        if (accomodation == null) {
                            this.warn("Student accomodation " + code4 + " not known.");
                            continue;
                        }
                        student.getAccomodations().add(accomodation);
                        accomodation.getStudents().add(student);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (StudentAccomodation accomodation : sAccomodations.values()) {
                        student.getAccomodations().remove(accomodation);
                        accomodation.getStudents().remove(student);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                }
                if (student.getUniqueId() == null) {
                    updatedStudents.add((Long)this.getHibSession().save((Object)student));
                } else {
                    this.getHibSession().update((Object)student);
                }
                Element reqCoursesElement = studentElement.element("updateCourseRequests");
                if (reqCoursesElement != null && "true".equals(reqCoursesElement.attributeValue("commit", "true"))) {
                    Hashtable<StudentEnrollmentImport.Pair, StudentClassEnrollment> enrollments = new Hashtable<StudentEnrollmentImport.Pair, StudentClassEnrollment>();
                    for (StudentClassEnrollment enrollment : student.getClassEnrollments()) {
                        enrollments.put(new StudentEnrollmentImport.Pair(enrollment.getCourseOffering().getUniqueId(), enrollment.getClazz().getUniqueId()), enrollment);
                    }
                    TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
                    int priority = 0;
                    Date ts = new Date();
                    HashMap<Long, CourseRequest> course2request = new HashMap<Long, CourseRequest>();
                    ArrayList<CourseRequest> unusedRequests = new ArrayList<CourseRequest>();
                    Iterator<Object> i = reqCoursesElement.elementIterator();
                    while (i.hasNext()) {
                        Iterator j;
                        Element requestElement = (Element)i.next();
                        String waitList = requestElement.attributeValue("waitlist");
                        String alternative = requestElement.attributeValue("alternative");
                        if (requestElement.getName().equals("courseOffering")) {
                            ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>();
                            ArrayList<Integer> credits = new ArrayList<Integer>();
                            ArrayList<Element> elements = new ArrayList<Element>();
                            CourseOffering course = (CourseOffering)name2course.get(requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber"));
                            if (course == null) {
                                this.warn("Course " + requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber") + " not found.");
                            } else {
                                courses.add(course);
                                credits.add(Integer.valueOf(requestElement.attributeValue("credit", "0")));
                                elements.add(requestElement);
                            }
                            LinkedList<Element> queue = new LinkedList<Element>();
                            queue.add(requestElement);
                            Element requestOrAlternativeElement = null;
                            while ((requestOrAlternativeElement = (Element)queue.poll()) != null) {
                                j = requestOrAlternativeElement.elementIterator("alternative");
                                while (j.hasNext()) {
                                    Element altElement = (Element)j.next();
                                    CourseOffering altCourse = (CourseOffering)name2course.get(altElement.attributeValue("subjectArea") + " " + altElement.attributeValue("courseNumber"));
                                    if (altCourse == null) {
                                        this.warn("Course " + altElement.attributeValue("subjectArea") + " " + altElement.attributeValue("courseNumber") + " not found.");
                                    } else {
                                        courses.add(altCourse);
                                        credits.add(Integer.valueOf(altElement.attributeValue("credit", "0")));
                                        elements.add(altElement);
                                    }
                                    queue.add(altElement);
                                }
                            }
                            if (!courses.isEmpty()) {
                                CourseDemand cd = null;
                                Iterator j2 = remaining.iterator();
                                block46: while (j2.hasNext()) {
                                    CourseDemand adept = (CourseDemand)j2.next();
                                    if (adept.getFreeTime() != null) continue;
                                    for (CourseRequest cr : adept.getCourseRequests()) {
                                        if (!cr.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                                        cd = adept;
                                        j2.remove();
                                        break block46;
                                    }
                                }
                                if (cd == null) {
                                    cd = new CourseDemand();
                                    cd.setTimestamp(ts);
                                    cd.setCourseRequests(new HashSet<CourseRequest>());
                                    cd.setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                                    cd.setStudent(student);
                                    student.getCourseDemands().add(cd);
                                }
                                cd.setAlternative("true".equals(alternative));
                                cd.setPriority(priority);
                                cd.setWaitlist("true".equals(waitList));
                                Iterator<CourseRequest> requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
                                int order = 0;
                                for (CourseOffering co : courses) {
                                    CourseRequest cr = null;
                                    if (requests.hasNext()) {
                                        cr = requests.next();
                                        if (cr.getCourseRequestOptions() != null) {
                                            Iterator<CourseRequestOption> j3 = cr.getCourseRequestOptions().iterator();
                                            while (j3.hasNext()) {
                                                this.getHibSession().delete((Object)j3.next());
                                            }
                                            cr.getCourseRequestOptions().clear();
                                        }
                                    } else {
                                        cr = new CourseRequest();
                                        cd.getCourseRequests().add(cr);
                                        cr.setCourseDemand(cd);
                                        cr.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                    }
                                    cr.setAllowOverlap(false);
                                    cr.setCredit((Integer)credits.get(order));
                                    cr.setOrder(order++);
                                    cr.setCourseOffering(co);
                                    course2request.put(co.getUniqueId(), cr);
                                }
                                while (requests.hasNext()) {
                                    unusedRequests.add(requests.next());
                                    requests.remove();
                                }
                                this.getHibSession().saveOrUpdate((Object)cd);
                                if (mode == EnrollmentMode.IMPORT) {
                                    for (int j4 = 0; j4 < courses.size(); ++j4) {
                                        CourseOffering co;
                                        co = (CourseOffering)courses.get(j4);
                                        Element reqEl = (Element)elements.get(j4);
                                        Map extId2class = (Map)course2extId2class.get(co.getUniqueId());
                                        Map name2class = (Map)course2name2class.get(co.getUniqueId());
                                        HashSet<Long> imported = new HashSet<Long>();
                                        Iterator k = reqEl.elementIterator("class");
                                        while (k.hasNext()) {
                                            Element classElement = (Element)k.next();
                                            Set classes = null;
                                            String classExternalId = classElement.attributeValue("externalId");
                                            if (classExternalId != null && (classes = (Set)extId2class.get(classExternalId)) == null) {
                                                classes = (Set)name2class.get(classExternalId);
                                            }
                                            if (classes == null) {
                                                String type = classElement.attributeValue("type");
                                                String suffix = classElement.attributeValue("suffix");
                                                if (type != null && suffix != null) {
                                                    classes = (Set)name2class.get(type.trim() + " " + suffix);
                                                }
                                            }
                                            if (classes == null) {
                                                this.warn(co.getCourseName() + ": Class " + (classExternalId != null ? classExternalId : classElement.attributeValue("type") + " " + classElement.attributeValue("suffix")) + " not found.");
                                                continue;
                                            }
                                            CourseRequest request = (CourseRequest)course2request.get(co.getUniqueId());
                                            if (request != null) {
                                                Iterator<StudentEnrollmentMessage> l = request.getCourseDemand().getEnrollmentMessages().iterator();
                                                while (l.hasNext()) {
                                                    StudentEnrollmentMessage message = l.next();
                                                    this.getHibSession().delete((Object)message);
                                                    l.remove();
                                                }
                                            }
                                            for (Class_ clazz : classes) {
                                                StudentClassEnrollment enrollment;
                                                if (!imported.add(clazz.getUniqueId()) || (enrollment = (StudentClassEnrollment)enrollments.remove(new StudentEnrollmentImport.Pair(co.getUniqueId(), clazz.getUniqueId()))) != null) continue;
                                                enrollment = new StudentClassEnrollment();
                                                enrollment.setStudent(student);
                                                enrollment.setClazz(clazz);
                                                enrollment.setCourseOffering(co);
                                                enrollment.setTimestamp(ts);
                                                enrollment.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                                                enrollment.setCourseRequest(request);
                                                student.getClassEnrollments().add(enrollment);
                                            }
                                        }
                                    }
                                }
                            }
                        } else if (requestElement.getName().equals("freeTime")) {
                            String days = requestElement.attributeValue("days");
                            String startTime = requestElement.attributeValue("startTime");
                            String length = requestElement.attributeValue("length");
                            String endTime = requestElement.attributeValue("endTime");
                            TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                            CourseDemand cd = null;
                            j = remaining.iterator();
                            while (j.hasNext()) {
                                CourseDemand adept = (CourseDemand)j.next();
                                if (adept.getFreeTime() == null) continue;
                                cd = adept;
                                j.remove();
                                break;
                            }
                            if (cd == null) {
                                cd = new CourseDemand();
                                cd.setTimestamp(ts);
                                student.getCourseDemands().add(cd);
                                cd.setStudent(student);
                            }
                            cd.setAlternative("true".equals(alternative));
                            cd.setPriority(priority);
                            cd.setWaitlist("true".equals(waitList));
                            FreeTime free = cd.getFreeTime();
                            if (free == null) {
                                free = new FreeTime();
                                cd.setFreeTime(free);
                            }
                            free.setCategory(time.getBreakTime());
                            free.setDayCode(time.getDayCode());
                            free.setStartSlot(time.getStartSlot());
                            free.setLength(time.getLength());
                            free.setSession(student.getSession());
                            free.setName(time.getLongName(true));
                            this.getHibSession().saveOrUpdate((Object)free);
                            this.getHibSession().saveOrUpdate((Object)cd);
                        } else {
                            this.warn("Request element " + requestElement.getName() + " not recognized.");
                        }
                        ++priority;
                    }
                    if (mode == EnrollmentMode.DELETE || mode == EnrollmentMode.IMPORT) {
                        for (StudentClassEnrollment enrl : enrollments.values()) {
                            student.getClassEnrollments().remove(enrl);
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            this.getHibSession().delete((Object)enrl);
                        }
                    } else {
                        i = student.getClassEnrollments().iterator();
                        while (i.hasNext()) {
                            StudentClassEnrollment enrl;
                            enrl = (StudentClassEnrollment)i.next();
                            CourseRequest cr = (CourseRequest)course2request.get(enrl.getCourseOffering().getUniqueId());
                            if (cr == null) {
                                if (mode == EnrollmentMode.NOCHANGE) {
                                    enrl.setCourseRequest(null);
                                    this.getHibSession().saveOrUpdate((Object)enrl);
                                    continue;
                                }
                                enrl.getClazz().getStudentEnrollments().remove(enrl);
                                this.getHibSession().delete((Object)enrl);
                                i.remove();
                                continue;
                            }
                            enrl.setCourseRequest(cr);
                            this.getHibSession().saveOrUpdate((Object)enrl);
                        }
                    }
                    for (CourseRequest cr : unusedRequests) {
                        cr.getCourseDemand().getCourseRequests().remove(cr);
                        this.getHibSession().delete((Object)cr);
                    }
                    for (CourseDemand cd : remaining) {
                        if (cd.getFreeTime() != null) {
                            this.getHibSession().delete((Object)cd.getFreeTime());
                        }
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            this.getHibSession().delete((Object)cr);
                        }
                        student.getCourseDemands().remove(cd);
                        this.getHibSession().delete((Object)cd);
                    }
                    updatedStudents.add(student.getUniqueId());
                }
                this.getHibSession().update((Object)student);
            }
            this.info(updatedStudents.size() + " students changed");
            if (!updatedStudents.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), updatedStudents);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    private TimeLocation makeTime(DatePattern dp, String days, String startTime, String endTime, String length) {
        int dayCode = 0;
        if (days.contains("Th")) {
            dayCode += Constants.DAY_CODES[3];
            days = days.replace("Th", "..");
        }
        if (days.contains("R")) {
            dayCode += Constants.DAY_CODES[3];
            days = days.replace("R", ".");
        }
        if (days.contains("Su")) {
            dayCode += Constants.DAY_CODES[6];
            days = days.replace("Su", "..");
        }
        if (days.contains("U")) {
            dayCode += Constants.DAY_CODES[6];
            days = days.replace("U", ".");
        }
        if (days.contains("M")) {
            dayCode += Constants.DAY_CODES[0];
            days = days.replace("M", ".");
        }
        if (days.contains("T")) {
            dayCode += Constants.DAY_CODES[1];
            days = days.replace("T", ".");
        }
        if (days.contains("W")) {
            dayCode += Constants.DAY_CODES[2];
            days = days.replace("W", ".");
        }
        if (days.contains("F")) {
            dayCode += Constants.DAY_CODES[4];
            days = days.replace("F", ".");
        }
        if (days.contains("S")) {
            dayCode += Constants.DAY_CODES[5];
            days = days.replace("S", ".");
        }
        int startSlot = (Integer.parseInt(startTime) / 100 * 60 + Integer.parseInt(startTime) % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        int nrSlots = 0;
        nrSlots = length != null ? Integer.parseInt(length) / Constants.SLOT_LENGTH_MIN : Integer.parseInt(endTime) / 100 * 60 + Integer.parseInt(endTime) % 100 - (Integer.parseInt(startTime) / 100 * 60 + Integer.parseInt(startTime) % 100) / Constants.SLOT_LENGTH_MIN;
        return new TimeLocation(dayCode, startSlot, nrSlots, 0, 0.0, dp.getUniqueId(), dp.getName(), dp.getPatternBitSet(), 0);
    }

    private boolean eq(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnrollmentMode {
        DELETE("Student enrollments will be deleted."),
        IMPORT("Student enrollments will be imported."),
        NOCHANGE("Student enrollments will be left unchanged"),
        UPDATE("Student enrollments will be updated (only enrollments that are no longer requested will be deleted)");

        private String iText;

        private EnrollmentMode(String text) {
            this.iText = text;
        }

        public String toString() {
            return this.iText;
        }
    }
}

