/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.test.UpdateExamConflicts;

public class StudentEnrollmentImport
extends BaseImport {
    public void loadXml(Element rootElement) throws Exception {
        boolean trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
        if (!rootElement.getName().equalsIgnoreCase("studentEnrollments")) {
            throw new Exception("Given XML file is not a Student Enrollments load file.");
        }
        Session session = null;
        HashSet<Long> updatedStudents = new HashSet<Long>();
        try {
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            String created = rootElement.attributeValue("created");
            boolean incremental = "true".equals(rootElement.attributeValue("incremental", "false"));
            this.beginTransaction();
            session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            HashMap<String, HashSet<Class_>> extId2class = new HashMap<String, HashSet<Class_>>();
            HashMap<String, Class_> name2class = new HashMap<String, Class_>();
            HashMap<Long, Class_> id2class = new HashMap<Long, Class_>();
            HashMap<String, HashSet<CourseOffering>> extId2course = new HashMap<String, HashSet<CourseOffering>>();
            HashMap<String, CourseOffering> name2course = new HashMap<String, CourseOffering>();
            HashMap<String, CourseOffering> cextId2course = new HashMap<String, CourseOffering>();
            HashMap<String, CourseOffering> cname2course = new HashMap<String, CourseOffering>();
            HashMap<Long, HashSet<CourseOffering>> class2courses = new HashMap<Long, HashSet<CourseOffering>>();
            this.info("Loading classes...");
            for (Object o : this.getHibSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                CourseOffering course;
                Class_ clazz = (Class_)o[0];
                String extId = clazz.getExternalId(course = (CourseOffering)o[1]);
                if (extId != null && !extId.isEmpty()) {
                    HashSet<Class_> sameExtIdClasses = (HashSet<Class_>)extId2class.get(extId);
                    if (sameExtIdClasses == null) {
                        sameExtIdClasses = new HashSet<Class_>();
                        extId2class.put(extId, sameExtIdClasses);
                    }
                    sameExtIdClasses.add(clazz);
                }
                String name = clazz.getClassLabel(course);
                name2class.put(name, clazz);
                name2course.put(name, course);
                id2class.put(clazz.getUniqueId(), clazz);
                if (extId != null && !extId.isEmpty()) {
                    HashSet<CourseOffering> sameExtIdCourses = (HashSet<CourseOffering>)extId2course.get(extId);
                    if (sameExtIdCourses == null) {
                        sameExtIdCourses = new HashSet<CourseOffering>();
                        extId2course.put(extId, sameExtIdCourses);
                    }
                    sameExtIdCourses.add(course);
                }
                HashSet<CourseOffering> courses = (HashSet<CourseOffering>)class2courses.get(clazz.getUniqueId());
                if (course.getExternalUniqueId() != null && !course.getExternalUniqueId().isEmpty()) {
                    cextId2course.put(course.getExternalUniqueId(), course);
                }
                cname2course.put(course.getCourseName(), course);
                if (courses == null) {
                    courses = new HashSet<CourseOffering>();
                    class2courses.put(clazz.getUniqueId(), courses);
                }
                courses.add(course);
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_STUDENT_ENROLLMENTS, ChangeLog.Operation.UPDATE, null, null);
            }
            this.info("Loading students...");
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Student student : this.getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch s.classEnrollments as e where s.session.uniqueId=:sessionId and s.externalUniqueId is not null").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                students.put(student.getExternalUniqueId(), student);
            }
            this.info("Importing enrollments...");
            Date ts = new Date();
            Iterator i = rootElement.elementIterator("student");
            while (i.hasNext()) {
                Element studentElement = (Element)i.next();
                String externalId = studentElement.attributeValue("externalId");
                if (externalId == null) continue;
                while (trimLeadingZerosFromExternalId && externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
                boolean fixCourseDemands = false;
                Student student = (Student)students.remove(externalId);
                if (student == null) {
                    student = new Student();
                    student.setSession(session);
                    student.setFirstName(studentElement.attributeValue("firstName", "Name"));
                    student.setMiddleName(studentElement.attributeValue("middleName"));
                    student.setLastName(studentElement.attributeValue("lastName", "Unknown"));
                    student.setEmail(studentElement.attributeValue("email"));
                    student.setExternalUniqueId(externalId);
                    student.setFreeTimeCategory(0);
                    student.setSchedulePreference(0);
                    student.setClassEnrollments(new HashSet<StudentClassEnrollment>());
                    student.setCourseDemands(new HashSet<CourseDemand>());
                }
                Hashtable<Pair, StudentClassEnrollment> enrollments = new Hashtable<Pair, StudentClassEnrollment>();
                for (StudentClassEnrollment studentClassEnrollment : student.getClassEnrollments()) {
                    enrollments.put(new Pair(studentClassEnrollment.getCourseOffering().getUniqueId(), studentClassEnrollment.getClazz().getUniqueId()), studentClassEnrollment);
                }
                int nextPriority = 0;
                for (CourseDemand cd : student.getCourseDemands()) {
                    if (cd.isAlternative().booleanValue() || cd.getPriority() < nextPriority) continue;
                    nextPriority = cd.getPriority() + 1;
                }
                HashSet<CourseDemand> hashSet = new HashSet<CourseDemand>(student.getCourseDemands());
                ArrayList<Enrollment> selected = new ArrayList<Enrollment>();
                Iterator j = studentElement.elementIterator("class");
                while (j.hasNext()) {
                    Iterator suffix;
                    Element classElement = (Element)j.next();
                    Class_ clazz = null;
                    CourseOffering course = null;
                    Set classes = null;
                    Set courses = null;
                    if (clazz == null && classElement.attributeValue("id") != null) {
                        clazz = (Class_)id2class.get(Long.valueOf(classElement.attributeValue("id")));
                    }
                    String classExternalId = classElement.attributeValue("externalId");
                    if (clazz == null && classExternalId != null) {
                        classes = (Set)extId2class.get(classExternalId);
                        courses = (Set)extId2course.get(classExternalId);
                        if (classes == null) {
                            clazz = (Class_)name2class.get(classExternalId);
                            course = (CourseOffering)name2course.get(classExternalId);
                        } else {
                            if (classes.size() == 1) {
                                clazz = (Class_)classes.iterator().next();
                            }
                            if (courses.size() == 1) {
                                course = (CourseOffering)courses.iterator().next();
                            }
                        }
                    }
                    if (clazz == null && classElement.attributeValue("name") != null) {
                        String className = classElement.attributeValue("name");
                        clazz = (Class_)name2class.get(className);
                        course = (CourseOffering)name2course.get(className);
                    }
                    if (course == null && classElement.attributeValue("courseId") != null) {
                        course = (CourseOffering)cextId2course.get(classElement.attributeValue("courseId"));
                    }
                    if (course == null) {
                        String courseName = classElement.attributeValue("course");
                        if (courseName != null) {
                            course = (CourseOffering)cname2course.get(courseName);
                        } else {
                            String subject = classElement.attributeValue("subject");
                            String courseNbr = classElement.attributeValue("courseNbr");
                            if (subject != null && courseNbr != null) {
                                course = (CourseOffering)cname2course.get(subject + " " + courseNbr);
                            }
                        }
                    }
                    if (course != null && clazz == null) {
                        String type = classElement.attributeValue("type");
                        suffix = classElement.attributeValue("suffix");
                        if (type != null && suffix != null) {
                            clazz = (Class_)name2class.get(course.getCourseName() + " " + type.trim() + " " + suffix);
                        }
                    }
                    if (clazz == null && classes == null) {
                        this.warn("Class " + (String)(classExternalId != null ? classExternalId : classElement.attributeValue("name", classElement.attributeValue("course", classElement.attributeValue("subject") + " " + classElement.attributeValue("courseNbr")) + " " + classElement.attributeValue("type") + " " + classElement.attributeValue("suffix"))) + " not found.");
                        continue;
                    }
                    if (clazz != null) {
                        Set coursesThisClass = (Set)class2courses.get(clazz.getUniqueId());
                        if (course == null && courses != null) {
                            for (CourseOffering co : courses) {
                                if (!co.isIsControl().booleanValue() || !coursesThisClass.contains(co)) continue;
                                course = co;
                                break;
                            }
                        }
                        if (course == null && courses != null) {
                            for (CourseOffering co : courses) {
                                if (!coursesThisClass.contains(co)) continue;
                                course = co;
                                break;
                            }
                        }
                        if (course == null || !coursesThisClass.contains(course)) {
                            suffix = coursesThisClass.iterator();
                            while (suffix.hasNext()) {
                                CourseOffering co;
                                co = (CourseOffering)suffix.next();
                                if (!co.isIsControl().booleanValue()) continue;
                                course = co;
                                break;
                            }
                        }
                        selected.add(new Enrollment(course, clazz));
                        continue;
                    }
                    block16: for (Class_ c : classes) {
                        Set coursesThisClass = (Set)class2courses.get(c.getUniqueId());
                        if (course != null) {
                            if (!coursesThisClass.contains(course)) continue;
                            selected.add(new Enrollment(course, c));
                            continue;
                        }
                        for (CourseOffering co : courses) {
                            if (!coursesThisClass.contains(co) || !co.isIsControl().booleanValue()) continue;
                            selected.add(new Enrollment(co, c));
                            continue block16;
                        }
                        for (CourseOffering co : courses) {
                            if (!coursesThisClass.contains(co)) continue;
                            selected.add(new Enrollment(co, c));
                            continue block16;
                        }
                    }
                }
                HashSet<Enrollment> imported = new HashSet<Enrollment>();
                for (Enrollment e : selected) {
                    if (!imported.add(e)) continue;
                    Class_ clazz = e.getClazz();
                    CourseOffering course = e.getCourse();
                    StudentClassEnrollment enrollment3 = (StudentClassEnrollment)enrollments.remove(new Pair(course.getUniqueId(), clazz.getUniqueId()));
                    if (enrollment3 == null) {
                        enrollment3 = new StudentClassEnrollment();
                        enrollment3.setStudent(student);
                        enrollment3.setClazz(clazz);
                        enrollment3.setCourseOffering(course);
                        enrollment3.setTimestamp(ts);
                        enrollment3.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                        student.getClassEnrollments().add(enrollment3);
                        block20: for (CourseDemand d : student.getCourseDemands()) {
                            for (CourseRequest r : d.getCourseRequests()) {
                                if (!r.getCourseOffering().equals(course)) continue;
                                enrollment3.setCourseRequest(r);
                                break block20;
                            }
                        }
                        if (student.getUniqueId() != null) {
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    if (enrollment3.getCourseRequest() != null) {
                        hashSet.remove(enrollment3.getCourseRequest().getCourseDemand());
                        Iterator<StudentEnrollmentMessage> j2 = enrollment3.getCourseRequest().getCourseDemand().getEnrollmentMessages().iterator();
                        while (j2.hasNext()) {
                            StudentEnrollmentMessage message = j2.next();
                            this.getHibSession().delete((Object)message);
                            j2.remove();
                        }
                        continue;
                    }
                    CourseDemand cd = new CourseDemand();
                    cd.setTimestamp(ts);
                    cd.setCourseRequests(new HashSet<CourseRequest>());
                    cd.setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                    cd.setStudent(student);
                    student.getCourseDemands().add(cd);
                    cd.setAlternative(false);
                    cd.setPriority(nextPriority++);
                    cd.setWaitlist(false);
                    CourseRequest cr = new CourseRequest();
                    cd.getCourseRequests().add(cr);
                    cr.setCourseDemand(cd);
                    cr.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                    cr.setAllowOverlap(false);
                    cr.setCredit(0);
                    cr.setOrder(0);
                    cr.setCourseOffering(enrollment3.getCourseOffering());
                    enrollment3.setCourseRequest(cr);
                    cr.getClassEnrollments().add(enrollment3);
                    fixCourseDemands = true;
                    if (student.getUniqueId() == null) continue;
                    updatedStudents.add(student.getUniqueId());
                }
                if (!enrollments.isEmpty()) {
                    for (StudentClassEnrollment enrollment4 : enrollments.values()) {
                        student.getClassEnrollments().remove(enrollment4);
                        this.getHibSession().delete((Object)enrollment4);
                        updatedStudents.add(student.getUniqueId());
                    }
                }
                if (student.getUniqueId() == null) {
                    updatedStudents.add((Long)this.getHibSession().save((Object)student));
                } else {
                    this.getHibSession().update((Object)student);
                }
                if (!fixCourseDemands) continue;
                for (CourseDemand cd : hashSet) {
                    if (cd.getFreeTime() != null) {
                        this.getHibSession().delete((Object)cd.getFreeTime());
                    }
                    for (CourseRequest cr : cd.getCourseRequests()) {
                        this.getHibSession().delete((Object)cr);
                    }
                    student.getCourseDemands().remove(cd);
                    this.getHibSession().delete((Object)cd);
                }
                int priority = 0;
                for (CourseDemand cd : new TreeSet<CourseDemand>(student.getCourseDemands())) {
                    cd.setPriority(priority++);
                    this.getHibSession().saveOrUpdate((Object)cd);
                }
            }
            if (!incremental) {
                for (Student student : students.values()) {
                    Iterator<StudentClassEnrollment> i2 = student.getClassEnrollments().iterator();
                    while (i2.hasNext()) {
                        StudentClassEnrollment enrollment = i2.next();
                        this.getHibSession().delete((Object)enrollment);
                        i2.remove();
                        updatedStudents.add(student.getUniqueId());
                    }
                    this.getHibSession().update((Object)student);
                }
            }
            this.info(updatedStudents.size() + " students changed");
            if (!updatedStudents.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), updatedStudents);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
        if (session != null && ApplicationProperty.DataExchangeUpdateStudentConflictsFinal.isTrue()) {
            try {
                this.beginTransaction();
                for (ExamType type : ExamType.findAllOfType(0)) {
                    new UpdateExamConflicts(this).update(session.getUniqueId(), type.getUniqueId(), this.getHibSession());
                }
                this.commitTransaction();
            }
            catch (Exception e) {
                this.fatal("Exception: " + e.getMessage(), e);
                this.rollbackTransaction();
            }
        }
        if (session != null && ApplicationProperty.DataExchangeUpdateStudentConflictsMidterm.isTrue()) {
            try {
                this.beginTransaction();
                for (ExamType type : ExamType.findAllOfType(1)) {
                    new UpdateExamConflicts(this).update(session.getUniqueId(), type.getUniqueId(), this.getHibSession());
                }
                this.commitTransaction();
            }
            catch (Exception e) {
                this.fatal("Exception: " + e.getMessage(), e);
                this.rollbackTransaction();
            }
        }
    }

    public static class Enrollment {
        private CourseOffering iCourse;
        private Class_ iClazz;

        private Enrollment(CourseOffering course, Class_ clazz) {
            this.iCourse = course;
            this.iClazz = clazz;
        }

        public Long getCourseId() {
            return this.iCourse.getUniqueId();
        }

        public CourseOffering getCourse() {
            return this.iCourse;
        }

        public Long getClassId() {
            return this.iClazz.getUniqueId();
        }

        public Class_ getClazz() {
            return this.iClazz;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Enrollment)) {
                return false;
            }
            Enrollment p = (Enrollment)o;
            return this.getCourseId().equals(p.getCourseId()) && this.getClassId().equals(p.getClassId());
        }

        public int hashCode() {
            return this.getCourseId().hashCode() ^ this.getClassId().hashCode();
        }

        public String toString() {
            return this.getClazz().getClassLabel(this.getCourse(), true);
        }

        public Pair toPair() {
            return new Pair(this.getCourseId(), this.getClassId());
        }
    }

    public static class Pair {
        private Long iCourseId;
        private Long iClassId;

        public Pair(Long courseId, Long classId) {
            this.iCourseId = courseId;
            this.iClassId = classId;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return this.getCourseId().equals(p.getCourseId()) && this.getClassId().equals(p.getClassId());
        }

        public int hashCode() {
            return this.getCourseId().hashCode() ^ this.getClassId().hashCode();
        }

        public String toString() {
            return "(" + this.getCourseId() + "," + this.getClassId() + ")";
        }
    }
}

