/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.SolverGroupEditForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/solverGroupEdit")
public class SolverGroupEditAction
extends Action {
    private static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            org.hibernate.Session hibSession;
            Transaction tx;
            String op;
            SolverGroupEditForm myForm = (SolverGroupEditForm)form;
            this.sessionContext.checkPermission(Right.SolverGroups);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (op == null || "Back".equals(op)) {
                myForm.setOp("List");
                if (myForm.getUniqueId() != null) {
                    request.setAttribute("hash", (Object)myForm.getUniqueId());
                }
            }
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    Transaction tx2 = null;
                    try {
                        org.hibernate.Session hibSession2 = new SolverGroupDAO().getSession();
                        if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                            tx2 = hibSession2.beginTransaction();
                        }
                        myForm.saveOrUpdate(hibSession2, this.sessionContext);
                        if (tx2 != null) {
                            tx2.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx2 != null) {
                            tx2.rollback();
                        }
                        throw e;
                    }
                    myForm.setOp("List");
                    if (myForm.getUniqueId() != null) {
                        request.setAttribute("hash", (Object)myForm.getUniqueId());
                    }
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                    return mapping.findForward("edit");
                }
                SolverGroup group = (SolverGroup)new SolverGroupDAO().get(Long.valueOf(id));
                if (group == null) {
                    errors.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                    return mapping.findForward("edit");
                }
                myForm.load(group, session);
            }
            if ("Delete".equals(op)) {
                tx = null;
                try {
                    hibSession = new SolverGroupDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    myForm.delete(hibSession, this.sessionContext);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.setOp("List");
            }
            if ("Add Solver Group".equals(op)) {
                myForm.load(null, session);
            }
            if ("Delete All".equals(op)) {
                tx = null;
                try {
                    hibSession = new SolverGroupDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    for (SolverGroup group : SolverGroup.findBySessionId(session.getUniqueId())) {
                        if (!group.getSolutions().isEmpty()) continue;
                        for (Department dept : group.getDepartments()) {
                            dept.setSolverGroup(null);
                            hibSession.saveOrUpdate((Object)dept);
                        }
                        for (TimetableManager mgr : group.getTimetableManagers()) {
                            mgr.getSolverGroups().remove(group);
                            hibSession.saveOrUpdate((Object)mgr);
                        }
                        hibSession.delete((Object)group);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.setOp("List");
            }
            if ("Auto Setup".equals(op)) {
                tx = null;
                try {
                    hibSession = new SolverGroupDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    TreeSet<Department> allDepts = new TreeSet<Department>(new Comparator(){

                        public int compare(Object o1, Object o2) {
                            Department d1 = (Department)o1;
                            Department d2 = (Department)o2;
                            int cmp = -Double.compare(d1.getTimetableManagers().size(), d2.getTimetableManagers().size());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return d1.getUniqueId().compareTo(d2.getUniqueId());
                        }
                    });
                    allDepts.addAll(session.getDepartments());
                    for (Department d : allDepts) {
                        if (d.getSolverGroup() != null) continue;
                        if (d.isExternalManager().booleanValue()) {
                            SolverGroup sg = new SolverGroup();
                            sg.setAbbv(d.getExternalMgrAbbv());
                            sg.setName(d.getDeptCode() + " - " + d.getExternalMgrLabel().replaceAll(" Manager", ""));
                            sg.setSession(session);
                            sg.setTimetableManagers(new HashSet<TimetableManager>());
                            hibSession.saveOrUpdate((Object)sg);
                            d.setSolverGroup(sg);
                            hibSession.saveOrUpdate((Object)d);
                            for (TimetableManager mgr : d.getTimetableManagers()) {
                                mgr.getSolverGroups().add(sg);
                                sg.getTimetableManagers().add(mgr);
                                hibSession.saveOrUpdate((Object)mgr);
                            }
                            continue;
                        }
                        if (d.getSubjectAreas().isEmpty() || d.getTimetableManagers().isEmpty()) continue;
                        HashSet depts = null;
                        for (TimetableManager mgr : d.getTimetableManagers()) {
                            Set myDepts = mgr.departmentsForSession(session.getUniqueId());
                            if (depts == null) {
                                depts = new HashSet(myDepts);
                                continue;
                            }
                            depts.retainAll(myDepts);
                        }
                        Iterator<TimetableManager> j = depts.iterator();
                        while (j.hasNext()) {
                            Department x = (Department)((Object)j.next());
                            if (x.getSolverGroup() == null && !x.getSubjectAreas().isEmpty()) continue;
                            j.remove();
                        }
                        if (depts.isEmpty()) continue;
                        StringBuffer abbv = new StringBuffer();
                        StringBuffer name = new StringBuffer();
                        HashSet<TimetableManager> mgrs = new HashSet<TimetableManager>();
                        for (Department x : depts) {
                            mgrs.addAll(x.getTimetableManagers());
                            abbv.append(x.getShortLabel().trim());
                            if (name.length() > 0) {
                                name.append(", ");
                            }
                            name.append(x.getLabel());
                        }
                        SolverGroup sg = new SolverGroup();
                        sg.setAbbv(abbv.length() <= 10 ? abbv.toString() : abbv.toString().substring(0, 10));
                        sg.setName(name.length() <= 50 ? name.toString() : name.toString().substring(0, 47) + "...");
                        sg.setTimetableManagers(new HashSet<TimetableManager>());
                        sg.setSession(session);
                        hibSession.saveOrUpdate((Object)sg);
                        for (Department x : depts) {
                            x.setSolverGroup(sg);
                            hibSession.saveOrUpdate((Object)x);
                        }
                        for (TimetableManager mgr : mgrs) {
                            mgr.getSolverGroups().add(sg);
                            sg.getTimetableManagers().add(mgr);
                            hibSession.saveOrUpdate((Object)mgr);
                        }
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.setOp("List");
            }
            if ("Export PDF".equals(op)) {
                ExportUtils.exportPDF(this.getSolverGroups(request, session, false), WebTable.getOrder(this.sessionContext, "solverGroups.ord"), response, "solverGroups");
                return null;
            }
            if ("List".equals(myForm.getOp())) {
                PdfWebTable table = this.getSolverGroups(request, session, true);
                request.setAttribute("SolverGroups.table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "solverGroups.ord")));
                return mapping.findForward("list");
            }
            return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private PdfWebTable getSolverGroups(HttpServletRequest request, Session session, boolean html) throws Exception {
        WebTable.setOrder(this.sessionContext, "solverGroups.ord", request.getParameter("ord"), 1);
        PdfWebTable webTable = new PdfWebTable(5, html ? null : "Solver Groups - " + session.getLabel(), "solverGroupEdit.do?ord=%%", new String[]{"Abbv", "Name", "Departments", "Managers", "Committed"}, new String[]{"left", "left", "left", "left", "left"}, null);
        Set<SolverGroup> solverGroups = SolverGroup.findBySessionId(session.getUniqueId());
        if (solverGroups.isEmpty()) {
            webTable.addLine(null, new String[]{"No time pattern defined for this academic initiative and term."}, null, null);
        }
        org.hibernate.Session hibSession = new SolverGroupDAO().getSession();
        for (SolverGroup group : solverGroups) {
            if (group.getDepartments() == null || group.getTimetableManagers() == null) {
                hibSession.refresh((Object)group);
            }
            String onClick = "onClick=\"document.location='solverGroupEdit.do?op=Edit&id=" + group.getUniqueId() + "';\"";
            String deptStr = "";
            String deptCmp = "";
            Iterator<Department> j = new TreeSet<Department>(group.getDepartments()).iterator();
            while (j.hasNext()) {
                Department d = j.next();
                deptStr = deptStr + (html ? "<span title='" + d.getDeptCode() + " - " + d.getName() + "'>" + d.getDeptCode() + "</span>" : d.getDeptCode());
                deptCmp = deptCmp + d.getDeptCode();
                if (!j.hasNext()) continue;
                deptStr = deptStr + ", ";
                deptCmp = deptCmp + ",";
            }
            String mgrStr = "";
            String mgrCmp = "";
            Iterator<TimetableManager> j2 = new TreeSet<TimetableManager>(group.getTimetableManagers()).iterator();
            while (j2.hasNext()) {
                TimetableManager mgr = j2.next();
                mgrStr = mgrStr + (html ? "<span title='" + mgr.getName() + "'>" + mgr.getShortName() + "</span>" : mgr.getShortName());
                mgrCmp = mgrCmp + mgr.getLastName();
                if (!j2.hasNext()) continue;
                mgrStr = mgrStr + ", ";
                mgrCmp = mgrCmp + ",";
            }
            Date commitDate = null;
            if (group.getCommittedSolution() != null) {
                commitDate = group.getCommittedSolution().getCommitDate();
            }
            webTable.addLine(onClick, new String[]{html ? "<a name='" + group.getUniqueId() + "'>" + (html ? group.getAbbv().replaceAll(" ", "&nbsp;") : group.getAbbv()) + "</a>" : group.getAbbv(), html ? group.getName().replaceAll(" ", "&nbsp;") : group.getName(), deptStr, mgrStr, commitDate == null ? "" : sDF.format(commitDate)}, new Comparable[]{group.getAbbv(), group.getName(), deptCmp, mgrCmp, new Long(commitDate == null ? -1L : commitDate.getTime())});
        }
        return webTable;
    }
}

