/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.ManagerSettingsForm;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.dao.SettingsDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/managerSettings")
public class ManagerSettingsAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.SettingsUser);
        MessageResources rsc = this.getResources(request);
        ManagerSettingsForm frm = (ManagerSettingsForm)form;
        String op = frm.getOp();
        if (op == null && (op = request.getParameter("op")) == null) {
            frm.setOp("List");
            op = "List";
        }
        if (op.equals(rsc.getMessage("button.cancelUpdateSetting"))) {
            frm.reset(mapping, request);
            frm.setOp("List");
        }
        if (op.equals("Edit")) {
            Settings s = (Settings)SettingsDAO.getInstance().get(Long.valueOf(request.getParameter("id")));
            frm.setOp("Edit");
            frm.setAllowedValues(s.getAllowedValues());
            frm.setKey(s.getKey());
            frm.setName(s.getDescription());
            frm.setDefaultValue(s.getDefaultValue());
            frm.setValue(this.sessionContext.getUser().getProperty(s.getKey(), s.getDefaultValue()));
            return mapping.findForward("editManagerSettings");
        }
        if (op.equals(rsc.getMessage("button.updateSetting"))) {
            ActionErrors errors = frm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                frm.setOp("Edit");
            } else {
                this.sessionContext.getUser().setProperty(frm.getKey(), frm.getValue());
            }
        }
        this.getSettingsList(request);
        return mapping.findForward("showManagerSettings");
    }

    private void getSettingsList(HttpServletRequest request) throws Exception {
        WebTable.setOrder(this.sessionContext, "managerSettings.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(2, "Manager Settings", "managerSettings.do?ord=%%", new String[]{"Setting", "Value"}, new String[]{"left", "left"}, null);
        for (Settings s : SettingsDAO.getInstance().findAll(Order.asc((String)"key"))) {
            String onClick = "onClick=\"document.location='managerSettings.do?op=Edit&id=" + s.getUniqueId() + "';\"";
            String value = this.sessionContext.getUser().getProperty(s.getKey(), s.getDefaultValue());
            webTable.addLine(onClick, new String[]{s.getDescription(), value}, (Comparable[])new String[]{s.getDescription(), value});
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "managerSettings.ord")));
    }
}

