/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.DeptStatusTypeEditForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.dao.DepartmentStatusTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/deptStatusTypeEdit")
public class DeptStatusTypeEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Session hibSession;
            Transaction tx;
            String op;
            DeptStatusTypeEditForm myForm = (DeptStatusTypeEditForm)form;
            this.sessionContext.checkPermission(Right.StatusTypes);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
                op = request.getParameter("op2");
            }
            if (op == null) {
                myForm.reset(mapping, request);
            }
            if ("Back".equals(op)) {
                myForm.reset(mapping, request);
            }
            if ("Add Status Type".equals(op)) {
                myForm.load(null);
            }
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    Transaction tx2 = null;
                    try {
                        Session hibSession2 = new DepartmentStatusTypeDAO().getSession();
                        if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                            tx2 = hibSession2.beginTransaction();
                        }
                        myForm.saveOrUpdate(hibSession2);
                        if (tx2 != null) {
                            tx2.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx2 != null) {
                            tx2.rollback();
                        }
                        throw e;
                    }
                    myForm.reset(mapping, request);
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("reference", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                } else {
                    DepartmentStatusType s = (DepartmentStatusType)new DepartmentStatusTypeDAO().get(new Long(id));
                    if (s == null) {
                        errors.add("reference", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                        this.saveErrors(request, errors);
                    } else {
                        myForm.load(s);
                    }
                }
            }
            if ("Delete".equals(op)) {
                tx = null;
                try {
                    hibSession = new DepartmentStatusTypeDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    myForm.delete(hibSession);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.reset(mapping, request);
            }
            if ("Move Up".equals(op) || "Move Down".equals(op)) {
                tx = null;
                try {
                    hibSession = new DepartmentStatusTypeDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    DepartmentStatusType curStatus = (DepartmentStatusType)new DepartmentStatusTypeDAO().get(myForm.getUniqueId());
                    if ("Move Up".equals(op)) {
                        boolean found = false;
                        for (DepartmentStatusType s : DepartmentStatusType.findAll()) {
                            if (s.getOrd() + 1 != curStatus.getOrd()) continue;
                            s.setOrd(s.getOrd() + 1);
                            hibSession.saveOrUpdate((Object)s);
                            found = true;
                        }
                        if (found) {
                            curStatus.setOrd(curStatus.getOrd() - 1);
                            myForm.setOrder(curStatus.getOrd());
                            hibSession.saveOrUpdate((Object)curStatus);
                        }
                    } else {
                        boolean found = false;
                        for (DepartmentStatusType s : DepartmentStatusType.findAll()) {
                            if (s.getOrd() - 1 != curStatus.getOrd()) continue;
                            s.setOrd(s.getOrd() - 1);
                            hibSession.saveOrUpdate((Object)s);
                            found = true;
                        }
                        if (found) {
                            curStatus.setOrd(curStatus.getOrd() + 1);
                            myForm.setOrder(curStatus.getOrd());
                            hibSession.saveOrUpdate((Object)curStatus);
                        }
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                myForm.reset(mapping, request);
            }
            if ("List".equals(myForm.getOp())) {
                this.getDeptStatusList(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
                return mapping.findForward("list");
            }
            return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void getDeptStatusList(HttpServletRequest request, Long sessionId) throws Exception {
        WebTable.setOrder(this.sessionContext, "deptStatusTypes.ord", request.getParameter("ord"), 2);
        WebTable webTable = new WebTable(5, null, "deptStatusTypeEdit.do?ord=%%", new String[]{"", "Reference", "Label", "Apply", "Rights"}, new String[]{"left", "left", "left", "left", "left"}, null);
        TreeSet statuses = DepartmentStatusType.findAll();
        if (statuses.isEmpty()) {
            webTable.addLine(null, new String[]{"No status defined."}, null, null);
        }
        int ord = 0;
        Iterator i = statuses.iterator();
        while (i.hasNext()) {
            DepartmentStatusType s = (DepartmentStatusType)i.next();
            if (ord != s.getOrd()) {
                s.setOrd(ord);
                DepartmentStatusTypeDAO.getInstance().saveOrUpdate(s);
            }
            ++ord;
            String onClick = "onClick=\"document.location='deptStatusTypeEdit.do?op=Edit&id=" + s.getUniqueId() + "';\"";
            String rights = "";
            String apply = "";
            if (s.applyDepartment()) {
                apply = s.applySession() ? (s.applyExamStatus() ? "All" : "Session &amp; Department") : "Department";
            } else if (s.applySession()) {
                apply = "Session";
            } else if (s.applyExamStatus()) {
                apply = "Examinations";
            }
            if (s.isAllowRollForward()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "roll-forward";
            }
            if (s.canOwnerView() || s.canOwnerLimitedEdit() || s.canOwnerEdit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "owner can ";
                if (s.canOwnerView() && s.canOwnerEdit()) {
                    rights = rights + "do all";
                } else {
                    if (s.canOwnerView()) {
                        rights = rights + "view";
                    }
                    if (s.canOwnerEdit()) {
                        if (!rights.endsWith(" ")) {
                            rights = rights + " and ";
                        }
                        rights = rights + "edit";
                    } else if (s.canOwnerLimitedEdit()) {
                        if (!rights.endsWith(" ")) {
                            rights = rights + " and ";
                        }
                        rights = rights + "limited edit";
                    }
                }
            }
            if (s.canManagerView() || s.canManagerLimitedEdit() || s.canManagerEdit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "manager can ";
                if (s.canManagerView() && s.canManagerEdit()) {
                    rights = rights + "do all";
                } else {
                    if (s.canManagerView()) {
                        rights = rights + "view";
                    }
                    if (s.canManagerEdit()) {
                        if (!rights.endsWith(" ")) {
                            rights = rights + " and ";
                        }
                        rights = rights + "edit";
                    } else if (s.canManagerLimitedEdit()) {
                        if (!rights.endsWith(" ")) {
                            rights = rights + " and ";
                        }
                        rights = rights + "limited edit";
                    }
                }
            }
            if (s.canAudit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "audit";
            }
            if (s.canTimetable()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "timetable";
            }
            if (s.canCommit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "commit";
            }
            if (s.canExamView() || s.canExamEdit() || s.canExamTimetable()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "exam ";
                if (s.canExamEdit() && s.canExamTimetable()) {
                    rights = rights + "do all";
                } else {
                    if (s.canExamView()) {
                        rights = rights + "view";
                    }
                    if (s.canExamEdit()) {
                        if (!rights.endsWith(" ")) {
                            rights = rights + " and ";
                        }
                        rights = rights + "edit";
                    } else if (s.canExamTimetable()) {
                        if (!rights.endsWith(" ")) {
                            rights = rights + " and ";
                        }
                        rights = rights + "timetable";
                    }
                }
            }
            if (s.canOnlineSectionStudents()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "sectioning";
            } else if (s.canSectionAssistStudents()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "assistant";
            } else if (s.canPreRegisterStudents()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "registration";
            }
            if (s.isAllowNoRole() || s.canNoRoleReportExamFinal() || s.canNoRoleReportExamMidterm() || s.canNoRoleReportClass()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "no-role";
                if (s.canNoRoleReportExamFinal() && s.canNoRoleReportExamMidterm() && s.canNoRoleReportClass()) {
                    rights = rights + " all";
                } else {
                    if (s.canNoRoleReportClass()) {
                        rights = rights + " classes";
                    }
                    if (s.canNoRoleReportExamFinal() && s.canNoRoleReportExamMidterm()) {
                        rights = rights + " exams";
                    } else {
                        if (s.canNoRoleReportExamFinal()) {
                            rights = rights + " final exams";
                        }
                        if (s.canNoRoleReportExamMidterm()) {
                            rights = rights + " midterm exams";
                        }
                    }
                }
            }
            if (s.isTestSession()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + "test session";
            }
            String ops = "";
            ops = s.getOrd() > 0 ? ops + "<img src='images/arrow_up.png' border='0' align='absmiddle' title='Move Up' onclick=\"deptStatusTypeEditForm.op2.value='Move Up';deptStatusTypeEditForm.uniqueId.value='" + s.getUniqueId() + "';deptStatusTypeEditForm.submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
            ops = i.hasNext() ? ops + "<img src='images/arrow_down.png' border='0' align='absmiddle' title='Move Down' onclick=\"deptStatusTypeEditForm.op2.value='Move Down';deptStatusTypeEditForm.uniqueId.value='" + s.getUniqueId() + "';deptStatusTypeEditForm.submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
            webTable.addLine(onClick, new String[]{ops, s.getReference(), s.getLabel(), apply, rights}, new Comparable[]{s.getOrd(), s.getOrd(), s.getLabel(), s.getApply(), s.getStatus()});
        }
        request.setAttribute("DeptStatusType.last", (Object)new Integer(statuses.size() - 1));
        request.setAttribute("DeptStatusType.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "deptStatusTypes.ord")));
    }
}

