/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.weights;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.weights.StudentWeights;

public class OriginalStudentWeights
implements StudentWeights {
    private double iPriorityWeight = 0.9;
    private double iAlterativeWeight = 1.0;
    private double iInitialWeight = 1.2;
    private double iSelectedWeight = 1.1;
    private double iWaitlistedWeight = 1.01;
    private double iDistConfWeight = 0.95;
    private double iAltValue = 0.5;
    private double iDummyStudentWeight = 0.5;
    private double iNormPenalty = 5.0;

    public OriginalStudentWeights(DataProperties config) {
        this.iDummyStudentWeight = config.getPropertyDouble("Student.DummyStudentWeight", this.iDummyStudentWeight);
    }

    public double normalizePenalty(double penalty) {
        return this.iNormPenalty / (this.iNormPenalty + penalty);
    }

    public double getWeight(Request request) {
        return Math.pow(this.iPriorityWeight, request.getPriority()) * (request.isAlternative() ? this.iAlterativeWeight : 1.0) * (request.getStudent().isDummy() ? this.iDummyStudentWeight : 1.0);
    }

    @Override
    public double getBound(Request request) {
        double w = this.getWeight(request) * Math.pow(this.iInitialWeight, request.getInitialAssignment() != null ? 1 : 0);
        if (request instanceof CourseRequest) {
            CourseRequest cr = (CourseRequest)request;
            w *= Math.pow(this.iSelectedWeight, cr.getSelectedChoices().isEmpty() ? 0.0 : 1.0);
            w *= Math.pow(this.iWaitlistedWeight, cr.getWaitlistedChoices().isEmpty() ? 0.0 : 1.0);
            w *= this.normalizePenalty(cr.getMinPenalty());
        }
        return w;
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        return this.getWeight(enrollment.getRequest()) * Math.pow(this.iAltValue, enrollment.getPriority()) * Math.pow(this.iInitialWeight, enrollment.percentInitial()) * Math.pow(this.iSelectedWeight, enrollment.percentSelected()) * Math.pow(this.iWaitlistedWeight, enrollment.percentWaitlisted()) * this.normalizePenalty(enrollment.getPenalty());
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
        int share = 0;
        if (timeOverlappingConflicts != null) {
            for (TimeOverlapsCounter.Conflict c : timeOverlappingConflicts) {
                share += c.getShare();
            }
        }
        return this.getWeight(assignment, enrollment) * (distanceConflicts == null || distanceConflicts.isEmpty() ? 1.0 : Math.pow(this.iDistConfWeight, distanceConflicts.size())) * Math.max(share == 0 ? 1.0 : 1.0 - (double)share / (double)enrollment.getNrSlots() / 2.0, 0.5);
    }

    @Override
    public double getDistanceConflictWeight(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict c) {
        if (c.getR1().getPriority() < c.getR2().getPriority()) {
            return (1.0 - this.iDistConfWeight) * this.getWeight(assignment, c.getE1());
        }
        return (1.0 - this.iDistConfWeight) * this.getWeight(assignment, c.getE2());
    }

    @Override
    public double getTimeOverlapConflictWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, TimeOverlapsCounter.Conflict timeOverlap) {
        return Math.min(0.5 * (double)timeOverlap.getShare() / (double)enrollment.getNrSlots(), 0.5) * this.getWeight(assignment, enrollment);
    }

    @Override
    public boolean isBetterThanBestSolution(Solution<Request, Enrollment> currentSolution) {
        if (currentSolution.getBestInfo() == null) {
            return true;
        }
        int unassigned = currentSolution.getModel().nrUnassignedVariables(currentSolution.getAssignment());
        if (currentSolution.getModel().getBestUnassignedVariables() != unassigned) {
            return currentSolution.getModel().getBestUnassignedVariables() > unassigned;
        }
        return currentSolution.getModel().getTotalValue(currentSolution.getAssignment()) < currentSolution.getBestValue();
    }

    public static void main(String[] args) {
        HashSet<DistanceConflict.Conflict> dc;
        Enrollment e;
        HashSet<Section> sections;
        Config cfg;
        int i;
        double[] w;
        CourseRequest cr;
        OriginalStudentWeights pw = new OriginalStudentWeights(new DataProperties());
        DecimalFormat df = new DecimalFormat("0.000");
        Student s = new Student(0L);
        new CourseRequest(1L, 0, false, s, ToolBox.toList(new Course(1L, "A", "1", new Offering(0L, "A")), new Course(1L, "A", "2", new Offering(0L, "A")), new Course(1L, "A", "3", new Offering(0L, "A"))), false, null);
        new CourseRequest(2L, 1, false, s, ToolBox.toList(new Course(1L, "B", "1", new Offering(0L, "B")), new Course(1L, "B", "2", new Offering(0L, "B")), new Course(1L, "B", "3", new Offering(0L, "B"))), false, null);
        new CourseRequest(3L, 2, false, s, ToolBox.toList(new Course(1L, "C", "1", new Offering(0L, "C")), new Course(1L, "C", "2", new Offering(0L, "C")), new Course(1L, "C", "3", new Offering(0L, "C"))), false, null);
        new CourseRequest(4L, 3, false, s, ToolBox.toList(new Course(1L, "D", "1", new Offering(0L, "D")), new Course(1L, "D", "2", new Offering(0L, "D")), new Course(1L, "D", "3", new Offering(0L, "D"))), false, null);
        new CourseRequest(5L, 4, false, s, ToolBox.toList(new Course(1L, "E", "1", new Offering(0L, "E")), new Course(1L, "E", "2", new Offering(0L, "E")), new Course(1L, "E", "3", new Offering(0L, "E"))), false, null);
        new CourseRequest(6L, 5, true, s, ToolBox.toList(new Course(1L, "F", "1", new Offering(0L, "F")), new Course(1L, "F", "2", new Offering(0L, "F")), new Course(1L, "F", "3", new Offering(0L, "F"))), false, null);
        new CourseRequest(7L, 6, true, s, ToolBox.toList(new Course(1L, "G", "1", new Offering(0L, "G")), new Course(1L, "G", "2", new Offering(0L, "G")), new Course(1L, "G", "3", new Offering(0L, "G"))), false, null);
        DefaultSingleAssignment<Request, Enrollment> assignment = new DefaultSingleAssignment<Request, Enrollment>();
        Placement p = new Placement(null, new TimeLocation(1, 90, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList<RoomLocation>());
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet<Section>();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections, assignment);
                w[i] = pw.getWeight(assignment, e, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With one distance conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections, assignment);
                dc = new HashSet<DistanceConflict.Conflict>();
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, (Section)sections.iterator().next()));
                w[i] = pw.getWeight(assignment, e, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With two distance conflicts:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections, assignment);
                dc = new HashSet();
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, (Section)sections.iterator().next()));
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null)));
                w[i] = pw.getWeight(assignment, e, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With 25% time overlapping conflicts:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections, assignment);
                HashSet<TimeOverlapsCounter.Conflict> toc = new HashSet<TimeOverlapsCounter.Conflict>();
                toc.add(new TimeOverlapsCounter.Conflict(s, 3, e, (SctAssignment)sections.iterator().next(), e, (SctAssignment)sections.iterator().next()));
                w[i] = pw.getWeight(assignment, e, null, toc);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
    }

    @Override
    public boolean isFreeTimeAllowOverlaps() {
        return true;
    }
}

