/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class Choice {
    private Offering iOffering = null;
    private String iInstructionalType = null;
    private TimeLocation iTime = null;
    private String iInstructorIds = null;
    private String iInstructorNames = null;
    private int iHashCode;

    public Choice(Offering offering, String instructionalType, TimeLocation time, String instructorIds, String instructorNames) {
        this.iOffering = offering;
        this.iInstructionalType = instructionalType;
        this.iTime = time;
        this.iInstructorIds = instructorIds;
        this.iInstructorNames = instructorNames;
        this.iHashCode = this.getId().hashCode();
    }

    public Choice(Offering offering, String choiceId) {
        this.iOffering = offering;
        this.iInstructionalType = choiceId.substring(0, choiceId.indexOf(124));
        choiceId = choiceId.substring(choiceId.indexOf(124) + 1);
        String timeId = null;
        if (choiceId.indexOf(124) < 0) {
            timeId = choiceId;
        } else {
            timeId = choiceId.substring(0, choiceId.indexOf(124));
            this.iInstructorIds = choiceId.substring(choiceId.indexOf(124) + 1);
        }
        if (timeId != null && timeId.length() > 0) {
            StringTokenizer s = new StringTokenizer(timeId, ":");
            int dayCode = Integer.parseInt(s.nextToken());
            int startSlot = Integer.parseInt(s.nextToken());
            int length = Integer.parseInt(s.nextToken());
            Long datePatternId = s.hasMoreElements() ? Long.valueOf(s.nextToken()) : null;
            this.iTime = new TimeLocation(dayCode, startSlot, length, 0, 0.0, datePatternId, "N/A", new BitSet(), 0);
        }
        this.iHashCode = this.getId().hashCode();
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public String getInstructionalType() {
        return this.iInstructionalType;
    }

    public TimeLocation getTime() {
        return this.iTime;
    }

    public boolean sameTime(Choice choice) {
        return this.getInstructionalType().equals(choice.getInstructionalType()) && (this.getTime() == null ? choice.getTime() == null : this.getTime().equals(choice.getTime()));
    }

    public String getInstructorIds() {
        return this.iInstructorIds;
    }

    public String getInstructorNames() {
        return this.iInstructorNames;
    }

    public void setInstructor(String instructorIds, String instructorNames) {
        this.iInstructorIds = instructorIds;
        this.iInstructorNames = instructorNames;
    }

    public String getId() {
        String ret = this.getInstructionalType() + "|";
        if (this.getTime() != null) {
            ret = ret + this.getTime().getDayCode() + ":" + this.getTime().getStartSlot() + ":" + this.getTime().getLength() + (this.getTime().getDatePatternId() == null ? "" : ":" + this.getTime().getDatePatternId());
        }
        if (this.getInstructorIds() != null) {
            ret = ret + "|" + this.getInstructorIds();
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Choice)) {
            return false;
        }
        return ((Choice)o).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.iHashCode;
    }

    public Set<Section> getSections() {
        HashSet<Section> sections = new HashSet<Section>();
        for (Config config : this.getOffering().getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                if (!subpart.getInstructionalType().equals(this.getInstructionalType())) continue;
                for (Section section : subpart.getSections()) {
                    if (!section.getChoice().equals(this)) continue;
                    sections.add(section);
                }
            }
        }
        return sections;
    }

    public Set<Section> getParentSections() {
        HashSet<Section> parentSections = new HashSet<Section>();
        for (Config config : this.getOffering().getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                if (!subpart.getInstructionalType().equals(this.getInstructionalType()) || subpart.getParent() == null) continue;
                for (Section section : subpart.getSections()) {
                    if (!section.getChoice().equals(this) || section.getParent() == null) continue;
                    parentSections.add(section.getParent());
                }
            }
        }
        return parentSections;
    }

    public String getName() {
        return this.getOffering().getSubparts(this.getInstructionalType()).iterator().next().getName() + " " + (this.getTime() == null ? "" : this.getTime().getLongName(true)) + (this.getInstructorIds() == null ? "" : (this.getInstructorNames() != null ? " " + this.getInstructorNames() : " " + this.getInstructorIds()));
    }

    public String toString() {
        return this.getName();
    }
}

