/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.heuristics.selection.ProblemStudentsProvider;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceRealFirstOrder;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class SwapStudentSelection
implements NeighbourSelection<Request, Enrollment>,
ProblemStudentsProvider {
    private static Logger sLog = Logger.getLogger(SwapStudentSelection.class);
    private Set<Student> iProblemStudents = Collections.synchronizedSet(new HashSet());
    private Queue<Student> iStudents = null;
    private int iTimeout = 5000;
    private int iMaxValues = 100;
    public static boolean sDebug = false;
    protected StudentOrder iOrder = new StudentChoiceRealFirstOrder();

    public SwapStudentSelection(DataProperties properties) {
        this.iTimeout = properties.getPropertyInt("Neighbour.SwapStudentsTimeout", this.iTimeout);
        this.iMaxValues = properties.getPropertyInt("Neighbour.SwapStudentsMaxValues", this.iMaxValues);
        if (properties.getProperty("Neighbour.SwapStudentsOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.SwapStudentsOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error("Unable to set student order, reason:" + e.getMessage(), e);
            }
        }
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        List<Student> students = this.iOrder.order(((StudentSectioningModel)solver.currentSolution().getModel()).getStudents());
        this.iStudents = new LinkedList<Student>(students);
        this.iProblemStudents.clear();
        Progress.getInstance(solver.currentSolution().getModel()).setPhase("Student swap...", students.size());
    }

    protected synchronized Student nextStudent() {
        return this.iStudents.poll();
    }

    protected synchronized void addStudent(Student student) {
        this.iStudents.add(student);
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        while ((student = this.nextStudent()) != null) {
            Progress.getInstance(solution.getModel()).incProgress();
            if (student.isComplete(solution.getAssignment()) || student.nrAssignedRequests(solution.getAssignment()) == 0) continue;
            Selection selection = this.getSelection(solution.getAssignment(), student);
            SwapStudentNeighbour neighbour = selection.select();
            if (neighbour != null) {
                this.addStudent(student);
                return neighbour;
            }
            this.iProblemStudents.addAll(selection.getProblemStudents());
        }
        return null;
    }

    @Override
    public Set<Student> getProblemStudents() {
        return this.iProblemStudents;
    }

    public Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        return new Selection(student, assignment);
    }

    public static Enrollment bestSwap(Assignment<Request, Enrollment> assignment, Enrollment conflict, Enrollment enrl, Set<Student> problematicStudents) {
        Enrollment bestEnrollment = null;
        double bestValue = 0.0;
        for (Enrollment enrollment : conflict.getRequest().values(assignment)) {
            if (((Request)conflict.variable()).getModel().inConflict(assignment, enrollment)) continue;
            double value = enrollment.toDouble(assignment);
            if (bestEnrollment != null && !(bestValue > value)) continue;
            bestEnrollment = enrollment;
            bestValue = value;
        }
        if (bestEnrollment == null && problematicStudents != null) {
            boolean added = false;
            for (Enrollment enrollment : conflict.getRequest().values(assignment)) {
                Set<Enrollment> conflicts = ((Request)conflict.variable()).getModel().conflictValues(assignment, enrollment);
                for (Enrollment c : conflicts) {
                    if (enrl.getStudent().isDummy() && !c.getStudent().isDummy() || enrl.getStudent().equals(c.getStudent()) || conflict.getStudent().equals(c.getStudent())) continue;
                    problematicStudents.add(c.getStudent());
                }
            }
            if (!added && !enrl.getStudent().equals(conflict.getStudent())) {
                problematicStudents.add(conflict.getStudent());
            }
        }
        return bestEnrollment;
    }

    public static class SwapStudentNeighbour
    implements Neighbour<Request, Enrollment> {
        private double iValue;
        private Enrollment iEnrollment;
        private List<Enrollment> iSwaps;

        public SwapStudentNeighbour(double value, Enrollment enrollment, List<Enrollment> swaps) {
            this.iValue = value;
            this.iEnrollment = enrollment;
            this.iSwaps = swaps;
        }

        @Override
        public double value(Assignment<Request, Enrollment> assignment) {
            return this.iValue;
        }

        @Override
        public void assign(Assignment<Request, Enrollment> assignment, long iteration) {
            assignment.unassign(iteration, (Request)this.iEnrollment.variable());
            for (Enrollment swap : this.iSwaps) {
                assignment.unassign(iteration, (Request)swap.variable());
            }
            assignment.assign(iteration, this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                assignment.assign(iteration, swap);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SwSt{");
            sb.append(" " + this.iEnrollment.getRequest().getStudent());
            sb.append(" (" + this.iValue + ")");
            sb.append("\n " + this.iEnrollment.getRequest());
            sb.append(" " + this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                sb.append("\n " + swap.getRequest());
                sb.append(" -> " + swap);
            }
            sb.append("\n}");
            return sb.toString();
        }

        @Override
        public Map<Request, Enrollment> assignments() {
            HashMap<Request, Enrollment> ret = new HashMap<Request, Enrollment>();
            ret.put((Request)this.iEnrollment.variable(), this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                ret.put((Request)swap.variable(), swap);
            }
            return ret;
        }
    }

    public class Selection {
        private Student iStudent;
        private long iT0;
        private long iT1;
        private boolean iTimeoutReached;
        private Enrollment iBestEnrollment;
        private double iBestValue;
        private Set<Student> iProblemStudents;
        private List<Enrollment> iBestSwaps;
        private Assignment<Request, Enrollment> iAssignment;

        public Selection(Student student, Assignment<Request, Enrollment> assignment) {
            this.iStudent = student;
            this.iAssignment = assignment;
        }

        public SwapStudentNeighbour select() {
            if (sDebug) {
                sLog.debug("select(S" + this.iStudent.getId() + ")");
            }
            this.iT0 = JProf.currentTimeMillis();
            this.iTimeoutReached = false;
            this.iBestEnrollment = null;
            this.iProblemStudents = new HashSet<Student>();
            Double initialValue = null;
            block0: for (Request request : this.iStudent.getRequests()) {
                if (initialValue == null) {
                    initialValue = request.getModel().getTotalValue(this.iAssignment);
                }
                if (SwapStudentSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)SwapStudentSelection.this.iTimeout) {
                    if (this.iTimeoutReached) break;
                    if (sDebug) {
                        sLog.debug("  -- timeout reached");
                    }
                    this.iTimeoutReached = true;
                    break;
                }
                if (this.iAssignment.getValue(request) != null || !this.iStudent.canAssign(this.iAssignment, request)) continue;
                if (sDebug) {
                    sLog.debug("  -- checking request " + request);
                }
                List<Enrollment> values = null;
                values = SwapStudentSelection.this.iMaxValues > 0 && request instanceof CourseRequest ? ((CourseRequest)request).computeRandomEnrollments(this.iAssignment, SwapStudentSelection.this.iMaxValues) : request.values(this.iAssignment);
                for (Enrollment enrollment : values) {
                    Set<Enrollment> conflicts;
                    if (SwapStudentSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)SwapStudentSelection.this.iTimeout) {
                        if (this.iTimeoutReached) continue block0;
                        if (sDebug) {
                            sLog.debug("  -- timeout reached");
                        }
                        this.iTimeoutReached = true;
                        continue block0;
                    }
                    if (sDebug) {
                        sLog.debug("      -- enrollment " + enrollment);
                    }
                    if ((conflicts = ((Request)enrollment.variable()).getModel().conflictValues(this.iAssignment, enrollment)).contains(enrollment)) continue;
                    double bound = enrollment.toDouble(this.iAssignment);
                    for (Enrollment conflict : conflicts) {
                        bound += ((Request)conflict.variable()).getBound();
                    }
                    if (this.iBestEnrollment != null && bound >= this.iBestValue) continue;
                    for (Enrollment conflict : conflicts) {
                        this.iAssignment.unassign(0L, (Request)conflict.variable());
                    }
                    this.iAssignment.assign(0L, enrollment);
                    boolean allResolved = true;
                    ArrayList<Enrollment> swaps = new ArrayList<Enrollment>(conflicts.size());
                    for (Enrollment conflict : conflicts) {
                        Enrollment other;
                        if (sDebug) {
                            sLog.debug("        -- conflict " + conflict);
                        }
                        if ((other = SwapStudentSelection.bestSwap(this.iAssignment, conflict, enrollment, this.iProblemStudents)) == null) {
                            if (sDebug) {
                                sLog.debug("          -- unable to resolve");
                            }
                            allResolved = false;
                            break;
                        }
                        this.iAssignment.assign(0L, other);
                        swaps.add(other);
                        if (!sDebug) continue;
                        sLog.debug("          -- can be resolved by switching to " + other.getName());
                    }
                    double value = request.getModel().getTotalValue(this.iAssignment) - initialValue;
                    for (Enrollment other : swaps) {
                        this.iAssignment.unassign(0L, (Request)other.variable());
                    }
                    this.iAssignment.unassign(0L, (Request)enrollment.variable());
                    for (Enrollment conflict : conflicts) {
                        this.iAssignment.assign(0L, conflict);
                    }
                    if (!allResolved || !(value <= 0.0) || this.iBestEnrollment != null && !(this.iBestValue > value)) continue;
                    this.iBestEnrollment = enrollment;
                    this.iBestValue = value;
                    this.iBestSwaps = swaps;
                }
            }
            this.iT1 = JProf.currentTimeMillis();
            if (sDebug) {
                sLog.debug("  -- done, best enrollment is " + this.iBestEnrollment);
            }
            if (this.iBestEnrollment == null) {
                if (this.iProblemStudents.isEmpty()) {
                    this.iProblemStudents.add(this.iStudent);
                }
                if (sDebug) {
                    sLog.debug("  -- problem students are: " + this.iProblemStudents);
                }
                return null;
            }
            if (sDebug) {
                sLog.debug("  -- value " + this.iBestValue);
            }
            Enrollment[] assignment = new Enrollment[this.iStudent.getRequests().size()];
            int idx = 0;
            for (Request request : this.iStudent.getRequests()) {
                assignment[idx++] = this.iBestEnrollment.getRequest().equals(request) ? this.iBestEnrollment : request.getAssignment(this.iAssignment);
            }
            return new SwapStudentNeighbour(this.iBestValue, this.iBestEnrollment, this.iBestSwaps);
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public long getTime() {
            return this.iT1 - this.iT0;
        }

        public Enrollment getBestEnrollment() {
            return this.iBestEnrollment;
        }

        public double getBestValue() {
            return this.iBestValue;
        }

        public Set<Student> getProblemStudents() {
            return this.iProblemStudents;
        }
    }
}

