/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.extension;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ExtensionWithContext;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;

public class TimeOverlapsCounter
extends ExtensionWithContext<Request, Enrollment, TimeOverlapsCounterContext> {
    private static Logger sLog = Logger.getLogger(TimeOverlapsCounter.class);
    public static boolean sDebug = false;

    public TimeOverlapsCounter(Solver<Request, Enrollment> solver, DataProperties properties) {
        super(solver, properties);
        if (solver != null) {
            ((StudentSectioningModel)solver.currentSolution().getModel()).setTimeOverlaps(this);
        }
    }

    public String toString() {
        return "TimeOverlaps";
    }

    public boolean inConflict(SctAssignment a1, SctAssignment a2) {
        if (a1.getTime() == null || a2.getTime() == null) {
            return false;
        }
        if (a1 instanceof Section && a2 instanceof Section && ((Section)a1).isToIgnoreStudentConflictsWith(a2.getId())) {
            return false;
        }
        return a1.getTime().hasIntersection(a2.getTime());
    }

    public int share(SctAssignment a1, SctAssignment a2) {
        if (!this.inConflict(a1, a2)) {
            return 0;
        }
        return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
    }

    public int nrConflicts(Enrollment e1, Enrollment e2) {
        if (!e1.getStudent().equals(e2.getStudent())) {
            return 0;
        }
        if (e1.getRequest() instanceof FreeTimeRequest && e2.getRequest() instanceof FreeTimeRequest) {
            return 0;
        }
        int cnt = 0;
        for (SctAssignment s1 : e1.getAssignments()) {
            for (SctAssignment s2 : e2.getAssignments()) {
                if (!this.inConflict(s1, s2)) continue;
                cnt += this.share(s1, s2);
            }
        }
        return cnt;
    }

    public Set<Conflict> conflicts(Enrollment e1, Enrollment e2) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (!e1.getStudent().equals(e2.getStudent())) {
            return ret;
        }
        if (e1.getRequest() instanceof FreeTimeRequest && e2.getRequest() instanceof FreeTimeRequest) {
            return ret;
        }
        for (SctAssignment s1 : e1.getAssignments()) {
            for (SctAssignment s2 : e2.getAssignments()) {
                if (!this.inConflict(s1, s2)) continue;
                ret.add(new Conflict(e1.getStudent(), this.share(s1, s2), e1, s1, e2, s2));
            }
        }
        return ret;
    }

    public int nrFreeTimeConflicts(Enrollment enrollment) {
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return 0;
        }
        int cnt = 0;
        for (Request request : enrollment.getStudent().getRequests()) {
            if (!(request instanceof FreeTimeRequest)) continue;
            FreeTimeRequest ft = (FreeTimeRequest)request;
            for (SctAssignment section : enrollment.getAssignments()) {
                cnt += this.share(section, ft);
            }
        }
        return cnt;
    }

    public Set<Conflict> freeTimeConflicts(Enrollment enrollment) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return ret;
        }
        for (Request request : enrollment.getStudent().getRequests()) {
            if (!(request instanceof FreeTimeRequest)) continue;
            FreeTimeRequest ft = (FreeTimeRequest)request;
            for (SctAssignment section : enrollment.getAssignments()) {
                if (!this.inConflict(section, ft)) continue;
                ret.add(new Conflict(enrollment.getStudent(), this.share(section, ft), enrollment, section, ft.createEnrollment(), ft));
            }
        }
        return ret;
    }

    public int getTotalNrConflicts(Assignment<Request, Enrollment> assignment) {
        return ((TimeOverlapsCounterContext)this.getContext(assignment)).getTotalNrConflicts();
    }

    public void checkTotalNrConflicts(Assignment<Request, Enrollment> assignment) {
        ((TimeOverlapsCounterContext)this.getContext(assignment)).checkTotalNrConflicts(assignment);
    }

    public Set<Conflict> getAllConflicts(Assignment<Request, Enrollment> assignment) {
        return ((TimeOverlapsCounterContext)this.getContext(assignment)).getAllConflicts();
    }

    @Override
    public void beforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((TimeOverlapsCounterContext)this.getContext(assignment)).beforeAssigned(assignment, iteration, value);
    }

    @Override
    public void afterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((TimeOverlapsCounterContext)this.getContext(assignment)).afterAssigned(assignment, iteration, value);
    }

    @Override
    public void afterUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
        ((TimeOverlapsCounterContext)this.getContext(assignment)).afterUnassigned(assignment, iteration, value);
    }

    public Set<Conflict> allConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return ret;
        }
        for (Request request : enrollment.getStudent().getRequests()) {
            if (request.equals(enrollment.getRequest())) continue;
            Enrollment other = assignment.getValue(request);
            if (request instanceof FreeTimeRequest) {
                FreeTimeRequest ft = (FreeTimeRequest)request;
                ret.addAll(this.conflicts(enrollment, ft.createEnrollment()));
                continue;
            }
            if (other == null) continue;
            ret.addAll(this.conflicts(enrollment, other));
        }
        return ret;
    }

    @Override
    public TimeOverlapsCounterContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new TimeOverlapsCounterContext(assignment);
    }

    public class TimeOverlapsCounterContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private int iTotalNrConflicts = 0;
        private Set<Conflict> iAllConflicts = new HashSet<Conflict>();
        private Request iOldVariable = null;
        private Enrollment iUnassignedValue = null;

        public TimeOverlapsCounterContext(Assignment<Request, Enrollment> assignment) {
            this.iTotalNrConflicts = this.countTotalNrConflicts(assignment);
            if (sDebug) {
                this.iAllConflicts = this.computeAllConflicts(assignment);
            }
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)TimeOverlapsCounter.this.getModel()).getContext((Assignment)assignment);
            for (Conflict c : this.computeAllConflicts(assignment)) {
                cx.add(assignment, c);
            }
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment value) {
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)TimeOverlapsCounter.this.getModel()).getContext((Assignment)assignment);
            for (Conflict c : this.allConflicts(assignment, value)) {
                this.iTotalNrConflicts += c.getShare();
                cx.add(assignment, c);
            }
            if (sDebug) {
                sLog.debug("A:" + value.variable() + " := " + value);
                int inc = this.nrAllConflicts(assignment, value);
                if (inc != 0) {
                    sLog.debug("-- TOC+" + inc + " A: " + value.variable() + " := " + value);
                    for (Conflict c : this.allConflicts(assignment, value)) {
                        sLog.debug("  -- " + c);
                        this.iAllConflicts.add(c);
                        inc -= c.getShare();
                    }
                    if (inc != 0) {
                        sLog.error("Different number of conflicts for the assigned value (difference: " + inc + ")!");
                    }
                }
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment value) {
            StudentSectioningModel.StudentSectioningModelContext cx = (StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)TimeOverlapsCounter.this.getModel()).getContext((Assignment)assignment);
            for (Conflict c : this.allConflicts(assignment, value)) {
                this.iTotalNrConflicts -= c.getShare();
                cx.remove(assignment, c);
            }
            if (sDebug) {
                sLog.debug("U:" + value.variable() + " := " + value);
                int dec = this.nrAllConflicts(assignment, value);
                if (dec != 0) {
                    sLog.debug("-- TOC-" + dec + " U: " + value.variable() + " := " + value);
                    for (Conflict c : this.allConflicts(assignment, value)) {
                        sLog.debug("  -- " + c);
                        this.iAllConflicts.remove(c);
                        dec -= c.getShare();
                    }
                    if (dec != 0) {
                        sLog.error("Different number of conflicts for the unassigned value (difference: " + dec + ")!");
                    }
                }
            }
        }

        public void beforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            if (value != null) {
                Enrollment old = assignment.getValue((Request)value.variable());
                if (old != null) {
                    this.iUnassignedValue = old;
                    this.unassigned(assignment, old);
                }
                this.iOldVariable = (Request)value.variable();
            }
        }

        public void afterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            this.iOldVariable = null;
            this.iUnassignedValue = null;
            if (value != null) {
                this.assigned(assignment, value);
            }
        }

        public void afterUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment value) {
            if (value != null && !value.equals(this.iUnassignedValue)) {
                this.unassigned(assignment, value);
            }
        }

        public Set<Conflict> getAllConflicts() {
            return this.iAllConflicts;
        }

        public int getTotalNrConflicts() {
            return this.iTotalNrConflicts;
        }

        public void checkTotalNrConflicts(Assignment<Request, Enrollment> assignment) {
            int total = this.countTotalNrConflicts(assignment);
            if (total != this.iTotalNrConflicts) {
                sLog.error("Number of conflicts does not match (actual: " + total + ", count: " + this.iTotalNrConflicts + ")!");
                this.iTotalNrConflicts = total;
                if (sDebug) {
                    Set<Conflict> conflicts = this.computeAllConflicts(assignment);
                    for (Conflict c : conflicts) {
                        if (this.iAllConflicts.contains(c)) continue;
                        sLog.debug("  +add+ " + c);
                    }
                    for (Conflict c : this.iAllConflicts) {
                        if (conflicts.contains(c)) continue;
                        sLog.debug("  -rem- " + c);
                    }
                    for (Conflict c : conflicts) {
                        for (Conflict d : this.iAllConflicts) {
                            if (!c.equals(d) || c.getShare() == d.getShare()) continue;
                            sLog.debug("  -dif- " + c + " (other: " + d.getShare() + ")");
                        }
                    }
                    this.iAllConflicts = conflicts;
                }
            }
        }

        public int countTotalNrConflicts(Assignment<Request, Enrollment> assignment) {
            int total = 0;
            for (Request r1 : TimeOverlapsCounter.this.getModel().variables()) {
                Enrollment e1 = assignment.getValue(r1);
                if (e1 == null || r1 instanceof FreeTimeRequest || r1.equals(this.iOldVariable)) continue;
                for (Request r2 : r1.getStudent().getRequests()) {
                    Enrollment e2 = assignment.getValue(r2);
                    if (r2 instanceof FreeTimeRequest) {
                        FreeTimeRequest ft = (FreeTimeRequest)r2;
                        total += TimeOverlapsCounter.this.nrConflicts(e1, ft.createEnrollment());
                        continue;
                    }
                    if (e2 == null || r1.getId() >= r2.getId() || r2.equals(this.iOldVariable)) continue;
                    total += TimeOverlapsCounter.this.nrConflicts(e1, e2);
                }
            }
            return total;
        }

        public Set<Conflict> computeAllConflicts(Assignment<Request, Enrollment> assignment) {
            HashSet<Conflict> ret = new HashSet<Conflict>();
            for (Request r1 : TimeOverlapsCounter.this.getModel().variables()) {
                Enrollment e1 = assignment.getValue(r1);
                if (e1 == null || r1 instanceof FreeTimeRequest || r1.equals(this.iOldVariable)) continue;
                for (Request r2 : r1.getStudent().getRequests()) {
                    Enrollment e2 = assignment.getValue(r2);
                    if (r2 instanceof FreeTimeRequest) {
                        FreeTimeRequest ft = (FreeTimeRequest)r2;
                        ret.addAll(TimeOverlapsCounter.this.conflicts(e1, ft.createEnrollment()));
                        continue;
                    }
                    if (e2 == null || r1.getId() >= r2.getId() || r2.equals(this.iOldVariable)) continue;
                    ret.addAll(TimeOverlapsCounter.this.conflicts(e1, e2));
                }
            }
            return ret;
        }

        public Set<Conflict> allConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            HashSet<Conflict> ret = new HashSet<Conflict>();
            if (enrollment.getRequest() instanceof FreeTimeRequest) {
                return ret;
            }
            for (Request request : enrollment.getStudent().getRequests()) {
                if (request.equals(enrollment.getRequest())) continue;
                if (request instanceof FreeTimeRequest) {
                    FreeTimeRequest ft = (FreeTimeRequest)request;
                    ret.addAll(TimeOverlapsCounter.this.conflicts(enrollment, ft.createEnrollment()));
                    continue;
                }
                if (assignment.getValue(request) == null || request.equals(this.iOldVariable)) continue;
                ret.addAll(TimeOverlapsCounter.this.conflicts(enrollment, assignment.getValue(request)));
            }
            return ret;
        }

        public int nrAllConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (enrollment.getRequest() instanceof FreeTimeRequest) {
                return 0;
            }
            int cnt = 0;
            for (Request request : enrollment.getStudent().getRequests()) {
                if (request.equals(enrollment.getRequest())) continue;
                if (request instanceof FreeTimeRequest) {
                    FreeTimeRequest ft = (FreeTimeRequest)request;
                    cnt += TimeOverlapsCounter.this.nrConflicts(enrollment, ft.createEnrollment());
                    continue;
                }
                if (assignment.getValue(request) == null || request.equals(this.iOldVariable)) continue;
                cnt += TimeOverlapsCounter.this.nrConflicts(enrollment, assignment.getValue(request));
            }
            return cnt;
        }
    }

    public static class Conflict {
        private int iShare;
        private Student iStudent;
        private SctAssignment iA1;
        private SctAssignment iA2;
        private Enrollment iE1;
        private Enrollment iE2;
        private int iHashCode;

        public Conflict(Student student, int share, Enrollment e1, SctAssignment a1, Enrollment e2, SctAssignment a2) {
            this.iStudent = student;
            if (a1.compareById(a2) < 0) {
                this.iA1 = a1;
                this.iA2 = a2;
                this.iE1 = e1;
                this.iE2 = e2;
            } else {
                this.iA1 = a2;
                this.iA2 = a1;
                this.iE1 = e2;
                this.iE2 = e1;
            }
            this.iHashCode = (this.iStudent.getId() + ":" + this.iA1.getId() + ":" + this.iA2.getId()).hashCode();
            this.iShare = share;
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public SctAssignment getS1() {
            return this.iA1;
        }

        public SctAssignment getS2() {
            return this.iA2;
        }

        public Request getR1() {
            return this.iE1.getRequest();
        }

        public Request getR2() {
            return this.iE2.getRequest();
        }

        public Enrollment getE1() {
            return this.iE1;
        }

        public Enrollment getE2() {
            return this.iE2;
        }

        public int hashCode() {
            return this.iHashCode;
        }

        public int getShare() {
            return this.iShare;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Conflict)) {
                return false;
            }
            Conflict c = (Conflict)o;
            return this.getStudent().equals(c.getStudent()) && this.getS1().equals(c.getS1()) && this.getS2().equals(c.getS2());
        }

        public String toString() {
            return this.getStudent() + ": (s:" + this.getShare() + ") " + this.getS1() + " -- " + this.getS2();
        }
    }
}

