/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class ConfigLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;

    public ConfigLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("ConfigLimit.PreferDummyStudents", false);
    }

    public static double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Config config, Request request) {
        return config.getEnrollmentWeight(assignment, request) + request.getWeight() - Math.max(config.getMaxEnrollmentWeight(assignment), request.getWeight()) + sNominalWeight;
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return;
        }
        if (config.getLimit() < 0) {
            return;
        }
        double enrlWeight = ConfigLimit.getEnrollmentWeight(assignment, config, enrollment.getRequest());
        if (enrlWeight <= (double)config.getLimit()) {
            return;
        }
        ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(config.getEnrollments(assignment).size());
        for (Enrollment e : config.getEnrollments(assignment)) {
            if (e.getRequest().equals(enrollment.getRequest())) continue;
            if (conflicts.contains(e)) {
                enrlWeight -= e.getRequest().getWeight();
                continue;
            }
            adepts.add(e);
        }
        while (enrlWeight > (double)config.getLimit()) {
            if (adepts.isEmpty()) {
                conflicts.add(enrollment);
                return;
            }
            ArrayList<Enrollment> best = new ArrayList<Enrollment>();
            boolean bestDummy = false;
            double bestValue = 0.0;
            boolean bestRes = true;
            for (Enrollment adept : adepts) {
                boolean res;
                boolean dummy = adept.getStudent().isDummy();
                double value = adept.toDouble(assignment, false);
                boolean bl = res = adept.getReservation() != null;
                if (this.iPreferDummyStudents && dummy != bestDummy) {
                    if (!dummy) continue;
                    best.clear();
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    bestRes = res;
                    continue;
                }
                if (bestRes != res) {
                    if (res) continue;
                    best.clear();
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    bestRes = res;
                    continue;
                }
                if (best.isEmpty() || value > bestValue) {
                    if (best.isEmpty()) {
                        best.clear();
                    }
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    bestRes = res;
                    continue;
                }
                if (bestValue != value) continue;
                best.add(adept);
            }
            Enrollment conflict = (Enrollment)ToolBox.random(best);
            adepts.remove(conflict);
            enrlWeight -= conflict.getRequest().getWeight();
            conflicts.add(conflict);
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return false;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (config.getLimit() < 0) {
            return false;
        }
        double enrlWeight = ConfigLimit.getEnrollmentWeight(assignment, config, enrollment.getRequest());
        return enrlWeight > (double)config.getLimit();
    }

    public String toString() {
        return "ConfigLimit";
    }
}

