/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.ifs.util.DataProperties;

public class ToolBox {
    private static long sSeed = System.currentTimeMillis();
    private static Random sRandom = new Random(sSeed);

    public static int random(int limit) {
        return (int)(ToolBox.random() * (double)limit);
    }

    public static <E> E random(Collection<E> set) {
        switch (set == null ? 0 : set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return set.iterator().next();
            }
            case 2: {
                Iterator<E> i = set.iterator();
                if (sRandom.nextBoolean()) {
                    i.next();
                }
                return i.next();
            }
        }
        List v = set instanceof List ? (List)set : new ArrayList<E>(set);
        return v.get(ToolBox.random(v.size()));
    }

    public static <E> Collection<E> subSet(Collection<E> set, double part) {
        return ToolBox.subSet(set, part, 1);
    }

    private static <E> void swap(List<E> list, int first, int second) {
        E o = list.get(first);
        list.set(first, list.get(second));
        list.set(second, o);
    }

    public static <E> Collection<E> subSet(Collection<E> set, double part, int minSize) {
        if (set.size() <= minSize || part >= 1.0) {
            return set;
        }
        ArrayList<E> subSet = new ArrayList<E>(set);
        int size = set.size();
        int numberToSelect = Math.max(minSize, (int)(part * (double)set.size()));
        for (int idx = 0; idx < numberToSelect; ++idx) {
            ToolBox.swap(subSet, idx, idx + (int)(ToolBox.random() * (double)(size - idx)));
        }
        return subSet.subList(0, numberToSelect);
    }

    public static String trim(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < length) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String col2string(Collection<?> col, int tab) {
        StringBuffer tabsb = new StringBuffer();
        while (tabsb.length() < 2 * tab) {
            tabsb.append("  ");
        }
        StringBuffer sb = new StringBuffer("[\n");
        Iterator<?> i = col.iterator();
        while (i.hasNext()) {
            sb.append(tabsb + "  " + i.next() + (i.hasNext() ? "," : "") + "\n");
        }
        sb.append(tabsb + "]");
        return sb.toString();
    }

    public static <K, V> String dict2string(Map<K, V> dict, int tab) {
        StringBuffer tabsb = new StringBuffer();
        while (tabsb.length() < 2 * tab) {
            tabsb.append("  ");
        }
        StringBuffer sb = new StringBuffer("[\n");
        TreeSet<K> keys = new TreeSet<K>(dict.keySet());
        for (K key : keys) {
            V value = dict.get(key);
            sb.append(tabsb + "  " + key + ": " + value + "\n");
        }
        sb.append(tabsb + "]");
        return sb.toString();
    }

    public static double rms(int n, double x, double x2) {
        double var = x2 / (double)n;
        double mean = x / (double)n;
        return Math.sqrt(Math.abs(var - mean * mean));
    }

    public static <E> void merge(List<E> target, Collection<E> source) {
        for (E o : source) {
            if (target.contains(o)) continue;
            target.add(o);
        }
    }

    public static <E> List<E> intersect(Collection<E> source1, Collection<E> source2) {
        ArrayList<E> target = new ArrayList<E>();
        for (E o : source1) {
            if (source2.contains(o)) continue;
            target.add(o);
        }
        return target;
    }

    public static void setSeed(long seed) {
        sSeed = seed;
        sRandom = new Random(sSeed);
    }

    public static long getSeed() {
        return sSeed;
    }

    public static Random getRandom() {
        return sRandom;
    }

    public static double random() {
        return sRandom.nextDouble();
    }

    public static void configureLogging() {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
        props.setProperty("log4j.logger.net", "INFO");
        props.setProperty("log4j.logger.org.cpsolver", "DEBUG");
        props.setProperty("log4j.logger.org", "INFO");
        PropertyConfigurator.configure(props);
    }

    public static String configureLogging(String logDir, Properties properties) {
        return ToolBox.configureLogging(logDir, properties, false);
    }

    public static String configureLogging(String logDir, Properties properties, boolean timeInFileName) {
        return ToolBox.configureLogging(logDir, properties, timeInFileName, true);
    }

    public static String configureLogging(String logDir, Properties properties, boolean timeInFileName, boolean includeSystemOuts) {
        Properties props;
        String time = new SimpleDateFormat("yyyy-MM-dd_(HH.mm.ss)", Locale.US).format(new Date());
        new File(logDir).mkdirs();
        String fileName = logDir + File.separator + (timeInFileName ? "debug_" + time : "debug") + ".log";
        Properties properties2 = props = properties != null ? properties : new Properties();
        if (!props.containsKey("log4j.rootLogger")) {
            props.setProperty("log4j.rootLogger", "debug, LogFile");
            if (timeInFileName) {
                props.setProperty("log4j.appender.LogFile", "org.apache.log4j.FileAppender");
            } else {
                props.setProperty("log4j.appender.LogFile", "org.apache.log4j.DailyRollingFileAppender");
                props.setProperty("log4j.appender.LogFile.DatePattern", "'.'yyyy-MM-dd");
            }
            props.setProperty("log4j.appender.LogFile.File", fileName);
            props.setProperty("log4j.appender.LogFile.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.LogFile.layout.ConversionPattern", "%d{dd-MMM-yy HH:mm:ss.SSS} [%t] %-5p %c{2}> %m%n");
        }
        PropertyConfigurator.configure(props);
        Logger log = Logger.getRootLogger();
        log.info("-----------------------------------------------------------------------");
        log.info("IFS debug file");
        log.info("");
        log.info("Created: " + new Date());
        log.info("");
        log.info("System info:");
        log.info("System:      " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        log.info("CPU:         " + System.getProperty("sun.cpu.isalist") + " endian:" + System.getProperty("sun.cpu.endian") + " encoding:" + System.getProperty("sun.io.unicode.encoding"));
        log.info("Java:        " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version")));
        log.info("User:        " + System.getProperty("user.name"));
        log.info("Timezone:    " + System.getProperty("user.timezone"));
        log.info("Working dir: " + System.getProperty("user.dir"));
        log.info("Classpath:   " + System.getProperty("java.class.path"));
        log.info("");
        if (includeSystemOuts) {
            System.setErr(new PrintStream(new LogOutputStream(System.err, Logger.getLogger("STDERR"), Level.ERROR)));
            System.setOut(new PrintStream(new LogOutputStream(System.out, Logger.getLogger("STDOUT"), Level.DEBUG)));
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataProperties loadProperties(File propertyFile) {
        FileInputStream is = null;
        try {
            DataProperties ret = new DataProperties();
            is = new FileInputStream(propertyFile);
            ret.load(is);
            is.close();
            is = null;
            if (ret.getProperty("INCLUDE") != null) {
                StringTokenizer stk = new StringTokenizer(ret.getProperty("INCLUDE"), ";");
                while (stk.hasMoreTokens()) {
                    String aFile = stk.nextToken();
                    System.out.println("  Loading included file '" + aFile + "' ... ");
                    if (new File(aFile).exists()) {
                        is = new FileInputStream(aFile);
                    }
                    if (new File(propertyFile.getParent() + File.separator + aFile).exists()) {
                        is = new FileInputStream(propertyFile.getParent() + File.separator + aFile);
                    }
                    if (is == null) {
                        System.err.println("Unable to find include file '" + aFile + "'.");
                    }
                    ret.load(is);
                    is.close();
                    is = null;
                }
                ret.remove("INCLUDE");
            }
            DataProperties dataProperties = ret;
            return dataProperties;
        }
        catch (Exception e) {
            System.err.println("Unable to load property file " + propertyFile);
            e.printStackTrace();
            DataProperties dataProperties = new DataProperties();
            return dataProperties;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <E> List<E> toList(E ... obj) {
        ArrayList<E> ret = new ArrayList<E>(obj == null ? 0 : obj.length);
        if (obj != null) {
            for (E e : obj) {
                ret.add(e);
            }
        }
        return ret;
    }

    public static long binomial(int N, int K) {
        long ret = 1L;
        for (int k = 0; k < K; ++k) {
            ret = ret * (long)(N - k) / (long)(k + 1);
        }
        return ret;
    }

    public static <E> Set<E> sample(List<E> items, int m) {
        HashSet<E> res = new HashSet<E>(m);
        int n = items.size();
        for (int i = n - m; i < n; ++i) {
            int pos = ToolBox.getRandom().nextInt(i + 1);
            E item = items.get(pos);
            if (res.contains(item)) {
                res.add(items.get(i));
                continue;
            }
            res.add(item);
        }
        return res;
    }

    public static <E> List<E> permutation(List<E> items, int m, long id) {
        ArrayList<E> ret = new ArrayList<E>();
        int n = items.size();
        int p = -1;
        for (int i = 0; i < m - 1; ++i) {
            long r = ToolBox.binomial(n - ++p - 1, m - i - 1);
            while (r <= id) {
                id -= r;
                r = ToolBox.binomial(n - ++p - 1, m - i - 1);
            }
            ret.add(items.get(p));
        }
        ret.add(items.get(p + 1 + (int)id));
        return ret;
    }

    public static <E> Enumeration<Collection<E>> sample(final List<E> items, final int m, final int count) {
        final long limit = ToolBox.binomial(items.size(), m);
        if ((long)count >= limit) {
            return ToolBox.permutations(items, m);
        }
        return new Enumeration<Collection<E>>(){
            int el = 0;
            Set<Long> used = new HashSet<Long>();

            @Override
            public boolean hasMoreElements() {
                return this.el < count && (long)this.el < limit;
            }

            @Override
            public Set<E> nextElement() {
                HashSet res;
                long fp;
                int n = items.size();
                do {
                    res = new HashSet(m);
                    TreeSet<Integer> ids = new TreeSet<Integer>();
                    for (int i = n - m; i < n; ++i) {
                        int pos = ToolBox.getRandom().nextInt(i + 1);
                        Object item = items.get(pos);
                        if (res.contains(item)) {
                            res.add(items.get(i));
                            ids.add(i);
                            continue;
                        }
                        res.add(item);
                        ids.add(pos);
                    }
                    fp = 0L;
                    for (Integer id : ids) {
                        fp = (long)n * fp + (long)id.intValue();
                    }
                } while (!this.used.add(fp));
                ++this.el;
                return res;
            }
        };
    }

    public static <E> Enumeration<Collection<E>> permutations(final List<E> items, final int m) {
        return new Enumeration<Collection<E>>(){
            int n;
            int[] p;
            {
                this.n = items.size();
                this.p = null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.p == null || this.p[0] < this.n - m;
            }

            @Override
            public Collection<E> nextElement() {
                int i;
                if (this.p == null) {
                    this.p = new int[m];
                    for (i = 0; i < m; ++i) {
                        this.p[i] = i;
                    }
                } else {
                    for (i = m - 1; i >= 0; --i) {
                        this.p[i] = this.p[i] + 1;
                        for (int j = i + 1; j < m; ++j) {
                            this.p[j] = this.p[j - 1] + 1;
                        }
                        if (i != 0 && this.p[i] > this.n - (m - i)) {
                            continue;
                        }
                        break;
                    }
                }
                ArrayList ret = new ArrayList();
                for (int i2 = 0; i2 < m; ++i2) {
                    ret.add(items.get(this.p[i2]));
                }
                return ret;
            }
        };
    }

    private static <E> Enumeration<Collection<E>> sample(final List<E> items1, final int m1, final List<E> items2, final int m2, final int count) {
        long c2;
        long c1 = ToolBox.binomial(items1.size(), m1);
        final long limit = c1 * (c2 = ToolBox.binomial(items2.size(), m2));
        if (limit <= 10L * (long)count && 10L * (long)count < Integer.MAX_VALUE) {
            return new Enumeration<Collection<E>>(){
                Set<Integer> used = new HashSet<Integer>();

                @Override
                public boolean hasMoreElements() {
                    return this.used.size() < count && (long)this.used.size() < limit;
                }

                @Override
                public Collection<E> nextElement() {
                    int id;
                    while (!this.used.add(id = ToolBox.getRandom().nextInt((int)limit))) {
                    }
                    ArrayList res = new ArrayList(m1 + m2);
                    if (m1 > 0) {
                        res.addAll(ToolBox.permutation(items1, m1, (long)id / c2));
                    }
                    if (m2 > 0) {
                        res.addAll(ToolBox.permutation(items2, m2, (long)id % c2));
                    }
                    return res;
                }
            };
        }
        return new Enumeration<Collection<E>>(){
            int n1;
            int n2;
            int el;
            Set<Long> used;
            {
                this.n1 = items1.size();
                this.n2 = items2.size();
                this.el = 0;
                this.used = new HashSet<Long>();
            }

            @Override
            public boolean hasMoreElements() {
                return this.el < count && (long)this.el < limit;
            }

            @Override
            public Collection<E> nextElement() {
                HashSet res;
                long fp;
                do {
                    int i;
                    res = new HashSet(m1 + m2);
                    TreeSet<Integer> ids1 = new TreeSet<Integer>();
                    if (m1 == this.n1) {
                        res.addAll(items1);
                    } else if (m1 + 1 == this.n1) {
                        int pos = ToolBox.getRandom().nextInt(this.n1);
                        for (i = 0; i < this.n1; ++i) {
                            if (i == pos) continue;
                            res.add(items1.get(i));
                        }
                        ids1.add(pos);
                    } else {
                        for (int i2 = this.n1 - m1; i2 < this.n1; ++i2) {
                            int pos = ToolBox.getRandom().nextInt(i2 + 1);
                            Object item = items1.get(pos);
                            if (res.contains(item)) {
                                res.add(items1.get(i2));
                                ids1.add(i2);
                                continue;
                            }
                            res.add(item);
                            ids1.add(pos);
                        }
                    }
                    TreeSet<Integer> ids2 = new TreeSet<Integer>();
                    if (m2 == this.n2) {
                        res.addAll(items2);
                    } else if (m2 + 1 == this.n2) {
                        int pos = ToolBox.getRandom().nextInt(this.n2);
                        for (int i3 = 0; i3 < this.n2; ++i3) {
                            if (i3 == pos) continue;
                            res.add(items2.get(i3));
                        }
                        ids2.add(pos);
                    } else {
                        for (i = this.n2 - m2; i < this.n2; ++i) {
                            int pos = ToolBox.getRandom().nextInt(i + 1);
                            Object item = items2.get(pos);
                            if (res.contains(item)) {
                                res.add(items2.get(i));
                                ids2.add(this.n1 + i);
                                continue;
                            }
                            res.add(item);
                            ids2.add(this.n1 + pos);
                        }
                    }
                    fp = 0L;
                    for (Integer id : ids1) {
                        fp = (long)this.n1 * fp + (long)id.intValue();
                    }
                    for (Integer id : ids2) {
                        fp = (long)this.n2 * fp + (long)id.intValue();
                    }
                } while (!this.used.add(fp));
                ++this.el;
                return res;
            }
        };
    }

    public static <E> Enumeration<Collection<E>> sample(final List<E> preferred, final List<E> additional, final int m, final int count) {
        return new Enumeration<Collection<E>>(){
            long limit;
            int k;
            int el;
            Enumeration<Collection<E>> e;
            {
                this.limit = Math.min((long)count, ToolBox.binomial(preferred.size() + additional.size(), m));
                this.k = Math.min(m, preferred.size());
                this.el = 0;
                this.e = ToolBox.sample(preferred, this.k, additional, m - this.k, count);
            }

            @Override
            public boolean hasMoreElements() {
                return (long)this.el < this.limit;
            }

            @Override
            public Collection<E> nextElement() {
                if (this.e.hasMoreElements()) {
                    ++this.el;
                    return this.e.nextElement();
                }
                this.k = Math.max(Math.min(this.k - 1, preferred.size() - 1), 0);
                this.e = ToolBox.sample(preferred, this.k, additional, m - this.k, count);
                ++this.el;
                return this.e.nextElement();
            }
        };
    }

    private static class LogOutputStream
    extends OutputStream {
        private Logger iLogger = null;
        private Level iLevel = null;
        private OutputStream iOldOutputStream;
        private ByteArrayOutputStream iOut = new ByteArrayOutputStream();

        public LogOutputStream(OutputStream oldOutputStream, Logger logger, Level level) {
            this.iLogger = logger;
            this.iLevel = level;
            this.iOldOutputStream = oldOutputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.iOldOutputStream.write(b);
            if (b == 13) {
                return;
            }
            if (b == 10) {
                this.iOut.flush();
                this.iLogger.log(this.iLevel, new String(this.iOut.toByteArray()));
                this.iOut.reset();
            } else {
                this.iOut.write(b);
            }
        }
    }
}

