/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.util.HashSet;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparable;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.IdGenerator;

public class Value<V extends Variable<V, T>, T extends Value<V, T>>
implements Comparable<T>,
AssignmentComparable<T, V, T> {
    private static IdGenerator sIdGenerator = new IdGenerator();
    private long iId = sIdGenerator.newId();
    private V iVariable = null;
    protected double iValue = 0.0;
    private Object iExtra = null;

    public Value(V variable) {
        this.iVariable = variable;
    }

    public Value(V variable, double value) {
        this.iVariable = variable;
        this.iValue = value;
    }

    public V variable() {
        return this.iVariable;
    }

    public void setVariable(Variable variable) {
        this.iVariable = variable;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public double toDouble(Assignment<V, T> assignment) {
        return this.iValue;
    }

    @Deprecated
    public double toDouble() {
        return this.iValue;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public boolean valueEquals(Assignment<V, T> assignment, T value) {
        if (value == null) {
            return false;
        }
        return this.toDouble(assignment) == ((Value)value).toDouble(assignment);
    }

    @Deprecated
    public boolean valueEquals(T value) {
        return this.valueEquals(((Variable)this.variable()).getModel().getDefaultAssignment(), value);
    }

    @Override
    public int compareTo(Assignment<V, T> assignment, T value) {
        if (value == null) {
            return -1;
        }
        int cmp = Double.compare(this.toDouble(assignment), ((Value)value).toDouble(assignment));
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), ((Value)value).getId());
    }

    @Override
    @Deprecated
    public int compareTo(T value) {
        return this.compareTo((Assignment<V, T>)((Variable)this.variable()).getModel().getDefaultAssignment(), value);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Value)) {
            return false;
        }
        return this.getId() == ((Value)o).getId();
    }

    @Deprecated
    public Object getExtra() {
        return this.iExtra;
    }

    @Deprecated
    public void setExtra(Object object) {
        this.iExtra = object;
    }

    public boolean isConsistent(T value) {
        for (Constraint constraint : ((Variable)this.iVariable).constraints()) {
            if (constraint.isConsistent(this, (Value)value)) continue;
            return false;
        }
        for (Constraint constraint : ((Variable)this.iVariable).getModel().globalConstraints()) {
            if (constraint.isConsistent(this, (Value)value)) continue;
            return false;
        }
        return true;
    }

    public Set<T> conflicts(Assignment<V, T> assignment) {
        HashSet conflicts = new HashSet();
        for (Constraint<V, Value> constraint : ((Variable)this.iVariable).constraints()) {
            constraint.computeConflicts(assignment, this, conflicts);
        }
        for (Constraint<V, Value> constraint : ((Variable)this.iVariable).getModel().globalConstraints()) {
            constraint.computeConflicts(assignment, this, conflicts);
        }
        if (!conflicts.isEmpty()) {
            return conflicts;
        }
        return null;
    }

    @Deprecated
    public Set<T> conflicts() {
        return this.conflicts(((Variable)this.variable()).getModel().getDefaultAssignment());
    }
}

