/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.Comparator;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class AssignedValue<T extends Value<?, T>> {
    private T iValue;
    private double iCounter = 1.0;
    private long iLastRevision;
    private double iAging = 1.0;
    private Constraint<?, T> iConstraint = null;

    public AssignedValue(long iteration, T value, double aging) {
        this.iValue = value;
        this.iLastRevision = iteration;
        this.iAging = aging;
    }

    public T getValue() {
        return this.iValue;
    }

    public void incCounter(long iteration) {
        this.revise(iteration);
        this.iCounter += 1.0;
    }

    public void setCounter(double cnt) {
        this.iCounter = cnt;
    }

    public double getCounter(long iteration) {
        if (iteration == 0L) {
            return this.iCounter;
        }
        if (this.iAging == 1.0) {
            return this.iCounter;
        }
        return this.iCounter * Math.pow(this.iAging, iteration - this.iLastRevision);
    }

    public Constraint<?, T> getConstraint() {
        return this.iConstraint;
    }

    public void setConstraint(Constraint<?, T> constraint) {
        this.iConstraint = constraint;
    }

    public synchronized void revise(long iteration) {
        if (this.iAging == 1.0) {
            return;
        }
        this.iCounter *= Math.pow(this.iAging, iteration - this.iLastRevision);
        this.iLastRevision = iteration;
    }

    public static int combine(int a, int b) {
        int ret = 0;
        for (int i = 0; i < 15; ++i) {
            ret = ret | (a & 1 << i) << i | (b & 1 << i) << i + 1;
        }
        return ret;
    }

    public int hashCode() {
        return ((Value)this.iValue).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AssignedValue)) {
            return false;
        }
        return ((Value)((AssignedValue)o).getValue()).equals(this.getValue());
    }

    public String toString() {
        return this.toString(0L, true);
    }

    public String toString(long iteration, boolean assignment) {
        return (assignment ? this.getCounter(iteration) + "x " : "") + ((Variable)((Value)this.getValue()).variable()).getName() + (assignment ? " := " : " != ") + ((Value)this.getValue()).getName();
    }

    public int compareTo(long iteration, AssignedValue<T> a) {
        int cmp = ((Variable)((Value)this.getValue()).variable()).getName().compareTo(((Variable)((Value)a.getValue()).variable()).getName());
        if (cmp != 0) {
            return cmp;
        }
        if (this.getCounter(iteration) != a.getCounter(iteration)) {
            return this.getCounter(iteration) < a.getCounter(iteration) ? 1 : -1;
        }
        return ((Value)this.getValue()).getName().compareTo(((Value)a.getValue()).getName());
    }

    public static class AssignmentComparator<E extends Value<?, E>>
    implements Comparator<AssignedValue<E>> {
        private long iIteration;

        public AssignmentComparator(long iteration) {
            this.iIteration = iteration;
        }

        @Override
        public int compare(AssignedValue<E> a1, AssignedValue<E> a2) {
            return a1.compareTo(this.iIteration, a2);
        }
    }
}

