/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ParallelConstruction<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSelectionWithContext<V, T, ConstructionContext>
implements SolutionListener<V, T> {
    protected static Logger sLog = Logger.getLogger(ParallelConstruction.class);
    protected NeighbourSelection<V, T> iParent = null;
    protected Double iBestValue = null;
    protected int iBestIndex = -1;
    protected int iBestAssigned = 0;
    protected int iMaxIdle = 100;

    public ParallelConstruction(DataProperties config, NeighbourSelection<V, T> parent) {
        this.iParent = parent;
        this.iMaxIdle = config.getPropertyInt("ParallelConstruction.MaxIdle", this.iMaxIdle);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iParent.init(solver);
        solver.currentSolution().addSolutionListener(this);
    }

    @Override
    public void solutionUpdated(Solution<V, T> solution) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
    }

    @Override
    public void bestCleared(Solution<V, T> solution) {
    }

    @Override
    public void bestSaved(Solution<V, T> solution) {
        this.iBestValue = solution.getBestValue();
        this.iBestIndex = solution.getAssignment().getIndex();
        this.iBestAssigned = solution.getAssignment().nrAssignedVariables();
        ((ConstructionContext)this.getContext(solution.getAssignment())).reset();
    }

    @Override
    public void bestRestored(Solution<V, T> solution) {
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        if (this.iBestValue != null && this.iBestIndex != solution.getAssignment().getIndex()) {
            ConstructionContext context = (ConstructionContext)this.getContext(solution.getAssignment());
            if (solution.getAssignment().nrAssignedVariables() == this.iBestAssigned) {
                context.reset();
            } else if (solution.getAssignment().nrAssignedVariables() < this.iBestAssigned && context.inc() >= this.iMaxIdle) {
                Model<V, T> model = solution.getModel();
                Assignment<Variable, T> assignment = solution.getAssignment();
                int idx = ToolBox.random(model.countVariables());
                for (int i = 0; i < model.countVariables(); ++i) {
                    Variable variable = (Variable)model.variables().get((i + idx) % model.countVariables());
                    T value = assignment.getValue(variable);
                    Object best = variable.getBestAssignment();
                    if (value != null || best == null) continue;
                    return new SimpleNeighbour(variable, best, model.conflictValues(solution.getAssignment(), best));
                }
            }
        }
        return this.iParent.selectNeighbour(solution);
    }

    @Override
    public ConstructionContext createAssignmentContext(Assignment<V, T> assignment) {
        return new ConstructionContext(assignment);
    }

    public class ConstructionContext
    implements AssignmentContext {
        private int iCounter = 0;

        public ConstructionContext(Assignment<V, T> assignment) {
        }

        public int inc() {
            return this.iCounter++;
        }

        public void reset() {
            this.iCounter = 0;
        }
    }
}

