/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cpsolver.exam.criteria.DistributionPenalty;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;

public class ExamDistributionConstraint
extends ConstraintWithContext<Exam, ExamPlacement, Context> {
    public static final int sDistSameRoom = 0;
    public static final int sDistDifferentRoom = 1;
    public static final int sDistSamePeriod = 2;
    public static final int sDistDifferentPeriod = 3;
    public static final int sDistPrecedence = 4;
    public static final int sDistPrecedenceRev = 5;
    public static final String[] sDistType = new String[]{"same-room", "different-room", "same-period", "different-period", "precedence", "precedence-rev"};
    private int iType = -1;
    private boolean iHard = true;
    private int iWeight = 0;

    public ExamDistributionConstraint(long id, int type, boolean hard, int weight) {
        this.iId = id;
        this.iType = type;
        this.iHard = hard;
        this.iWeight = weight;
    }

    public ExamDistributionConstraint(long id, String type, String pref) {
        boolean neg;
        this.iId = id;
        boolean bl = neg = "P".equals(pref) || "2".equals(pref) || "1".equals(pref);
        if ("EX_SAME_PER".equals(type)) {
            this.iType = neg ? 3 : 2;
        } else if ("EX_SAME_ROOM".equals(type)) {
            this.iType = neg ? 1 : 0;
        } else if ("EX_PRECEDENCE".equals(type)) {
            this.iType = neg ? 5 : 4;
        } else {
            throw new RuntimeException("Unkown type " + type);
        }
        if ("P".equals(pref) || "R".equals(pref)) {
            this.iHard = true;
        } else {
            this.iHard = false;
            this.iWeight = Integer.parseInt(pref) * Integer.parseInt(pref);
        }
    }

    public ExamDistributionConstraint(long id, String type, boolean hard, int weight) {
        this.iId = id;
        for (int i = 0; i < sDistType.length; ++i) {
            if (!sDistType[i].equals(type)) continue;
            this.iType = i;
        }
        if (this.iType < 0) {
            throw new RuntimeException("Unknown type '" + type + "'.");
        }
        this.iHard = hard;
        this.iWeight = weight;
    }

    @Override
    public boolean isHard() {
        return this.iHard;
    }

    public int getWeight() {
        return this.iWeight;
    }

    public int getType() {
        return this.iType;
    }

    public String getTypeString() {
        return sDistType[this.iType];
    }

    public String toString() {
        return this.getTypeString() + " (" + this.variables() + ")";
    }

    @Override
    public void computeConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPlacement givenPlacement, Set<ExamPlacement> conflicts) {
        boolean before = true;
        for (Exam exam : this.variables()) {
            if (exam.equals(givenPlacement.variable())) {
                before = false;
                continue;
            }
            ExamPlacement placement = assignment.getValue(exam);
            if (placement == null || this.check(before ? placement : givenPlacement, before ? givenPlacement : placement)) continue;
            conflicts.add(placement);
        }
    }

    @Override
    public boolean inConflict(Assignment<Exam, ExamPlacement> assignment, ExamPlacement givenPlacement) {
        boolean before = true;
        for (Exam exam : this.variables()) {
            if (exam.equals(givenPlacement.variable())) {
                before = false;
                continue;
            }
            ExamPlacement placement = assignment.getValue(exam);
            if (placement == null || this.check(before ? placement : givenPlacement, before ? givenPlacement : placement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(ExamPlacement first, ExamPlacement second) {
        boolean before = this.variables().indexOf(first.variable()) < this.variables().indexOf(second.variable());
        return this.check(before ? first : second, before ? second : first);
    }

    public boolean check(ExamPlacement first, ExamPlacement second) {
        switch (this.getType()) {
            case 4: {
                return first.getPeriod().getIndex() < second.getPeriod().getIndex();
            }
            case 5: {
                return first.getPeriod().getIndex() > second.getPeriod().getIndex();
            }
            case 2: {
                return first.getPeriod().getIndex() == second.getPeriod().getIndex();
            }
            case 3: {
                return first.getPeriod().getIndex() != second.getPeriod().getIndex();
            }
            case 0: {
                return first.getRoomPlacements().containsAll(second.getRoomPlacements()) || second.getRoomPlacements().containsAll(first.getRoomPlacements());
            }
            case 1: {
                Iterator<ExamRoomPlacement> i = first.getRoomPlacements().iterator();
                while (i.hasNext()) {
                    if (!second.getRoomPlacements().contains(i.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamDistributionConstraint)) {
            return false;
        }
        ExamDistributionConstraint c = (ExamDistributionConstraint)o;
        return this.getType() == c.getType() && this.getId() == c.getId();
    }

    public boolean isSatisfied(Assignment<Exam, ExamPlacement> assignment) {
        return this.isSatisfied(assignment, null);
    }

    public boolean isSatisfied(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p) {
        if (this.isHard()) {
            return true;
        }
        switch (this.getType()) {
            case 4: {
                ExamPeriod last = null;
                for (Exam exam : this.variables()) {
                    ExamPlacement placement = p != null && exam.equals(p.variable()) ? p : assignment.getValue(exam);
                    if (placement == null) continue;
                    if (last == null || last.getIndex() < placement.getPeriod().getIndex()) {
                        last = placement.getPeriod();
                        continue;
                    }
                    return false;
                }
                return true;
            }
            case 5: {
                ExamPeriod last = null;
                for (Exam exam : this.variables()) {
                    ExamPlacement placement = p != null && exam.equals(p.variable()) ? p : assignment.getValue(exam);
                    if (placement == null) continue;
                    if (last == null || last.getIndex() > placement.getPeriod().getIndex()) {
                        last = placement.getPeriod();
                        continue;
                    }
                    return false;
                }
                return true;
            }
            case 2: {
                ExamPeriod period = null;
                for (Exam exam : this.variables()) {
                    ExamPlacement placement = p != null && exam.equals(p.variable()) ? p : assignment.getValue(exam);
                    if (placement == null) continue;
                    if (period == null) {
                        period = placement.getPeriod();
                        continue;
                    }
                    if (period.getIndex() == placement.getPeriod().getIndex()) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                HashSet<ExamPeriod> periods = new HashSet<ExamPeriod>();
                for (Exam exam : this.variables()) {
                    ExamPlacement placement = p != null && exam.equals(p.variable()) ? p : assignment.getValue(exam);
                    if (placement == null || periods.add(placement.getPeriod())) continue;
                    return false;
                }
                return true;
            }
            case 0: {
                Set<ExamRoomPlacement> rooms = null;
                for (Exam exam : this.variables()) {
                    ExamPlacement placement = p != null && exam.equals(p.variable()) ? p : assignment.getValue(exam);
                    if (placement == null) continue;
                    if (rooms == null) {
                        rooms = placement.getRoomPlacements();
                        continue;
                    }
                    if (rooms.containsAll(placement.getRoomPlacements()) && placement.getRoomPlacements().containsAll(rooms)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                HashSet<ExamRoomPlacement> allRooms = new HashSet<ExamRoomPlacement>();
                for (Exam exam : this.variables()) {
                    ExamPlacement placement;
                    ExamPlacement examPlacement = placement = p != null && exam.equals(p.variable()) ? p : assignment.getValue(exam);
                    if (placement == null) continue;
                    for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                        if (allRooms.add(room)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isRoomRelated() {
        return this.iType == 0 || this.iType == 1;
    }

    public boolean isPeriodRelated() {
        return !this.isRoomRelated();
    }

    @Override
    public Context createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentConstraintContext<Exam, ExamPlacement> {
        private boolean iIsSatisfied;

        public Context(Assignment<Exam, ExamPlacement> assignment) {
            this.iIsSatisfied = ExamDistributionConstraint.this.isSatisfied(assignment);
            if (!this.iIsSatisfied) {
                ((DistributionPenalty)ExamDistributionConstraint.this.getModel().getCriterion(DistributionPenalty.class)).inc(assignment, (double)ExamDistributionConstraint.this.getWeight());
            }
        }

        @Override
        public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
            if (!ExamDistributionConstraint.this.isHard() && this.iIsSatisfied != ExamDistributionConstraint.this.isSatisfied(assignment)) {
                this.iIsSatisfied = !this.iIsSatisfied;
                ((DistributionPenalty)ExamDistributionConstraint.this.getModel().getCriterion(DistributionPenalty.class)).inc(assignment, this.iIsSatisfied ? (double)(-ExamDistributionConstraint.this.getWeight()) : (double)ExamDistributionConstraint.this.getWeight());
            }
        }

        @Override
        public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
            if (!ExamDistributionConstraint.this.isHard() && this.iIsSatisfied != ExamDistributionConstraint.this.isSatisfied(assignment)) {
                this.iIsSatisfied = !this.iIsSatisfied;
                ((DistributionPenalty)ExamDistributionConstraint.this.getModel().getCriterion(DistributionPenalty.class)).inc(assignment, this.iIsSatisfied ? (double)(-ExamDistributionConstraint.this.getWeight()) : (double)ExamDistributionConstraint.this.getWeight());
            }
        }
    }
}

