/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class DistributionPreferences
extends TimetablingCriterion {
    public DistributionPreferences() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.ContrPreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.ConstrPreferenceWeight";
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (GroupConstraint gc : ((Lecture)value.variable()).groupConstraints()) {
            ret += (double)gc.getCurrentPreference(assignment, value);
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<GroupConstraint> constraints = new HashSet<GroupConstraint>();
        for (Lecture lect : variables) {
            for (GroupConstraint gc : lect.groupConstraints()) {
                if (!constraints.add(gc)) continue;
                ret += (double)((GroupConstraint.GroupConstraintContext)gc.getContext((Assignment)assignment)).getPreference();
            }
        }
        return ret;
    }

    @Override
    protected double[] computeBounds(Assignment<Lecture, Placement> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (GroupConstraint gc : ((TimetableModel)this.getModel()).getGroupConstraints()) {
            if (gc.isHard()) continue;
            bounds[0] = bounds[0] - (double)Math.abs(gc.getPreference());
            bounds[1] = bounds[1] + (double)(Math.abs(gc.getPreference()) * (gc.variables().size() * (gc.variables().size() - 1)) / 2);
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet<GroupConstraint> constraints = new HashSet<GroupConstraint>();
        for (Lecture lect : variables) {
            for (GroupConstraint gc : lect.groupConstraints()) {
                if (gc.isHard() || !constraints.add(gc)) continue;
                bounds[0] = bounds[0] - (double)Math.abs(gc.getPreference());
                bounds[1] = bounds[1] + (double)(Math.abs(gc.getPreference()) * (gc.variables().size() * (gc.variables().size() - 1)) / 2);
            }
        }
        return bounds;
    }
}

