/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class SpreadConstraint
extends ConstraintWithContext<Lecture, Placement, SpreadConstraintContext>
implements WeakeningConstraint<Lecture, Placement> {
    private boolean iInteractive = false;
    private double iSpreadFactor = 1.2;
    private int iUnassignmentsToWeaken = 250;
    private String iName = null;
    public static boolean USE_MOST_IMPROVEMENT_ADEPTS = false;

    public SpreadConstraint(String name, double spreadFactor, int unassignmentsToWeaken, boolean interactiveMode) {
        this.iName = name;
        this.iSpreadFactor = spreadFactor;
        this.iUnassignmentsToWeaken = unassignmentsToWeaken;
        this.iInteractive = interactiveMode;
    }

    public SpreadConstraint(DataProperties config, String name) {
        this(name, config.getPropertyDouble("Spread.SpreadFactor", 1.2), config.getPropertyInt("Spread.Unassignments2Weaken", 250), config.getPropertyBoolean("General.InteractiveMode", false));
    }

    protected Criterion<Lecture, Placement> getCriterion() {
        return this.getModel().getCriterion(SameSubpartBalancingPenalty.class);
    }

    public Placement getAdept(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses, Set<Placement> conflicts) {
        int imp;
        Placement plac;
        Placement adept = null;
        int improvement = 0;
        for (Lecture lect : this.variables()) {
            if (lect.isCommitted() || (plac = assignment.getValue(lect)) == null || plac.equals(placement) || ((Lecture)placement.variable()).equals(plac.variable()) || conflicts.contains(plac) || (imp = this.getPenaltyIfUnassigned(assignment, plac, nrCourses)) == 0 || adept != null && imp <= improvement) continue;
            adept = plac;
            improvement = imp;
        }
        if (adept != null) {
            return adept;
        }
        for (Lecture lect : this.variables()) {
            if (!lect.isCommitted() || (plac = assignment.getValue(lect)) == null || plac.equals(placement) || conflicts.contains(plac) || (imp = this.getPenaltyIfUnassigned(assignment, plac, nrCourses)) == 0 || adept != null && imp <= improvement) continue;
            adept = plac;
            improvement = imp;
        }
        return adept;
    }

    private Set<Placement>[] getAdepts(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses, Set<Placement> conflicts) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return null;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return null;
        }
        HashSet[] adepts = new HashSet[]{new HashSet(), new HashSet()};
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0 || nrCourses[i - Constants.DAY_SLOTS_FIRST][j] < context.getMaxCourses(i, j)) continue;
                for (Placement p : context.getCourses(i, j)) {
                    if (conflicts.contains(p) || p.equals(placement) || ((Lecture)p.variable()).equals(placement.variable())) continue;
                    adepts[((Lecture)p.variable()).isCommitted() ? 1 : 0].add(p);
                }
            }
        }
        return adepts;
    }

    private int getPenaltyIfUnassigned(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0 || nrCourses[i - Constants.DAY_SLOTS_FIRST][j] <= context.getMaxCourses(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    private int tryUnassign(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int improvement = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                if (nrCourses[i - Constants.DAY_SLOTS_FIRST][j] > context.getMaxCourses(i, j)) {
                    ++improvement;
                }
                int[] nArray = nrCourses[i - Constants.DAY_SLOTS_FIRST];
                int n = j;
                nArray[n] = nArray[n] - 1;
            }
        }
        return improvement;
    }

    private int tryAssign(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                int[] nArray = nrCourses[i - Constants.DAY_SLOTS_FIRST];
                int n = j;
                nArray[n] = nArray[n] + 1;
                if (nrCourses[i - Constants.DAY_SLOTS_FIRST][j] <= context.getMaxCourses(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        block12: {
            int[][] nrCourses;
            int penalty;
            SpreadConstraintContext context;
            block11: {
                Placement plac;
                context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
                if (context.getUnassignmentsToWeaken() == 0) {
                    return;
                }
                penalty = context.getCurrentPenalty() + this.getPenalty(assignment, placement);
                if (penalty <= context.getMaxAllowedPenalty()) {
                    return;
                }
                int firstSlot = placement.getTimeLocation().getStartSlot();
                if (firstSlot > Constants.DAY_SLOTS_LAST) {
                    return;
                }
                int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
                if (endSlot < Constants.DAY_SLOTS_FIRST) {
                    return;
                }
                nrCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
                for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
                    for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        nrCourses[i][j] = context.getNrCourses(i + Constants.DAY_SLOTS_FIRST, j, placement);
                    }
                }
                this.tryAssign(assignment, placement, nrCourses);
                for (Lecture lect : this.variables()) {
                    if (lect.equals(placement.variable())) continue;
                    if (conflicts.contains(lect)) {
                        penalty -= this.tryUnassign(assignment, assignment.getValue(lect), nrCourses);
                    }
                    if (penalty > context.getMaxAllowedPenalty()) continue;
                    return;
                }
                if (!USE_MOST_IMPROVEMENT_ADEPTS) break block11;
                while (penalty > context.getMaxAllowedPenalty() && (plac = this.getAdept(assignment, placement, nrCourses, conflicts)) != null) {
                    conflicts.add(plac);
                    penalty -= this.tryUnassign(assignment, plac, nrCourses);
                }
                break block12;
            }
            if (penalty <= context.getMaxAllowedPenalty()) break block12;
            Set<Placement>[] adepts = this.getAdepts(assignment, placement, nrCourses, conflicts);
            for (int i = 0; penalty > context.getMaxAllowedPenalty() && i < adepts.length; ++i) {
                while (!adepts[i].isEmpty() && penalty > context.getMaxAllowedPenalty()) {
                    Placement plac = ToolBox.random(adepts[i]);
                    adepts[i].remove(plac);
                    conflicts.add(plac);
                    penalty -= this.tryUnassign(assignment, plac, nrCourses);
                }
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        if (context.getUnassignmentsToWeaken() == 0) {
            return false;
        }
        return this.getPenalty(assignment, placement) + context.getCurrentPenalty() > context.getMaxAllowedPenalty();
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
        ((SpreadConstraintContext)this.getContext((Assignment)assignment)).weaken();
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Time Spread between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public int getPenalty(Assignment<Lecture, Placement> assignment) {
        return ((SpreadConstraintContext)this.getContext((Assignment)assignment)).getCurrentPenalty();
    }

    public int getPenaltyEstimate(Assignment<Lecture, Placement> assignment) {
        int i;
        int endSlot;
        int firstSlot;
        double[][] histogramPerDay = new double[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        int[][] maxCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        int[][] nrCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        for (int i2 = 0; i2 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i2) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                histogramPerDay[i2][j] = 0.0;
            }
        }
        int totalUsedSlots = 0;
        for (Lecture lecture : this.variables()) {
            Placement firstPlacement;
            List<Placement> values = lecture.values(assignment);
            Placement placement = firstPlacement = values.isEmpty() ? null : values.get(0);
            if (firstPlacement != null) {
                totalUsedSlots += firstPlacement.getTimeLocation().getNrSlotsPerMeeting() * firstPlacement.getTimeLocation().getNrMeetings();
            }
            for (Placement p : values) {
                firstSlot = p.getTimeLocation().getStartSlot();
                if (firstSlot > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
                for (i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                    int dayCode = p.getTimeLocation().getDayCode();
                    for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                        double[] dArray = histogramPerDay[i - Constants.DAY_SLOTS_FIRST];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0 / (double)values.size();
                    }
                }
            }
        }
        double threshold = this.iSpreadFactor * ((double)totalUsedSlots / (double)(Constants.NR_DAYS_WEEK * Constants.SLOTS_PER_DAY_NO_EVENINGS));
        for (int i3 = 0; i3 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i3) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                nrCourses[i3][j] = 0;
                maxCourses[i3][j] = (int)(0.999 + (histogramPerDay[i3][j] <= threshold ? this.iSpreadFactor * histogramPerDay[i3][j] : histogramPerDay[i3][j]));
            }
        }
        int currentPenalty = 0;
        for (Lecture lecture : this.variables()) {
            Placement placement = assignment.getValue(lecture);
            if (placement == null || (firstSlot = placement.getTimeLocation().getStartSlot()) > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
            for (i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    int[] nArray = nrCourses[i - Constants.DAY_SLOTS_FIRST];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (int i4 = 0; i4 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i4) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                currentPenalty += Math.max(0, nrCourses[i4][j] - maxCourses[i4][j]);
            }
        }
        return currentPenalty;
    }

    public int getMaxPenalty(Assignment<Lecture, Placement> assignment, Placement placement) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int penalty = 0;
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int dif;
            int slot = (Integer)e.nextElement();
            int day = slot / 288;
            int time = slot % 288;
            if (time < Constants.DAY_SLOTS_FIRST || time > Constants.DAY_SLOTS_LAST || day >= Constants.NR_DAYS_WEEK || (dif = 1 + context.getNrCourses(time, day, placement) - context.getMaxCourses(time, day)) <= penalty) continue;
            penalty = dif;
        }
        return penalty;
    }

    public int getPenalty(Assignment<Lecture, Placement> assignment, Placement placement) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int penalty = 0;
        int min = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST);
        int max = Math.min(endSlot, Constants.DAY_SLOTS_LAST);
        for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
            int dayCode = Constants.DAY_CODES[j];
            if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
            for (int i = min; i <= max; ++i) {
                if (context.getNrCourses(i, j, placement) < context.getMaxCourses(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public void addVariable(Lecture lecture) {
        if (lecture.canShareRoom()) {
            for (GroupConstraint gc : lecture.groupConstraints()) {
                if (gc.getType() != GroupConstraint.ConstraintType.MEET_WITH || gc.variables().indexOf(lecture) <= 0) continue;
                return;
            }
        }
        super.addVariable(lecture);
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        while (this.inConflict(assignment, value)) {
            ((SpreadConstraintContext)this.getContext((Assignment)assignment)).weaken(((SpreadConstraintContext)this.getContext((Assignment)assignment)).getCurrentPenalty() + this.getPenalty(assignment, value));
        }
    }

    @Override
    public SpreadConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new SpreadConstraintContext(assignment);
    }

    public class SpreadConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        private int iMaxAllowedPenalty = 0;
        private long iUnassignment = 0L;
        private Set<Placement>[][] iCourses = new Set[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        private int[][] iMaxCourses = null;
        private int iCurrentPenalty = 0;

        public SpreadConstraintContext(Assignment<Lecture, Placement> assignment) {
            int dayCode;
            if (SpreadConstraint.this.iInteractive) {
                SpreadConstraint.this.iUnassignmentsToWeaken = 0;
            }
            for (int i = 0; i < this.iCourses.length; ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    this.iCourses[i][j] = new HashSet<Placement>(10);
                }
            }
            double[][] histogramPerDay = new double[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
            this.iMaxCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
            for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    histogramPerDay[i][j] = 0.0;
                }
            }
            int totalUsedSlots = 0;
            for (Lecture lecture : SpreadConstraint.this.variables()) {
                Placement firstPlacement;
                List<Placement> values = lecture.values(assignment);
                Placement placement = firstPlacement = values.isEmpty() ? null : values.get(0);
                if (firstPlacement != null) {
                    totalUsedSlots += firstPlacement.getTimeLocation().getNrSlotsPerMeeting() * firstPlacement.getTimeLocation().getNrMeetings();
                }
                for (Placement p : values) {
                    int endSlot;
                    int firstSlot = p.getTimeLocation().getStartSlot();
                    if (firstSlot > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
                    for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                        dayCode = p.getTimeLocation().getDayCode();
                        for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                            if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                            double[] dArray = histogramPerDay[i - Constants.DAY_SLOTS_FIRST];
                            int n = j;
                            dArray[n] = dArray[n] + 1.0 / (double)values.size();
                        }
                    }
                }
            }
            double threshold = SpreadConstraint.this.iSpreadFactor * ((double)totalUsedSlots / (double)(Constants.NR_DAYS_WEEK * Constants.SLOTS_PER_DAY_NO_EVENINGS));
            for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    this.iMaxCourses[i][j] = (int)(0.999 + (histogramPerDay[i][j] <= threshold ? SpreadConstraint.this.iSpreadFactor * histogramPerDay[i][j] : histogramPerDay[i][j]));
                }
            }
            for (Lecture lecture : SpreadConstraint.this.variables()) {
                int endSlot;
                int firstSlot;
                Placement placement = assignment.getValue(lecture);
                if (placement == null || (firstSlot = placement.getTimeLocation().getStartSlot()) > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
                for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                    for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        dayCode = Constants.DAY_CODES[j];
                        if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                        this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].add(placement);
                    }
                }
            }
            this.iCurrentPenalty = 0;
            for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    this.iCurrentPenalty += Math.max(0, this.iCourses[i][j].size() - this.iMaxCourses[i][j]);
                }
            }
            this.iMaxAllowedPenalty = this.iCurrentPenalty;
            SpreadConstraint.this.getCriterion().inc(assignment, this.iCurrentPenalty);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            int firstSlot = placement.getTimeLocation().getStartSlot();
            if (firstSlot > Constants.DAY_SLOTS_LAST) {
                return;
            }
            int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
            if (endSlot < Constants.DAY_SLOTS_FIRST) {
                return;
            }
            SpreadConstraint.this.getCriterion().inc(assignment, -this.iCurrentPenalty);
            for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].add(placement);
                    if (this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].size() <= this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) continue;
                    ++this.iCurrentPenalty;
                }
            }
            SpreadConstraint.this.getCriterion().inc(assignment, this.iCurrentPenalty);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            int firstSlot = placement.getTimeLocation().getStartSlot();
            if (firstSlot > Constants.DAY_SLOTS_LAST) {
                return;
            }
            int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
            if (endSlot < Constants.DAY_SLOTS_FIRST) {
                return;
            }
            SpreadConstraint.this.getCriterion().inc(assignment, -this.iCurrentPenalty);
            for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    if (this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].size() > this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) {
                        --this.iCurrentPenalty;
                    }
                    this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].remove(placement);
                }
            }
            SpreadConstraint.this.getCriterion().inc(assignment, this.iCurrentPenalty);
        }

        public int[][] getMaxCourses() {
            return this.iMaxCourses;
        }

        public int getMaxCourses(int time, int day) {
            return this.iMaxCourses[time - Constants.DAY_SLOTS_FIRST][day];
        }

        public int getNrCourses(int time, int day, Placement placement) {
            if (placement == null) {
                return this.getCourses(time, day).size();
            }
            int nrCourses = 0;
            for (Placement p : this.getCourses(time, day)) {
                if (((Lecture)p.variable()).equals(placement.variable())) continue;
                ++nrCourses;
            }
            return nrCourses;
        }

        public Set<Placement> getCourses(int time, int day) {
            return this.iCourses[time - Constants.DAY_SLOTS_FIRST][day];
        }

        public int getUnassignmentsToWeaken() {
            return SpreadConstraint.this.iUnassignmentsToWeaken;
        }

        public int getCurrentPenalty() {
            return this.iCurrentPenalty;
        }

        public int getMaxAllowedPenalty() {
            return this.iMaxAllowedPenalty;
        }

        public void weaken() {
            if (SpreadConstraint.this.iUnassignmentsToWeaken == 0) {
                return;
            }
            ++this.iUnassignment;
            if (this.iUnassignment % (long)SpreadConstraint.this.iUnassignmentsToWeaken == 0L) {
                ++this.iMaxAllowedPenalty;
            }
        }

        public void weaken(int penalty) {
            if (penalty > this.iMaxAllowedPenalty) {
                this.iMaxAllowedPenalty = penalty;
            }
        }
    }
}

