/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.timegrid.TimetableGridCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimetableGridModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TimetableGridCell[][][] iData = new TimetableGridCell[Constants.DAY_CODES.length][288][];
    private boolean[][] iAvailable;
    private String[][] iBackground = null;
    private String iName;
    private int iSize = 0;
    private Long iType = null;
    private transient boolean[][][] iRendered = null;
    private transient HashSet<Integer>[][][] iRenderedDate = null;
    private transient Hashtable<Integer, Hashtable<Long, Integer>> iIndex = null;
    private int iFirstDay = -1;
    public static final int sResourceTypeRoom = 0;
    public static final int sResourceTypeInstructor = 1;
    public static final int sResourceTypeDepartment = 2;
    public static final int sResourceTypeCurriculum = 3;
    public static final int sBgModeNotAvailable = -1;
    public static final int sBgModeNone = 0;
    public static final int sBgModeTimePref = 1;
    public static final int sBgModeRoomPref = 2;
    public static final int sBgModeStudentConf = 3;
    public static final int sBgModeInstructorBtbPref = 4;
    public static final int sBgModeDistributionConstPref = 5;
    public static final int sBgModePerturbations = 6;
    public static final int sBgModePerturbationPenalty = 7;
    public static final int sBgModeHardConflicts = 8;
    public static final int sBgModeDepartmentalBalancing = 9;
    public static final int sBgModeTooBigRooms = 10;
    public static String[] sBgModes = new String[]{"None", "Time Preferences", "Room Preferences", "Student Conflicts", "Instructor Back-to-Back Preferences", "Distribution Preferences", "Perturbations", "Perturbation Penalty", "Hard Conflicts", "Departmental Balancing Penalty", "Too Big Rooms"};
    public static String[] sResourceTypes = new String[]{"Room", "Instructor", "Department", "Curriculum"};
    private int iResourceType;
    private long iResourceId;

    public TimetableGridModel() {
        int j;
        int i;
        for (i = 0; i < Constants.DAY_CODES.length; ++i) {
            for (j = 0; j < 288; ++j) {
                this.iData[i][j] = null;
            }
        }
        this.iAvailable = new boolean[Constants.DAY_CODES.length][288];
        for (i = 0; i < Constants.DAY_CODES.length; ++i) {
            for (j = 0; j < 288; ++j) {
                this.iAvailable[i][j] = true;
            }
        }
    }

    public TimetableGridModel(int resourceType, long resourceId) {
        this();
        this.iResourceType = resourceType;
        this.iResourceId = resourceId;
    }

    public int getResourceType() {
        return this.iResourceType;
    }

    public long getResourceId() {
        return this.iResourceId;
    }

    public int getFirstDay() {
        return this.iFirstDay;
    }

    public void setFirstDay(int firstDay) {
        this.iFirstDay = firstDay;
    }

    public static String[] getBackgroundModes() {
        return sBgModes;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public void setSize(int size) {
        this.iSize = size;
    }

    public void setType(Long type) {
        this.iType = type;
    }

    public void addCell(int slot, TimetableGridCell cell) {
        this.addCell(slot / 288, slot % 288, cell);
    }

    public void addCell(int day, int slot, TimetableGridCell cell) {
        int i;
        int idx = 0;
        for (i = 0; i < cell.getLength(); ++i) {
            idx = Math.max(this.getIndex(day, slot + i, cell), idx);
        }
        for (i = 0; i < cell.getLength(); ++i) {
            this.shift(day, slot + i, idx);
            this.setCell(day, slot + i, idx, cell);
        }
    }

    public void setAvailable(int slot, boolean available) {
        this.setAvailable(slot / 288, slot % 288, available);
    }

    public void setAvailable(int day, int slot, boolean available) {
        this.iAvailable[day][slot] = available;
    }

    public void setBackground(int day, int slot, String background) {
        if (this.iBackground == null) {
            this.iBackground = new String[Constants.DAY_CODES.length][288];
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < 288; ++j) {
                    this.iBackground[i][j] = null;
                }
            }
        }
        this.iBackground[day][slot] = background;
    }

    public String getBackground(int day, int slot) {
        if (this.iBackground == null) {
            return null;
        }
        return this.iBackground[day][slot];
    }

    public String getName() {
        return this.iName;
    }

    public int getSize() {
        return this.iSize;
    }

    public Long getType() {
        return this.iType;
    }

    public void shift(int day, int slot, int idx) {
        TimetableGridCell cell = this.getCell(day, slot, idx);
        if (cell == null) {
            return;
        }
        for (int s = cell.getSlot(); s < cell.getSlot() + cell.getLength(); ++s) {
            this.shift(day, s, idx + 1);
            this.setCell(day, s, idx, null);
            this.setCell(day, s, idx + 1, cell);
        }
    }

    public void setCell(int day, int slot, int idx, TimetableGridCell cell) {
        if (this.iData[day][slot] == null) {
            this.iData[day][slot] = new TimetableGridCell[idx + 1];
            for (int i = 0; i < idx; ++i) {
                this.iData[day][slot][i] = null;
            }
            this.iData[day][slot][idx] = cell;
        } else if (this.iData[day][slot].length <= idx) {
            TimetableGridCell[] old = this.iData[day][slot];
            this.iData[day][slot] = new TimetableGridCell[idx + 1];
            for (int i = 0; i < idx; ++i) {
                this.iData[day][slot][i] = i < old.length ? old[i] : null;
            }
            this.iData[day][slot][idx] = cell;
        } else {
            if (this.iData[day][slot][idx] != null && cell != null) {
                System.out.println("WARN: (" + day + "," + slot + "," + idx + ") already full with " + this.iData[day][slot][idx].getName());
            }
            this.iData[day][slot][idx] = cell;
        }
    }

    public int getIndex(int day, int slot, TimetableGridCell cell) {
        if (this.iData[day][slot] == null) {
            return 0;
        }
        int idx = 0;
        for (int i = 0; i < this.iData[day][slot].length; ++i) {
            if (this.iData[day][slot][i] == null || this.iData[day][slot][i].compareTo(cell) > 0) continue;
            idx = i + 1;
        }
        return idx;
    }

    public int nrCells(int day, int slot) {
        if (this.iData[day][slot] == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < this.iData[day][slot].length; ++i) {
            if (this.iData[day][slot][i] == null) continue;
            ++ret;
        }
        return ret;
    }

    public TimetableGridCell getCell(int day, int slot, int idx) {
        if (this.iData[day][slot] == null) {
            return null;
        }
        if (this.iData[day][slot].length <= idx) {
            return null;
        }
        return this.iData[day][slot][idx];
    }

    private Hashtable<Long, Integer> index(int date) {
        Hashtable<Long, Integer> index;
        if (this.iIndex == null) {
            this.iIndex = new Hashtable();
        }
        if ((index = this.iIndex.get(date)) == null) {
            index = new Hashtable();
            this.iIndex.put(date, index);
            for (int day = 0; day < this.iData.length; ++day) {
                for (int slot = 0; slot < this.iData[day].length; ++slot) {
                    if (this.iData[day][slot] == null) continue;
                    HashSet<Integer> used = new HashSet<Integer>();
                    ArrayList<TimetableGridCell> cells = new ArrayList<TimetableGridCell>();
                    for (TimetableGridCell cell : this.iData[day][slot]) {
                        if (cell == null || !cell.getWeekCode().get(date)) continue;
                        Integer i = index.get(cell.getAssignmentId());
                        if (i == null) {
                            cells.add(cell);
                            continue;
                        }
                        used.add(i);
                    }
                    int i = 0;
                    for (TimetableGridCell cell : cells) {
                        while (used.contains(i)) {
                            ++i;
                        }
                        index.put(cell.getAssignmentId(), i++);
                    }
                }
            }
        }
        return index;
    }

    public TimetableGridCell getCell(int day, int slot, int idx, int date) {
        if (this.iData[day][slot] == null) {
            return null;
        }
        Hashtable<Long, Integer> index = this.index(date);
        for (TimetableGridCell cell : this.iData[day][slot]) {
            if (cell == null || !cell.getWeekCode().get(date) || idx != index.get(cell.getAssignmentId())) continue;
            return cell;
        }
        return null;
    }

    public int getMaxIdx(int startDay, int endDay, int firstSlot, int lastSlot) {
        int max = 0;
        for (int day = startDay; day <= endDay; ++day) {
            for (int slot = firstSlot; slot <= lastSlot; ++slot) {
                if (this.iData[day][slot] == null) continue;
                max = Math.max(max, this.iData[day][slot].length - 1);
            }
        }
        return max;
    }

    public int getMaxIdx(int startDay, int endDay, int firstSlot, int lastSlot, int date) {
        int max = 0;
        for (int day = startDay; day <= endDay; ++day) {
            for (int slot = firstSlot; slot <= lastSlot; ++slot) {
                int idx = 0;
                if (this.iData[day][slot] != null) {
                    Hashtable<Long, Integer> index = this.index(date);
                    for (TimetableGridCell cell : this.iData[day][slot]) {
                        if (cell == null || !cell.getWeekCode().get(date)) continue;
                        idx = Math.max(idx, index.get(cell.getAssignmentId()));
                    }
                }
                max = Math.max(max, idx);
            }
        }
        return max;
    }

    public int getMaxIdxForDay(int day, int firstSlot, int lastSlot) {
        int max = 0;
        for (int slot = firstSlot; slot <= lastSlot; ++slot) {
            if (this.iData[day][slot] == null) continue;
            max = Math.max(max, this.iData[day][slot].length - 1);
        }
        return max;
    }

    public int getMaxIdxForDay(int day, int firstSlot, int lastSlot, int date) {
        return this.getMaxIdx(day, day, firstSlot, lastSlot, date);
    }

    public boolean isAvailable(int day, int slot) {
        return this.iAvailable[day][slot];
    }

    public void clearRendered() {
        this.iRendered = null;
        this.iRenderedDate = null;
    }

    public boolean isRendered(int day, int slot, int idx) {
        if (this.iRendered == null || this.iRendered[day][slot] == null) {
            return false;
        }
        if (this.iRendered[day][slot].length <= idx) {
            return false;
        }
        return this.iRendered[day][slot][idx];
    }

    public void setRendered(int day, int slot, int idx, int rowSpan, int colSpan) {
        if (this.iRendered == null) {
            this.iRendered = new boolean[Constants.DAY_CODES.length][288][];
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < 288; ++j) {
                    this.iRendered[i][j] = null;
                }
            }
        }
        for (int row = 0; row < rowSpan; ++row) {
            for (int col = 0; col < colSpan; ++col) {
                if (this.iRendered[day][slot + col] == null) {
                    this.iRendered[day][slot + col] = new boolean[idx + rowSpan];
                    for (int i = 0; i < idx + rowSpan; ++i) {
                        this.iRendered[day][slot + col][i] = false;
                    }
                    this.iRendered[day][slot + col][idx + row] = true;
                    continue;
                }
                if (this.iRendered[day][slot + col].length <= idx + row) {
                    boolean[] old = this.iRendered[day][slot + col];
                    this.iRendered[day][slot + col] = new boolean[idx + rowSpan];
                    for (int i = 0; i < idx + rowSpan; ++i) {
                        this.iRendered[day][slot + col][i] = i < old.length ? old[i] : false;
                    }
                    this.iRendered[day][slot + col][idx + row] = true;
                    continue;
                }
                if (this.iRendered[day][slot + col][idx + row]) {
                    System.out.println("WARN: (" + day + "," + (slot + col) + "," + (idx + row) + ") already rendered");
                }
                this.iRendered[day][slot + col][idx + row] = true;
            }
        }
    }

    public boolean isRendered(int day, int slot, int idx, int date) {
        if (this.iRenderedDate == null || this.iRenderedDate[day][slot] == null) {
            return false;
        }
        if (this.iRenderedDate[day][slot].length <= idx) {
            return false;
        }
        return this.iRenderedDate[day][slot][idx].contains(date);
    }

    public void setRendered(int day, int slot, int idx, int rowSpan, int colSpan, int date) {
        if (this.iRenderedDate == null) {
            this.iRenderedDate = new HashSet[Constants.DAY_CODES.length][288][];
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < 288; ++j) {
                    this.iRenderedDate[i][j] = null;
                }
            }
        }
        for (int row = 0; row < rowSpan; ++row) {
            for (int col = 0; col < colSpan; ++col) {
                if (this.iRenderedDate[day][slot + col] == null) {
                    this.iRenderedDate[day][slot + col] = new HashSet[idx + rowSpan];
                    for (int i = 0; i < idx + rowSpan; ++i) {
                        this.iRenderedDate[day][slot + col][i] = new HashSet();
                    }
                    this.iRenderedDate[day][slot + col][idx + row].add(date);
                    continue;
                }
                if (this.iRenderedDate[day][slot + col].length <= idx + row) {
                    HashSet<Integer>[] old = this.iRenderedDate[day][slot + col];
                    this.iRenderedDate[day][slot + col] = new HashSet[idx + rowSpan];
                    for (int i = 0; i < idx + rowSpan; ++i) {
                        this.iRenderedDate[day][slot + col][i] = i < old.length ? old[i] : new HashSet<Integer>();
                    }
                    this.iRenderedDate[day][slot + col][idx + row].add(date);
                    continue;
                }
                if (this.iRenderedDate[day][slot + col][idx + row].contains(date)) {
                    System.out.println("WARN: (" + day + "," + (slot + col) + "," + (idx + row) + "," + date + ") already rendered");
                }
                this.iRenderedDate[day][slot + col][idx + row].add(date);
            }
        }
    }

    public int getDepth(int day, int slot, int idx, int maxIdx, int colSpan) {
        int depth = Integer.MAX_VALUE;
        for (int col = 0; col < colSpan; ++col) {
            int d = 1;
            for (int i = idx + 1; i <= maxIdx && this.getCell(day, slot + col, i) == null && !this.isRendered(day, slot + col, i); ++i) {
                ++d;
            }
            depth = Math.min(depth, d);
        }
        return depth;
    }

    public int getDepth(int day, int slot, int idx, int maxIdx, int colSpan, int date) {
        int depth = Integer.MAX_VALUE;
        for (int col = 0; col < colSpan; ++col) {
            int d = 1;
            for (int i = idx + 1; i <= maxIdx && this.getCell(day, slot + col, i, date) == null && !this.isRendered(day, slot + col, i, date); ++i) {
                ++d;
            }
            depth = Math.min(depth, d);
        }
        return depth;
    }

    protected boolean isUselessFirst(int d, int s) {
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return this.nrCells(d, s - 1) != 0 && this.nrCells(d, s + 0) == 0 && this.nrCells(d, s + 1) == 0 && this.nrCells(d, s + 2) == 0 && this.nrCells(d, s + 3) == 0 && this.nrCells(d, s + 4) == 0 && this.nrCells(d, s + 5) == 0 && this.nrCells(d, s + 6) != 0;
    }

    protected boolean isUseless(int d, int s) {
        return this.isUselessFirst(d, s) || this.isUselessFirst(d, s - 1) || this.isUselessFirst(d, s - 2) || this.isUselessFirst(d, s - 3) || this.isUselessFirst(d, s - 4) || this.isUselessFirst(d, s - 5);
    }

    protected void initBgModeUselessSlots() {
        for (int d = 0; d < Constants.DAY_CODES.length; ++d) {
            for (int s = 0; s < 288; ++s) {
                if (!this.isAvailable(d, s)) continue;
                int pref = 0;
                if (this.nrCells(d, s) == 0) {
                    if (this.isUseless(d, s)) {
                        pref = 4;
                    }
                    switch (d) {
                        case 0: {
                            if (this.nrCells(2, s) == 0 || this.nrCells(4, s) == 0) break;
                            ++pref;
                            break;
                        }
                        case 1: {
                            if (this.nrCells(3, s) == 0) break;
                            ++pref;
                            break;
                        }
                        case 2: {
                            if (this.nrCells(0, s) == 0 || this.nrCells(4, s) == 0) break;
                            ++pref;
                            break;
                        }
                        case 3: {
                            if (this.nrCells(1, s) == 0) break;
                            ++pref;
                            break;
                        }
                        case 4: {
                            if (this.nrCells(0, s) == 0 || this.nrCells(2, s) == 0) break;
                            ++pref;
                        }
                    }
                }
                String background = TimetableGridCell.pref2color(PreferenceLevel.sNeutral);
                if (pref > 4) {
                    background = TimetableGridCell.pref2color(PreferenceLevel.sProhibited);
                } else if (pref == 4) {
                    background = TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged);
                } else if (pref > 0) {
                    background = TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged);
                }
                this.setBackground(d, s, background);
            }
        }
    }
}

