/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.commons.Debug;
import org.unitime.commons.web.htmlgen.TableCell;
import org.unitime.commons.web.htmlgen.TableHeaderCell;
import org.unitime.commons.web.htmlgen.TableRow;
import org.unitime.commons.web.htmlgen.TableStream;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.form.InstructionalOfferingListFormInterface;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebInstructionalOfferingTableBuilder {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
    protected static DecimalFormat sRoomRatioFormat = new DecimalFormat("0.00");
    protected static String indent = "&nbsp;&nbsp;&nbsp;&nbsp;";
    protected static String oddRowBGColor = "#f1f3f9";
    protected static String oddRowBGColorChild = "#EFEFEF";
    protected static String oddRowMouseOverBGColor = "#8EACD0";
    protected static String evenRowMouseOverBGColor = "#8EACD0";
    protected String disabledColor = "gray";
    protected static String formName = "instructionalOfferingListForm";
    protected static String LABEL = "&nbsp;";
    protected String[] COLUMNS = new String[]{LABEL, MSG.columnTitle(), MSG.columnExternalId(), MSG.columnDemand(), MSG.columnProjectedDemand(), MSG.columnConsent(), MSG.columnMinPerWk(), MSG.columnLimit(), MSG.columnRoomRatio(), MSG.columnManager(), MSG.columnDatePattern(), MSG.columnTimePattern(), MSG.columnPreferences(), MSG.columnInstructor(), MSG.columnTimetable(), MSG.columnOfferingCredit(), MSG.columnSubpartCredit(), MSG.columnSchedulePrintNote(), MSG.columnNote(), MSG.columnExam()};
    protected static boolean sAggregateRoomPrefs = true;
    protected String[] PREFERENCE_COLUMN_ORDER;
    protected String[] TIMETABLE_COLUMN_ORDER;
    private boolean showLabel;
    private boolean showDivSec;
    private boolean showDemand;
    private boolean showProjectedDemand;
    private boolean showMinPerWk;
    private boolean showLimit;
    private boolean showRoomRatio;
    private boolean showManager;
    private boolean showDatePattern;
    private boolean showTimePattern;
    private boolean showPreferences;
    private boolean showInstructor;
    private boolean showTimetable;
    private boolean showCredit;
    private boolean showSubpartCredit;
    private boolean showSchedulePrintNote;
    private boolean showNote;
    private boolean showTitle;
    private boolean showConsent;
    private boolean showExam;
    private boolean showExamName;
    private boolean showExamTimetable;
    private boolean iDisplayDistributionPrefs;
    private boolean iDisplayTimetable;
    private String iBackType;
    private String iBackId;
    private Comparator iClassComparator;
    private boolean displayConfigOpButtons;
    private boolean iTimeVertical;
    private boolean iGridAsText;
    public String iInstructorNameFormat;
    public String iDefaultTimeGridSize;

    public void setDisplayConfigOpButtons(boolean displayConfigOpButtons) {
        this.displayConfigOpButtons = displayConfigOpButtons;
    }

    public boolean getDisplayConfigOpButtons() {
        return this.displayConfigOpButtons;
    }

    public void setDisplayDistributionPrefs(boolean displayDistributionPrefs) {
        this.iDisplayDistributionPrefs = displayDistributionPrefs;
    }

    public boolean getDisplayDistributionPrefs() {
        return this.iDisplayDistributionPrefs;
    }

    public void setDisplayTimetable(boolean displayTimetable) {
        this.iDisplayTimetable = displayTimetable;
    }

    public boolean getDisplayTimetable() {
        return this.iDisplayTimetable;
    }

    public void setTimeVertival(boolean timeVertical) {
        this.iTimeVertical = timeVertical;
    }

    public boolean getTimeVertival() {
        return this.iTimeVertical;
    }

    public void setGridAsText(boolean gridAsText) {
        this.iGridAsText = gridAsText;
    }

    public boolean getGridAsText() {
        return this.iGridAsText;
    }

    public void setInstructorNameFormat(String instructorNameFormat) {
        this.iInstructorNameFormat = instructorNameFormat;
    }

    public String getInstructorNameFormat() {
        return this.iInstructorNameFormat;
    }

    public void setDefaultTimeGridSize(String defaultTimeGridSize) {
        this.iDefaultTimeGridSize = defaultTimeGridSize;
    }

    public String getDefaultTimeGridSize() {
        return this.iDefaultTimeGridSize;
    }

    public void setUserSettings(UserContext user) {
        this.setTimeVertival(RequiredTimeTable.getTimeGridVertical(user));
        this.setGridAsText(RequiredTimeTable.getTimeGridAsText(user));
        this.setInstructorNameFormat(UserProperty.NameFormat.get(user));
        this.setDefaultTimeGridSize(RequiredTimeTable.getTimeGridSize(user));
    }

    public boolean isShowConsent() {
        return this.showConsent;
    }

    public void setShowConsent(boolean showConsent) {
        this.showConsent = showConsent;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public boolean isShowExam() {
        return this.showExam;
    }

    public void setShowExam(boolean showExam) {
        this.showExam = showExam;
    }

    public boolean isShowExamName() {
        return this.showExamName;
    }

    public void setShowExamName(boolean showExamName) {
        this.showExamName = showExamName;
    }

    public boolean isShowExamTimetable() {
        return this.showExamTimetable;
    }

    public void setShowExamTimetable(boolean showExamTimetable) {
        this.showExamTimetable = showExamTimetable;
    }

    public WebInstructionalOfferingTableBuilder() {
        String[] stringArray;
        if (sAggregateRoomPrefs) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = MSG.columnTimePref();
            stringArray2[1] = MSG.columnAllRoomPref();
            stringArray = stringArray2;
            stringArray2[2] = MSG.columnDistributionPref();
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = MSG.columnTimePref();
            stringArray3[1] = MSG.columnRoomGroupPref();
            stringArray3[2] = MSG.columnBuildingPref();
            stringArray3[3] = MSG.columnRoomPref();
            stringArray3[4] = MSG.columnRoomFeaturePref();
            stringArray = stringArray3;
            stringArray3[5] = MSG.columnDistributionPref();
        }
        this.PREFERENCE_COLUMN_ORDER = stringArray;
        this.TIMETABLE_COLUMN_ORDER = new String[]{MSG.columnAssignedTime(), MSG.columnAssignedRoom(), MSG.columnAssignedRoomCapacity()};
        this.showExamName = true;
        this.iDisplayDistributionPrefs = true;
        this.iDisplayTimetable = true;
        this.iBackType = null;
        this.iBackId = null;
        this.iClassComparator = new ClassComparator(3);
        this.displayConfigOpButtons = false;
        this.iTimeVertical = false;
        this.iGridAsText = false;
        this.iInstructorNameFormat = "last-first";
        this.iDefaultTimeGridSize = null;
    }

    protected String getRowMouseOver(boolean isHeaderRow, boolean isControl) {
        return "this.style.backgroundColor='" + (isHeaderRow ? oddRowMouseOverBGColor : evenRowMouseOverBGColor) + "';this.style.cursor='" + (isControl ? "hand" : "default") + "';this.style.cursor='" + (isControl ? "pointer" : "default") + "';";
    }

    protected String getRowMouseOut(boolean isHeaderRow) {
        return "this.style.backgroundColor='" + (isHeaderRow ? oddRowBGColor : "transparent") + "';";
    }

    protected String getRowMouseOut(boolean isHeaderRow, int ct) {
        return "this.style.backgroundColor='" + (isHeaderRow ? oddRowBGColor : (ct % 2 == 1 ? oddRowBGColorChild : "transparent")) + "';";
    }

    protected TableRow initRow(boolean isHeaderRow) {
        TableRow row = new TableRow();
        if (isHeaderRow) {
            row.setBgColor(oddRowBGColor);
        }
        return row;
    }

    protected TableHeaderCell headerCell(String content, int rowSpan, int colSpan) {
        TableHeaderCell cell = new TableHeaderCell();
        cell.setRowSpan(rowSpan);
        cell.setColSpan(colSpan);
        cell.setAlign("left");
        cell.setValign("bottom");
        cell.addContent("<font size=\"-1\">");
        cell.addContent(content);
        cell.addContent("</font>");
        cell.setStyleClass("WebTableHeader");
        return cell;
    }

    private TableCell initCell(boolean isEditable, String onClick, int cols) {
        return this.initCell(isEditable, onClick, cols, false);
    }

    private TableCell initCell(boolean isEditable, String onClick, int cols, boolean nowrap) {
        TableCell cell = new TableCell();
        cell.setValign("top");
        if (cols > 1) {
            cell.setColSpan(cols);
        }
        if (nowrap) {
            cell.setNoWrap(true);
        }
        if (onClick != null && onClick.length() > 0) {
            cell.setOnClick(onClick);
        }
        if (!isEditable) {
            cell.addContent("<span style=\"color:" + this.disabledColor + ";\">");
        }
        return cell;
    }

    private void endCell(TableCell cell, boolean isEditable) {
        if (!isEditable) {
            cell.addContent("</span>");
        }
    }

    protected TableCell initNormalCell(String text, boolean isEditable) {
        return this.initColSpanCell(text, isEditable, 1);
    }

    private TableCell initColSpanCell(String text, boolean isEditable, int cols) {
        TableCell cell = this.initCell(isEditable, null, cols);
        cell.addContent(text);
        this.endCell(cell, isEditable);
        return cell;
    }

    protected void buildTableHeader(TableStream table, Long sessionId) {
        int j;
        TableRow row = new TableRow();
        TableRow row2 = new TableRow();
        TableHeaderCell cell = null;
        if (this.isShowLabel()) {
            cell = this.headerCell(LABEL, 2, 1);
            row.addContent(cell);
        }
        if (this.isShowDivSec()) {
            cell = this.headerCell(MSG.columnExternalId(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowDemand()) {
            cell = StudentClassEnrollment.sessionHasEnrollments(sessionId) ? this.headerCell(MSG.columnDemand(), 2, 1) : this.headerCell(MSG.columnLastDemand(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowProjectedDemand()) {
            cell = this.headerCell(MSG.columnProjectedDemand(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowLimit()) {
            cell = this.headerCell(MSG.columnLimit(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowRoomRatio()) {
            cell = this.headerCell(MSG.columnRoomRatio(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowManager()) {
            cell = this.headerCell(MSG.columnManager(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowDatePattern()) {
            cell = this.headerCell(MSG.columnDatePattern(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowMinPerWk()) {
            cell = this.headerCell(MSG.columnMinPerWk(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowTimePattern()) {
            cell = this.headerCell(MSG.columnTimePattern(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowPreferences()) {
            cell = this.headerCell("----" + MSG.columnPreferences() + "----", 1, this.PREFERENCE_COLUMN_ORDER.length + (this.iDisplayDistributionPrefs ? 0 : -1));
            cell.setStyleClass("WebTableHeaderFirstRow");
            cell.setAlign("center");
            row.addContent(cell);
            for (j = 0; j < this.PREFERENCE_COLUMN_ORDER.length + (this.iDisplayDistributionPrefs ? 0 : -1); ++j) {
                cell = this.headerCell(this.PREFERENCE_COLUMN_ORDER[j], 1, 1);
                cell.setStyleClass("WebTableHeaderSecondRow");
                row2.addContent(cell);
            }
        }
        if (this.isShowInstructor()) {
            cell = this.headerCell(MSG.columnInstructor(), 2, 1);
            row.addContent(cell);
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            cell = this.headerCell("--------" + MSG.columnTimetable() + "--------", 1, this.TIMETABLE_COLUMN_ORDER.length);
            cell.setStyleClass("WebTableHeaderFirstRow");
            cell.setAlign("center");
            row.addContent(cell);
            for (j = 0; j < this.TIMETABLE_COLUMN_ORDER.length; ++j) {
                cell = this.headerCell(this.TIMETABLE_COLUMN_ORDER[j], 1, 1);
                cell.setNoWrap(true);
                cell.setStyleClass("WebTableHeaderSecondRow");
                row2.addContent(cell);
            }
        }
        if (this.isShowTitle()) {
            cell = this.headerCell(MSG.columnTitle(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowCredit()) {
            cell = this.headerCell(MSG.columnOfferingCredit(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowSubpartCredit()) {
            cell = this.headerCell(MSG.columnSubpartCredit(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowConsent()) {
            cell = this.headerCell(MSG.columnConsent(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowSchedulePrintNote()) {
            cell = this.headerCell(this.getSchedulePrintNoteLabel(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowNote()) {
            cell = this.headerCell(MSG.columnNote(), 2, 1);
            row.addContent(cell);
        }
        if (this.isShowExam()) {
            cell = this.headerCell("-----------" + MSG.columnExam() + "--------", 1, (this.isShowExamName() ? 1 : 0) + (this.isShowExamTimetable() ? 2 : 0));
            cell.setStyleClass("WebTableHeaderFirstRow");
            cell.setAlign("center");
            cell.setNoWrap(true);
            row.addContent(cell);
            if (this.isShowExamName()) {
                cell = this.headerCell(MSG.columnExamName(), 1, 1);
                cell.setNoWrap(true);
                cell.setStyleClass("WebTableHeaderSecondRow");
                row2.addContent(cell);
            }
            if (this.isShowExamTimetable()) {
                cell = this.headerCell(MSG.columnExamPeriod(), 1, 1);
                cell.setNoWrap(true);
                cell.setStyleClass("WebTableHeaderSecondRow");
                row2.addContent(cell);
                cell = this.headerCell(MSG.columnExamRoom(), 1, 1);
                cell.setNoWrap(true);
                cell.setStyleClass("WebTableHeaderSecondRow");
                row2.addContent(cell);
            }
        }
        table.addContent(row);
        table.addContent(row2);
    }

    protected String getSchedulePrintNoteLabel() {
        return MSG.columnSchedulePrintNote();
    }

    private String subjectOnClickAction(Long instrOfferingId) {
        return "document.location='instructionalOfferingDetail.do?op=view&io=" + instrOfferingId + "';";
    }

    private TableCell subjectAndCourseInfo(InstructionalOffering io, CourseOffering co, boolean isEditable) {
        TableCell cell = this.initCell(isEditable && co.isIsControl() != false, null, 1, true);
        if ("InstructionalOffering".equals(this.getBackType()) && io.getUniqueId().toString().equals(this.getBackId())) {
            cell.addContent("<A name=\"back\"></A>");
        }
        if ("PreferenceGroup".equals(this.getBackType())) {
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                    if (ss.getUniqueId().toString().equals(this.getBackId())) {
                        cell.addContent("<A name=\"back\"></A>");
                    }
                    for (Class_ c : ss.getClasses()) {
                        if (!c.getUniqueId().toString().equals(this.getBackId())) continue;
                        cell.addContent("<A name=\"back\"></A>");
                    }
                }
            }
        }
        cell.addContent("<A name=\"A" + io.getUniqueId().toString() + "\"></A>");
        cell.addContent("<A name=\"A" + co.getUniqueId().toString() + "\"></A>");
        cell.addContent(co != null ? "<span title='" + co.getCourseNameWithTitle() + "'><b>" + co.getSubjectAreaAbbv() + "</b>" : "");
        cell.addContent(" ");
        cell.addContent(co != null ? "<b>" + co.getCourseNbr() + "</b></span>" : "");
        if (co != null && co.getCourseType() != null) {
            cell.addContent(" (<span title='" + co.getCourseType().getLabel() + "'>" + co.getCourseType().getReference() + "</span>)");
        }
        Iterator it = io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId()).iterator();
        StringBuffer addlCos = new StringBuffer();
        CourseOffering tempCo = null;
        addlCos.append("<font color='" + this.disabledColor + "'>");
        while (it.hasNext()) {
            tempCo = (CourseOffering)it.next();
            addlCos.append("<br>");
            addlCos.append(indent);
            addlCos.append("<span title='" + tempCo.getCourseNameWithTitle() + "'>");
            addlCos.append(tempCo.getSubjectAreaAbbv());
            addlCos.append(" ");
            addlCos.append(tempCo.getCourseNbr());
            if (tempCo != null && tempCo.getCourseType() != null) {
                addlCos.append(" (<span title='" + tempCo.getCourseType().getLabel() + "'>" + tempCo.getCourseType().getReference() + "</span>)");
            }
            addlCos.append("</span>");
        }
        addlCos.append("</font>");
        if (tempCo != null) {
            cell.addContent(addlCos.toString());
        }
        this.endCell(cell, co.isIsControl());
        return cell;
    }

    protected TableCell buildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel) {
        TableCell cell = this.initNormalCell(indentSpaces, isEditable);
        if (!isEditable) {
            cell.addContent("<font color='" + this.disabledColor + "'>");
        }
        cell.addContent("<A name=\"A" + prefGroup.getUniqueId().toString() + "\"></A>");
        String label = prefGroup.htmlLabel();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (!aClass.isEnabledForStudentScheduling().booleanValue()) {
                cell.setTitle(MSG.tooltipDisabledForStudentScheduling(aClass.getClassLabelWithTitle(co)));
                label = "<i>" + label + "</i>";
            } else {
                cell.setTitle(aClass.getClassLabelWithTitle(co));
            }
        }
        if (prevLabel != null && label.equals(prevLabel)) {
            label = " &nbsp;";
        }
        cell.addContent(label);
        cell.setNoWrap(true);
        if (!isEditable) {
            cell.addContent("</font>");
        }
        return cell;
    }

    protected TableCell buildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Assignment a = null;
        AssignmentPreferenceInfo p = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
                p = classAssignment.getAssignmentInfo((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        TableCell cell = null;
        if (dp == null) {
            cell = this.initNormalCell("", isEditable);
        } else if (dp.getType() == 4 && isEditable) {
            String text = "";
            boolean hasReq = false;
            for (Preference pref : prefGroup.effectivePreferences(DatePatternPref.class)) {
                if (!hasReq && PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) {
                    hasReq = true;
                    text = "";
                }
                if (hasReq && !PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) continue;
                text = text + (text.isEmpty() ? "" : "<br>") + pref.preferenceHtml();
            }
            cell = this.initNormalCell("<div>" + dp.getName() + "</div>" + text, isEditable);
        } else {
            cell = this.initNormalCell("<div title='" + sDateFormat.format(dp.getStartDate()) + " - " + sDateFormat.format(dp.getEndDate()) + "' " + (p == null || !isEditable ? "" : "style='color:" + PreferenceLevel.int2color(p.getDatePatternPref()) + ";'") + ">" + dp.getName() + "</div>", isEditable);
        }
        cell.setAlign("center");
        return cell;
    }

    private TableCell buildTimePatternCell(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = this.initNormalCell(prefGroup.effectiveTimePatternHtml(), isEditable);
        cell.setAlign("center");
        cell.setNoWrap(true);
        return cell;
    }

    private TableCell buildTimePrefCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Assignment a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        TableCell cell = this.initNormalCell(prefGroup.getEffectivePrefHtmlForPrefType(a, TimePref.class, this.getTimeVertival(), this.getGridAsText(), this.getDefaultTimeGridSize()), isEditable);
        cell.setNoWrap(true);
        return cell;
    }

    private TableCell buildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class prefType, boolean isEditable) {
        if (!isEditable) {
            return this.initNormalCell("", false);
        }
        if (TimePref.class.equals((Object)prefType)) {
            return this.buildTimePrefCell(classAssignment, prefGroup, isEditable);
        }
        TableCell cell = this.initNormalCell(prefGroup.getEffectivePrefHtmlForPrefType(prefType), isEditable);
        cell.setNoWrap(true);
        return cell;
    }

    private TableCell buildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class[] prefTypes, boolean isEditable) {
        if (!isEditable) {
            return this.initNormalCell("", false);
        }
        StringBuffer pref = new StringBuffer();
        boolean noRoomPrefs = false;
        if (prefGroup instanceof Class_ && ((Class_)prefGroup).getNbrRooms() == 0) {
            noRoomPrefs = true;
        }
        if (prefGroup instanceof SchedulingSubpart && ((SchedulingSubpart)prefGroup).getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            noRoomPrefs = true;
        }
        for (int i = 0; i < prefTypes.length; ++i) {
            String x;
            Class prefType = prefTypes[i];
            if (noRoomPrefs && (prefType.equals(RoomGroupPref.class) || prefType.equals(RoomFeaturePref.class) || prefType.equals(BuildingPref.class)) || (x = prefGroup.getEffectivePrefHtmlForPrefType(prefType)) == null || x.trim().length() <= 0) continue;
            if (pref.length() > 0) {
                pref.append("<BR>");
            }
            pref.append(x);
        }
        TableCell cell = this.initNormalCell(noRoomPrefs && pref.length() == 0 ? "<i>N/A</i>" : pref.toString(), isEditable);
        cell.setNoWrap(true);
        return cell;
    }

    private TableCell buildPrefGroupDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        if (prefGroup instanceof Class_ && StudentClassEnrollment.sessionHasEnrollments((c = (Class_)prefGroup).getSessionId())) {
            TableCell tc = null;
            tc = c.getEnrollment() != null ? this.initNormalCell(c.getEnrollment().toString(), isEditable) : this.initNormalCell("0", isEditable);
            tc.setAlign("right");
            return tc;
        }
        return this.initNormalCell("&nbsp;", isEditable);
    }

    private TableCell buildPrefGroupProjectedDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        SectioningInfo i;
        if (prefGroup instanceof Class_ && (i = (c = (Class_)prefGroup).getSectioningInfo()) != null && i.getNbrExpectedStudents() != null) {
            TableCell cell = this.initNormalCell(String.valueOf(Math.round(Math.max(0.0, (double)c.getEnrollment().intValue() + i.getNbrExpectedStudents()))), isEditable);
            cell.setAlign("right");
            return cell;
        }
        return this.initNormalCell("&nbsp;", isEditable);
    }

    private TableCell buildLimit(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        boolean nowrap = false;
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            boolean unlimited = ss.getInstrOfferingConfig().isUnlimitedEnrollment();
            if (!unlimited) {
                int maxExpCap;
                int limit = ss.getLimit() == null ? 0 : ss.getLimit();
                if (limit == (maxExpCap = ss.getMaxExpectedCapacity())) {
                    cell = this.initNormalCell(String.valueOf(limit), isEditable);
                } else {
                    cell = this.initNormalCell(limit + "-" + maxExpCap, isEditable);
                    nowrap = true;
                }
            } else {
                cell = this.initNormalCell("&nbsp;", isEditable);
            }
        } else if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            boolean unlimited = aClass.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment();
            if (!unlimited) {
                String limitString = null;
                Assignment a = null;
                try {
                    if (classAssignment != null) {
                        a = classAssignment.getAssignment(aClass);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (a == null) {
                    if (aClass.getExpectedCapacity() != null) {
                        limitString = aClass.getExpectedCapacity().toString();
                        if (aClass.getMaxExpectedCapacity() != null && !aClass.getMaxExpectedCapacity().equals(aClass.getExpectedCapacity())) {
                            limitString = limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                            nowrap = true;
                        }
                    } else {
                        limitString = "0";
                        if (aClass.getMaxExpectedCapacity() != null && aClass.getMaxExpectedCapacity() != 0) {
                            limitString = limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                            nowrap = true;
                        }
                    }
                } else {
                    limitString = "" + aClass.getClassLimit(classAssignment);
                }
                cell = this.initNormalCell(limitString, isEditable);
                if (nowrap) {
                    cell.setNoWrap(true);
                }
            } else {
                cell = this.initNormalCell("<font size=\"+1\">&infin;</font>", isEditable);
            }
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        cell.setAlign("right");
        return cell;
    }

    private TableCell buildDivisionSection(CourseOffering co, PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            String divSec = aClass.getClassSuffix(co);
            cell = this.initNormalCell(divSec == null ? "&nbsp;" : divSec, isEditable);
            cell.setAlign("right");
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        cell.setNoWrap(true);
        return cell;
    }

    protected TableCell buildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = this.initNormalCell("", isEditable);
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            String label = aClass.instructorHtml(this.getInstructorNameFormat());
            if (!aClass.isDisplayInstructor().booleanValue()) {
                label = "<i>" + label + "</i>";
            }
            if (!isEditable) {
                label = "<span style=\"color:gray;\">" + label + "</span>";
            }
            cell.addContent(label);
            cell.setAlign("left");
        } else {
            cell.addContent(" &nbsp; ");
        }
        return cell;
    }

    private TableCell buildCredit(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = this.initNormalCell("", isEditable);
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            if (ss.getCredit() != null) {
                cell.addContent("<span title='" + ss.getCredit().creditText() + "'>" + ss.getCredit().creditAbbv() + "</span>");
            } else {
                cell.addContent(" &nbsp; ");
            }
            cell.setAlign("left");
        } else {
            cell.addContent(" &nbsp; ");
        }
        return cell;
    }

    private TableCell buildSchedulePrintNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            if (c.getSchedulePrintNote() != null && !c.getSchedulePrintNote().trim().isEmpty()) {
                if (CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                    cell = this.initNormalCell(c.getSchedulePrintNote().replace("\n", "<br>"), isEditable);
                    cell.setAlign("left");
                } else if (CommonValues.NoteAsShortText.eq(user.getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                    String note = c.getSchedulePrintNote().length() <= 20 ? c.getSchedulePrintNote() : c.getSchedulePrintNote().substring(0, 20) + "...";
                    cell = this.initNormalCell(note.replace("\n", "<br>"), isEditable);
                    cell.setAlign("left");
                } else {
                    cell = this.initNormalCell("<IMG border='0' alt='" + MSG.altHasSchedulePrintNote() + "' title='" + c.getSchedulePrintNote() + "' align='absmiddle' src='images/note.png'>", isEditable);
                    cell.setAlign("center");
                }
            } else {
                cell = this.initNormalCell("&nbsp;", isEditable);
            }
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }

    private TableCell buildExamName(TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            sb.append("<span " + (0 == exam.getExamType().getType() ? "style='font-weight:bold;' " : "") + "title='" + MSG.tooltipExam(exam.getLabel(), exam.getExamType().getLabel()) + "'>");
            sb.append(exam.getLabel());
            if (0 == exam.getExamType().getType()) {
                sb.append("</span>");
            }
            if (!i.hasNext()) continue;
            sb.append("<br>");
        }
        TableCell cell = this.initNormalCell(sb.toString(), isEditable);
        cell.setAlign("left");
        cell.setNoWrap(true);
        return cell;
    }

    private TableCell buildExamPeriod(ExamAssignmentProxy examAssignment, TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            sb.append("<span " + (0 == exam.getExamType().getType() ? "style='font-weight:bold;' " : "") + "title='" + MSG.tooltipExam(exam.getLabel(), exam.getExamType().getLabel()) + "'>");
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                sb.append(ea == null ? "" : ea.getPeriodAbbreviationWithPref());
            } else {
                if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
                sb.append(exam.getAssignedPeriod() == null ? "" : exam.getAssignedPeriod().getAbbreviation());
            }
            if (0 == exam.getExamType().getType()) {
                sb.append("</span>");
            }
            if (!i.hasNext()) continue;
            sb.append("<br>");
        }
        TableCell cell = this.initNormalCell(sb.toString(), isEditable);
        cell.setAlign("left");
        cell.setNoWrap(true);
        return cell;
    }

    private TableCell buildExamRoom(ExamAssignmentProxy examAssignment, TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            sb.append("<span " + (0 == exam.getExamType().getType() ? "style='font-weight:bold;' " : "") + "title='" + MSG.tooltipExam(exam.getLabel(), exam.getExamType().getLabel()) + "'>");
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                sb.append(ea == null ? "" : ea.getRoomsNameWithPref(", "));
            } else {
                if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
                Iterator<Location> j = new TreeSet<Location>(exam.getAssignedRooms()).iterator();
                while (j.hasNext()) {
                    Location location = j.next();
                    sb.append(location.getLabelWithHint());
                    if (!j.hasNext()) continue;
                    sb.append(", ");
                }
            }
            if (0 == exam.getExamType().getType()) {
                sb.append("</span>");
            }
            if (!i.hasNext()) continue;
            sb.append("<br>");
        }
        TableCell cell = this.initNormalCell(sb.toString(), isEditable);
        cell.setAlign("left");
        cell.setNoWrap(true);
        return cell;
    }

    protected TreeSet getExams(Class_ clazz) {
        return new TreeSet(Exam.findAll(3, clazz.getUniqueId()));
    }

    private TableCell buildSchedulePrintNote(InstructionalOffering io, boolean isEditable, UserContext user) {
        TableCell cell = null;
        String note = "";
        for (CourseOffering co : io.getCourseOfferings()) {
            if (co.getScheduleBookNote() == null || co.getScheduleBookNote().trim().isEmpty()) continue;
            if (!note.isEmpty()) {
                note = note + "<br>";
            }
            if (CommonValues.NoteAsShortText.eq(user.getProperty(UserProperty.CourseOfferingNoteDisplay))) {
                note = note + (co.getScheduleBookNote().length() <= 20 ? co.getScheduleBookNote() : co.getScheduleBookNote().substring(0, 20) + "...");
                continue;
            }
            note = note + co.getScheduleBookNote();
        }
        if (note.isEmpty()) {
            cell = this.initNormalCell("&nbsp;", isEditable);
        } else if (CommonValues.NoteAsIcon.eq(user.getProperty(UserProperty.CourseOfferingNoteDisplay))) {
            cell = this.initNormalCell("<IMG border='0' alt='" + MSG.altHasCourseOfferingNote() + "' title='" + note.replace("<br>", "\n") + "' align='absmiddle' src='images/note.png'>", isEditable);
            cell.setAlign("center");
        } else {
            cell = this.initNormalCell(note.replace("\n", "<br>"), isEditable);
            cell.setAlign("left");
        }
        return cell;
    }

    private TableCell buildNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            if (c.getNotes() != null && !c.getNotes().trim().isEmpty()) {
                if (CommonValues.NoteAsShortText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                    String note = c.getNotes().length() <= 20 ? c.getNotes() : c.getNotes().substring(0, 20) + "...";
                    cell = this.initNormalCell(note.replaceAll("\n", "<br>"), isEditable);
                    cell.setAlign("left");
                } else if (CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                    cell = this.initNormalCell(c.getNotes().replaceAll("\n", "<br>"), isEditable);
                    cell.setAlign("left");
                } else {
                    cell = this.initNormalCell("<IMG border='0' alt='" + MSG.altHasNoteToMgr() + "' title='" + c.getNotes() + "' align='absmiddle' src='images/note.png'>", isEditable);
                    cell.setAlign("center");
                }
            } else {
                cell = this.initNormalCell("&nbsp;", isEditable);
            }
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }

    private TableCell buildManager(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        Department managingDept = null;
        if (prefGroup instanceof Class_) {
            managingDept = ((Class_)prefGroup).getManagingDept();
        } else if (prefGroup instanceof SchedulingSubpart) {
            managingDept = ((SchedulingSubpart)prefGroup).getManagingDept();
        }
        cell = this.initNormalCell(managingDept == null ? "&nbsp;" : managingDept.getManagingDeptAbbv(), isEditable);
        return cell;
    }

    private TableCell buildMinPerWeek(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            cell = this.initNormalCell(aClass.getSchedulingSubpart().getMinutesPerWk().toString(), isEditable);
            cell.setAlign("right");
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart aSchedulingSubpart = (SchedulingSubpart)prefGroup;
            cell = this.initNormalCell(aSchedulingSubpart.getMinutesPerWk().toString(), isEditable);
            cell.setAlign("right");
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }

    private TableCell buildRoomLimit(PreferenceGroup prefGroup, boolean isEditable, boolean classLimitDisplayed) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (aClass.getNbrRooms() != null && aClass.getNbrRooms() != 1) {
                if (aClass.getNbrRooms() == 0) {
                    cell = this.initNormalCell("<i>N/A</i>", isEditable);
                } else {
                    String text = aClass.getNbrRooms().toString();
                    text = text + " at ";
                    text = aClass.getRoomRatio() != null ? text + sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()) : text + "0";
                    cell = this.initNormalCell(text, isEditable);
                    cell.setNoWrap(true);
                }
            } else {
                cell = aClass.getRoomRatio() != null ? (classLimitDisplayed && aClass.getRoomRatio().equals(new Float(1.0)) ? this.initNormalCell("&nbsp;", isEditable) : this.initNormalCell(sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()), isEditable)) : (aClass.getExpectedCapacity() == null ? this.initNormalCell("&nbsp;", isEditable) : this.initNormalCell("0", isEditable));
            }
            cell.setAlign("right");
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }

    private TableCell buildAssignedTime(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            AssignmentPreferenceInfo info = null;
            try {
                a = classAssignment.getAssignment(aClass);
                info = classAssignment.getAssignmentInfo(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                if (info != null) {
                    sb.append("<font color='" + (isEditable ? PreferenceLevel.int2color(info.getTimePreference()) : this.disabledColor) + "'>");
                }
                TimeLocation.IntEnumeration e = a.getTimeLocation().getDays();
                while (e.hasMoreElements()) {
                    sb.append(Constants.DAY_NAMES_SHORT[(Integer)e.nextElement()]);
                }
                sb.append(" ");
                sb.append(a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
                sb.append("-");
                sb.append(a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
                if (info != null) {
                    sb.append("</font>");
                }
                cell = this.initNormalCell(sb.toString(), isEditable);
            } else {
                cell = this.initNormalCell("&nbsp;", isEditable);
            }
            cell.setAlign("left");
            cell.setNoWrap(true);
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }

    private TableCell buildAssignedRoom(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            AssignmentPreferenceInfo info = null;
            try {
                a = classAssignment.getAssignment(aClass);
                info = classAssignment.getAssignmentInfo(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Iterator<Location> it2 = a.getRooms().iterator();
                while (it2.hasNext()) {
                    Location room = it2.next();
                    if (info != null) {
                        sb.append("<span style='color:" + (isEditable ? PreferenceLevel.int2color(info.getRoomPreference(room.getUniqueId())) : this.disabledColor) + ";' " + "onmouseover=\"showGwtRoomHint(this, '" + room.getUniqueId() + "', '" + (isEditable ? PreferenceLevel.int2string(info.getRoomPreference(room.getUniqueId())) : "") + "');\" onmouseout=\"hideGwtRoomHint();\">");
                    }
                    sb.append(room.getLabel());
                    if (info != null) {
                        sb.append("</span>");
                    }
                    if (!it2.hasNext()) continue;
                    sb.append("<BR>");
                }
                cell = this.initNormalCell(sb.toString(), isEditable);
            } else {
                cell = this.initNormalCell("&nbsp;", isEditable);
            }
            cell.setAlign("left");
            cell.setNoWrap(true);
        } else {
            cell = this.initNormalCell(" &nbsp;", isEditable);
        }
        return cell;
    }

    private TableCell buildAssignedRoomCapacity(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            try {
                a = classAssignment.getAssignment(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Iterator<Location> it2 = a.getRooms().iterator();
                while (it2.hasNext()) {
                    sb.append(it2.next().getCapacity());
                    if (!it2.hasNext()) continue;
                    sb.append("<BR>");
                }
                cell = this.initNormalCell(sb.toString(), isEditable);
            } else {
                cell = this.initNormalCell(" &nbsp;", isEditable);
            }
            cell.setAlign("right");
            cell.setNoWrap(true);
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }

    protected void buildClassOrSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableRow row, CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel, SessionContext context) {
        int j;
        boolean classLimitDisplayed = false;
        if (this.isShowLabel()) {
            row.addContent(this.buildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel));
        }
        if (this.isShowDivSec()) {
            row.addContent(this.buildDivisionSection(co, prefGroup, isEditable));
        }
        if (this.isShowDemand()) {
            row.addContent(this.buildPrefGroupDemand(prefGroup, isEditable));
        }
        if (this.isShowProjectedDemand()) {
            row.addContent(this.buildPrefGroupProjectedDemand(prefGroup, isEditable));
        }
        if (this.isShowLimit()) {
            classLimitDisplayed = true;
            row.addContent(this.buildLimit(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowRoomRatio()) {
            row.addContent(this.buildRoomLimit(prefGroup, isEditable, classLimitDisplayed));
        }
        if (this.isShowManager()) {
            row.addContent(this.buildManager(prefGroup, isEditable));
        }
        if (this.isShowDatePattern()) {
            row.addContent(this.buildDatePatternCell(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowMinPerWk()) {
            row.addContent(this.buildMinPerWeek(prefGroup, isEditable));
        }
        if (this.isShowTimePattern()) {
            row.addContent(this.buildTimePatternCell(prefGroup, isEditable));
        }
        if (this.isShowPreferences()) {
            for (j = 0; j < this.PREFERENCE_COLUMN_ORDER.length; ++j) {
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnTimePref())) {
                    row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, TimePref.class, isEditable));
                    continue;
                }
                if (sAggregateRoomPrefs && this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnAllRoomPref())) {
                    row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, new Class[]{RoomPref.class, BuildingPref.class, RoomFeaturePref.class, RoomGroupPref.class}, isEditable));
                    continue;
                }
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnRoomPref())) {
                    row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, RoomPref.class, isEditable));
                    continue;
                }
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnBuildingPref())) {
                    row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, BuildingPref.class, isEditable));
                    continue;
                }
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnRoomFeaturePref())) {
                    row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, RoomFeaturePref.class, isEditable));
                    continue;
                }
                if (this.iDisplayDistributionPrefs && this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnDistributionPref())) {
                    row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, DistributionPref.class, isEditable));
                    continue;
                }
                if (!this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnRoomGroupPref())) continue;
                row.addContent(this.buildPreferenceCell(classAssignment, prefGroup, RoomGroupPref.class, isEditable));
            }
        }
        if (this.isShowInstructor()) {
            row.addContent(this.buildInstructor(prefGroup, isEditable));
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            for (j = 0; j < this.TIMETABLE_COLUMN_ORDER.length; ++j) {
                if (this.TIMETABLE_COLUMN_ORDER[j].equals(MSG.columnAssignedTime())) {
                    row.addContent(this.buildAssignedTime(classAssignment, prefGroup, isEditable));
                    continue;
                }
                if (this.TIMETABLE_COLUMN_ORDER[j].equals(MSG.columnAssignedRoom())) {
                    row.addContent(this.buildAssignedRoom(classAssignment, prefGroup, isEditable));
                    continue;
                }
                if (!this.TIMETABLE_COLUMN_ORDER[j].equals(MSG.columnAssignedRoomCapacity())) continue;
                row.addContent(this.buildAssignedRoomCapacity(classAssignment, prefGroup, isEditable));
            }
        }
        if (this.isShowTitle()) {
            row.addContent(this.initNormalCell("&nbsp;", isEditable));
        }
        if (this.isShowCredit()) {
            row.addContent(this.initNormalCell("&nbsp;", isEditable));
        }
        if (this.isShowSubpartCredit()) {
            row.addContent(this.buildCredit(prefGroup, isEditable));
        }
        if (this.isShowConsent()) {
            row.addContent(this.initNormalCell("&nbsp;", isEditable));
        }
        if (this.isShowSchedulePrintNote()) {
            row.addContent(this.buildSchedulePrintNote(prefGroup, isEditable, context.getUser()));
        }
        if (this.isShowNote()) {
            row.addContent(this.buildNote(prefGroup, isEditable, context.getUser()));
        }
        if (this.isShowExam()) {
            if (prefGroup instanceof Class_) {
                TreeSet exams = this.getExams((Class_)prefGroup);
                if (this.isShowExamName()) {
                    row.addContent(this.buildExamName(exams, isEditable));
                }
                if (this.isShowExamTimetable()) {
                    row.addContent(this.buildExamPeriod(examAssignment, exams, isEditable));
                    row.addContent(this.buildExamRoom(examAssignment, exams, isEditable));
                }
            } else {
                if (this.isShowExamName()) {
                    row.addContent(this.initNormalCell("&nbsp;", isEditable));
                }
                if (this.isShowExamTimetable()) {
                    row.addContent(this.initNormalCell("&nbsp;", isEditable));
                    row.addContent(this.initNormalCell("&nbsp;", isEditable));
                }
            }
        }
    }

    private void buildSchedulingSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableStream table, CourseOffering co, SchedulingSubpart ss, String indentSpaces, SessionContext context) {
        boolean isOffered;
        boolean isHeaderRow = true;
        TableRow row = this.initRow(isHeaderRow);
        boolean isEditable = context.hasPermission(ss, Right.SchedulingSubpartDetail);
        boolean bl = isOffered = ss.getInstrOfferingConfig().getInstructionalOffering().isNotOffered() == false;
        if (isOffered) {
            row.setOnMouseOver(this.getRowMouseOver(isHeaderRow, isEditable));
        }
        if (isEditable && isOffered) {
            row.setOnClick("document.location='schedulingSubpartDetail.do?ssuid=" + ss.getUniqueId().toString() + "'");
        }
        if (isOffered) {
            row.setOnMouseOut(this.getRowMouseOut(isHeaderRow));
        }
        this.buildClassOrSubpartRow(classAssignment, examAssignment, row, co, ss, indentSpaces, isEditable, null, context);
        table.addContent(row);
    }

    private void buildSchedulingSubpartRows(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableStream table, CourseOffering co, SchedulingSubpart ss, String indentSpaces, SessionContext context) {
        if (subpartIds != null) {
            subpartIds.add(ss.getUniqueId());
        }
        this.buildSchedulingSubpartRow(classAssignment, examAssignment, table, co, ss, indentSpaces, context);
        Set<SchedulingSubpart> childSubparts = ss.getChildSubparts();
        if (childSubparts != null && !childSubparts.isEmpty()) {
            ArrayList<SchedulingSubpart> childSubpartList = new ArrayList<SchedulingSubpart>(childSubparts);
            Collections.sort(childSubpartList, new SchedulingSubpartComparator());
            Iterator<SchedulingSubpart> it = childSubpartList.iterator();
            SchedulingSubpart child = null;
            while (it.hasNext()) {
                child = it.next();
                this.buildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, table, co, child, indentSpaces + indent, context);
            }
        }
    }

    protected void buildClassRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, TableStream table, CourseOffering co, Class_ aClass, String indentSpaces, SessionContext context, String prevLabel) {
        boolean isHeaderRow = false;
        boolean isEditable = context.hasPermission(aClass, Right.ClassDetail);
        TableRow row = this.initRow(isHeaderRow);
        row.setOnMouseOver(this.getRowMouseOver(isHeaderRow, isEditable));
        row.setOnMouseOut(this.getRowMouseOut(isHeaderRow));
        if (isEditable) {
            row.setOnClick("document.location='classDetail.do?cid=" + aClass.getUniqueId().toString() + "&sec=" + aClass.getSectionNumberString() + "'");
        }
        this.buildClassOrSubpartRow(classAssignment, examAssignment, row, co, aClass, indentSpaces, isEditable, prevLabel, context);
        table.addContent(row);
    }

    private void buildClassRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, TableStream table, CourseOffering co, Class_ aClass, String indentSpaces, SessionContext context, String prevLabel) {
        this.buildClassRow(classAssignment, examAssignment, ct, table, co, aClass, indentSpaces, context, prevLabel);
        Set<Class_> childClasses = aClass.getChildClasses();
        if (childClasses != null && !childClasses.isEmpty()) {
            ArrayList<Class_> childClassesList = new ArrayList<Class_>(childClasses);
            Collections.sort(childClassesList, this.iClassComparator);
            Iterator<Class_> it = childClassesList.iterator();
            Class_ child = null;
            String previousLabel = aClass.htmlLabel();
            while (it.hasNext()) {
                child = it.next();
                this.buildClassRows(classAssignment, examAssignment, ct, table, co, child, indentSpaces + indent, context, previousLabel);
            }
        }
    }

    protected void buildConfigRow(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableStream table, CourseOffering co, InstrOfferingConfig ioc, SessionContext context, boolean printConfigLine, boolean printConfigReservation) {
        boolean isHeaderRow = true;
        boolean isEditable = context.hasPermission(ioc.getInstructionalOffering(), Right.InstructionalOfferingDetail);
        String configName = ioc.getName();
        boolean unlimited = ioc.isUnlimitedEnrollment();
        boolean hasConfig = false;
        if (printConfigLine) {
            int j;
            TableRow row = this.initRow(isHeaderRow);
            TableCell cell = null;
            if (this.isShowLabel()) {
                if (configName == null || configName.trim().length() == 0) {
                    configName = ioc.getUniqueId().toString();
                }
                cell = this.initNormalCell(indent + MSG.labelConfiguration(configName), isEditable);
                cell.setNoWrap(true);
                row.addContent(cell);
            }
            if (this.isShowDivSec()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowDemand()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowProjectedDemand()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowLimit()) {
                cell = this.initNormalCell(unlimited ? "<font size=\"+1\">&infin;</font>" : ioc.getLimit().toString(), isEditable);
                cell.setAlign("right");
                row.addContent(cell);
            }
            if (this.isShowRoomRatio()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowManager()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowDatePattern()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowMinPerWk()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowTimePattern()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowPreferences()) {
                for (j = 0; j < this.PREFERENCE_COLUMN_ORDER.length + (this.iDisplayDistributionPrefs ? 0 : -1); ++j) {
                    row.addContent(this.initNormalCell("", isEditable));
                }
            }
            if (this.isShowInstructor()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.getDisplayTimetable() && this.isShowTimetable()) {
                for (j = 0; j < this.TIMETABLE_COLUMN_ORDER.length; ++j) {
                    row.addContent(this.initNormalCell("", isEditable));
                }
            }
            if (this.isShowTitle()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowCredit()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowSubpartCredit()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowConsent()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowSchedulePrintNote()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowNote()) {
                row.addContent(this.initNormalCell("", isEditable));
            }
            if (this.isShowExam()) {
                TreeSet exams = new TreeSet(Exam.findAll(2, ioc.getUniqueId()));
                if (this.isShowExamName()) {
                    row.addContent(this.buildExamName(exams, isEditable));
                }
                if (this.isShowExamTimetable()) {
                    row.addContent(this.buildExamPeriod(examAssignment, exams, isEditable));
                    row.addContent(this.buildExamRoom(examAssignment, exams, isEditable));
                }
            }
            table.addContent(row);
            hasConfig = true;
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        Iterator<SchedulingSubpart> it = subpartList.iterator();
        SchedulingSubpart ss = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null) continue;
            this.buildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, table, co, ss, hasConfig ? indent + indent : indent, context);
        }
        it = subpartList.iterator();
        int ct = 0;
        String prevLabel = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null || ss.getClasses() == null) continue;
            Vector<Class_> classes = new Vector<Class_>(ss.getClasses());
            Collections.sort(classes, this.iClassComparator);
            Iterator<Class_> cIt = classes.iterator();
            Class_ c = null;
            while (cIt.hasNext()) {
                c = cIt.next();
                this.buildClassRows(classAssignment, examAssignment, ++ct, table, co, c, indent, context, prevLabel);
                prevLabel = c.htmlLabel();
            }
        }
    }

    private void buildConfigRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableStream table, CourseOffering co, Set instrOfferingConfigs, SessionContext context, boolean printConfigLine, boolean printConfigReservation) {
        Iterator it = instrOfferingConfigs.iterator();
        InstrOfferingConfig ioc = null;
        while (it.hasNext()) {
            ioc = (InstrOfferingConfig)it.next();
            this.buildConfigRow(null, classAssignment, examAssignment, table, co, ioc, context, printConfigLine && instrOfferingConfigs.size() > 1, printConfigReservation);
        }
    }

    private void addInstrOffrRowsToTable(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableStream table, InstructionalOffering io, Long subjectAreaId, SessionContext context) {
        CourseOffering co = io.findSortCourseOfferingForSubjectArea(subjectAreaId);
        boolean isEditable = context.hasPermission(io, Right.InstructionalOfferingDetail);
        TableRow row = this.initRow(true);
        row.setOnMouseOver(this.getRowMouseOver(true, isEditable));
        row.setOnMouseOut(this.getRowMouseOut(true));
        if (isEditable) {
            row.setOnClick(this.subjectOnClickAction(io.getUniqueId()));
        }
        boolean isManagedAs = co.isIsControl() == false;
        TableCell cell = null;
        if (this.isShowLabel()) {
            row.addContent(this.subjectAndCourseInfo(io, co, isEditable));
        }
        if (this.isShowDivSec()) {
            row.addContent(this.initNormalCell("", isEditable));
        }
        if (this.isShowDemand()) {
            String demand = "0";
            if (StudentClassEnrollment.sessionHasEnrollments(io.getSessionId())) {
                demand = io.getEnrollment() != null ? io.getEnrollment().toString() : "0";
            } else {
                String string = demand = io.getDemand() != null ? io.getDemand().toString() : "0";
                if (co.isIsControl().booleanValue() && !io.isNotOffered().booleanValue() && (io.getDemand() == null || io.getDemand() == 0)) {
                    demand = "<span style='font-weight:bold;color:red;'>0</span>";
                }
            }
            cell = this.initNormalCell(demand, isEditable && co.isIsControl() != false);
            cell.setAlign("right");
            row.addContent(cell);
        }
        if (this.isShowProjectedDemand()) {
            cell = this.initNormalCell(io.getProjectedDemand() != null ? io.getProjectedDemand().toString() : "0", isEditable && co.isIsControl() != false);
            cell.setAlign("right");
            row.addContent(cell);
        }
        if (this.isShowLimit()) {
            boolean unlimited = false;
            Iterator<InstrOfferingConfig> x = io.getInstrOfferingConfigs().iterator();
            while (!unlimited && x.hasNext()) {
                if (!x.next().isUnlimitedEnrollment().booleanValue()) continue;
                unlimited = true;
            }
            cell = unlimited ? this.initNormalCell("<font size=\"+1\">&infin;</font>", co.isIsControl()) : this.initNormalCell(io.getLimit() != null ? io.getLimit().toString() : "", isEditable && co.isIsControl() != false);
            cell.setAlign("right");
            row.addContent(cell);
        }
        int emptyCells = 0;
        cell = null;
        if (this.isShowRoomRatio()) {
            ++emptyCells;
        }
        if (this.isShowManager()) {
            ++emptyCells;
        }
        if (this.isShowDatePattern()) {
            ++emptyCells;
        }
        if (this.isShowMinPerWk()) {
            ++emptyCells;
        }
        if (this.isShowTimePattern()) {
            ++emptyCells;
        }
        if (this.isShowPreferences()) {
            emptyCells += this.PREFERENCE_COLUMN_ORDER.length + (this.iDisplayDistributionPrefs ? 0 : -1);
        }
        if (this.isShowInstructor()) {
            ++emptyCells;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            emptyCells += this.TIMETABLE_COLUMN_ORDER.length;
        }
        if (emptyCells > 0) {
            String title;
            if (isManagedAs) {
                if (!this.isShowTitle() && io.getControllingCourseOffering().getTitle() != null) {
                    title = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                    if (co.getTitle() != null && co.getTitle().length() > 0) {
                        title = title + "<b>" + co.getTitle() + "</b>";
                        title = title + " (<span title='" + io.getControllingCourseOffering().getCourseNameWithTitle() + "'>Managed As " + io.getControllingCourseOffering().getCourseName() + "</span>)";
                    } else {
                        title = title + "<span title='" + io.getControllingCourseOffering().getCourseNameWithTitle() + "'>Managed As " + io.getControllingCourseOffering().getCourseName() + "</span>";
                    }
                    for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                        title = title + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                        if (x.getTitle() == null) continue;
                        title = title + "<font color=\"" + this.disabledColor + "\">" + x.getTitle() + "</font>";
                    }
                    cell = this.initNormalCell("<font color=\"" + this.disabledColor + "\">" + title + "</font>", isEditable);
                } else {
                    cell = this.initNormalCell("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"" + this.disabledColor + "\"><span title='" + io.getControllingCourseOffering().getCourseNameWithTitle() + "'>Managed As " + io.getControllingCourseOffering().getCourseName() + "</span></font>", isEditable);
                }
            } else if (!this.isShowTitle() && io.getControllingCourseOffering().getTitle() != null) {
                title = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                if (co.isIsControl().booleanValue()) {
                    title = title + "<b>";
                }
                title = title + (co.getTitle() == null ? "" : co.getTitle());
                if (co.isIsControl().booleanValue()) {
                    title = title + "</b>";
                }
                for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                    title = title + "<br>";
                    if (x.getTitle() == null) continue;
                    title = title + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"" + this.disabledColor + "\">" + x.getTitle() + "</font>";
                }
                cell = this.initNormalCell(title, isEditable);
            } else {
                cell = this.initNormalCell("", isEditable);
            }
            cell.setColSpan(emptyCells);
            cell.setAlign("left");
            row.addContent(cell);
        }
        if (this.isShowTitle()) {
            row.addContent(this.initNormalCell(io.getControllingCourseOffering().getTitle() != null ? io.getControllingCourseOffering().getTitle() : "&nbsp;", isEditable));
        }
        if (this.isShowCredit()) {
            String credit = "";
            if (co.isIsControl().booleanValue()) {
                credit = credit + "<b>";
            }
            credit = isManagedAs ? "<font color=\"" + this.disabledColor + "\"><b>" + (co.getCredit() == null ? "" : "<span title='" + co.getCredit().creditText() + "'>" + co.getCredit().creditAbbv() + "</span>") + "</b></font>" : "<b>" + (co.getCredit() == null ? "" : "<span title='" + co.getCredit().creditText() + "'>" + co.getCredit().creditAbbv() + "</span>") + "</b>";
            if (co.isIsControl().booleanValue()) {
                credit = credit + "</b>";
            }
            for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                credit = credit + "<br>";
                if (x.getCredit() == null) continue;
                credit = credit + "<font color=\"" + this.disabledColor + "\"><span title='" + x.getCredit().creditText() + "'>" + x.getCredit().creditAbbv() + "</span></font>";
            }
            row.addContent(this.initNormalCell(credit, isEditable));
        }
        if (this.isShowSubpartCredit()) {
            row.addContent(this.initNormalCell("", isEditable));
        }
        if (this.isShowConsent()) {
            String consent = "";
            if (co.isIsControl().booleanValue()) {
                consent = consent + "<b>";
            }
            consent = isManagedAs ? "<font color=\"" + this.disabledColor + "\"><b>" + (co.getConsentType() == null ? MSG.noConsentRequired() : "<span title='" + co.getConsentType().getLabel() + "'>" + co.getConsentType().getAbbv() + "</span>") + "</b></font>" : "<b>" + (co.getConsentType() == null ? MSG.noConsentRequired() : "<span title='" + co.getConsentType().getLabel() + "'>" + co.getConsentType().getAbbv() + "</span>") + "</b>";
            if (co.isIsControl().booleanValue()) {
                consent = consent + "</b>";
            }
            for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                consent = consent + "<br>";
                if (x.getConsentType() != null) {
                    consent = consent + "<font color=\"" + this.disabledColor + "\"><span title='" + x.getConsentType().getLabel() + "'>" + x.getConsentType().getAbbv() + "</span></font>";
                    continue;
                }
                consent = consent + "<font color=\"" + this.disabledColor + "\">" + MSG.noConsentRequired() + "</font>";
            }
            row.addContent(this.initNormalCell(consent, isEditable));
        }
        if (this.isShowSchedulePrintNote()) {
            row.addContent(this.buildSchedulePrintNote(io, isEditable, context.getUser()));
        }
        if (this.isShowNote()) {
            row.addContent(this.initNormalCell("", isEditable));
        }
        if (this.isShowExam()) {
            TreeSet exams = new TreeSet(Exam.findAll(0, io.getUniqueId()));
            for (CourseOffering cox : io.getCourseOfferings()) {
                exams.addAll(Exam.findAll(1, cox.getUniqueId()));
            }
            if (io.getInstrOfferingConfigs().size() == 1) {
                for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                    exams.addAll(Exam.findAll(2, ioc.getUniqueId()));
                }
            }
            if (this.isShowExamName()) {
                row.addContent(this.buildExamName(exams, isEditable));
            }
            if (this.isShowExamTimetable()) {
                row.addContent(this.buildExamPeriod(examAssignment, exams, isEditable));
                row.addContent(this.buildExamRoom(examAssignment, exams, isEditable));
            }
        }
        table.addContent(row);
        if (io.getInstrOfferingConfigs() != null & !io.getInstrOfferingConfigs().isEmpty()) {
            TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            configs.addAll(io.getInstrOfferingConfigs());
            this.buildConfigRows(classAssignment, examAssignment, table, io.getControllingCourseOffering(), configs, context, true, false);
        }
    }

    protected TableStream initTable(JspWriter outputStream, Long sessionId) {
        TableStream table = new TableStream(outputStream);
        table.setWidth("100%");
        table.setBorder(0);
        table.setCellSpacing(0);
        table.setCellPadding(3);
        table.tableDefComplete();
        this.buildTableHeader(table, sessionId);
        return table;
    }

    public void htmlTableForInstructionalOffering(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, Long instructionalOfferingId, JspWriter outputStream, Comparator classComparator) {
        if (instructionalOfferingId != null) {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(instructionalOfferingId);
            Long subjectAreaId = io.getControllingCourseOffering().getSubjectArea().getUniqueId();
            TreeSet<InstructionalOffering> ts = new TreeSet<InstructionalOffering>();
            ts.add(io);
            WebInstructionalOfferingTableBuilder iotbl = new WebInstructionalOfferingTableBuilder();
            iotbl.setDisplayDistributionPrefs(false);
            this.setVisibleColumns(this.COLUMNS);
            this.htmlTableForInstructionalOfferings(context, classAssignment, examAssignment, ts, subjectAreaId, false, false, outputStream, classComparator, null);
        }
    }

    public void htmlTableForInstructionalOfferings(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstructionalOfferingListForm form, String[] subjectAreaIds, boolean displayHeader, boolean allCoursesAreGiven, JspWriter outputStream, String backType, String backId) {
        this.setBackType(backType);
        this.setBackId(backId);
        this.setVisibleColumns(form);
        ArrayList<Long> navigationOfferingIds = new ArrayList<Long>();
        for (String subjectAreaId : subjectAreaIds) {
            this.htmlTableForInstructionalOfferings(context, classAssignment, examAssignment, form.getInstructionalOfferings(Long.valueOf(subjectAreaId)), Long.valueOf(subjectAreaId), displayHeader, allCoursesAreGiven, outputStream, new ClassCourseComparator(form.getSortBy(), classAssignment, false), navigationOfferingIds);
        }
    }

    protected void htmlTableForInstructionalOfferings(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TreeSet insructionalOfferings, Long subjectAreaId, boolean displayHeader, boolean allCoursesAreGiven, JspWriter outputStream, Comparator classComparator, List<Long> navigationOfferingIds) {
        InstructionalOffering io;
        if (insructionalOfferings == null) {
            return;
        }
        if (classComparator != null) {
            this.setClassComparator(classComparator);
        }
        SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId));
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        Vector<Class_> allClasses = new Vector<Class_>();
                        Iterator i = insructionalOfferings.iterator();
                        while (!hasTimetable && i.hasNext()) {
                            io = (InstructionalOffering)i.next();
                            Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
                            while (!hasTimetable && j.hasNext()) {
                                InstrOfferingConfig ioc = j.next();
                                Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                                while (!hasTimetable && k.hasNext()) {
                                    SchedulingSubpart ss = k.next();
                                    for (Class_ clazz : ss.getClasses()) {
                                        allClasses.add(clazz);
                                    }
                                }
                            }
                        }
                        ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                        hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                    } else {
                        Iterator i = insructionalOfferings.iterator();
                        while (!hasTimetable && i.hasNext()) {
                            InstructionalOffering io2 = (InstructionalOffering)i.next();
                            Iterator<InstrOfferingConfig> j = io2.getInstrOfferingConfigs().iterator();
                            while (!hasTimetable && j.hasNext()) {
                                InstrOfferingConfig ioc = j.next();
                                Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                                block16: while (!hasTimetable && k.hasNext()) {
                                    SchedulingSubpart ss = k.next();
                                    for (Class_ clazz : ss.getClasses()) {
                                        if (classAssignment.getAssignment(clazz) == null) continue;
                                        hasTimetable = true;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId()));
        }
        ArrayList<InstructionalOffering> notOfferedOfferings = new ArrayList<InstructionalOffering>();
        ArrayList<InstructionalOffering> offeredOfferings = new ArrayList<InstructionalOffering>();
        Iterator it = insructionalOfferings.iterator();
        io = null;
        boolean hasOfferedCourses = false;
        boolean hasNotOfferedCourses = false;
        this.setUserSettings(context.getUser());
        while (it.hasNext()) {
            io = (InstructionalOffering)it.next();
            if (io.isNotOffered() == null || io.isNotOffered().booleanValue()) {
                hasNotOfferedCourses = true;
                notOfferedOfferings.add(io);
                continue;
            }
            hasOfferedCourses = true;
            offeredOfferings.add(io);
        }
        if (hasOfferedCourses || allCoursesAreGiven) {
            if (displayHeader) {
                try {
                    if (allCoursesAreGiven) {
                        outputStream.print("<DIV align=\"right\"><A class=\"l7\" href=\"#notOffered" + subjectAreaId + "\">" + MSG.labelNotOfferedCourses(subjectArea.getSubjectAreaAbbreviation()) + "</A></DIV>");
                    }
                    outputStream.print("<DIV class=\"WelcomeRowHead\"><A name=\"offered" + subjectAreaId + "\"></A>" + MSG.labelOfferedCourses(subjectArea.getSubjectAreaAbbreviation()) + "</DIV>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (hasOfferedCourses) {
                it = offeredOfferings.iterator();
                TableStream offeredTable = this.initTable(outputStream, context.getUser().getCurrentAcademicSessionId());
                while (it.hasNext()) {
                    io = (InstructionalOffering)it.next();
                    if (navigationOfferingIds != null) {
                        navigationOfferingIds.add(io.getUniqueId());
                    }
                    this.addInstrOffrRowsToTable(classAssignment, examAssignment, offeredTable, io, subjectAreaId, context);
                }
                offeredTable.tableComplete();
            } else if (displayHeader) {
                try {
                    outputStream.print("<font class=\"error\">" + MSG.errorNoCoursesOffered(subjectArea.getSubjectAreaAbbreviation()) + "</font>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (hasNotOfferedCourses || allCoursesAreGiven) {
            if (displayHeader) {
                try {
                    outputStream.print("<br>");
                    if (allCoursesAreGiven) {
                        outputStream.print("<DIV align=\"right\"><A class=\"l7\" href=\"#offered" + subjectAreaId + "\">" + MSG.labelOfferedCourses(subjectArea.getSubjectAreaAbbreviation()) + "</A></DIV>");
                    }
                    outputStream.print("<DIV class=\"WelcomeRowHead\"><A name=\"notOffered" + subjectAreaId + "\"></A>" + MSG.labelNotOfferedCourses(subjectArea.getSubjectAreaAbbreviation()) + "</DIV>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (hasNotOfferedCourses) {
                it = notOfferedOfferings.iterator();
                TableStream notOfferedTable = this.initTable(outputStream, context.getUser().getCurrentAcademicSessionId());
                while (it.hasNext()) {
                    io = (InstructionalOffering)it.next();
                    if (navigationOfferingIds != null) {
                        navigationOfferingIds.add(io.getUniqueId());
                    }
                    this.addInstrOffrRowsToTable(classAssignment, examAssignment, notOfferedTable, io, subjectAreaId, context);
                }
                notOfferedTable.tableComplete();
            } else if (displayHeader) {
                try {
                    outputStream.print("<font class=\"normal\">&nbsp;" + MSG.errorAllCoursesOffered(subjectArea.getSubjectAreaAbbreviation()) + "</font>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (navigationOfferingIds != null) {
            Navigation.set(context, Navigation.sInstructionalOfferingLevel, navigationOfferingIds);
        }
    }

    protected void setVisibleColumns(InstructionalOfferingListFormInterface form) {
        this.setShowLabel(true);
        this.setShowDivSec(form.getDivSec());
        this.setShowDemand(form.getDemand());
        this.setShowProjectedDemand(form.getProjectedDemand());
        this.setShowMinPerWk(form.getMinPerWk());
        this.setShowLimit(form.getLimit());
        this.setShowRoomRatio(form.getRoomLimit());
        this.setShowManager(form.getManager());
        this.setShowDatePattern(form.getDatePattern());
        this.setShowTimePattern(form.getTimePattern());
        this.setShowPreferences(form.getPreferences());
        this.setShowInstructor(form.getInstructor());
        if (form.getTimetable() != null) {
            this.setShowTimetable(form.getTimetable());
        } else {
            this.setShowTimetable(false);
        }
        this.setShowCredit(form.getCredit());
        this.setShowSubpartCredit(form.getSubpartCredit());
        this.setShowSchedulePrintNote(form.getSchedulePrintNote());
        this.setShowNote(form.getNote());
        this.setShowConsent(form.getConsent());
        this.setShowTitle(form.getTitle());
        if (form.getExams() != null) {
            this.setShowExam(form.getExams());
        } else {
            this.setShowExam(false);
        }
    }

    protected void setVisibleColumns(String[] columns) {
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            a.add(columns[i]);
        }
        this.setShowLabel(a.contains(LABEL));
        this.setShowDivSec(a.contains(MSG.columnExternalId()));
        this.setShowDemand(a.contains(MSG.columnDemand()));
        this.setShowProjectedDemand(a.contains(MSG.columnProjectedDemand()));
        this.setShowMinPerWk(a.contains(MSG.columnMinPerWk()));
        this.setShowLimit(a.contains(MSG.columnLimit()));
        this.setShowRoomRatio(a.contains(MSG.columnRoomRatio()));
        this.setShowManager(a.contains(MSG.columnManager()));
        this.setShowDatePattern(a.contains(MSG.columnDatePattern()));
        this.setShowTimePattern(a.contains(MSG.columnTimePattern()));
        this.setShowPreferences(a.contains(MSG.columnPreferences()));
        this.setShowInstructor(a.contains(MSG.columnInstructor()));
        this.setShowTimetable(a.contains(MSG.columnTimetable()));
        this.setShowCredit(a.contains(MSG.columnOfferingCredit()));
        this.setShowSubpartCredit(a.contains(MSG.columnSubpartCredit()));
        this.setShowSchedulePrintNote(a.contains(MSG.columnSchedulePrintNote()));
        this.setShowNote(a.contains(MSG.columnNote()));
        this.setShowConsent(a.contains(MSG.columnConsent()));
        this.setShowTitle(a.contains(MSG.columnTitle()));
        this.setShowExam(a.contains(MSG.columnExam()));
    }

    public boolean isShowCredit() {
        return this.showCredit;
    }

    public void setShowCredit(boolean showCredit) {
        this.showCredit = showCredit;
    }

    public boolean isShowDatePattern() {
        return this.showDatePattern;
    }

    public void setShowDatePattern(boolean showDatePattern) {
        this.showDatePattern = showDatePattern;
    }

    public boolean isShowDemand() {
        return this.showDemand;
    }

    public void setShowDemand(boolean showDemand) {
        this.showDemand = showDemand;
    }

    public boolean isShowDivSec() {
        return this.showDivSec;
    }

    public void setShowDivSec(boolean showDivSec) {
        this.showDivSec = showDivSec;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isShowLimit() {
        return this.showLimit;
    }

    public void setShowLimit(boolean showLimit) {
        this.showLimit = showLimit;
    }

    public boolean isShowManager() {
        return this.showManager;
    }

    public void setShowManager(boolean showManager) {
        this.showManager = showManager;
    }

    public boolean isShowMinPerWk() {
        return this.showMinPerWk;
    }

    public void setShowMinPerWk(boolean showMinPerWk) {
        this.showMinPerWk = showMinPerWk;
    }

    public boolean isShowNote() {
        return this.showNote;
    }

    public void setShowNote(boolean showNote) {
        this.showNote = showNote;
    }

    public boolean isShowPreferences() {
        return this.showPreferences;
    }

    public void setShowPreferences(boolean showPreferences) {
        this.showPreferences = showPreferences;
    }

    public boolean isShowProjectedDemand() {
        return this.showProjectedDemand;
    }

    public void setShowProjectedDemand(boolean showProjectedDemand) {
        this.showProjectedDemand = showProjectedDemand;
    }

    public boolean isShowRoomRatio() {
        return this.showRoomRatio;
    }

    public void setShowRoomRatio(boolean showRoomRatio) {
        this.showRoomRatio = showRoomRatio;
    }

    public boolean isShowSchedulePrintNote() {
        return this.showSchedulePrintNote;
    }

    public void setShowSchedulePrintNote(boolean showSchedulePrintNote) {
        this.showSchedulePrintNote = showSchedulePrintNote;
    }

    public boolean isShowTimePattern() {
        return this.showTimePattern;
    }

    public void setShowTimePattern(boolean showTimePattern) {
        this.showTimePattern = showTimePattern;
    }

    public boolean isShowTimetable() {
        return this.showTimetable;
    }

    public void setShowTimetable(boolean showTimetable) {
        this.showTimetable = showTimetable;
    }

    public boolean isShowInstructor() {
        return this.showInstructor;
    }

    public void setShowInstructor(boolean showInstructor) {
        this.showInstructor = showInstructor;
    }

    public Comparator getClassComparator() {
        return this.iClassComparator;
    }

    public void setClassComparator(Comparator comparator) {
        this.iClassComparator = comparator;
    }

    public String getBackType() {
        return this.iBackType;
    }

    public void setBackType(String backType) {
        this.iBackType = backType;
    }

    public String getBackId() {
        return this.iBackId;
    }

    public void setBackId(String backId) {
        this.iBackId = backId;
    }

    public boolean isShowSubpartCredit() {
        return this.showSubpartCredit;
    }

    public void setShowSubpartCredit(boolean showSubpartCredit) {
        this.showSubpartCredit = showSubpartCredit;
    }
}

