/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.io.IOException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;
import org.unitime.timetable.security.SessionContext;

public class BackTracker {
    public static int MAX_BACK_STEPS = 10;
    public static String BACK_LIST = "BackTracker.back";
    private static String mark = "-_.!~*'()\"";

    protected static MessageResources getResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getBackList(HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            Vector back = (Vector)session.getAttribute(BACK_LIST);
            if (back == null) {
                back = new Vector();
                session.setAttribute("BackTracker.back", back);
            }
            return back;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForBack(HttpServletRequest request, String uri, String title, boolean back, boolean clear) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            Vector backList = BackTracker.getBackList(request.getSession());
            if (clear) {
                backList.clear();
            }
            if (back) {
                if (uri == null && request.getAttribute("javax.servlet.forward.request_uri") == null) {
                    return;
                }
                String titleObj = title == null ? request.getAttribute("title") : title;
                String requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
                String queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
                if (queryString != null && queryString.length() > 0) {
                    requestURI = requestURI + "?" + queryString;
                }
                if (uri != null) {
                    requestURI = uri;
                }
                if (!backList.isEmpty()) {
                    int found = -1;
                    for (int idx = 0; idx < backList.size(); ++idx) {
                        String[] lastBack = (String[])backList.elementAt(idx);
                        if (!lastBack[0].equals(requestURI)) continue;
                        found = idx;
                        break;
                    }
                    while (found >= 0 && backList.size() > found) {
                        backList.removeElementAt(backList.size() - 1);
                    }
                }
                backList.addElement(new String[]{requestURI, titleObj == null ? null : titleObj.toString()});
            }
        }
    }

    public static void markForBack(SessionContext context, String uri, String title, boolean back, boolean clear) {
        Vector<String[]> backList = (Vector<String[]>)context.getAttribute(BACK_LIST);
        if (backList == null) {
            backList = new Vector<String[]>();
            context.setAttribute("BackTracker.back", backList);
        }
        if (clear) {
            backList.clear();
        }
        if (back) {
            if (!backList.isEmpty()) {
                int found = -1;
                for (int idx = 0; idx < backList.size(); ++idx) {
                    String[] lastBack = (String[])backList.elementAt(idx);
                    if (!lastBack[0].equals(uri)) continue;
                    found = idx;
                    break;
                }
                while (found >= 0 && backList.size() > found) {
                    backList.removeElementAt(backList.size() - 1);
                }
            }
            backList.addElement(new String[]{uri, title});
        }
    }

    public static String encodeURL(String url) {
        StringBuffer encodedUrl = new StringBuffer();
        int len = url.length();
        for (int i = 0; i < len; ++i) {
            char c = url.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                encodedUrl.append(c);
                continue;
            }
            int imark = mark.indexOf(c);
            if (imark >= 0) {
                encodedUrl.append(c);
                continue;
            }
            encodedUrl.append('%');
            encodedUrl.append(Integer.toHexString(c));
        }
        return encodedUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBackButton(HttpServletRequest request, int nrBackSteps, String name, String title, String accessKey, String style, String clazz, String backType, String backId) {
        MessageResources rsc = BackTracker.getResources(request);
        if (rsc != null && rsc.getMessage(name) != null) {
            name = rsc.getMessage(name);
        }
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            Vector backList = BackTracker.getBackList(request.getSession());
            if (backList.size() < nrBackSteps) {
                return "";
            }
            String[] backItem = (String[])backList.elementAt(backList.size() - nrBackSteps);
            if (backItem[1] != null) {
                title = title.replaceAll("%%", backItem[1]);
            }
            String backUrl = backItem[0];
            if (backId != null && backType != null) {
                backUrl = backUrl.indexOf(63) > 0 ? backUrl + "&backType=" + backType + "&backId=" + backId + "#back" : backUrl + "?backType=" + backType + "&backId=" + backId + "#back";
            }
            return "<input type='button' value='" + name + "' " + (accessKey == null ? "" : " accesskey=\"" + accessKey + "\"") + (style == null ? "" : " style=\"" + style + "\"") + (clazz == null ? "" : " class=\"" + clazz + "\"") + " title=\"" + title + "\"" + " onClick=\"document.location='back.do?uri=" + BackTracker.encodeURL(backUrl) + "'" + ";\"" + "/>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGwtBack(HttpServletRequest request, int nrBackSteps) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            Vector back = BackTracker.getBackList(request.getSession());
            if (back.size() <= 1) {
                return "";
            }
            StringBuffer ret = new StringBuffer("");
            for (int i = Math.max(0, back.size() - MAX_BACK_STEPS); i < back.size(); ++i) {
                String[] backItem = (String[])back.elementAt(i);
                if (ret.length() > 0) {
                    ret.append("&");
                }
                ret.append(BackTracker.encodeURL(backItem[0]) + "|" + backItem[1]);
            }
            return "<span id='UniTimeGWT:Back' style='display:none;'>" + ret.toString() + "</span>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasBack(HttpServletRequest request, int nrBackSteps) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            Vector backList = BackTracker.getBackList(request.getSession());
            return backList.size() >= nrBackSteps;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            String uri = request.getParameter("uri");
            Vector back = BackTracker.getBackList(request.getSession());
            if (back.isEmpty()) {
                if (uri != null) {
                    response.sendRedirect(response.encodeURL(uri));
                    return true;
                }
                return false;
            }
            if (uri == null) {
                uri = ((String[])back.lastElement())[0];
                back.remove(back.size() - 1);
            } else {
                String uriNoBack = uri;
                if (uriNoBack.indexOf("backType=") >= 0) {
                    uriNoBack = uriNoBack.substring(0, uriNoBack.indexOf("backType=") - 1);
                }
                while (!back.isEmpty() && !uriNoBack.equals(((String[])back.lastElement())[0])) {
                    back.remove(back.size() - 1);
                }
                if (!back.isEmpty()) {
                    back.remove(back.size() - 1);
                }
            }
            if (uri.indexOf("backType=") < 0 && request.getAttribute("backType") != null && request.getAttribute("backId") != null) {
                uri = uri.indexOf(63) > 0 ? uri + "&backType=" + request.getAttribute("backType") + "&backId=" + request.getAttribute("backId") + "#back" : uri + "?backType=" + request.getAttribute("backType") + "&backId=" + request.getAttribute("backId") + "#back";
            }
            response.sendRedirect(response.encodeURL(uri));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBackTree(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            Vector back = BackTracker.getBackList(request.getSession());
            if (back.size() <= 1) {
                return "";
            }
            StringBuffer ret = new StringBuffer();
            for (int i = Math.max(0, back.size() - MAX_BACK_STEPS); i < back.size(); ++i) {
                String[] backItem = (String[])back.elementAt(i);
                if (ret.length() > 0) {
                    ret.append(" &rarr; ");
                }
                ret.append("<span class='item'><A href='back.do?uri=" + BackTracker.encodeURL(backItem[0]) + "'>" + backItem[1] + "</A></span>");
            }
            return "&nbsp;" + ret.toString();
        }
    }
}

