/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.Query;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRoomAvailabilityService
implements RoomAvailabilityInterface {
    private Vector<CacheElement> iCache = new Vector();
    private boolean iInstructorAvailabilityEnabled = false;

    @Override
    public String getTimeStamp(Date startTime, Date endTime, String excludeType) {
        TimeFrame time = new TimeFrame(startTime, endTime);
        CacheElement cache = this.get(time, excludeType);
        return cache == null ? null : cache.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheElement get(TimeFrame time, String excludeType) {
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            for (CacheElement cache : this.iCache) {
                if (!cache.cover(time) || !cache.exclude(excludeType)) continue;
                return cache;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(Long locationId, Date startTime, Date endTime, String excludeType) {
        Location location = (Location)LocationDAO.getInstance().get(locationId);
        if (location == null || location.getPermanentId() == null) {
            return null;
        }
        EventDateMapping.Class2EventDateMap class2eventDateMap = sClassType.equals(excludeType) ? EventDateMapping.getMapping(location.getSession().getUniqueId()) : null;
        TimeFrame time = new TimeFrame(startTime, endTime);
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            CacheElement cache = this.get(time, excludeType);
            if (cache != null) {
                return cache.get(location.getPermanentId(), excludeType);
            }
            Calendar start = Calendar.getInstance(Locale.US);
            start.setTime(startTime);
            int startMin = 60 * start.get(11) + start.get(12);
            start.add(12, -startMin);
            Calendar end = Calendar.getInstance(Locale.US);
            end.setTime(endTime);
            int endMin = 60 * end.get(11) + start.get(12);
            end.add(12, -endMin);
            int startSlot = (startMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            int endSlot = (endMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            String exclude = null;
            if (excludeType != null) {
                if (sFinalExamType.equals(excludeType)) {
                    exclude = "FinalExamEvent";
                } else if (sMidtermExamType.equals(excludeType)) {
                    exclude = "MidtermExamEvent";
                } else if (sClassType.equals(excludeType)) {
                    exclude = "ClassEvent";
                }
            }
            Query q = new _RootDAO().getSession().createQuery("select m from Meeting m where m.locationPermanentId=:locPermId and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (exclude != null ? " and m.event.class!=" + exclude : "")).setLong("locPermId", location.getPermanentId().longValue()).setDate("startDate", start.getTime()).setDate("endDate", end.getTime()).setInteger("startSlot", startSlot).setInteger("endSlot", endSlot).setCacheable(true);
            for (Meeting m : q.list()) {
                MeetingTimeBlock block = new MeetingTimeBlock(m, class2eventDateMap);
                if (block.getStartTime() == null) continue;
                ret.add(block);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(Session session, Date startTime, Date endTime, String excludeType, boolean waitForSync) {
        this.iInstructorAvailabilityEnabled = ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue();
        TimeFrame time = new TimeFrame(startTime, endTime);
        EventDateMapping.Class2EventDateMap class2eventDateMap = sClassType.equals(excludeType) ? EventDateMapping.getMapping(session.getUniqueId()) : null;
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            CacheElement cache = this.get(time, excludeType);
            if (cache == null) {
                cache = new CacheElement(time, excludeType);
                this.iCache.insertElementAt(cache, 0);
            }
            cache.update(class2eventDateMap, this.iInstructorAvailabilityEnabled ? session.getUniqueId() : null);
        }
    }

    @Override
    public void startService() {
    }

    @Override
    public void stopService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RoomAvailabilityInterface.TimeBlock> getInstructorAvailability(Long instructorId, Date startTime, Date endTime, String excludeType) {
        if (!this.iInstructorAvailabilityEnabled) {
            return null;
        }
        DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instructorId);
        if (instructor == null || instructor.getExternalUniqueId() == null) {
            return null;
        }
        EventDateMapping.Class2EventDateMap class2eventDateMap = sClassType.equals(excludeType) ? EventDateMapping.getMapping(instructor.getDepartment().getSession().getUniqueId()) : null;
        TimeFrame time = new TimeFrame(startTime, endTime);
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            CacheElement cache = this.get(time, excludeType);
            if (cache != null) {
                return cache.get(-instructor.getUniqueId().longValue(), excludeType);
            }
            Calendar start = Calendar.getInstance(Locale.US);
            start.setTime(startTime);
            int startMin = 60 * start.get(11) + start.get(12);
            start.add(12, -startMin);
            Calendar end = Calendar.getInstance(Locale.US);
            end.setTime(endTime);
            int endMin = 60 * end.get(11) + start.get(12);
            end.add(12, -endMin);
            int startSlot = (startMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            int endSlot = (endMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            String exclude = null;
            if (excludeType != null) {
                if (sFinalExamType.equals(excludeType)) {
                    exclude = "FinalExamEvent";
                } else if (sMidtermExamType.equals(excludeType)) {
                    exclude = "MidtermExamEvent";
                } else if (sClassType.equals(excludeType)) {
                    exclude = "ClassEvent";
                }
            }
            Query q = new _RootDAO().getSession().createQuery("select m from Meeting m left outer join m.event.additionalContacts c where (m.event.mainContact.externalUniqueId = :user or c.externalUniqueId = :user) and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (exclude != null ? " and m.event.class!=" + exclude : "")).setString("user", instructor.getExternalUniqueId()).setDate("startDate", start.getTime()).setDate("endDate", end.getTime()).setInteger("startSlot", startSlot).setInteger("endSlot", endSlot).setCacheable(true);
            for (Meeting m : q.list()) {
                MeetingTimeBlock block = new MeetingTimeBlock(m, class2eventDateMap);
                if (block.getStartTime() == null) continue;
                ret.add(block);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MeetingTimeBlock
    implements RoomAvailabilityInterface.TimeBlock,
    Comparable<RoomAvailabilityInterface.TimeBlock> {
        private static final long serialVersionUID = -5557707709984628517L;
        Long iMeetingId;
        String iEventName;
        String iEventType;
        Date iStart;
        Date iEnd;

        public MeetingTimeBlock(Meeting m, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            this.iMeetingId = m.getUniqueId();
            this.iEventName = m.getEvent().getEventName();
            this.iEventType = m.getEvent().getEventTypeLabel();
            this.iStart = m.getTrueStartTime(class2eventDateMap);
            this.iEnd = m.getTrueStopTime(class2eventDateMap);
        }

        public Long getId() {
            return this.iMeetingId;
        }

        @Override
        public String getEventName() {
            return this.iEventName;
        }

        @Override
        public String getEventType() {
            return this.iEventType;
        }

        @Override
        public Date getStartTime() {
            return this.iStart;
        }

        @Override
        public Date getEndTime() {
            return this.iEnd;
        }

        public String toString() {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy HH:mm");
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
            return this.getEventName() + " (" + this.getEventType() + ") " + df.format(this.getStartTime()) + " - " + df2.format(this.getEndTime());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MeetingTimeBlock)) {
                return false;
            }
            MeetingTimeBlock m = (MeetingTimeBlock)o;
            return this.getId().equals(m.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(RoomAvailabilityInterface.TimeBlock block) {
            int cmp = this.getStartTime().compareTo(block.getStartTime());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getEndTime().compareTo(block.getEndTime());
            if (cmp != 0) {
                return cmp;
            }
            return this.getEventName().compareTo(block.getEventName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheElement {
        private TimeFrame iTime;
        private Hashtable<Long, TreeSet<RoomAvailabilityInterface.TimeBlock>> iAvailability = new Hashtable();
        private String iTimestamp = null;
        private String iExcludeType = null;

        public CacheElement(TimeFrame time, String excludeType) {
            this.iTime = time;
            this.iExcludeType = excludeType;
        }

        public void update(EventDateMapping.Class2EventDateMap class2eventDateMap, Long sessionId) {
            this.iAvailability.clear();
            String exclude = null;
            if (this.iExcludeType != null) {
                if (RoomAvailabilityInterface.sFinalExamType.equals(this.iExcludeType)) {
                    exclude = "FinalExamEvent";
                } else if (RoomAvailabilityInterface.sMidtermExamType.equals(this.iExcludeType)) {
                    exclude = "MidtermExamEvent";
                } else if (RoomAvailabilityInterface.sClassType.equals(this.iExcludeType)) {
                    exclude = "ClassEvent";
                }
            }
            Query q = new _RootDAO().getSession().createQuery("select m from Meeting m where m.locationPermanentId!=null and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (exclude == null ? "" : " and m.event.class!=" + exclude)).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true);
            for (Meeting m : q.list()) {
                MeetingTimeBlock block;
                TreeSet<RoomAvailabilityInterface.TimeBlock> blocks = this.iAvailability.get(m.getLocationPermanentId());
                if (blocks == null) {
                    blocks = new TreeSet();
                    this.iAvailability.put(m.getLocationPermanentId(), blocks);
                }
                if ((block = new MeetingTimeBlock(m, class2eventDateMap)).getStartTime() == null) continue;
                blocks.add(block);
            }
            if (sessionId != null) {
                q = new _RootDAO().getSession().createQuery("select distinct m, -i.uniqueId from Meeting m left outer join m.event.additionalContacts c, DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId is not null and (m.event.mainContact.externalUniqueId = i.externalUniqueId or c.externalUniqueId = i.externalUniqueId) and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (exclude != null ? " and m.event.class!=" + exclude : "")).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setLong("sessionId", sessionId.longValue()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true);
                for (Object[] o : q.list()) {
                    MeetingTimeBlock block;
                    Meeting m = (Meeting)o[0];
                    Long id = (Long)o[1];
                    TreeSet<RoomAvailabilityInterface.TimeBlock> blocks = this.iAvailability.get(id);
                    if (blocks == null) {
                        blocks = new TreeSet();
                        this.iAvailability.put(id, blocks);
                    }
                    if ((block = new MeetingTimeBlock(m, class2eventDateMap)).getStartTime() == null) continue;
                    blocks.add(block);
                }
            }
            this.iTimestamp = new Date().toString();
        }

        public TreeSet<RoomAvailabilityInterface.TimeBlock> get(Long roomPermId, String excludeType) {
            TreeSet<RoomAvailabilityInterface.TimeBlock> roomAvailability = this.iAvailability.get(roomPermId);
            if (roomAvailability == null || excludeType == null || excludeType.equals(this.iExcludeType)) {
                return roomAvailability;
            }
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            for (RoomAvailabilityInterface.TimeBlock block : roomAvailability) {
                if (excludeType.equals(block.getEventType())) continue;
                ret.add(block);
            }
            return ret;
        }

        public TimeFrame getTimeFrame() {
            return this.iTime;
        }

        public String getExcludeType() {
            return this.iExcludeType;
        }

        public boolean exclude(String type) {
            return this.iExcludeType == null || this.iExcludeType.equals(type);
        }

        public boolean cover(TimeFrame time) {
            return this.iTime.getStartDate().compareTo(time.getStartDate()) <= 0 && time.getEndDate().compareTo(this.iTime.getEndDate()) <= 0 && this.iTime.getStartSlot() <= time.getStartSlot() && time.getEndSlot() <= this.iTime.getEndSlot();
        }

        public String getTimestamp() {
            return this.iTimestamp;
        }

        public String toString() {
            return this.iTime.toString();
        }
    }

    public static class TimeFrame {
        private Date iStart;
        private Date iEnd;
        private int iStartSlot;
        private int iEndSlot;

        public TimeFrame(Date startTime, Date endTime) {
            Calendar start = Calendar.getInstance(Locale.US);
            start.setTime(startTime);
            int startMin = 60 * start.get(11) + start.get(12);
            start.add(12, -startMin);
            Calendar end = Calendar.getInstance(Locale.US);
            end.setTime(endTime);
            int endMin = 60 * end.get(11) + start.get(12);
            end.add(12, -endMin);
            this.iStartSlot = (startMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            this.iEndSlot = (endMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            this.iStart = start.getTime();
            this.iEnd = end.getTime();
        }

        public Date getStartDate() {
            return this.iStart;
        }

        public Date getEndDate() {
            return this.iEnd;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public int getEndSlot() {
            return this.iEndSlot;
        }

        public int hashCode() {
            return this.iStart.hashCode() ^ this.iEnd.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeFrame)) {
                return false;
            }
            TimeFrame t = (TimeFrame)o;
            return this.getStartDate().equals(t.getStartDate()) && this.getEndDate().equals(t.getEndDate()) && this.getStartSlot() == t.getStartSlot() && this.getEndSlot() == t.getEndSlot();
        }

        public String toString() {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy");
            int start = this.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int end = this.getEndSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            return df.format(this.getStartDate()) + " - " + df.format(this.getEndDate()) + " " + Constants.toTime(start) + " - " + Constants.toTime(end);
        }
    }
}

