/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.security.UserContext;

public class Constants
extends org.cpsolver.coursett.Constants {
    public static final ConstantsMessages MSG = Localization.create(ConstantsMessages.class);
    public static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    public static String[] DAY_NAME = new String[]{MSG.mon(), MSG.tue(), MSG.wed(), MSG.thu(), MSG.fri(), MSG.sat(), MSG.sun()};
    public static String[] DAY_NAMES_FULL = new String[]{MSG.monday(), MSG.tuesday(), MSG.wednesday(), MSG.thursday(), MSG.friday(), MSG.saturday(), MSG.sunday()};
    public static final int DAY_MON = 0;
    public static final int DAY_TUE = 1;
    public static final int DAY_WED = 2;
    public static final int DAY_THU = 3;
    public static final int DAY_FRI = 4;
    public static final int DAY_SAT = 5;
    public static final int DAY_SUN = 6;
    public static int EVENING_SLOTS_FIRST = DAY_SLOTS_LAST + 1;
    public static int EVENING_SLOTS_LAST = 275;
    public static String VERSION = "4.0";
    private static String REL_DATE = "Wed, 24 Feb 2016";
    private static String BLD_NUMBER = "49";
    public static String STARTUP_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    public static String DATE_FORMAT = "EEE, d MMM yyyy";
    public static int TIME_PATTERN_STANDARD = 0;
    public static int TIME_PATTERN_GENERIC = 1;
    public static int TIME_PATTERN_EVENING = 2;
    public static int TIME_PATTERN_SATURDAY = 3;
    public static String CAMPUS_WLAF = "1";
    public static String SESSION_ID_ATTR_NAME = "acadSessionId";
    public static String ACAD_YRTERM_ATTR_NAME = "acadYearTerm";
    public static String ACAD_YRTERM_LABEL_ATTR_NAME = "acadYearTermLabel";
    public static String TMTBL_MGR_ID_ATTR_NAME = "tmtblManagerId";
    public static String JUMP_TO_ATTR_NAME = "jumpTo";
    public static String DEPT_ID_ATTR_NAME = "deptUniqueId";
    public static String DEPT_CODE_ATTR_NAME = "deptCode";
    public static String CRS_ASGN_LST_SUBJ_AREA_IDS_ATTR_NAME = "crsAsgnLstSubjectAreaIds";
    public static String[] LLR_DEPTS = new String[]{"1994", "1980"};
    public static String BLANK_OPTION_LABEL = MSG.select();
    public static String BLANK_OPTION_VALUE = "";
    public static String ALL_OPTION_LABEL = MSG.all();
    public static String ALL_OPTION_VALUE = "All";
    public static String FACILITY_GROUP_LLR = "LLR";
    public static String FACILITY_GROUP_LAB = "LAB";
    public static String FACILITY_GROUP_DEPT = "DEPT";
    public static String[] PREF_CLASS_NAMES = new String[]{TimePref.class.getName(), RoomPref.class.getName(), BuildingPref.class.getName(), RoomFeaturePref.class.getName(), DistributionPref.class.getName()};
    public static final long MANAGED_BY_MULTIPLE_DEPTS = 0L;
    public static final String REQUEST_OPEN_URL = "RqOpenUrl";
    public static final String REQUEST_WARN = "RqWarn";
    public static final String REQUEST_MSSG = "RqMsg";
    public static final int PREF_ROWS_ADDED = 2;
    private static Boolean sCurriculaToInitialCase = null;

    public static String getReleaseDate() {
        return REL_DATE.replaceAll("\\$\\{[^\\}]*\\}", "?");
    }

    public static String getBuildNumber() {
        return BLD_NUMBER.replaceAll("\\$\\{[^\\}]*\\}", "?");
    }

    public static String getVersion() {
        return VERSION + "." + Constants.getBuildNumber();
    }

    public static int getPositiveInteger(String str, int defaultValue) {
        try {
            int i = Integer.parseInt(str);
            if (i >= 0) {
                return i;
            }
        }
        catch (Exception e) {
            return defaultValue;
        }
        return defaultValue;
    }

    public static float getPositiveFloat(String str, float defaultValue) {
        try {
            float i = Float.parseFloat(str);
            if (i >= 0.0f) {
                return i;
            }
        }
        catch (Exception e) {
            return defaultValue;
        }
        return defaultValue;
    }

    public static String filterXSS(String str) {
        if (str != null) {
            str = str.trim().replaceAll("([^A-Za-z0-9@.' _-]+)", "_");
        }
        return str;
    }

    public static String arrayToStr(Object[] array, String encloseBy, String separator) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Supply a valid array");
        }
        if (encloseBy == null) {
            throw new IllegalArgumentException("encloseBy cannot be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cannot be null");
        }
        StringBuffer str = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            str.append(encloseBy);
            str.append(array[i].toString());
            str.append(encloseBy);
            if (i >= array.length - 1) continue;
            str.append(separator);
        }
        return str.toString();
    }

    public static String leftPad(Object value, int width, String pad) throws Exception {
        return Constants.pad(1, value, width, pad);
    }

    public static String rightPad(Object value, int width, String pad) throws Exception {
        return Constants.pad(2, value, width, pad);
    }

    public static String pad(int direction, Object value, int width, String pad) throws Exception {
        String value1 = value == null ? "" : value.toString();
        if (width <= 0) {
            throw new Exception("Width must be > 0");
        }
        if (pad.equals("") || pad == null) {
            pad = " ";
        }
        int lnCount = width - value1.length();
        if (direction == 1) {
            for (int i = 0; i < lnCount; ++i) {
                value1 = pad + value1;
            }
        } else {
            for (int i = 0; i < lnCount; ++i) {
                value1 = value1 + pad;
            }
        }
        return value1;
    }

    public static String toInitialCase(String str) {
        return Constants.toInitialCase(str, new char[]{'-', '\''});
    }

    public static String toInitialCase(String str, char[] delimiters) {
        if (str == null || str.trim().isEmpty()) {
            return str;
        }
        if (!str.toUpperCase().equals(str) && !str.toLowerCase().equals(str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        boolean upper = true;
        block0: for (int i = 0; i < chars.length; ++i) {
            if (upper && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                upper = false;
            } else {
                chars[i] = Character.toLowerCase(chars[i]);
            }
            if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '\'') {
                upper = true;
            }
            if (delimiters == null || delimiters.length <= 0) continue;
            for (int j = 0; j < delimiters.length; ++j) {
                if (chars[i] != delimiters[j]) continue;
                upper = true;
                continue block0;
            }
        }
        str = new String(chars);
        return str;
    }

    public static String slot2str(int slot) {
        return Constants.toTime(slot * SLOT_LENGTH_MIN + FIRST_SLOT_TIME_MIN);
    }

    public static void main(String[] args) {
        System.out.println("JOHN G DOE -> " + Constants.toInitialCase("JOHN G DOE"));
        System.out.println("DOE jOHn G. -> " + Constants.toInitialCase("DOE jOHn G."));
        System.out.println("jOhN g. dOe -> " + Constants.toInitialCase("jOhN g. dOe"));
        System.out.println("To be Or NOT to BE.that is THE QUESTION. -> " + Constants.toInitialCase("To be Or NOT to BE.that is THE QUESTION."));
    }

    public static String sort(String data, String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("separator cannot be null");
        }
        List<String> list = Arrays.asList(data.split(separator));
        Collections.sort(list);
        return list.toString();
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String toTime(int minutesSinceMidnight) {
        int hour = minutesSinceMidnight / 60;
        int min = minutesSinceMidnight % 60;
        if (CONSTANTS.useAmPm()) {
            return (hour == 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + ":" + (min < 10 ? "0" : "") + min + (hour < 24 && hour >= 12 ? "p" : "a");
        }
        return hour + ":" + (min < 10 ? "0" : "") + min;
    }

    public static boolean showPrintNoteAsFullText(UserContext user) {
        return user != null && CommonValues.NoteAsFullText.value().equals(user.getProperty(UserProperty.SchedulePrintNoteDisplay));
    }

    public static boolean showCrsOffrAsFullText(UserContext user) {
        return user != null && CommonValues.NoteAsFullText.value().equals(user.getProperty(UserProperty.CourseOfferingNoteDisplay));
    }

    public static int getDefaultExamStartOffset(ExamType examType) {
        return Constants.getExamOffset(ApplicationProperty.ExaminationPeriodDefaultStartOffset.value(examType.getReference()));
    }

    public static int getDefaultExamStopOffset(ExamType examType) {
        return Constants.getExamOffset(ApplicationProperty.ExaminationPeriodDefaultStopOffset.value(examType.getReference()));
    }

    private static int getExamOffset(String value) {
        int offset = 0;
        if (value == null || value.trim().length() == 0) {
            offset = 0;
        } else {
            try {
                offset = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                offset = 0;
            }
            if (offset < 0) {
                offset = 0;
            }
        }
        return offset;
    }

    public static int getDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(date);
        switch (c.get(7)) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    public static int toHour(int slot) {
        int min = slot * SLOT_LENGTH_MIN + FIRST_SLOT_TIME_MIN;
        return min / 60;
    }

    public static int toMinute(int slot) {
        int min = slot * SLOT_LENGTH_MIN + FIRST_SLOT_TIME_MIN;
        return min % 60;
    }

    public static String curriculaToInitialCase(String text) {
        if (sCurriculaToInitialCase == null) {
            sCurriculaToInitialCase = ApplicationProperty.CurriculumConvertNamesToInitialCase.isTrue();
        }
        if (sCurriculaToInitialCase.booleanValue()) {
            return Constants.toInitialCase(text);
        }
        return text;
    }
}

