/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.security.UserContext;

public class Property
extends BodyTagSupport {
    private static final long serialVersionUID = -7140085371832958782L;
    private String iName;
    private boolean iUser = false;

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public boolean isUser() {
        return this.iUser;
    }

    public void setUser(boolean user) {
        this.iUser = user;
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    protected String getProperty(String defaultValue) {
        if (this.isUser() && this.getUser() != null) {
            return this.getUser().getProperty(this.getName(), ApplicationProperties.getProperty(this.getName(), defaultValue));
        }
        return ApplicationProperties.getProperty(this.getName(), defaultValue);
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            String body = this.getBodyContent() == null ? null : this.getBodyContent().getString();
            String value = ApplicationProperties.getProperty(this.iName, body);
            if (value != null) {
                this.pageContext.getOut().println(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspTagException(e.getMessage());
        }
        return 6;
    }
}

